/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.controls.NumericControl;
import com.sun.media.ui.BasicComp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Slider
extends BasicComp
implements MouseListener,
MouseMotionListener {
    Image imageGrabber = Slider.fetchImage("grabber.gif");
    Image imageGrabberX;
    Image imageGrabberDown = Slider.fetchImage("grabber-pressed.gif");
    Graphics paintG = null;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 8;
    int rightBorder = 8;
    int sliderWidth;
    int width;
    int height;
    int displayPercent;
    float[] detents;
    Dimension dimension;
    float lower = 0.0f;
    float upper = 1.0f;
    float range = 1.0f;
    float value = 0.5f;
    boolean dragging = false;
    boolean grabberVisible = true;

    public Slider() {
        this(null, null);
    }

    public Slider(float[] fArray) {
        this(fArray, null);
    }

    public Slider(float[] fArray, Color color) {
        super("Slider");
        this.imageGrabberX = Slider.fetchImage("grabber-disabled.gif");
        this.detents = fArray;
        if (color != null) {
            this.setBackground(color);
        }
        this.width = 115;
        this.height = 18;
        this.displayPercent = 100;
        this.dimension = new Dimension(this.width, this.height);
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.grabbed = false;
        this.entered = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public Point getPosition() {
        return new Point(this.grabberPosition + this.leftBorder, 10);
    }

    public void setDisplayPercent(int n) {
        if (n != this.displayPercent) {
            this.displayPercent = n;
            if (this.displayPercent > 100) {
                this.displayPercent = 100;
            } else if (this.displayPercent < 0) {
                this.displayPercent = 0;
            }
            this.repaint();
        }
    }

    public boolean isGrabberVisible() {
        return this.grabberVisible;
    }

    public void setGrabberVisible(boolean bl) {
        if (this.grabberVisible != bl) {
            this.grabberVisible = bl;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.height / 2 - 2;
        this.paintG = graphics;
        int n2 = this.grabberPosition + this.leftBorder - 5;
        graphics.setColor(this.getBackground().darker());
        graphics.drawRect(this.leftBorder, n, this.sliderWidth, 3);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(this.leftBorder, n, this.sliderWidth * this.displayPercent / 100, 3, false);
        if (this.detents != null && this.detents.length != 0) {
            this.paintG.setColor(Color.black);
            for (int i = 0; i < this.detents.length; ++i) {
                int n3 = this.leftBorder + (int)(this.detents[i] * (float)this.sliderWidth / this.range);
                this.paintG.drawLine(n3, 12, n3, 15);
            }
        }
        if (this.grabberVisible) {
            Image image = this.isEnabled() ? (this.grabbed || this.entered ? this.imageGrabberDown : this.imageGrabber) : this.imageGrabberX;
            this.paintG.drawImage(image, n2, 4, this);
        }
    }

    private int limitGrabber(int n) {
        int n2 = n - this.leftBorder;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.sliderWidth) {
            n2 = this.sliderWidth;
        }
        return n2;
    }

    private void setSliderPosition(float f, float f2) {
        this.grabberPosition = (int)(f / f2 * (float)this.sliderWidth);
    }

    private void seek() {
        if (this.control != null && this.control instanceof NumericControl) {
            float f;
            NumericControl numericControl = (NumericControl)this.control;
            float f2 = numericControl.getLowerLimit();
            float f3 = numericControl.getUpperLimit();
            float f4 = (float)this.grabberPosition / (float)this.sliderWidth * (f3 - f2) + f2;
            if (this.detents != null && this.detents.length > 0 && this.dragging) {
                f = (f3 - f2) * 0.05f;
                for (int i = 0; i < this.detents.length; ++i) {
                    if (!(Math.abs(this.detents[i] - f4) <= f)) continue;
                    f4 = this.detents[i];
                }
            }
            if (f4 != (f = numericControl.setValue(f4))) {
                this.setSliderPosition(f - f2, f3 - f2);
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 8) == 0 && (n & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = true;
            this.grabberPosition = this.limitGrabber(mouseEvent.getX());
            this.seek();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 8) == 0 && (n & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 8) == 0 && (n & 4) == 0 && this.isEnabled()) {
            this.dragging = true;
            this.grabberPosition = this.limitGrabber(mouseEvent.getX());
            this.seek();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.entered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.entered = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.paintG = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }
}

