/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class Region
implements Cloneable,
Serializable {
    protected Vector rects = new Vector();

    public Region() {
    }

    public Region(Rectangle rectangle) {
        this.addRectangle(rectangle);
    }

    public Region(Rectangle rectangle, Rectangle rectangle2) {
        this.addRectangle(rectangle);
        this.addRectangle(rectangle2);
    }

    public boolean isEmpty() {
        return this.rects.isEmpty();
    }

    public int getNumRectangles() {
        return this.rects.size();
    }

    public Enumeration rectangles() {
        return this.rects.elements();
    }

    public Object clone() {
        Region region = new Region();
        region.rects = (Vector)this.rects.clone();
        return region;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < this.rects.size(); ++i) {
            rectangle = rectangle.union((Rectangle)this.rects.elementAt(i));
        }
        return rectangle;
    }

    public void addRectangle(Rectangle rectangle) {
        int n = 0;
        while (n < this.rects.size()) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(n);
            if (rectangle.x > rectangle2.x && rectangle.y > rectangle2.y && Region.right(rectangle) <= Region.right(rectangle2) && Region.bottom(rectangle) <= Region.bottom(rectangle2)) {
                return;
            }
            if (rectangle.intersects(rectangle2)) {
                rectangle = rectangle.union(rectangle2);
                this.rects.removeElementAt(n);
                continue;
            }
            ++n;
        }
        this.rects.addElement(rectangle);
    }

    public boolean intersects(Rectangle rectangle) {
        for (int i = 0; i < this.rects.size(); ++i) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(i);
            if (!rectangle2.intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    public void intersect(Rectangle rectangle) {
        int n = 0;
        while (n < this.rects.size()) {
            Rectangle rectangle2 = (Rectangle)this.rects.elementAt(n);
            if ((rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) {
                this.rects.removeElementAt(n);
                continue;
            }
            this.rects.setElementAt(rectangle2, n);
            ++n;
        }
    }

    public void addRegion(Region region) {
        Enumeration enumeration = region.rectangles();
        while (enumeration.hasMoreElements()) {
            this.addRectangle((Rectangle)enumeration.nextElement());
        }
    }

    public void translate(int n, int n2) {
        for (int i = 0; i < this.rects.size(); ++i) {
            Rectangle rectangle = (Rectangle)this.rects.elementAt(i);
            rectangle.translate(n, n2);
        }
    }

    public String toString() {
        String string = this.getClass().getName() + " = [\n";
        Enumeration enumeration = this.rectangles();
        while (enumeration.hasMoreElements()) {
            string = string + "(" + (Rectangle)enumeration.nextElement() + ")\n";
        }
        return string + "]";
    }

    public static int right(Rectangle rectangle) {
        return rectangle.x + rectangle.width - 1;
    }

    public static int bottom(Rectangle rectangle) {
        return rectangle.y + rectangle.height - 1;
    }
}

