/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;
import javax.media.control.MonitorControl;
import javax.media.format.FormatChangeEvent;

public class PlayerWindow
extends Frame
implements ControllerListener {
    private static final String MENU_ZOOM_1_2 = JMFI18N.getResource("mediaplayer.zoom.1:2");
    private static final String MENU_ZOOM_1_1 = JMFI18N.getResource("mediaplayer.zoom.1:1");
    private static final String MENU_ZOOM_2_1 = JMFI18N.getResource("mediaplayer.zoom.2:1");
    private static final String MENU_ZOOM_4_1 = JMFI18N.getResource("mediaplayer.zoom.4:1");
    private static final String MENU_ZOOM = JMFI18N.getResource("mediaplayer.menu.zoom");
    Player player;
    Panel framePanel;
    ComponentListener cl;
    ComponentListener fcl;
    WindowListener wl;
    MouseListener ml;
    Component controlComp = null;
    Component visualComp = null;
    Insets insets;
    PopupMenu zoomMenu = null;
    boolean windowCreated = false;
    boolean newVideo = true;
    boolean panelResized = false;
    boolean autoStart = true;
    boolean autoLoop = true;
    Component progressBar = null;
    private Integer playerLock = new Integer(1);

    public PlayerWindow(Player player) {
        this(player, JMFI18N.getResource("mediaplayer.windowtitle"), true, true);
    }

    public PlayerWindow(Player player, String string) {
        this(player, string, true, true);
    }

    public PlayerWindow(Player player, String string, boolean bl) {
        this(player, string, bl, true);
    }

    public PlayerWindow(Player player, String string, boolean bl, boolean bl2) {
        super(string);
        this.autoStart = bl;
        this.autoLoop = bl2;
        this.player = player;
        this.setLayout(new BorderLayout());
        this.framePanel = new Panel();
        this.framePanel.setLayout(null);
        this.add((Component)this.framePanel, "Center");
        this.insets = this.getInsets();
        this.setSize(this.insets.left + this.insets.right + 320, this.insets.top + this.insets.bottom + 30);
        this.setVisible(true);
        this.wl = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlayerWindow.this.killThePlayer();
            }
        };
        this.addWindowListener(this.wl);
        this.fcl = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PlayerWindow.this.panelResized = true;
                PlayerWindow.this.doResize();
            }
        };
        this.framePanel.addComponentListener(this.fcl);
        this.fcl = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PlayerWindow.this.insets = PlayerWindow.this.getInsets();
                Dimension dimension = PlayerWindow.this.getSize();
                PlayerWindow.this.framePanel.setSize(dimension.width - PlayerWindow.this.insets.left - PlayerWindow.this.insets.right, dimension.height - PlayerWindow.this.insets.top - PlayerWindow.this.insets.bottom);
            }
        };
        this.addComponentListener(this.fcl);
        player.addControllerListener(this);
        player.realize();
    }

    void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        this.invalidate();
    }

    public void doResize() {
        Dimension dimension = this.framePanel.getSize();
        int n = dimension.height;
        if (this.controlComp != null) {
            if ((n -= this.controlComp.getPreferredSize().height) < 2) {
                n = 2;
            }
            if (dimension.width < 80) {
                dimension.width = 80;
            }
            this.controlComp.setBounds(0, n, dimension.width, this.controlComp.getPreferredSize().height);
            this.controlComp.invalidate();
        }
        if (this.visualComp != null) {
            this.visualComp.setBounds(0, 0, dimension.width, n);
        }
        this.framePanel.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killThePlayer() {
        Integer n = this.playerLock;
        synchronized (n) {
            if (this.visualComp != null) {
                this.framePanel.remove(this.visualComp);
                this.visualComp = null;
            }
            if (this.controlComp != null) {
                this.framePanel.remove(this.controlComp);
                this.controlComp = null;
            }
            if (this.player != null) {
                this.player.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        Integer n = this.playerLock;
        synchronized (n) {
            CachingControl cachingControl;
            if (controllerEvent instanceof RealizeCompleteEvent) {
                int n2 = 320;
                int n3 = 0;
                this.insets = this.getInsets();
                if (this.progressBar != null) {
                    this.framePanel.remove(this.progressBar);
                }
                if ((this.visualComp = this.player.getVisualComponent()) != null) {
                    n2 = this.visualComp.getPreferredSize().width;
                    n3 = this.visualComp.getPreferredSize().height;
                    this.framePanel.add(this.visualComp);
                    this.visualComp.setBounds(0, 0, n2, n3);
                    this.addPopupMenu(this.visualComp);
                } else {
                    MonitorControl monitorControl = (MonitorControl)this.player.getControl("javax.media.control.MonitorControl");
                    if (monitorControl != null) {
                        Panel panel;
                        Control[] controlArray = this.player.getControls();
                        Panel panel2 = panel = new Panel(new BorderLayout());
                        for (int i = 0; i < controlArray.length; ++i) {
                            if (!(controlArray[i] instanceof MonitorControl)) continue;
                            monitorControl = (MonitorControl)controlArray[i];
                            monitorControl.setEnabled(true);
                            if (monitorControl.getControlComponent() == null) continue;
                            panel2.add("North", monitorControl.getControlComponent());
                            Panel panel3 = new Panel(new BorderLayout());
                            panel2.add("South", panel3);
                            panel2 = panel3;
                        }
                        this.visualComp = panel;
                        n2 = this.visualComp.getPreferredSize().width;
                        n3 = this.visualComp.getPreferredSize().height;
                        this.framePanel.add(this.visualComp);
                        this.visualComp.setBounds(0, 0, n2, n3);
                    }
                }
                this.controlComp = this.player.getControlPanelComponent();
                if (this.controlComp != null) {
                    int n4 = this.controlComp.getPreferredSize().height;
                    this.framePanel.add(this.controlComp);
                    this.controlComp.setBounds(0, n3, n2, n4);
                    n3 += n4;
                }
                this.setSize(n2 + this.insets.left + this.insets.right, n3 + this.insets.top + this.insets.bottom);
                if (this.autoStart) {
                    this.player.prefetch();
                }
            } else if (controllerEvent instanceof PrefetchCompleteEvent) {
                if (this.visualComp != null) {
                    Dimension dimension = this.visualComp.getPreferredSize();
                    if (this.controlComp != null) {
                        dimension.height += this.controlComp.getPreferredSize().height;
                    }
                    this.panelResized = false;
                    this.setSize(dimension.width + this.insets.left + this.insets.right, dimension.height + this.insets.top + this.insets.bottom);
                    int n5 = 0;
                    while (!this.panelResized && n5 < 2000) {
                        try {
                            n5 += 50;
                            Thread.currentThread();
                            Thread.sleep(50L);
                            Thread.currentThread();
                            Thread.yield();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    int n6 = 1;
                    if (this.controlComp != null) {
                        n6 = this.controlComp.getPreferredSize().height;
                    }
                    this.setSize(320 + this.insets.left + this.insets.right, n6 + this.insets.top + this.insets.bottom);
                }
                if (this.autoStart && this.player != null && this.player.getTargetState() != 600) {
                    this.player.start();
                }
            } else if (controllerEvent instanceof EndOfMediaEvent) {
                if (this.autoLoop) {
                    this.player.setMediaTime(new Time(0L));
                    this.player.start();
                }
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                System.err.println("Received controller error");
                this.killThePlayer();
                this.dispose();
            } else if (controllerEvent instanceof SizeChangeEvent) {
                if (this.framePanel != null) {
                    SizeChangeEvent sizeChangeEvent = (SizeChangeEvent)controllerEvent;
                    int n7 = sizeChangeEvent.getWidth();
                    int n8 = sizeChangeEvent.getHeight();
                    if (this.controlComp != null) {
                        n8 += this.controlComp.getPreferredSize().height;
                    }
                    if (this.framePanel.getSize().width != n7 || this.framePanel.getSize().height != n8) {
                        this.setSize(n7 + this.insets.left + this.insets.right, n8 + this.insets.top + this.insets.bottom);
                    } else {
                        this.doResize();
                    }
                    if (this.controlComp != null) {
                        this.controlComp.invalidate();
                    }
                }
            } else if (controllerEvent instanceof FormatChangeEvent) {
                Dimension dimension = new Dimension(320, 0);
                Component component = this.visualComp;
                this.visualComp = this.player.getVisualComponent();
                if (this.visualComp != null && component != this.visualComp) {
                    if (component != null && this.zoomMenu != null) {
                        component.remove(this.zoomMenu);
                    }
                    this.framePanel.remove(component);
                    dimension = this.visualComp.getPreferredSize();
                    this.framePanel.add(this.visualComp);
                    this.visualComp.setBounds(0, 0, dimension.width, dimension.height);
                    this.addPopupMenu(this.visualComp);
                }
                Component component2 = this.controlComp;
                this.controlComp = this.player.getControlPanelComponent();
                if (this.controlComp != null && component2 != this.controlComp) {
                    this.framePanel.remove(component2);
                    this.framePanel.add(this.controlComp);
                    if (this.controlComp != null) {
                        int n9 = this.controlComp.getPreferredSize().height;
                        this.controlComp.setBounds(0, dimension.height, dimension.width, n9);
                    }
                }
            } else if (controllerEvent instanceof ControllerClosedEvent) {
                if (this.visualComp != null) {
                    if (this.zoomMenu != null) {
                        this.visualComp.remove(this.zoomMenu);
                    }
                    this.visualComp.removeMouseListener(this.ml);
                }
                this.removeWindowListener(this.wl);
                this.removeComponentListener(this.cl);
                if (this.framePanel != null) {
                    this.framePanel.removeAll();
                }
                this.player = null;
                this.visualComp = null;
                this.controlComp = null;
                this.sleep(200L);
                this.dispose();
            } else if (controllerEvent instanceof CachingControlEvent && (cachingControl = ((CachingControlEvent)controllerEvent).getCachingControl()) != null && this.progressBar == null) {
                this.progressBar = cachingControl.getControlComponent();
                if (this.progressBar == null) {
                    this.progressBar = cachingControl.getProgressBarComponent();
                }
                if (this.progressBar != null) {
                    this.framePanel.add(this.progressBar);
                    Dimension dimension = this.progressBar.getPreferredSize();
                    this.progressBar.setBounds(0, 0, dimension.width, dimension.height);
                    this.insets = this.getInsets();
                    this.framePanel.setSize(dimension.width, dimension.height);
                    this.setSize(this.insets.left + this.insets.right + dimension.width, this.insets.top + this.insets.bottom + dimension.height);
                }
            }
        }
    }

    public void zoomTo(float f) {
        if (this.visualComp != null) {
            this.insets = this.getInsets();
            Dimension dimension = this.visualComp.getPreferredSize();
            dimension.width = (int)((float)dimension.width * f);
            dimension.height = (int)((float)dimension.height * f);
            if (this.controlComp != null) {
                dimension.height += this.controlComp.getPreferredSize().height;
            }
            this.setSize(dimension.width + this.insets.left + this.insets.right, dimension.height + this.insets.top + this.insets.bottom);
        }
    }

    private void addPopupMenu(Component component) {
        this.zoomMenu = new PopupMenu(MENU_ZOOM);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals(MENU_ZOOM_1_2)) {
                    PlayerWindow.this.zoomTo(0.5f);
                } else if (string.equals(MENU_ZOOM_1_1)) {
                    PlayerWindow.this.zoomTo(1.0f);
                } else if (string.equals(MENU_ZOOM_2_1)) {
                    PlayerWindow.this.zoomTo(2.0f);
                } else if (string.equals(MENU_ZOOM_4_1)) {
                    PlayerWindow.this.zoomTo(4.0f);
                }
            }
        };
        component.add(this.zoomMenu);
        MenuItem menuItem = new MenuItem(MENU_ZOOM_1_2);
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(actionListener);
        menuItem = new MenuItem(MENU_ZOOM_1_1);
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(actionListener);
        menuItem = new MenuItem(MENU_ZOOM_2_1);
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(actionListener);
        menuItem = new MenuItem(MENU_ZOOM_4_1);
        this.zoomMenu.add(menuItem);
        menuItem.addActionListener(actionListener);
        this.ml = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        component.addMouseListener(this.ml);
    }
}

