/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import com.sun.media.ui.PopupThread;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

class GainSlider
extends Window
implements GainChangeListener,
MouseListener,
MouseMotionListener,
FocusListener {
    private GainControl gainControl;
    private Image imageGrabber = null;
    private Dimension dimGrabber = new Dimension();
    private Button buttonFocus;
    private boolean boolFocus = false;
    private boolean pressed = false;
    private PopupThread threadPopup = null;
    private Image imageBackground = null;
    private static final int WIDTH = 80;
    private static final int HEIGHT = 20;

    public GainSlider(GainControl gainControl) {
        this(gainControl, new Frame());
    }

    public GainSlider(GainControl gainControl, Frame frame) {
        super(frame);
        this.gainControl = gainControl;
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.gainControl = null;
    }

    public void addNotify() {
        super.addNotify();
        Insets insets = this.getInsets();
        this.setSize(80 + insets.left + insets.right, 20 + insets.top + insets.bottom);
    }

    private void init() throws Exception {
        this.gainControl.addGainChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        this.imageBackground = BasicComp.fetchImage("texture3.gif");
        this.buttonFocus = new Button("Focus");
        this.buttonFocus.setBounds(-100, -100, 80, 24);
        this.add(this.buttonFocus);
        this.buttonFocus.addFocusListener(this);
        this.imageGrabber = BasicComp.fetchImage("grabber.gif");
        this.setBackground(Color.lightGray);
        this.setSize(80, 20);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.buttonFocus.requestFocus();
            if (this.threadPopup != null) {
                this.threadPopup.stopNormaly();
            }
            this.threadPopup = new PopupThread(this);
            this.threadPopup.resetCounter(3);
            this.threadPopup.start();
        } else if (this.threadPopup != null) {
            this.threadPopup.stopNormaly();
        }
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image != null ? image.getGraphics() : graphics;
        this.paint(graphics2);
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
        graphics.draw3DRect(rectangle.x + 4, rectangle.y + rectangle.height / 2 - 2, rectangle.width - 9, 3, false);
        if (this.dimGrabber.width < 1) {
            this.dimGrabber.width = this.imageGrabber.getWidth(this);
        }
        if (this.dimGrabber.height < 1) {
            this.dimGrabber.height = this.imageGrabber.getHeight(this);
        }
        float f = this.gainControl.getLevel();
        int n = rectangle.x + (int)(2.0f + f * (float)(rectangle.width - 5 - this.dimGrabber.width));
        int n2 = rectangle.y + (rectangle.height - this.dimGrabber.height) / 2;
        graphics.drawImage(this.imageGrabber, n, n2, this);
    }

    private void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.imageBackground == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            Rectangle rectangle = new Rectangle(0, 0, this.imageBackground.getWidth(this), this.imageBackground.getHeight(this));
            Rectangle rectangle2 = graphics.getClipBounds();
            while (rectangle.y < dimension.height) {
                while (rectangle.x < dimension.width) {
                    if (rectangle2 == null || rectangle2.intersects(rectangle)) {
                        graphics.drawImage(this.imageBackground, rectangle.x, rectangle.y, this);
                    }
                    rectangle.x += rectangle.width;
                }
                rectangle.x = 0;
                rectangle.y += rectangle.height;
            }
        }
    }

    public void gainChange(GainChangeEvent gainChangeEvent) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.threadPopup != null) {
            this.threadPopup.resetCounter(3);
        }
        Point point = mouseEvent.getPoint();
        this.setLevelToMouse(point);
        this.pressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
        if (!this.boolFocus) {
            this.setVisible(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.boolFocus = true;
        if (this.threadPopup != null) {
            this.threadPopup.stopNormaly();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.boolFocus && !this.pressed) {
            this.setVisible(false);
        }
        this.boolFocus = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.threadPopup != null) {
            this.threadPopup.resetCounter(3);
        }
        Point point = mouseEvent.getPoint();
        this.setLevelToMouse(point);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    private void setLevelToMouse(Point point) {
        if (this.gainControl == null) {
            return;
        }
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = point.x - 2 - insets.left;
        int n2 = dimension.width - insets.left - insets.right - 5;
        if (n > n2) {
            n = n2;
        }
        if (n < 0) {
            n = 0;
        }
        float f = (float)n / (float)n2;
        this.gainControl.setMute(false);
        this.gainControl.setLevel(f);
    }
}

