/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.ColumnData;
import com.sun.media.ui.RowData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class ColumnList
extends Canvas
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_DATE = 4;
    private static final int MARGIN_VERT = 2;
    private static final int MARGIN_HORZ = 6;
    private static final Color COLOR_HEADER_BG = Color.lightGray;
    private static final Color COLOR_HEADER_FG = Color.black;
    private static final Color COLOR_SHADOW_TOP = Color.white;
    private static final Color COLOR_SHADOW_BOTTOM = Color.darkGray;
    private static final Color COLOR_SEL_BG = Color.white;
    private static final Color COLOR_SEL_FG = Color.black;
    private Vector vectorColumns = new Vector();
    private Vector vectorRows = new Vector();
    private boolean boolFocus = false;
    private boolean boolSetColumnWidthAsPreferred = false;
    private int nScrollPosHorz = 0;
    private int nScrollPosVert = 0;
    private int nCurrentIndex = 0;
    private int nVisibleRows = 1;
    private Font fontHeader = new Font("Dialog", 0, 12);
    private Font fontItem = new Font("Dialog", 0, 12);
    private int nHeightHeader;
    private int nHeightRow;

    public ColumnList(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ColumnData columnData = new ColumnData(stringArray[i], 3);
            this.vectorColumns.addElement(columnData);
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addRow(Object[] objectArray) {
        RowData rowData = new RowData(objectArray);
        this.vectorRows.addElement(rowData);
        this.repaint();
    }

    public void removeRow(int n) {
        this.vectorRows.removeElementAt(n);
        this.repaint();
    }

    public void setCellValue(Object object, int n, int n2) {
        RowData rowData = (RowData)this.vectorRows.elementAt(n);
        rowData.setValue(object, n2);
        this.repaint();
    }

    public void setColumnWidth(int n, int n2) {
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n2);
        columnData.nWidth = n;
        this.repaint();
    }

    public void setColumnWidth(int n) {
        int n2 = this.vectorColumns.size();
        for (int i = 0; i < n2; ++i) {
            ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(i);
            columnData.nWidth = n;
        }
        this.repaint();
    }

    public void setColumnWidthAsPreferred(int n) {
        int n2;
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n);
        columnData.nWidth = n2 = this.getPreferredColumnWidth(n);
        this.repaint();
    }

    public void setColumnWidthAsPreferred() {
        ColumnData columnData;
        int n;
        int n2 = this.vectorColumns.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4;
            columnData = (ColumnData)this.vectorColumns.elementAt(n);
            columnData.nWidth = n4 = this.getPreferredColumnWidth(n);
            n3 += n4;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < 1) {
            this.boolSetColumnWidthAsPreferred = true;
        }
        rectangle.width -= 2;
        if (rectangle.width > n3) {
            int n5 = (rectangle.width - n3) / n2;
            n3 = rectangle.width;
            for (n = 0; n < n2; ++n) {
                columnData = (ColumnData)this.vectorColumns.elementAt(n);
                columnData.nWidth = n < n2 - 1 ? (columnData.nWidth += n5) : n3;
                n3 -= columnData.nWidth;
            }
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.height += this.nHeightHeader;
        int n = this.nHeightRow;
        dimension.height += (n *= this.vectorRows.size());
        int n2 = this.vectorColumns.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getPreferredColumnWidth(i);
            dimension.width += n3;
        }
        dimension.width += 3;
        dimension.height += 3;
        return dimension;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image != null ? image.getGraphics() : graphics;
        this.paint(graphics2);
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        ColumnData columnData;
        int n5;
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle(rectangle);
        super.paint(graphics);
        graphics.setColor(COLOR_SHADOW_BOTTOM);
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 2, rectangle2.height - 2);
        graphics.setColor(COLOR_SHADOW_TOP);
        graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
        int n6 = this.vectorColumns.size();
        int n7 = this.vectorRows.size();
        ++rectangle2.x;
        ++rectangle2.y;
        int n8 = rectangle2.x;
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        graphics.setFont(this.fontHeader);
        int n9 = fontMetrics.getHeight();
        rectangle2.height = this.nHeightHeader;
        for (n5 = this.nScrollPosHorz; n5 < n6; ++n5) {
            columnData = (ColumnData)this.vectorColumns.elementAt(n5);
            rectangle2.width = columnData.nWidth;
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width - 1) {
                rectangle2.width = rectangle.x + rectangle.width - 1 - rectangle2.x;
            }
            graphics.setColor(COLOR_HEADER_BG);
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.setColor(COLOR_SHADOW_TOP);
            graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height - 2);
            graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width - 2, rectangle2.y);
            graphics.setColor(COLOR_SHADOW_BOTTOM);
            graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            string = columnData.strName;
            n4 = string.length();
            n3 = fontMetrics.stringWidth(string);
            while (n3 > rectangle2.width - 12 && n4 > 0) {
                string = string.substring(0, --n4) + "...";
                n3 = fontMetrics.stringWidth(string);
            }
            n2 = rectangle2.x + (rectangle2.width - n3) / 2;
            n = rectangle2.y + rectangle2.height - (rectangle2.height - n9) / 2 - fontMetrics.getMaxDescent();
            graphics.setColor(this.getForeground());
            graphics.drawString(string, n2, n);
            rectangle2.x += rectangle2.width;
        }
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        n9 = fontMetrics.getHeight();
        rectangle2.y += rectangle2.height;
        rectangle2.height = this.nHeightRow;
        for (int i = this.nScrollPosVert; i < n7; ++i) {
            rectangle2.x = n8;
            if (i == this.nCurrentIndex) {
                rectangle2.width = rectangle.width - 3;
                graphics.setColor(COLOR_SEL_BG);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(COLOR_SEL_FG);
                if (this.boolFocus) {
                    this.drawDottedLine(graphics, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width - 1, rectangle2.y);
                    this.drawDottedLine(graphics, rectangle2.x, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
                }
            } else {
                graphics.setColor(this.getForeground());
            }
            RowData rowData = (RowData)this.vectorRows.elementAt(i);
            for (n5 = this.nScrollPosHorz; n5 < n6; ++n5) {
                columnData = (ColumnData)this.vectorColumns.elementAt(n5);
                rectangle2.width = columnData.nWidth;
                if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width - 1) {
                    rectangle2.width = rectangle.x + rectangle.width - 1 - rectangle2.x;
                }
                string = rowData.getValue(n5).toString();
                n4 = string.length();
                n3 = fontMetrics.stringWidth(string);
                while (n3 > rectangle2.width - 12 && n4 > 0) {
                    string = string.substring(0, --n4) + "...";
                    n3 = fontMetrics.stringWidth(string);
                }
                n2 = rectangle2.x + 6;
                n = rectangle2.y + rectangle2.height - (rectangle2.height - n9) / 2 - fontMetrics.getMaxDescent();
                graphics.drawString(string, n2, n);
                rectangle2.x += rectangle2.width;
            }
            rectangle2.y += rectangle2.height;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if ((n3 -= 1 + this.nHeightHeader) >= 0 && (n = n3 / this.nHeightRow) >= 0 && n < this.vectorRows.size() - this.nScrollPosVert) {
            this.nCurrentIndex = n + this.nScrollPosVert;
        }
        this.requestFocus();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.nCurrentIndex;
        if (n == 40) {
            ++n2;
        } else if (n == 38) {
            --n2;
        } else if (n == 36) {
            n2 = 0;
        } else if (n == 35) {
            n2 = this.vectorRows.size() - 1;
        } else if (n == 33) {
            n2 -= this.nVisibleRows;
        } else if (n == 34) {
            n2 += this.nVisibleRows;
        }
        if (n2 > this.vectorRows.size() - 1) {
            n2 = this.vectorRows.size() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != this.nCurrentIndex) {
            this.nCurrentIndex = n2;
            if (this.nScrollPosVert + this.nVisibleRows < this.nCurrentIndex) {
                this.nScrollPosVert = this.nCurrentIndex - this.nVisibleRows + 1;
            }
            if (this.nScrollPosVert > this.nCurrentIndex) {
                this.nScrollPosVert = this.nCurrentIndex;
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.boolFocus) {
            return;
        }
        this.boolFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.boolFocus) {
            return;
        }
        this.boolFocus = false;
        this.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.boolSetColumnWidthAsPreferred) {
            this.boolSetColumnWidthAsPreferred = false;
            this.setColumnWidthAsPreferred();
        }
        Rectangle rectangle = this.getBounds();
        rectangle.height -= 3 + this.nHeightHeader;
        this.nVisibleRows = rectangle.height / this.nHeightRow;
        if (this.nVisibleRows < 1) {
            this.nVisibleRows = 1;
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void init() throws Exception {
        this.setFont(this.fontItem);
        this.computeHeights();
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
    }

    private int getPreferredColumnWidth(int n) {
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n);
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        String string = columnData.strName;
        int n2 = fontMetrics.stringWidth(string) + 12 + 2;
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        int n3 = this.vectorRows.size();
        for (int i = 0; i < n3; ++i) {
            RowData rowData = (RowData)this.vectorRows.elementAt(i);
            string = rowData.getValue(n).toString();
            int n4 = fontMetrics.stringWidth(string) + 12;
            n2 = Math.max(n2, n4);
        }
        return n2;
    }

    private void computeHeights() {
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        this.nHeightHeader = fontMetrics.getHeight();
        this.nHeightHeader += 2;
        this.nHeightHeader += 4;
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        this.nHeightRow = fontMetrics.getHeight();
        this.nHeightRow += 4;
    }

    private void drawDottedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n == n3 && n2 == n4) {
            this.drawDot(graphics, n, n2);
            return;
        }
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        if (n3 - n > n4 - n2) {
            double d = (double)(n4 - n2) / (double)(n3 - n);
            for (n6 = n; n6 <= n3; ++n6) {
                n5 = (int)Math.rint((double)n2 + (double)(n6 - n) * d);
                this.drawDot(graphics, n6, n5);
            }
        } else {
            double d = (n3 - n) / (n4 - n2);
            for (n5 = n2; n5 <= n4; ++n5) {
                n6 = (int)Math.rint((double)n + (double)(n5 - n2) * d);
                this.drawDot(graphics, n6, n5);
            }
        }
    }

    private void drawDot(Graphics graphics, int n, int n2) {
        if ((n + n2) % 2 == 0) {
            graphics.drawLine(n, n2, n, n2);
        }
    }
}

