/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ButtonComp
extends BasicComp
implements MouseListener {
    Image[] imageNormal = new Image[2];
    Image[] imageActive = new Image[2];
    Image[] imageDown = new Image[2];
    Image[] imageDisabled = new Image[2];
    static final int NORMAL = 1;
    static final int ACTIVE = 2;
    static final int DOWN = 4;
    static final int DISABLED = 8;
    int width;
    int height;
    boolean state = false;
    boolean mouseIn = false;
    boolean mouseDown = false;
    boolean mouseUp = false;
    boolean mouseClick = false;
    int visualState = 1;
    private PopupMenu menuPopup = null;
    private ContPressThread threadContPress = null;
    private boolean boolContPress = false;
    private boolean boolPopup = false;
    private boolean boolDoAction = false;
    private static final int POPUP_DELAY = 1000;

    public ButtonComp(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        super(string);
        this.imageNormal[0] = ButtonComp.fetchImage(string2);
        this.imageNormal[1] = ButtonComp.fetchImage(string6);
        this.imageActive[0] = ButtonComp.fetchImage(string3);
        this.imageActive[1] = ButtonComp.fetchImage(string7);
        this.imageDown[0] = ButtonComp.fetchImage(string4);
        this.imageDown[1] = ButtonComp.fetchImage(string8);
        this.imageDisabled[0] = ButtonComp.fetchImage(string5);
        this.imageDisabled[1] = ButtonComp.fetchImage(string9);
        this.width = this.imageNormal[0].getWidth(this);
        this.height = this.imageNormal[0].getHeight(this);
        this.visualState = 1;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.addMouseListener(this);
    }

    public void mouseActivity() {
        if (this.isEnabled()) {
            if (this.mouseIn) {
                if (this.mouseDown) {
                    this.visualState = 4;
                    if (this.mouseUp) {
                        this.action();
                        this.visualState = 2;
                    }
                } else {
                    this.visualState = 2;
                }
            } else {
                this.visualState = 1;
            }
        } else {
            this.visualState = 8;
        }
        this.repaint();
    }

    public void action() {
        if (!this.boolDoAction) {
            return;
        }
        this.state = !this.state;
        this.informListener();
    }

    public void paint(Graphics graphics) {
        int n = this.state ? 1 : 0;
        Image image = null;
        switch (this.visualState) {
            case 1: {
                image = this.imageNormal[n];
                break;
            }
            case 2: {
                image = this.imageActive[n];
                break;
            }
            case 4: {
                image = this.imageDown[n];
                break;
            }
            case 8: {
                image = this.imageDisabled[n];
            }
        }
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.visualState = !bl ? 8 : (this.mouseIn ? (this.mouseDown ? 4 : 2) : 1);
        this.repaint();
    }

    public boolean getValue() {
        return this.state;
    }

    public void setValue(boolean bl) {
        if (this.state != bl) {
            this.state = bl;
            this.repaint();
        }
    }

    public void setPopupMenu(PopupMenu popupMenu) {
        if (popupMenu != null) {
            this.setMousePopup(true);
            this.menuPopup = popupMenu;
            this.add(popupMenu);
        } else if (this.menuPopup != null) {
            this.setMousePopup(false);
            this.remove(this.menuPopup);
            this.menuPopup = null;
        }
    }

    public void setMousePopup(boolean bl) {
        this.boolPopup = bl;
    }

    public void setContMousePress(boolean bl) {
        this.boolContPress = bl;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIn = true;
        this.mouseActivity();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseIn = false;
        this.mouseActivity();
        if (this.threadContPress != null) {
            this.threadContPress.stopNormaly();
            this.threadContPress = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 8) == 0 && (n & 4) == 0) {
            this.mouseDown = true;
            this.mouseUp = false;
            this.mouseActivity();
            if (this.boolContPress || this.boolPopup) {
                if (this.threadContPress != null) {
                    this.threadContPress.stopNormaly();
                }
                this.threadContPress = new ContPressThread(this);
                if (this.boolPopup) {
                    this.threadContPress.setDelayedPress(1000L);
                }
                this.threadContPress.start();
            }
            this.boolDoAction = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 8) == 0 && (n & 4) == 0) {
            this.mouseUp = true;
            this.mouseActivity();
            this.mouseUp = false;
            this.mouseDown = false;
            if (this.threadContPress != null) {
                this.threadContPress.stopNormaly();
                this.threadContPress = null;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 8) == 0 && (n & 4) == 0) {
            this.mouseClick = true;
            this.mouseActivity();
            this.mouseClick = false;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.processMousePopup();
        }
    }

    protected void processMousePopup() {
        if (this.menuPopup != null) {
            this.menuPopup.show(this, 0, this.height);
        }
    }

    protected void processContPress() {
        if (this.boolContPress) {
            this.informListener();
        } else if (this.boolPopup && this.mouseIn && this.mouseDown) {
            this.boolDoAction = false;
            this.processMousePopup();
        }
    }

    class ContPressThread
    extends Thread {
        protected ButtonComp button = null;
        protected boolean boolContinueRun = true;
        protected boolean boolIgnoreFirst = true;
        protected boolean boolDelayedPress = false;
        protected long lMills = 500L;

        public ContPressThread(ButtonComp buttonComp2) {
            this.button = buttonComp2;
        }

        public void setDelayedPress(long l) {
            this.boolDelayedPress = true;
            this.lMills = l;
        }

        public void stopNormaly() {
            this.boolContinueRun = false;
        }

        public void run() {
            this.boolIgnoreFirst = !this.boolDelayedPress;
            while (this.boolContinueRun) {
                try {
                    ContPressThread.sleep(this.lMills);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.button != null && !this.boolIgnoreFirst) {
                    this.button.processContPress();
                }
                this.boolIgnoreFirst = false;
                if (!this.boolDelayedPress) continue;
                this.boolContinueRun = false;
            }
            this.boolDelayedPress = false;
            this.lMills = 250L;
        }
    }
}

