/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.Region;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BufferedPanel
extends Panel {
    protected boolean buffered;
    protected boolean autoFlushing;
    protected Image background;
    protected boolean windowCreated;
    protected transient Image buffer;
    protected transient Graphics bufferGraphics;
    protected transient Region damage;
    protected Object lock = new Object();

    public BufferedPanel(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
        this.buffered = true;
        this.autoFlushing = true;
        this.background = null;
        this.windowCreated = false;
        this.buffer = null;
        this.bufferGraphics = null;
        this.damage = new Region();
    }

    public BufferedPanel() {
        this(null);
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean bl) {
        if (bl != this.buffered) {
            this.buffered = bl;
            if (bl) {
                this.repaint();
            }
        }
    }

    public boolean isAutoFlushing() {
        return this.autoFlushing;
    }

    public void setAutoFlushing(boolean bl) {
        if (bl != this.autoFlushing) {
            this.autoFlushing = bl;
        }
    }

    public Image getBackgroundTile() {
        return this.background;
    }

    public void setBackgroundTile(Image image) {
        this.background = image;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        if (this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        super.reshape(n, n2, n3, n4);
        if (this.windowCreated && (n3 != rectangle.width || n4 != rectangle.height) && this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void flushBuffer() {
        Dimension dimension = this.getSize();
        super.repaint(0L, 0, 0, dimension.width, dimension.height);
    }

    void createBufferImage() {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            this.buffer = this.createImage(dimension.width, dimension.height);
            if (this.buffer != null) {
                this.bufferGraphics = this.buffer.getGraphics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBuffer() {
        Region region;
        if (this.damage.isEmpty()) {
            return;
        }
        if (this.buffer == null) {
            return;
        }
        Object object = this.damage;
        synchronized (object) {
            region = this.damage;
            this.damage = new Region();
        }
        object = region.rectangles();
        while (object.hasMoreElements()) {
            Rectangle rectangle = (Rectangle)object.nextElement();
            this.render(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Rectangle rectangle) {
        Component[] componentArray = this.getComponents();
        Image image = this.buffer;
        synchronized (image) {
            this.bufferGraphics.setClip(rectangle);
            this.paintBackground(this.bufferGraphics);
            this.bufferGraphics.setColor(this.getForeground());
            for (int i = componentArray.length - 1; i >= 0; --i) {
                Rectangle rectangle2;
                Component component = componentArray[i];
                if (!this.isLightweight(component) || !component.isVisible() || !(rectangle2 = component.getBounds()).intersects(rectangle)) continue;
                Graphics graphics = this.bufferGraphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                component.paint(graphics);
                graphics.dispose();
            }
            this.bufferGraphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    protected void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.background == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            Rectangle rectangle = new Rectangle(0, 0, this.background.getWidth(this), this.background.getHeight(this));
            Rectangle rectangle2 = graphics.getClipBounds();
            while (rectangle.y < dimension.height) {
                while (rectangle.x < dimension.width) {
                    if (rectangle2 == null || rectangle2.intersects(rectangle)) {
                        graphics.drawImage(this.background, rectangle.x, rectangle.y, this);
                    }
                    rectangle.x += rectangle.width;
                }
                rectangle.x = 0;
                rectangle.y += rectangle.height;
            }
        }
    }

    boolean isLightweight(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.buffered) {
            Region region = this.damage;
            synchronized (region) {
                this.damage.addRectangle(new Rectangle(n, n2, n3, n4));
            }
            if (this.autoFlushing) {
                this.flushBuffer();
            }
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void update(Graphics graphics) {
        if (this.buffered) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }

    public void paint(Graphics graphics) {
        if (this.buffered && this.buffer != null) {
            this.renderBuffer();
            graphics.drawImage(this.buffer, 0, 0, this);
        } else {
            super.paint(graphics);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.damage = new Region();
    }
}

