/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class AudioFormatChooser
extends Panel
implements ItemListener {
    public static final String ACTION_TRACK_ENABLED = "ACTION_AUDIO_TRACK_ENABLED";
    public static final String ACTION_TRACK_DISABLED = "ACTION_AUDIO_TRACK_DISABLED";
    private AudioFormat formatOld;
    private Format[] arrSupportedFormats = null;
    private Vector vectorContSuppFormats = new Vector();
    private boolean boolDisplayEnableTrack;
    private ActionListener listenerEnableTrack;
    private boolean boolEnableTrackSaved = true;
    private Checkbox checkEnableTrack;
    private Label labelEncoding;
    private Choice comboEncoding;
    private Label labelSampleRate;
    private Choice comboSampleRate;
    private Label labelHz;
    private Label labelBitsPerSample;
    private CheckboxGroup groupBitsPerSample;
    private Checkbox checkBits8;
    private Checkbox checkBits16;
    private Label labelChannels;
    private CheckboxGroup groupChannels;
    private Checkbox checkMono;
    private Checkbox checkStereo;
    private Label labelEndian;
    private CheckboxGroup groupEndian;
    private Checkbox checkEndianBig;
    private Checkbox checkEndianLittle;
    private Checkbox checkSigned;
    private boolean boolEnable8 = false;
    private boolean boolEnable16 = false;
    private boolean boolEnableMono = false;
    private boolean boolEnableStereo = false;
    private boolean boolEnableEndianBig = false;
    private boolean boolEnableEndianLittle = false;
    private boolean boolEnableSigned = false;

    public AudioFormatChooser(Format[] formatArray, AudioFormat audioFormat) {
        this(formatArray, audioFormat, false, null);
    }

    public AudioFormatChooser(Format[] formatArray, AudioFormat audioFormat, boolean bl, ActionListener actionListener) {
        this.arrSupportedFormats = formatArray;
        this.boolDisplayEnableTrack = bl;
        this.listenerEnableTrack = actionListener;
        int n = this.arrSupportedFormats.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.arrSupportedFormats[i] instanceof AudioFormat)) continue;
            this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i]);
        }
        this.formatOld = this.isFormatSupported(audioFormat) ? audioFormat : null;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.checkEnableTrack != null) {
            this.checkEnableTrack.setEnabled(bl);
        }
        this.enableControls(bl);
    }

    public Format getFormat() {
        Format format = null;
        String string = this.comboEncoding.getSelectedItem();
        String string2 = this.comboSampleRate.getSelectedItem();
        double d = Double.valueOf(string2);
        int n = this.checkBits8.getState() && this.checkBits8.isEnabled() ? 8 : (this.checkBits16.getState() && this.checkBits16.isEnabled() ? 16 : -1);
        int n2 = this.checkMono.getState() && this.checkMono.isEnabled() ? 1 : (this.checkStereo.getState() && this.checkStereo.isEnabled() ? 2 : -1);
        int n3 = this.checkEndianBig.getState() && this.checkEndianBig.isEnabled() ? 1 : (this.checkEndianLittle.getState() && this.checkEndianLittle.isEnabled() ? 0 : -1);
        int n4 = this.checkSigned.getState() ? 1 : 0;
        AudioFormat audioFormat = new AudioFormat(string, d, n, n2, n3, n4);
        int n5 = this.vectorContSuppFormats.size();
        for (int i = 0; i < n5 && format == null; ++i) {
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || !this.isFormatGoodForEncoding(audioFormat2 = (AudioFormat)e) || !this.isFormatGoodForSampleRate(audioFormat2) || !this.isFormatGoodForBitSize(audioFormat2) || !this.isFormatGoodForChannels(audioFormat2) || !this.isFormatGoodForEndian(audioFormat2) || !this.isFormatGoodForSigned(audioFormat2) || !audioFormat2.matches(audioFormat)) continue;
            format = audioFormat2.intersects(audioFormat);
        }
        return format;
    }

    public void setCurrentFormat(AudioFormat audioFormat) {
        if (this.isFormatSupported(audioFormat)) {
            this.formatOld = audioFormat;
        }
        this.updateFields(this.formatOld);
    }

    public void setSupportedFormats(Format[] formatArray, AudioFormat audioFormat) {
        this.arrSupportedFormats = formatArray;
        int n = this.arrSupportedFormats.length;
        this.vectorContSuppFormats.removeAllElements();
        for (int i = 0; i < n; ++i) {
            if (!(this.arrSupportedFormats[i] instanceof AudioFormat)) continue;
            this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i]);
        }
        this.formatOld = this.isFormatSupported(audioFormat) ? audioFormat : null;
        this.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void setSupportedFormats(Vector vector) {
        this.vectorContSuppFormats = vector;
        if (vector.isEmpty()) {
            this.checkEnableTrack.setState(false);
            this.checkEnableTrack.setEnabled(false);
            this.onEnableTrack(true);
            return;
        }
        this.checkEnableTrack.setEnabled(true);
        this.checkEnableTrack.setState(this.boolEnableTrackSaved);
        this.onEnableTrack(true);
        if (!this.isFormatSupported(this.formatOld)) {
            this.formatOld = null;
        }
        this.updateFields(this.formatOld);
    }

    public void setTrackEnabled(boolean bl) {
        this.boolEnableTrackSaved = bl;
        if (this.checkEnableTrack == null) {
            return;
        }
        this.checkEnableTrack.setState(bl);
        this.onEnableTrack(true);
    }

    public boolean isTrackEnabled() {
        boolean bl = this.checkEnableTrack.getState();
        return bl;
    }

    private void init() throws Exception {
        Panel panel;
        this.setLayout(new BorderLayout(6, 6));
        Panel panel2 = this;
        this.checkEnableTrack = new Checkbox(JMFI18N.getResource("formatchooser.enabletrack"), true);
        this.checkEnableTrack.addItemListener(this);
        if (this.boolDisplayEnableTrack) {
            panel = new Panel(new BorderLayout());
            panel2.add((Component)panel, "North");
            panel.add((Component)this.checkEnableTrack, "West");
        }
        panel = new Panel(new BorderLayout(6, 6));
        panel2.add((Component)panel, "Center");
        panel2 = panel;
        panel = new Panel(new BorderLayout());
        panel2.add((Component)panel, "North");
        Panel panel3 = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panel3, "West");
        Panel panel4 = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)panel4, "Center");
        this.labelEncoding = new Label(JMFI18N.getResource("formatchooser.encoding"), 0);
        panel3.add(this.labelEncoding);
        this.comboEncoding = new Choice();
        this.comboEncoding.addItemListener(this);
        panel4.add(this.comboEncoding);
        this.labelSampleRate = new Label(JMFI18N.getResource("formatchooser.samplerate"), 0);
        panel3.add(this.labelSampleRate);
        Panel panel5 = new Panel(new BorderLayout(6, 6));
        panel4.add(panel5);
        this.comboSampleRate = new Choice();
        this.comboSampleRate.addItemListener(this);
        panel5.add((Component)this.comboSampleRate, "Center");
        this.labelHz = new Label(JMFI18N.getResource("formatchooser.hz"));
        panel5.add((Component)this.labelHz, "East");
        this.labelBitsPerSample = new Label(JMFI18N.getResource("formatchooser.bitspersample"), 0);
        panel3.add(this.labelBitsPerSample);
        panel5 = new Panel(new GridLayout(1, 0, 6, 6));
        panel4.add(panel5);
        this.groupBitsPerSample = new CheckboxGroup();
        this.checkBits8 = new Checkbox(JMFI18N.getResource("formatchooser.8bit"), this.groupBitsPerSample, false);
        this.checkBits8.addItemListener(this);
        panel5.add(this.checkBits8);
        this.checkBits16 = new Checkbox(JMFI18N.getResource("formatchooser.16bit"), this.groupBitsPerSample, false);
        this.checkBits16.addItemListener(this);
        panel5.add(this.checkBits16);
        this.labelChannels = new Label(JMFI18N.getResource("formatchooser.channels"), 0);
        panel3.add(this.labelChannels);
        panel5 = new Panel(new GridLayout(1, 0, 6, 6));
        panel4.add(panel5);
        this.groupChannels = new CheckboxGroup();
        this.checkMono = new Checkbox(JMFI18N.getResource("formatchooser.mono"), this.groupChannels, false);
        this.checkMono.addItemListener(this);
        panel5.add(this.checkMono);
        this.checkStereo = new Checkbox(JMFI18N.getResource("formatchooser.stereo"), this.groupChannels, false);
        this.checkStereo.addItemListener(this);
        panel5.add(this.checkStereo);
        this.labelEndian = new Label(JMFI18N.getResource("formatchooser.endian"), 0);
        panel3.add(this.labelEndian);
        panel5 = new Panel(new GridLayout(1, 0, 6, 6));
        panel4.add(panel5);
        this.groupEndian = new CheckboxGroup();
        this.checkEndianBig = new Checkbox(JMFI18N.getResource("formatchooser.endian.big"), this.groupEndian, false);
        this.checkEndianBig.addItemListener(this);
        panel5.add(this.checkEndianBig);
        this.checkEndianLittle = new Checkbox(JMFI18N.getResource("formatchooser.endian.little"), this.groupEndian, false);
        this.checkEndianLittle.addItemListener(this);
        panel5.add(this.checkEndianLittle);
        panel = new Panel(new BorderLayout(6, 6));
        panel2.add((Component)panel, "Center");
        panel2 = panel;
        panel = new Panel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.checkSigned = new Checkbox(JMFI18N.getResource("formatchooser.signed"), true);
        this.checkSigned.addItemListener(this);
        panel.add((Component)this.checkSigned, "West");
        this.updateFields(this.formatOld);
    }

    private void updateFields(AudioFormat audioFormat) {
        String string;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = this.comboEncoding.isEnabled();
        this.comboEncoding.setEnabled(false);
        this.comboEncoding.removeAll();
        int n = this.vectorContSuppFormats.size();
        for (int i = 0; i < n; ++i) {
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || vector.contains(string = (audioFormat2 = (AudioFormat)e).getEncoding().toUpperCase())) continue;
            this.comboEncoding.addItem(string);
            vector.addElement(string);
            if (string2 != null) continue;
            string2 = string;
        }
        if (audioFormat != null) {
            string = audioFormat.getEncoding();
            this.comboEncoding.select(string);
        } else if (string2 != null) {
            this.comboEncoding.select(string2);
        } else if (this.comboEncoding.getItemCount() > 0) {
            this.comboEncoding.select(0);
        }
        this.updateFieldsFromEncoding(audioFormat);
        this.comboEncoding.setEnabled(bl);
    }

    private void updateFieldsFromEncoding(AudioFormat audioFormat) {
        String string = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = this.comboSampleRate.isEnabled();
        this.comboSampleRate.setEnabled(false);
        this.comboSampleRate.removeAll();
        int n = this.vectorContSuppFormats.size();
        for (int i = 0; i < n; ++i) {
            double d;
            String string2;
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || !this.isFormatGoodForEncoding(audioFormat2 = (AudioFormat)e) || vector.contains(string2 = Double.toString(d = audioFormat2.getSampleRate()))) continue;
            this.comboSampleRate.addItem(string2);
            vector.addElement(string2);
            if (string != null) continue;
            string = string2;
        }
        if (audioFormat != null && this.isFormatGoodForEncoding(audioFormat)) {
            this.comboSampleRate.select(Double.toString(audioFormat.getSampleRate()));
        } else if (string != null) {
            this.comboEncoding.select(string);
        } else if (this.comboSampleRate.getItemCount() > 0) {
            this.comboSampleRate.select(0);
        }
        this.updateFieldsFromRate(audioFormat);
        this.comboSampleRate.setEnabled(bl);
    }

    private void updateFieldsFromRate(AudioFormat audioFormat) {
        int n;
        int n2 = -1;
        this.boolEnable8 = false;
        this.boolEnable16 = false;
        int n3 = this.vectorContSuppFormats.size();
        for (int i = 0; i < n3; ++i) {
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || !this.isFormatGoodForEncoding(audioFormat2 = (AudioFormat)e) || !this.isFormatGoodForSampleRate(audioFormat2)) continue;
            n = audioFormat2.getSampleSizeInBits();
            if (n2 == -1) {
                n2 = n;
            }
            if (n == -1) {
                this.boolEnable8 = true;
                this.boolEnable16 = true;
                continue;
            }
            if (n == 8) {
                this.boolEnable8 = true;
                continue;
            }
            if (n != 16) continue;
            this.boolEnable16 = true;
        }
        this.checkBits8.setEnabled(this.boolEnable8);
        this.checkBits16.setEnabled(this.boolEnable16);
        if (audioFormat != null && this.isFormatGoodForEncoding(audioFormat) && this.isFormatGoodForSampleRate(audioFormat)) {
            n = audioFormat.getSampleSizeInBits();
            if (n == 8) {
                this.checkBits8.setState(true);
            } else if (n == 16) {
                this.checkBits16.setState(true);
            }
        } else if (n2 != -1) {
            if (n2 == 8) {
                this.checkBits8.setState(true);
            } else if (n2 == 16) {
                this.checkBits16.setState(true);
            }
        } else if (this.boolEnable8) {
            this.checkBits8.setState(true);
        } else {
            this.checkBits16.setState(true);
        }
        this.updateFieldsFromBits(audioFormat);
    }

    private void updateFieldsFromBits(AudioFormat audioFormat) {
        int n;
        int n2 = -1;
        this.boolEnableMono = false;
        this.boolEnableStereo = false;
        int n3 = this.vectorContSuppFormats.size();
        for (int i = 0; i < n3; ++i) {
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || !this.isFormatGoodForEncoding(audioFormat2 = (AudioFormat)e) || !this.isFormatGoodForSampleRate(audioFormat2) || !this.isFormatGoodForBitSize(audioFormat2)) continue;
            n = audioFormat2.getChannels();
            if (n2 == -1) {
                n2 = n;
            }
            if (n == -1) {
                this.boolEnableMono = true;
                this.boolEnableStereo = true;
                continue;
            }
            if (n == 1) {
                this.boolEnableMono = true;
                continue;
            }
            this.boolEnableStereo = true;
        }
        this.checkMono.setEnabled(this.boolEnableMono);
        this.checkStereo.setEnabled(this.boolEnableStereo);
        if (audioFormat != null && this.isFormatGoodForEncoding(audioFormat) && this.isFormatGoodForSampleRate(audioFormat) && this.isFormatGoodForBitSize(audioFormat)) {
            n = audioFormat.getChannels();
            if (n == 1) {
                this.checkMono.setState(true);
            } else {
                this.checkStereo.setState(true);
            }
        } else if (n2 != -1) {
            if (n2 == 1) {
                this.checkMono.setState(true);
            } else {
                this.checkStereo.setState(true);
            }
        } else if (this.boolEnableMono) {
            this.checkMono.setState(true);
        } else {
            this.checkStereo.setState(true);
        }
        this.updateFieldsFromChannels(audioFormat);
    }

    private void updateFieldsFromChannels(AudioFormat audioFormat) {
        int n;
        int n2 = -1;
        this.boolEnableEndianBig = false;
        this.boolEnableEndianLittle = false;
        int n3 = this.vectorContSuppFormats.size();
        for (int i = 0; i < n3; ++i) {
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || !this.isFormatGoodForEncoding(audioFormat2 = (AudioFormat)e) || !this.isFormatGoodForSampleRate(audioFormat2) || !this.isFormatGoodForBitSize(audioFormat2) || !this.isFormatGoodForChannels(audioFormat2)) continue;
            n = audioFormat2.getEndian();
            if (n2 == -1) {
                n2 = n;
            }
            if (n == -1) {
                this.boolEnableEndianBig = true;
                this.boolEnableEndianLittle = true;
                continue;
            }
            if (n == 1) {
                this.boolEnableEndianBig = true;
                continue;
            }
            this.boolEnableEndianLittle = true;
        }
        this.checkEndianBig.setEnabled(this.boolEnableEndianBig);
        this.checkEndianLittle.setEnabled(this.boolEnableEndianLittle);
        if (audioFormat != null && this.isFormatGoodForEncoding(audioFormat) && this.isFormatGoodForSampleRate(audioFormat) && this.isFormatGoodForBitSize(audioFormat) && this.isFormatGoodForChannels(audioFormat)) {
            n = audioFormat.getEndian();
            if (n == 1) {
                this.checkEndianBig.setState(true);
            } else {
                this.checkEndianLittle.setState(true);
            }
        } else if (n2 != -1) {
            if (n2 == 1) {
                this.checkEndianBig.setState(true);
            } else {
                this.checkEndianLittle.setState(true);
            }
        } else if (this.boolEnableEndianBig) {
            this.checkEndianBig.setState(true);
        } else {
            this.checkEndianLittle.setState(true);
        }
        if (!this.checkBits16.getState()) {
            this.boolEnableEndianBig = false;
            this.boolEnableEndianLittle = false;
            this.checkEndianBig.setEnabled(this.boolEnableEndianBig);
            this.checkEndianLittle.setEnabled(this.boolEnableEndianLittle);
        }
        this.updateFieldsFromEndian(audioFormat);
    }

    private void updateFieldsFromEndian(AudioFormat audioFormat) {
        int n;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = this.vectorContSuppFormats.size();
        for (int i = 0; i < n3; ++i) {
            AudioFormat audioFormat2;
            Object e = this.vectorContSuppFormats.elementAt(i);
            if (!(e instanceof AudioFormat) || !this.isFormatGoodForEncoding(audioFormat2 = (AudioFormat)e) || !this.isFormatGoodForSampleRate(audioFormat2) || !this.isFormatGoodForBitSize(audioFormat2) || !this.isFormatGoodForChannels(audioFormat2) || !this.isFormatGoodForEndian(audioFormat2)) continue;
            n = audioFormat2.getSigned();
            if (n2 == -1) {
                n2 = n;
            }
            if (n == -1) {
                bl = true;
                bl2 = true;
                continue;
            }
            if (n == 1) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        this.boolEnableSigned = bl && bl2;
        this.checkSigned.setEnabled(this.boolEnableSigned);
        if (audioFormat != null && this.isFormatGoodForEncoding(audioFormat) && this.isFormatGoodForSampleRate(audioFormat) && this.isFormatGoodForBitSize(audioFormat) && this.isFormatGoodForChannels(audioFormat) && this.isFormatGoodForEndian(audioFormat)) {
            n = audioFormat.getSigned();
            if (n == 1) {
                this.checkSigned.setState(true);
            } else {
                this.checkSigned.setState(false);
            }
        } else if (n2 != -1) {
            if (n2 == 1) {
                this.checkSigned.setState(true);
            } else {
                this.checkSigned.setState(false);
            }
        } else if (bl) {
            this.checkSigned.setState(true);
        } else {
            this.checkSigned.setState(false);
        }
        this.updateFieldsFromSigned(audioFormat);
    }

    private void updateFieldsFromSigned(AudioFormat audioFormat) {
    }

    private boolean isFormatGoodForEncoding(AudioFormat audioFormat) {
        boolean bl = false;
        String string = this.comboEncoding.getSelectedItem();
        if (string != null) {
            bl = audioFormat.getEncoding().equalsIgnoreCase(string);
        }
        return bl;
    }

    private boolean isFormatGoodForSampleRate(AudioFormat audioFormat) {
        boolean bl = false;
        String string = this.comboSampleRate.getSelectedItem();
        if (string != null) {
            double d = Double.valueOf(string);
            if (audioFormat.getSampleRate() == -1.0) {
                bl = true;
            } else if (audioFormat.getSampleRate() == d) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isFormatGoodForBitSize(AudioFormat audioFormat) {
        boolean bl = false;
        int n = this.checkBits8.getState() ? 8 : (this.checkBits16.getState() ? 16 : -1);
        if (audioFormat.getSampleSizeInBits() == -1) {
            bl = true;
        } else if (n == -1) {
            bl = true;
        } else if (audioFormat.getSampleSizeInBits() == n) {
            bl = true;
        } else if (audioFormat.getSampleSizeInBits() < 8) {
            bl = true;
        }
        return bl;
    }

    private boolean isFormatGoodForChannels(AudioFormat audioFormat) {
        boolean bl = false;
        int n = this.checkMono.getState() ? 1 : (this.checkStereo.getState() ? 2 : -1);
        if (audioFormat.getChannels() == -1) {
            bl = true;
        } else if (n == -1) {
            bl = true;
        } else if (audioFormat.getChannels() == n) {
            bl = true;
        }
        return bl;
    }

    private boolean isFormatGoodForEndian(AudioFormat audioFormat) {
        boolean bl = false;
        int n = this.checkEndianBig.getState() ? 1 : (this.checkStereo.getState() ? 0 : -1);
        if (audioFormat.getEndian() == -1) {
            bl = true;
        } else if (n == -1) {
            bl = true;
        } else if (audioFormat.getEndian() == n) {
            bl = true;
        }
        return bl;
    }

    private boolean isFormatGoodForSigned(AudioFormat audioFormat) {
        boolean bl = false;
        int n = this.checkSigned.getState() ? 1 : 0;
        if (audioFormat.getSigned() == -1) {
            bl = true;
        } else if (n == -1) {
            bl = true;
        } else if (audioFormat.getSigned() == n) {
            bl = true;
        }
        return bl;
    }

    private boolean isFormatSupported(AudioFormat audioFormat) {
        boolean bl = false;
        if (audioFormat == null) {
            return bl;
        }
        int n = this.vectorContSuppFormats.size();
        for (int i = 0; i < n && !bl; ++i) {
            AudioFormat audioFormat2 = (AudioFormat)this.vectorContSuppFormats.elementAt(i);
            if (!audioFormat2.matches(audioFormat)) continue;
            bl = true;
        }
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkEnableTrack) {
            this.boolEnableTrackSaved = this.checkEnableTrack.getState();
            this.onEnableTrack(true);
        } else if (object == this.comboEncoding) {
            this.updateFieldsFromEncoding(this.formatOld);
        } else if (object == this.comboSampleRate) {
            this.updateFieldsFromRate(this.formatOld);
        } else if (object == this.checkBits8 || object == this.checkBits16) {
            this.updateFieldsFromBits(this.formatOld);
        } else if (object == this.checkMono || object == this.checkStereo) {
            this.updateFieldsFromChannels(this.formatOld);
        } else if (object == this.checkEndianBig || object == this.checkEndianLittle) {
            this.updateFieldsFromEndian(this.formatOld);
        } else if (object == this.checkSigned) {
            this.updateFieldsFromSigned(this.formatOld);
        }
    }

    private void onEnableTrack(boolean bl) {
        boolean bl2 = this.checkEnableTrack.getState();
        this.enableControls(bl2 && this.isEnabled());
        if (bl && this.listenerEnableTrack != null) {
            ActionEvent actionEvent = bl2 ? new ActionEvent(this, 1001, ACTION_TRACK_ENABLED) : new ActionEvent(this, 1001, ACTION_TRACK_DISABLED);
            this.listenerEnableTrack.actionPerformed(actionEvent);
        }
    }

    private void enableControls(boolean bl) {
        this.labelEncoding.setEnabled(bl);
        this.comboEncoding.setEnabled(bl);
        this.labelSampleRate.setEnabled(bl);
        this.comboSampleRate.setEnabled(bl);
        this.labelHz.setEnabled(bl);
        this.labelBitsPerSample.setEnabled(bl);
        this.checkBits8.setEnabled(bl && this.boolEnable8);
        this.checkBits16.setEnabled(bl && this.boolEnable16);
        this.labelChannels.setEnabled(bl);
        this.checkMono.setEnabled(bl && this.boolEnableMono);
        this.checkStereo.setEnabled(bl && this.boolEnableStereo);
        this.labelEndian.setEnabled(bl);
        this.checkEndianBig.setEnabled(bl && this.boolEnableEndianBig);
        this.checkEndianLittle.setEnabled(bl && this.boolEnableEndianLittle);
        this.checkSigned.setEnabled(bl && this.boolEnableSigned);
    }
}

