/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.BasicPlugIn;
import com.sun.media.Log;
import com.sun.media.MediaTimeBase;
import com.sun.media.renderer.audio.device.AudioOutput;
import java.awt.Component;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Owned;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;

public abstract class AudioRenderer
extends BasicPlugIn
implements Renderer,
Prefetchable,
Drainable,
Clock {
    Format[] supportedFormats;
    protected AudioFormat inputFormat;
    protected AudioFormat devFormat;
    protected AudioOutput device = null;
    protected TimeBase timeBase = null;
    protected boolean started = false;
    protected boolean prefetched = false;
    protected boolean resetted = false;
    protected boolean devicePaused = true;
    protected GainControl gainControl;
    protected BufferControl bufferControl;
    protected Control peakVolumeMeter = null;
    protected long bytesWritten = 0L;
    protected int bytesPerSec;
    private Object writeLock = new Object();
    long mediaTimeAnchor = 0L;
    long startTime = Long.MAX_VALUE;
    long stopTime = Long.MAX_VALUE;
    long ticksSinceLastReset = 0L;
    float rate = 1.0f;
    TimeBase master = null;
    static int DefaultMinBufferSize = 62;
    static int DefaultMaxBufferSize = 4000;
    long bufLenReq = 200L;

    public AudioRenderer() {
        this.timeBase = new AudioTimeBase(this);
        this.bufferControl = new BC(this);
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public Format setInputFormat(Format format) {
        for (int i = 0; i < this.supportedFormats.length; ++i) {
            if (!this.supportedFormats[i].matches(format)) continue;
            this.inputFormat = (AudioFormat)format;
            return format;
        }
        return null;
    }

    public void close() {
        this.stop();
        if (this.device != null) {
            this.pauseDevice();
            this.device.flush();
            this.mediaTimeAnchor = this.getMediaNanoseconds();
            this.ticksSinceLastReset = 0L;
            this.device.dispose();
        }
        this.device = null;
    }

    public void reset() {
        this.resetted = true;
        this.mediaTimeAnchor = this.getMediaNanoseconds();
        if (this.device != null) {
            this.device.flush();
            this.ticksSinceLastReset = this.device.getMediaNanoseconds();
        } else {
            this.ticksSinceLastReset = 0L;
        }
        this.prefetched = false;
    }

    synchronized void pauseDevice() {
        if (!this.devicePaused && this.device != null) {
            this.device.pause();
            this.devicePaused = true;
        }
        if (this.timeBase instanceof AudioTimeBase) {
            ((AudioTimeBase)this.timeBase).mediaStopped();
        }
    }

    synchronized void resumeDevice() {
        if (this.timeBase instanceof AudioTimeBase) {
            ((AudioTimeBase)this.timeBase).mediaStarted();
        }
        if (this.devicePaused && this.device != null) {
            this.device.resume();
            this.devicePaused = false;
        }
    }

    public void start() {
        this.syncStart(this.getTimeBase().getTime());
    }

    public synchronized void drain() {
        if (this.started && this.device != null) {
            this.device.drain();
        }
        this.prefetched = false;
    }

    public int process(Buffer buffer) {
        int n = this.processData(buffer);
        if (buffer.isEOM() && n != 2) {
            this.drain();
            this.pauseDevice();
        }
        return n;
    }

    protected boolean checkInput(Buffer buffer) {
        Format format = buffer.getFormat();
        if (this.device == null || this.devFormat == null || !this.devFormat.equals(format)) {
            if (!this.initDevice((AudioFormat)format)) {
                buffer.setDiscard(true);
                return false;
            }
            this.devFormat = (AudioFormat)format;
        }
        return true;
    }

    protected int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        return this.doProcessData(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doProcessData(Buffer buffer) {
        int n;
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        int n3 = 0;
        Object object = this;
        synchronized (object) {
            if (!this.started) {
                if (!this.devicePaused) {
                    this.pauseDevice();
                }
                this.resetted = false;
                int n4 = this.device.bufferAvailable();
                if (n4 > n) {
                    n4 = n;
                }
                if (n4 > 0) {
                    n3 = this.device.write(byArray, n2, n4);
                    this.bytesWritten += (long)n3;
                }
                buffer.setLength(n - n3);
                if (buffer.getLength() > 0 || buffer.isEOM()) {
                    buffer.setOffset(n2 + n3);
                    this.prefetched = true;
                    return 2;
                }
                return 0;
            }
        }
        object = this.writeLock;
        synchronized (object) {
            if (this.devicePaused) {
                return 2;
            }
            try {
                for (n = buffer.getLength(); n > 0 && !this.resetted; n -= n3) {
                    n3 = this.device.write(byArray, n2, n);
                    this.bytesWritten += (long)n3;
                    n2 += n3;
                }
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }
        buffer.setLength(0);
        buffer.setOffset(0);
        return 0;
    }

    protected boolean initDevice(AudioFormat audioFormat) {
        if (audioFormat == null) {
            System.err.println("AudioRenderer: ERROR: Unknown AudioFormat");
            return false;
        }
        if (audioFormat.getSampleRate() == -1.0 || audioFormat.getSampleSizeInBits() == -1) {
            Log.error("Cannot initialize audio renderer with format: " + audioFormat);
            return false;
        }
        if (this.device != null) {
            this.device.drain();
            this.pauseDevice();
            this.mediaTimeAnchor = this.getMediaNanoseconds();
            this.ticksSinceLastReset = 0L;
            this.device.dispose();
            this.device = null;
        }
        AudioFormat audioFormat2 = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getEndian(), audioFormat.getSigned());
        this.device = this.createDevice(audioFormat2);
        if (this.device == null || !this.device.initialize(audioFormat2, this.computeBufferSize(audioFormat2))) {
            this.device = null;
            return false;
        }
        this.device.setMute(this.gainControl.getMute());
        this.device.setGain(this.gainControl.getDB());
        if (this.rate != 1.0f && this.rate != this.device.setRate(this.rate)) {
            System.err.println("The AudioRenderer does not support the given rate: " + this.rate);
            this.device.setRate(1.0f);
        }
        if (this.started) {
            this.resumeDevice();
        }
        this.bytesPerSec = (int)(audioFormat.getSampleRate() * (double)audioFormat.getChannels() * (double)audioFormat.getSampleSizeInBits() / 8.0);
        return true;
    }

    protected abstract AudioOutput createDevice(AudioFormat var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processByWaiting(Buffer buffer) {
        Object object = this;
        synchronized (object) {
            if (!this.started) {
                this.prefetched = true;
                return;
            }
        }
        object = (AudioFormat)buffer.getFormat();
        int n = (int)((AudioFormat)object).getSampleRate();
        int n2 = ((AudioFormat)object).getSampleSizeInBits();
        int n3 = ((AudioFormat)object).getChannels();
        long l = buffer.getLength() * 1000 / (n2 / 8 * n * n3);
        int n4 = (int)((float)l / this.getRate());
        try {
            Thread.currentThread();
            Thread.sleep(n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer.setLength(0);
        buffer.setOffset(0);
        this.mediaTimeAnchor += l * 1000000L;
    }

    public Object[] getControls() {
        Object[] objectArray = new Control[]{this.gainControl, this.bufferControl};
        return objectArray;
    }

    public boolean isPrefetched() {
        return this.prefetched;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (!(timeBase instanceof AudioTimeBase)) {
            Log.warning("AudioRenderer cannot be controlled by time bases other than its own: " + timeBase);
        }
        this.master = timeBase;
    }

    public synchronized void syncStart(Time time) {
        this.started = true;
        this.prefetched = true;
        this.resetted = false;
        this.resumeDevice();
        this.startTime = time.getNanoseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.started = false;
        this.prefetched = false;
        Object object = this.writeLock;
        synchronized (object) {
            this.pauseDevice();
        }
    }

    public void setStopTime(Time time) {
        this.stopTime = time.getNanoseconds();
    }

    public Time getStopTime() {
        return new Time(this.stopTime);
    }

    public void setMediaTime(Time time) {
        this.mediaTimeAnchor = time.getNanoseconds();
    }

    public Time getMediaTime() {
        return new Time(this.getMediaNanoseconds());
    }

    public long getMediaNanoseconds() {
        return this.mediaTimeAnchor + (this.device != null ? this.device.getMediaNanoseconds() : 0L) - this.ticksSinceLastReset;
    }

    public long getLatency() {
        long l = this.bytesWritten * 1000L / (long)this.bytesPerSec * 1000000L;
        return l - this.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public TimeBase getTimeBase() {
        if (this.master != null) {
            return this.master;
        }
        return this.timeBase;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return new Time((long)((float)(time.getNanoseconds() - this.mediaTimeAnchor) / this.rate) + this.startTime);
    }

    public float getRate() {
        return this.rate;
    }

    public float setRate(float f) {
        this.rate = this.device != null ? this.device.setRate(f) : 1.0f;
        return this.rate;
    }

    public int computeBufferSize(AudioFormat audioFormat) {
        long l = (long)(audioFormat.getSampleRate() * (double)audioFormat.getChannels() * (double)audioFormat.getSampleSizeInBits() / 8.0);
        long l2 = this.bufLenReq < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (this.bufLenReq > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : this.bufLenReq);
        float f = (float)l2 / 1000.0f;
        long l3 = (long)((float)l * f);
        return (int)l3;
    }

    class BC
    implements BufferControl,
    Owned {
        AudioRenderer renderer;

        BC(AudioRenderer audioRenderer2) {
            this.renderer = audioRenderer2;
        }

        public long getBufferLength() {
            return AudioRenderer.this.bufLenReq;
        }

        public long setBufferLength(long l) {
            AudioRenderer.this.bufLenReq = l < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (l > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : l);
            return AudioRenderer.this.bufLenReq;
        }

        public long getMinimumThreshold() {
            return 0L;
        }

        public long setMinimumThreshold(long l) {
            return 0L;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return this.renderer;
        }
    }

    class AudioTimeBase
    extends MediaTimeBase {
        AudioRenderer renderer;

        AudioTimeBase(AudioRenderer audioRenderer2) {
            this.renderer = audioRenderer2;
        }

        public long getMediaTime() {
            if (AudioRenderer.this.rate == 1.0f || AudioRenderer.this.rate == 0.0f) {
                return AudioRenderer.this.device != null ? AudioRenderer.this.device.getMediaNanoseconds() : 0L;
            }
            return (long)((float)(AudioRenderer.this.device != null ? AudioRenderer.this.device.getMediaNanoseconds() : 0L) / AudioRenderer.this.rate);
        }
    }
}

