/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VFlowLayout
implements LayoutManager {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    private int gap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public VFlowLayout() {
        this(0);
    }

    public VFlowLayout(int n) {
        this.gap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private void setSizes(Container container) {
        int n = container.countComponents();
        Dimension dimension = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            dimension = component.preferredSize();
            this.minWidth = Math.max(component.minimumSize().width, this.minWidth);
            this.preferredWidth = Math.max(component.preferredSize().width, this.preferredWidth);
            this.minHeight += component.minimumSize().height + this.gap;
            this.preferredHeight += component.preferredSize().height + this.gap;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        this.setSizes(container);
        Insets insets = container.insets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        this.setSizes(container);
        Insets insets = container.insets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = container.size().width - (insets.left + insets.right);
        int n2 = container.size().height - (insets.top + insets.bottom);
        int n3 = container.countComponents();
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = insets.top + this.gap / 2;
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = 0;
        boolean bl4 = false;
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        if (n2 > this.preferredHeight) {
            n7 = (n2 - this.preferredHeight) / n3;
        }
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.preferredSize();
            n6 = i != 0 ? (n6 += n5 + n7 + this.gap) : (n6 += n5 + (n7 + this.gap) / 2);
            component.reshape(0, n6, n, dimension.height);
            n4 = dimension.width;
            n5 = dimension.height;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[gap=" + this.gap + "]";
    }
}

