/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.Component;
import java.util.Vector;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class GainControlAdapter
implements GainControl {
    private Vector listeners = null;
    private boolean muteState;
    private Component component;
    private float DefLevel = 0.4f;
    private float dB = 0.0f;
    private float level = this.DefLevel;

    public GainControlAdapter() {
    }

    public GainControlAdapter(float f) {
        this.DefLevel = f;
        this.level = f;
    }

    public GainControlAdapter(boolean bl) {
        this.muteState = bl;
        this.setLevel(this.DefLevel);
    }

    public void setMute(boolean bl) {
        if (this.muteState != bl) {
            this.muteState = bl;
            this.informListeners();
        }
    }

    public boolean getMute() {
        return this.muteState;
    }

    public float setDB(float f) {
        if (this.dB != f) {
            this.dB = f;
            float f2 = (float)Math.pow(10.0, (double)this.dB / 20.0);
            this.level = f2 * this.DefLevel;
            if ((double)this.level < 0.0) {
                this.setLevel(0.0f);
            } else if ((double)this.level > 1.0) {
                this.setLevel(1.0f);
            } else {
                this.setLevel(this.level);
                this.informListeners();
            }
        }
        return this.dB;
    }

    public float getDB() {
        return this.dB;
    }

    public float setLevel(float f) {
        if ((double)f < 0.0) {
            f = 0.0f;
        }
        if ((double)f > 1.0) {
            f = 1.0f;
        }
        if (this.level != f) {
            this.level = f;
            float f2 = f / this.DefLevel;
            this.dB = (float)(Math.log((double)f2 == 0.0 ? 1.0E-4 : (double)f2) / Math.log(10.0) * 20.0);
            this.informListeners();
        }
        return this.level;
    }

    public float getLevel() {
        return this.level;
    }

    public synchronized void addGainChangeListener(GainChangeListener gainChangeListener) {
        if (gainChangeListener != null) {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(gainChangeListener);
        }
    }

    public synchronized void removeGainChangeListener(GainChangeListener gainChangeListener) {
        if (gainChangeListener != null && this.listeners != null) {
            this.listeners.removeElement(gainChangeListener);
        }
    }

    public Component getControlComponent() {
        return null;
    }

    protected synchronized void informListeners() {
        if (this.listeners != null) {
            GainChangeEvent gainChangeEvent = new GainChangeEvent(this, this.muteState, this.dB, this.level);
            for (int i = 0; i < this.listeners.size(); ++i) {
                GainChangeListener gainChangeListener = (GainChangeListener)this.listeners.elementAt(i);
                gainChangeListener.gainChange(gainChangeEvent);
            }
        }
    }
}

