/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.Reparentable;
import com.sun.media.ui.TextComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.FrameRateControl;

public class FrameRateAdapter
implements FrameRateControl,
ActionListener,
Reparentable {
    protected float value = 0.0f;
    protected float min = 0.0f;
    protected float max = 0.0f;
    protected TextComp textComp = null;
    protected boolean settable;
    protected Object owner = null;

    public FrameRateAdapter(float f, float f2, float f3, boolean bl) {
        this.value = f;
        this.min = f2;
        this.max = f3;
        this.settable = bl;
    }

    public FrameRateAdapter(Object object, float f, float f2, float f3, boolean bl) {
        this(f, f2, f3, bl);
        this.owner = object;
    }

    public float getFrameRate() {
        return this.value;
    }

    public float setFrameRate(float f) {
        if (this.settable) {
            if (f < this.min) {
                f = this.min;
            } else if (f > this.max) {
                f = this.max;
            }
            this.value = f;
            if (this.textComp != null) {
                this.textComp.setValue(Float.toString(this.value));
            }
            return this.value;
        }
        return -1.0f;
    }

    public float getMaxSupportedFrameRate() {
        return this.max;
    }

    public float getPreferredFrameRate() {
        return this.min;
    }

    protected String getName() {
        return "Frame Rate";
    }

    public void setEnabled(boolean bl) {
        if (this.textComp != null) {
            this.textComp.setEnabled(bl);
        }
    }

    public Component getControlComponent() {
        if (this.textComp == null) {
            this.textComp = new TextComp(this.getName(), this.value + "", 2, this.settable);
            this.textComp.setActionListener(this);
        }
        return this.textComp;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("fra:");
        float f = this.textComp.getFloatValue();
        this.setFrameRate(f);
    }

    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }
}

