/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.Reparentable;
import java.awt.Component;
import javax.media.Format;
import javax.media.Player;
import javax.media.Time;
import javax.media.Track;
import javax.media.control.FramePositioningControl;
import javax.media.format.VideoFormat;

public class FramePositioningAdapter
implements FramePositioningControl,
Reparentable {
    Object owner;
    Player player;
    Track master = null;
    long frameStep = -1L;

    public static Track getMasterTrack(Track[] trackArray) {
        Track track = null;
        float f = -1.0f;
        for (int i = 0; i < trackArray.length; ++i) {
            Format format;
            if (trackArray[i] == null || (format = trackArray[i].getFormat()) == null || !(format instanceof VideoFormat)) continue;
            track = trackArray[i];
            f = ((VideoFormat)format).getFrameRate();
            if (f == -1.0f || f == 0.0f) continue;
            return track;
        }
        if (track != null && track.mapTimeToFrame(new Time(0L)) != Integer.MAX_VALUE) {
            return track;
        }
        return null;
    }

    public FramePositioningAdapter(Player player, Track track) {
        float f;
        this.player = player;
        this.master = track;
        Format format = track.getFormat();
        if (format instanceof VideoFormat && (f = ((VideoFormat)format).getFrameRate()) != -1.0f && f != 0.0f) {
            this.frameStep = (long)(1.0E9f / f);
        }
    }

    public int seek(int n) {
        Time time = this.master.mapFrameToTime(n);
        if (time != null && time != FramePositioningControl.TIME_UNKNOWN) {
            this.player.setMediaTime(time);
            return this.master.mapTimeToFrame(time);
        }
        return Integer.MAX_VALUE;
    }

    public int skip(int n) {
        if (this.frameStep != -1L) {
            long l = this.player.getMediaNanoseconds() + (long)n * this.frameStep;
            this.player.setMediaTime(new Time(l));
            return n;
        }
        int n2 = this.master.mapTimeToFrame(this.player.getMediaTime());
        if (n2 != 0 && n2 != Integer.MAX_VALUE) {
            int n3 = this.seek(n2 + n);
            return n3 - n2;
        }
        return Integer.MAX_VALUE;
    }

    public Time mapFrameToTime(int n) {
        return this.master.mapFrameToTime(n);
    }

    public int mapTimeToFrame(Time time) {
        return this.master.mapTimeToFrame(time);
    }

    public Component getControlComponent() {
        return null;
    }

    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }
}

