/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.ui.TextComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.BitRateControl;

public class BitRateAdapter
implements BitRateControl,
ActionListener {
    protected int value;
    protected int min;
    protected int max;
    protected boolean settable;
    protected TextComp textComp;

    public BitRateAdapter(int n, int n2, int n3, boolean bl) {
        this.value = n;
        this.min = n2;
        this.max = n3;
        this.settable = bl;
    }

    public int getBitRate() {
        return this.value;
    }

    public int setBitRate(int n) {
        if (this.settable) {
            if (n < this.min) {
                n = this.min;
            }
            if (n > this.max) {
                n = this.max;
            }
            this.value = n;
            if (this.textComp != null) {
                this.textComp.setValue(Integer.toString(n));
            }
            return this.value;
        }
        return -1;
    }

    public int getMinSupportedBitRate() {
        return this.min;
    }

    public int getMaxSupportedBitRate() {
        return this.max;
    }

    protected String getName() {
        return "Bit Rate";
    }

    public Component getControlComponent() {
        if (this.textComp == null) {
            this.textComp = new TextComp(this.getName(), Integer.toString(this.value), 7, this.settable);
            this.textComp.setActionListener(this);
        }
        return this.textComp;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.textComp != null) {
            this.setBitRate(this.textComp.getIntValue());
        }
    }
}

