/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.customjmpx;

import com.sun.media.BasicController;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaTimeBase;
import com.sun.media.SeekFailedEvent;
import com.sun.media.codec.video.customjmpx.CustomDataThread;
import com.sun.media.codec.video.customjmpx.CustomMpxCmd;
import com.sun.media.codec.video.customjmpx.CustomMpxThread;
import com.sun.media.codec.video.customjmpx.JmpxAckNotifyEvent;
import com.sun.media.codec.video.customjmpx.JmpxAudio;
import com.sun.media.codec.video.customjmpx.JmpxEvent;
import com.sun.media.codec.video.customjmpx.JmpxListener;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.Buffer;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BitRateControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.renderer.VideoRenderer;

public class CustomJmpx
extends BasicController
implements Runnable {
    private PipedInputStream cmdPipe;
    protected PipedOutputStream mpxCmdPipe;
    protected boolean killCommandThread = false;
    private Vector listeners;
    private CustomMpxThread customMpxThread;
    private CustomDataThread dataThread;
    private int audioRate = 0;
    private int audioChannels = 0;
    private boolean sourceIsOn = false;
    private Component monitor;
    private long lastStatTime = 0L;
    protected VideoRenderer renderer = null;
    private VideoFormat videoformat = null;
    protected JmpxAudio audio = null;
    public static boolean BIG_ENDIAN = true;
    public static boolean LITTLE_ENDIAN = false;
    public static final int MpxStrm_11172 = 1;
    public static final int MpxStrm_VSEQ = 2;
    public static final int MpxStrm_ASEQ = 4;
    public static final int MpxStrm_Unknown = 0;
    public static final int MpxAudioLeft = 1;
    public static final int MpxAudioRight = 2;
    public static final int MpxAudioStereo = 3;
    public static final int MpxAudioLowQ = 8;
    public static final int MpxAudioMedQ = 16;
    public static final int MpxAudioHiQ = 24;
    protected static final int MCMD_NULL = 0;
    protected static final int MCMD_EXIT = 1;
    protected static final int MCMD_OPENSRC = 2;
    protected static final int MCMD_CLOSESRC = 3;
    protected static final int MCMD_REENTER = 4;
    protected static final int MCMD_PLAYCTR = 5;
    protected static final int MCMD_PRESCTR = 6;
    protected static final int MCMD_STREAM = 7;
    protected static final int MCMD_SENDSTAT = 8;
    protected static final int MCMD_STATUS = 9;
    protected static final int MCMD_ACK = 10;
    protected static final int MCMD_SETRSRC = 11;
    protected static final int MCMD_CAPTURE = 12;
    protected static final int MCMD_CDOP = 13;
    protected static final int MCMD_TEST = 255;
    protected static final int MCMD_QSIZE = 30;
    protected static final int MCMD_QSTATS = 31;
    protected static final double MULF = 65535.0;
    protected static final int MCFL_SNDACK = 1;
    protected static final int MCFL_NOACK = 2;
    protected static final int MCFL_ORGMPX = 4;
    protected static final int MCFL_MPXRSV1 = 65536;
    protected static final int MSC_NONE = 0;
    protected static final int MSC_FNAME = 1;
    protected static final int MSC_CDFILE = 2;
    protected static final int MSC_NETWORK = 3;
    protected static final int MSC_FDSCP = 4;
    protected static final int MSC_JAVASTRM = 5;
    protected static final int MRE_FOFS = 1;
    protected static final int MRE_RELOFS = 2;
    protected static final int MRE_ASOPEN = 4;
    protected static final int MRE_STRMS = 8;
    protected static final int MRE_SEEKVSEQ = 16;
    public static final int PC_PLAY = 1;
    public static final int PC_FWDSPEED = 2;
    public static final int PC_FWDSTEP = 4;
    public static final int PC_PAUSE = 8;
    public static final int PC_AUDMSK = 13;
    protected static final int STRM_IGNOREID = 128;
    protected static final int STRM_SBCOFF = 64;
    protected static final int STRM_AUTOSBC = 32;
    protected static final int STRM_IDBITS = 63;
    protected static final int PCTR_VMD = 1;
    protected static final int PCTR_AMD = 2;
    protected static final int PCTR_AVOL = 4;
    protected static final int PCTR_LUM = 8;
    protected static final int PCTR_SAT = 16;
    protected static final int PCTR_GAM = 32;
    protected static final int PCTR_LSG = 56;
    protected static final int VDM_NONE = 0;
    protected static final int VDM_COL = 1;
    protected static final int VDM_COLB = 2;
    protected static final int VDM_COL8 = 3;
    protected static final int TRYSET_DONE = 0;
    protected static final int TRYSET_CANT = 1;
    protected static final int TRYSET_PASTEOM = 2;
    protected MediaThread cmdInputThread;
    protected int ackSeq;
    protected int strmType = 0;
    protected float fwdSpeed = 1.0f;
    protected int width;
    protected int height;
    protected int outWidth;
    protected int outHeight;
    protected int zoom;
    protected float java_zoom;
    protected int cmap;
    protected boolean interleaved;
    protected boolean muted = false;
    protected boolean reloaded = false;
    protected float fps;
    protected float kbps;
    protected float loc;
    protected float oldLoc;
    protected long time;
    protected long size;
    protected long frames;
    protected long peer = 0L;
    protected int possibleLength = -1;
    protected int possibleWidth = -1;
    protected int possibleHeight = -1;
    protected int useJavaRenderer = 1;
    protected Object rgbBuffer = null;
    protected FrameRateControl frameRateControl = null;
    protected BitRateControl bitRateControl = null;
    protected GainControl gainControl = null;
    protected Control[] controls;
    protected int needYUVBuffer = 0;
    protected int needXBGR = 1;
    private FramePositioningCtrl framePositioningControl;
    protected boolean windowAvailable = false;
    protected DataSource source;
    protected TimeBase timeBase;
    protected String filename;
    protected SourceStream sourceStream;
    protected byte[] tempArray = new byte[65536];
    protected MemoryImageSource sourceImage = null;
    protected Image displayImage = null;
    private int rMask = 255;
    private int gMask = 65280;
    private int bMask = 0xFF0000;
    protected Time knownDuration = Duration.DURATION_UNKNOWN;
    protected Time eomDuration = Duration.DURATION_UNKNOWN;
    protected Time requestedMediaTime = new Time(0L);
    protected boolean mediaTimeChanged = false;
    protected boolean outputSizeSet = false;
    protected int contentLength = -1;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    private Player player;
    private Buffer outBuffer = new Buffer();
    static /* synthetic */ Class class$com$sun$media$codec$video$customjmpx$CustomMpxThread;
    static /* synthetic */ Class class$com$sun$media$codec$video$customjmpx$CustomDataThread;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    private native boolean initMPX(Component var1);

    private native void sendMPX(byte[] var1);

    private native void broadcastMPX(byte[] var1);

    private native void setStream(SourceStream var1);

    private native int checkMpegFile(String var1);

    private native int getMediaDuration(String var1);

    private native int checkMpegStream(SourceStream var1);

    private native boolean isBigEndian();

    public CustomJmpx(Player player, String string, VideoRenderer videoRenderer) {
        this.player = player;
        this.filename = string;
        this.renderer = videoRenderer;
        this.ackSeq = 0;
        this.width = 320;
        this.height = 240;
        this.outWidth = 320;
        this.outHeight = 240;
        this.zoom = 1;
        this.java_zoom = 1.0f;
        this.cmap = 0;
        this.interleaved = true;
        this.fps = 0.0f;
        this.kbps = 0.0f;
        this.loc = 0.0f;
        this.time = 0L;
        this.size = 0L;
        this.frames = 0L;
        this.listeners = new Vector();
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource) && !(dataSource instanceof PushDataSource)) {
            throw new IncompatibleSourceException(this + ": doesn't support " + dataSource);
        }
        this.source = dataSource;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.isInitialized()) {
            this.close();
        }
    }

    protected int readFromStream(int n, int n2) {
        if (this.tempArray == null) {
            this.tempArray = new byte[65536];
        }
        return this.readFromStream(this.tempArray, n, n2);
    }

    protected int readFromStream(byte[] byArray, int n, int n2) {
        if (this.sourceStream == null) {
            this.sendEvent(new ConnectionErrorEvent(this, "No source stream specified!"));
            return -1;
        }
        try {
            if (this.sourceStream instanceof PullSourceStream) {
                return ((PullSourceStream)this.sourceStream).read(byArray, n, n2);
            }
            if (this.sourceStream instanceof PushSourceStream) {
                return this.readFromPushStream(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            this.sendEvent(new ConnectionErrorEvent(this, iOException.getMessage()));
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readFromPushStream(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        PushSourceStream pushSourceStream = (PushSourceStream)this.sourceStream;
        boolean bl = false;
        boolean bl2 = false;
        CustomJmpx customJmpx = this;
        synchronized (customJmpx) {
            while ((n3 = pushSourceStream.read(byArray, n, n2)) == 0) {
                if (!bl) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = true;
                    continue;
                }
                super.stop();
                this.pause();
                this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
                bl2 = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (bl2) {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
        if (n3 == -1) {
            return 0;
        }
        return n3;
    }

    protected synchronized void notifyPushDataArrival() {
        this.notifyAll();
    }

    protected boolean doRealize() {
        Object object;
        try {
            System.loadLibrary("jmcustommpx");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("doRealize: UnsatisfiedLinkError " + unsatisfiedLinkError);
            return false;
        }
        if (this.isBigEndian()) {
            BIG_ENDIAN = true;
            LITTLE_ENDIAN = false;
        } else {
            BIG_ENDIAN = false;
            LITTLE_ENDIAN = true;
        }
        if (this.filename == null && this.source == null) {
            return false;
        }
        this.mediaTimeChanged = false;
        this.startSource(true);
        this.sourceStream = null;
        if (this.filename == null) {
            if (this.source instanceof PullDataSource) {
                object = (PullDataSource)this.source;
                URL uRL = null;
                String string = null;
                MediaLocator mediaLocator = ((DataSource)object).getLocator();
                if (mediaLocator != null) {
                    string = mediaLocator.getProtocol();
                    try {
                        uRL = mediaLocator.getURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = null;
                    }
                }
                if (string != null && string.equals("file") && uRL != null) {
                    this.filename = uRL.getFile();
                } else {
                    PullSourceStream[] pullSourceStreamArray = ((PullDataSource)object).getStreams();
                    if (pullSourceStreamArray.length >= 1) {
                        this.sourceStream = pullSourceStreamArray[0];
                    }
                    this.contentLength = (int)this.sourceStream.getContentLength();
                    if (this.contentLength <= 0) {
                        this.contentLength = -1;
                    }
                }
            } else {
                object = (PushDataSource)this.source;
                PushSourceStream[] pushSourceStreamArray = ((PushDataSource)object).getStreams();
                if (pushSourceStreamArray.length >= 1) {
                    this.sourceStream = pushSourceStreamArray[0];
                    ((PushSourceStream)this.sourceStream).setTransferHandler(new PushStreamHandler());
                }
            }
        }
        if (this.sourceStream == null && this.filename == null) {
            System.err.println("No source stream");
            return false;
        }
        if (!this.checkStreamType()) {
            System.err.println("The data is not an MPEG stream.\n");
            return false;
        }
        this.reloaded = true;
        this.timeBase = new MPXTimeBase();
        this.monitor = this.renderer.getComponent();
        this.needXBGR = 1;
        object = new Dimension(this.width, this.height);
        this.videoformat = new RGBFormat((Dimension)object, this.width * this.height, Format.intArray, 30.0f, 32, this.rMask, this.gMask, this.bMask, 1, ((Dimension)object).width + 7 & 0xFFFFFFF8, 0, -1);
        this.rgbBuffer = new int[this.width * this.height];
        this.renderer.setInputFormat(this.videoformat);
        this.startSource(false);
        return true;
    }

    protected void abortRealize() {
        this.startSource(false);
    }

    protected boolean doPrefetch() {
        boolean bl;
        if (this.isInitialized()) {
            return true;
        }
        if (this.strmType != 2 && !(bl = this.audioRate == 0 || this.audioChannels == 0 ? this.setAudio(22050, 1) : this.setAudio(this.audioRate, this.audioChannels))) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            if (this.strmType == 4) {
                return false;
            }
        }
        this.cmdPipe = new PipedInputStream();
        this.mpxCmdPipe = new PipedOutputStream();
        try {
            this.cmdPipe.connect(this.mpxCmdPipe);
        }
        catch (IOException iOException) {
            return false;
        }
        if (jmfSecurity != null) {
            String string = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    string = "thread";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                    string = "thread group";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor constructor = jdk12CreateThreadRunnableAction.cons;
                this.customMpxThread = (CustomMpxThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$codec$video$customjmpx$CustomMpxThread == null ? (class$com$sun$media$codec$video$customjmpx$CustomMpxThread = CustomJmpx.class$("com.sun.media.codec.video.customjmpx.CustomMpxThread")) : class$com$sun$media$codec$video$customjmpx$CustomMpxThread, this));
                this.dataThread = (CustomDataThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$codec$video$customjmpx$CustomDataThread == null ? (class$com$sun$media$codec$video$customjmpx$CustomDataThread = CustomJmpx.class$("com.sun.media.codec.video.customjmpx.CustomDataThread")) : class$com$sun$media$codec$video$customjmpx$CustomDataThread, this));
                if (!this.initMPX(this.monitor)) {
                    return false;
                }
                this.cmdInputThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = CustomJmpx.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                this.cmdInputThread.setName("CustomJmpx command input thread");
                constructor = jdk12PriorityAction.cons;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.cmdInputThread;
                CustomJmpx customJmpx = this;
                objectArray2[1] = new Integer(customJmpx.cmdInputThread.getControlPriority());
                objectArray[0] = constructor.newInstance(objectArray2);
                jdk12.doPrivM.invoke((Object)jdk12.ac, objectArray);
                this.cmdInputThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.customMpxThread = new CustomMpxThread(this);
            this.dataThread = new CustomDataThread(this);
            if (!this.initMPX(this.monitor)) {
                return false;
            }
            this.cmdInputThread = new MediaThread(this);
            this.cmdInputThread.setName("CustomJmpx command input thread");
            this.cmdInputThread.useControlPriority();
            this.cmdInputThread.start();
        }
        try {
            while (this.dataThread.started == 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    protected void abortPrefetch() {
        this.closeMPX();
        this.reloaded = true;
        this.startSource(false);
    }

    protected void doStart() {
        this.oldLoc = 0.0f;
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        this.startSource(true);
        if (this.reloaded) {
            if (this.filename != null) {
                this.openFile(this.filename);
            } else if (this.sourceStream != null) {
                this.openStream(this.sourceStream);
            }
            this.reloaded = false;
        }
        if (!this.mediaTimeChanged) {
            this.play();
            return;
        }
        int n = this.trySetMediaTime(this.requestedMediaTime);
        if (n == 0) {
            this.play();
            this.mediaTimeChanged = false;
        } else if (n == 1) {
            super.stop();
            this.sendEvent(new SeekFailedEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        } else if (n == 2) {
            super.stop();
            this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }
    }

    public void stop() {
        super.stop();
        this.pause();
        this.startSource(false);
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    public boolean startSource(boolean bl) {
        if (this.sourceIsOn == bl) {
            return true;
        }
        try {
            if (bl) {
                this.source.start();
            } else {
                this.source.stop();
            }
        }
        catch (Exception exception) {
            return false;
        }
        this.sourceIsOn = bl;
        return true;
    }

    protected void closeMPX() {
        if (this.isInitialized()) {
            this.killCommandThread = true;
            this.exit();
            try {
                this.mpxCmdPipe.flush();
                this.mpxCmdPipe.close();
                this.cmdPipe.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void doClose() {
        if (this.isInitialized()) {
            this.windowAvailable = false;
            this.closeMPX();
            this.customMpxThread = null;
            this.dataThread = null;
            this.cmdInputThread = null;
            this.monitor = null;
        }
        this.closeAudio();
        if (this.source != null) {
            try {
                this.source.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        super.setTimeBase(timeBase);
        if (timeBase == null || timeBase != this.timeBase) {
            // empty if block
        }
        this.timeBase = timeBase;
    }

    public TimeBase getTimeBase() {
        super.getTimeBase();
        return this.timeBase;
    }

    protected void doSetMediaTime(Time time) {
        this.requestedMediaTime = time;
        this.mediaTimeChanged = true;
    }

    protected int trySetMediaTime(Time time) {
        Time time2 = this.getDuration();
        double d = time.getSeconds();
        double d2 = time2.getSeconds();
        if (time2 != Duration.DURATION_UNKNOWN) {
            if (d > d2) {
                return 2;
            }
        } else if (d != 0.0) {
            return 1;
        }
        if (this.sourceStream != null) {
            if (this.sourceStream instanceof Seekable) {
                Seekable seekable = (Seekable)((Object)this.sourceStream);
                if (d == 0.0) {
                    seekable.seek(0L);
                    this.seek(0.0);
                    return 0;
                }
                if (seekable.isRandomAccess() && this.getContentLength() > 0) {
                    double d3 = d / d2;
                    long l = (long)(d3 * (double)this.getContentLength());
                    seekable.seek(l);
                    this.seek(d3);
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (d == 0.0) {
            this.seek(0.0);
            return 0;
        }
        double d4 = d / d2;
        if (d4 > 1.0) {
            d4 = 1.0;
        }
        this.seek(d4);
        return 0;
    }

    public long getMediaNanoseconds() {
        return this.getMediaTime().getNanoseconds();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Time getDuration() {
        Time time;
        if (this.eomDuration != Duration.DURATION_UNKNOWN) {
            return this.eomDuration;
        }
        if (this.source instanceof Duration && (time = this.source.getDuration()) != null && time != Duration.DURATION_UNKNOWN && time != Duration.DURATION_UNBOUNDED) {
            return time;
        }
        if (this.mediaTimeChanged) {
            return this.knownDuration;
        }
        long l = this.getMediaNanoseconds();
        double d = this.getLoc();
        if (d == 0.0 || l < 3000000000L) {
            return this.knownDuration;
        }
        long l2 = (long)((double)l / d);
        long l3 = this.knownDuration.getNanoseconds();
        if ((double)Math.abs(l2 - l3) > 5.0E9) {
            this.knownDuration = new Time(l2);
            this.sendEvent(new DurationUpdateEvent(this, this.knownDuration));
        }
        return this.knownDuration;
    }

    public Component getVisualComponent() {
        if (this.strmType == 4) {
            return null;
        }
        return this.monitor;
    }

    public Control[] getControls() {
        if (this.strmType != 4 && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this, 0.0f, 0.0f, 30.0f, false){

                public float setFrameRate(float f) {
                    if (f <= 0.0f) {
                        return this.getFrameRate();
                    }
                    this.value = f;
                    return this.value;
                }

                public Component getControlComponent() {
                    return null;
                }

                public Object getOwner() {
                    return CustomJmpx.this;
                }
            };
        }
        if (this.strmType != 2 && this.gainControl == null) {
            this.gainControl = new GCA(this);
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateAdapter(0, -1, -1, false){

                public int setBitRate(int n) {
                    this.value = n;
                    return this.value;
                }

                public Component getControlComponent() {
                    return null;
                }
            };
        }
        if (this.framePositioningControl == null) {
            this.framePositioningControl = new FramePositioningCtrl();
        }
        int n = 0;
        if (this.frameRateControl != null) {
            ++n;
        }
        if (this.gainControl != null) {
            ++n;
        }
        if (this.bitRateControl != null) {
            ++n;
        }
        if (this.framePositioningControl != null) {
            ++n;
        }
        this.controls = new Control[n];
        n = 0;
        if (this.frameRateControl != null) {
            this.controls[n++] = this.frameRateControl;
        }
        if (this.gainControl != null) {
            this.controls[n++] = this.gainControl;
        }
        if (this.bitRateControl != null) {
            this.controls[n++] = this.bitRateControl;
        }
        if (this.framePositioningControl != null) {
            this.controls[n++] = this.framePositioningControl;
        }
        return this.controls;
    }

    public void play() {
        if (this.fwdSpeed == 1.0f) {
            this.setAction(1);
        } else {
            this.setAction(2);
        }
    }

    public void pause() {
        this.setAction(8);
    }

    protected float doSetRate(float f) {
        if (this.strmType == 4) {
            return 1.0f;
        }
        if (f < 0.1f) {
            f = 0.1f;
        } else if (f > 10.0f) {
            f = 10.0f;
        }
        this.fwdSpeed = f;
        return this.fwdSpeed;
    }

    public boolean checkStreamType() {
        if (this.strmType != 0) {
            this.possibleLength = -1;
            if (this.filename != null) {
                this.getMediaDuration(this.filename);
            }
            if (this.possibleLength > 0) {
                this.eomDuration = new Time((double)this.possibleLength);
            }
            return true;
        }
        this.possibleLength = -1;
        if (this.filename != null) {
            this.strmType = this.checkMpegFile(this.filename);
            if (this.strmType == 0) {
                return false;
            }
        } else if (this.sourceStream != null) {
            this.strmType = this.checkMpegStream(this.sourceStream);
            if (this.strmType == 0) {
                return false;
            }
            if (this.sourceStream instanceof Seekable) {
                ((Seekable)((Object)this.sourceStream)).seek(0L);
            }
        } else {
            return false;
        }
        if (this.possibleWidth != -1 && this.possibleHeight != -1) {
            this.width = this.possibleWidth;
            this.height = this.possibleHeight;
            this.outWidth = this.width;
            this.outHeight = this.height;
        }
        if (this.possibleLength > 0) {
            this.eomDuration = new Time((double)this.possibleLength);
        }
        return true;
    }

    protected boolean initAudio() {
        return this.audio != null;
    }

    protected void closeAudio() {
        try {
            if (this.audio != null) {
                this.audio.pause();
                this.audio.flush();
                this.audio.dispose();
                this.audio = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean setAudio(int n, int n2) {
        boolean bl = false;
        float f = -1.0f;
        if (this.audio != null) {
            if (this.audioRate == n && this.audioChannels == n2) {
                this.audio.flush();
                this.audio.resetSamples();
                return true;
            }
            bl = this.audio.getMute();
            f = (float)this.audio.getGain();
            this.audio.pause();
            this.audio.flush();
            this.audio.dispose();
        }
        AudioFormat audioFormat = new AudioFormat("LINEAR", n, 16, n2, BIG_ENDIAN ? 1 : 0, 1);
        this.audioRate = n;
        this.audioChannels = n2;
        this.audio = new JmpxAudio();
        if (!this.audio.initialize(audioFormat)) {
            this.audio = null;
            return false;
        }
        this.audio.resume();
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        if (this.gainControl != null) {
            this.audio.setMute(this.gainControl.getMute());
            if (this.gainControl.getDB() != -1.0f) {
                this.audio.setGain(this.gainControl.getDB());
            }
        } else {
            if (bl) {
                this.audio.setMute(bl);
            }
            if (f != -1.0f) {
                this.audio.setGain(f);
            }
        }
        return true;
    }

    public boolean isInitialized() {
        return this.peer != 0L;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStreamType() {
        return this.strmType;
    }

    public int getDisplayWidth() {
        if (this.useJavaRenderer == 1) {
            return this.outWidth;
        }
        return this.width * this.zoom;
    }

    public int getDisplayHeight() {
        if (this.useJavaRenderer == 1) {
            return this.outHeight;
        }
        return this.height * this.zoom;
    }

    public double getLoc() {
        return this.loc;
    }

    public void setMute(boolean bl) {
        if (this.audio != null) {
            this.audio.setMute(bl);
        }
    }

    public void setGain(float f) {
        if (this.audio != null) {
            this.audio.setGain(f);
        }
    }

    public synchronized void exit() {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(7, -859045887);
        customMpxCmd.packInt(9, 1);
        this.sendMPX(customMpxCmd.getBytes());
        this.peer = 0L;
    }

    public synchronized void openFile(String string) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 2);
        customMpxCmd.packInt(10, 0);
        customMpxCmd.packInt(11, 0);
        customMpxCmd.packInt(12, this.strmType);
        customMpxCmd.packInt(13, 0);
        customMpxCmd.packInt(14, 1);
        customMpxCmd.packInt(15, 1);
        customMpxCmd.packStr(16, string);
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void openStream(SourceStream sourceStream) {
        this.setStream(sourceStream);
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 2);
        customMpxCmd.packInt(10, 0);
        customMpxCmd.packInt(11, 0);
        customMpxCmd.packInt(12, this.strmType);
        customMpxCmd.packInt(13, 0);
        customMpxCmd.packInt(14, 1);
        customMpxCmd.packInt(15, 5);
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void setAction(int n) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 5);
        customMpxCmd.packInt(10, n);
        customMpxCmd.packInt(11, (int)((double)this.fwdSpeed * 65535.0));
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void seek(double d) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 4);
        customMpxCmd.packInt(10, 0);
        customMpxCmd.packInt(11, (int)(d * 65535.0));
        customMpxCmd.packInt(12, this.strmType);
        customMpxCmd.packInt(13, 0);
        customMpxCmd.packInt(14, 1);
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void flush() {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 4);
        customMpxCmd.packInt(10, 0);
        customMpxCmd.packInt(11, 0);
        customMpxCmd.packInt(12, this.strmType);
        customMpxCmd.packInt(13, 8224);
        customMpxCmd.packInt(14, 4);
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void mute(boolean bl) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 7);
        if (bl) {
            customMpxCmd.packInt(10, 192);
        } else {
            customMpxCmd.packInt(10, 0);
        }
        this.sendMPX(customMpxCmd.getBytes());
        this.muted = bl;
    }

    public synchronized void muteAll(boolean bl) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 7);
        if (bl) {
            customMpxCmd.packInt(10, 192);
        } else {
            customMpxCmd.packInt(10, 0);
        }
        this.broadcastMPX(customMpxCmd.getBytes());
    }

    public synchronized void zoom(int n) {
        if (this.useJavaRenderer != 1) {
            CustomMpxCmd customMpxCmd = new CustomMpxCmd();
            customMpxCmd.packInt(9, 6);
            customMpxCmd.packInt(10, 1);
            int n2 = this.interleaved ? 2 : 1;
            n2 <<= 8;
            customMpxCmd.packInt(11, n2 |= n);
            this.sendMPX(customMpxCmd.getBytes());
        } else {
            this.java_zoom = n;
        }
    }

    public synchronized void zoomIn() {
        if (this.useJavaRenderer == 1) {
            if (this.java_zoom >= 2.0f) {
                return;
            }
            this.java_zoom *= 2.0f;
            this.updateSizeChanged(this.width, this.height);
        } else {
            this.zoom(this.zoom + 1);
        }
    }

    public synchronized void zoomOut() {
        if (this.useJavaRenderer == 1) {
            if (this.java_zoom <= 0.25f) {
                return;
            }
            this.java_zoom /= 2.0f;
            this.updateSizeChanged(this.width, this.height);
        } else {
            if (this.zoom <= 1) {
                return;
            }
            this.zoom(this.zoom - 1);
        }
    }

    public void updateSizeChanged(int n, int n2) {
        this.sendEvent(new SizeChangeEvent(this, n, n2, 1.0f));
    }

    public synchronized void setInterleave(boolean bl) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 6);
        customMpxCmd.packInt(10, 1);
        int n = bl ? 2 : 1;
        n <<= 8;
        n = this.useJavaRenderer == 1 ? (n |= 1) : (n |= this.zoom);
        customMpxCmd.packInt(11, n);
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void setAudioMode(int n) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 6);
        customMpxCmd.packInt(10, 2);
        if ((n & 3) == 3) {
            customMpxCmd.packInt(12, 56);
        } else if ((n & 2) == 2) {
            customMpxCmd.packInt(12, 48);
        } else {
            customMpxCmd.packInt(12, 40);
        }
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void setAudioQuality(int n) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 6);
        customMpxCmd.packInt(10, 2);
        if ((n & 0x18) == 24) {
            customMpxCmd.packInt(12, 4);
        } else if ((n & 0x10) == 16) {
            customMpxCmd.packInt(12, 5);
        } else {
            customMpxCmd.packInt(12, 6);
        }
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void setGamma(double d) {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(9, 6);
        customMpxCmd.packInt(10, 32);
        customMpxCmd.packInt(16, (int)(d * 65535.0));
        this.sendMPX(customMpxCmd.getBytes());
    }

    public synchronized void sendAck() {
        CustomMpxCmd customMpxCmd = new CustomMpxCmd();
        customMpxCmd.packInt(7, -859045887);
        customMpxCmd.packInt(9, 10);
        customMpxCmd.packInt(6, this.ackSeq);
        this.sendMPX(customMpxCmd.getBytes());
    }

    public void addJmpxListener(JmpxListener jmpxListener) {
        this.listeners.addElement(jmpxListener);
    }

    public void removeJmpxListener(JmpxListener jmpxListener) {
        this.listeners.removeElement(jmpxListener);
    }

    public void updateListeners(JmpxEvent jmpxEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((JmpxListener)this.listeners.elementAt(i)).jmpxUpdate(jmpxEvent);
        }
    }

    protected void listenCommand() {
        byte[] byArray = new byte[128];
        int n = 0;
        try {
            if (!this.killCommandThread) {
                n = this.cmdPipe.read(byArray);
            }
        }
        catch (IOException iOException) {
            return;
        }
        if (n > 0) {
            this.processCommand(byArray, n);
        }
    }

    protected int processCommand(byte[] byArray, int n) {
        int n2;
        int[] nArray = new int[n /= 4];
        if (BIG_ENDIAN) {
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = 0;
                int n3 = n2;
                nArray[n3] = nArray[n3] | byArray[n2 * 4] & 0x7F;
                int n4 = n2;
                nArray[n4] = nArray[n4] | byArray[n2 * 4] & 0x80;
                int n5 = n2;
                nArray[n5] = nArray[n5] << 8;
                int n6 = n2;
                nArray[n6] = nArray[n6] | byArray[n2 * 4 + 1] & 0x7F;
                int n7 = n2;
                nArray[n7] = nArray[n7] | byArray[n2 * 4 + 1] & 0x80;
                int n8 = n2;
                nArray[n8] = nArray[n8] << 8;
                int n9 = n2;
                nArray[n9] = nArray[n9] | byArray[n2 * 4 + 2] & 0x7F;
                int n10 = n2;
                nArray[n10] = nArray[n10] | byArray[n2 * 4 + 2] & 0x80;
                int n11 = n2;
                nArray[n11] = nArray[n11] << 8;
                int n12 = n2;
                nArray[n12] = nArray[n12] | byArray[n2 * 4 + 3] & 0x7F;
                int n13 = n2;
                nArray[n13] = nArray[n13] | byArray[n2 * 4 + 3] & 0x80;
            }
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = 0;
                int n14 = n2;
                nArray[n14] = nArray[n14] | byArray[n2 * 4 + 3] & 0x7F;
                int n15 = n2;
                nArray[n15] = nArray[n15] | byArray[n2 * 4 + 3] & 0x80;
                int n16 = n2;
                nArray[n16] = nArray[n16] << 8;
                int n17 = n2;
                nArray[n17] = nArray[n17] | byArray[n2 * 4 + 2] & 0x7F;
                int n18 = n2;
                nArray[n18] = nArray[n18] | byArray[n2 * 4 + 2] & 0x80;
                int n19 = n2;
                nArray[n19] = nArray[n19] << 8;
                int n20 = n2;
                nArray[n20] = nArray[n20] | byArray[n2 * 4 + 1] & 0x7F;
                int n21 = n2;
                nArray[n21] = nArray[n21] | byArray[n2 * 4 + 1] & 0x80;
                int n22 = n2;
                nArray[n22] = nArray[n22] << 8;
                int n23 = n2;
                nArray[n23] = nArray[n23] | byArray[n2 * 4 + 0] & 0x7F;
                int n24 = n2;
                nArray[n24] = nArray[n24] | byArray[n2 * 4 + 0] & 0x80;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (nArray[n2] == CustomMpxCmd.SyncPat[n2]) continue;
            return 0;
        }
        if (nArray[4] != -1431699455) {
            return 0;
        }
        if (nArray[7] >>> 16 != 52428) {
            return 0;
        }
        int n25 = nArray[7] & 0xFFFF;
        if ((n25 & 4) == 0) {
            return 0;
        }
        if (nArray[8] >>> 16 != 56797) {
            return 0;
        }
        int n26 = nArray[8] & 0xFFFF;
        if (n26 != 1 && n26 != 2) {
            return 0;
        }
        if (n26 == 1 && n != 32 || n26 == 2 && n != 128) {
            return 0;
        }
        int n27 = nArray[6];
        int n28 = nArray[9];
        switch (n28 & 0xFF) {
            case 30: {
                this.width = nArray[10];
                this.height = nArray[11];
                if (this.useJavaRenderer != 1) {
                    this.zoom = nArray[12];
                }
                this.cmap = nArray[13];
                this.updateSize(this.width, this.height);
                this.sendEvent(new SizeChangeEvent(this, this.width, this.height, 1.0f));
                break;
            }
            case 31: {
                long l = System.currentTimeMillis();
                float f = (float)(l - this.lastStatTime) / 1000.0f;
                this.lastStatTime = l;
                this.size = nArray[10];
                this.loc = (float)((double)nArray[11] / 65535.0);
                this.time = nArray[12];
                long l2 = nArray[13] + nArray[14] + nArray[15];
                this.fps = (float)(nArray[13] + nArray[14] + nArray[15]) / f;
                this.fps = (float)((int)(this.fps * 10.0f)) / 10.0f;
                this.kbps = (float)(nArray[16] * 8) / f / 1000.0f;
                this.kbps = (float)((int)(this.kbps * 10.0f)) / 10.0f;
                this.frames += (long)(nArray[13] + nArray[14] + nArray[15]);
                if (this.frameRateControl != null) {
                    this.frameRateControl.setFrameRate(this.fps);
                }
                if (this.bitRateControl != null) {
                    this.bitRateControl.setBitRate((int)(this.kbps * 1000.0f));
                }
                if ((double)this.loc >= 1.0 && (this.frames != 0L || this.strmType == 4)) {
                    this.pause();
                    super.stop();
                    this.startSource(false);
                    if ((double)this.oldLoc < 1.0) {
                        this.knownDuration = this.eomDuration = this.getMediaTime();
                        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                        this.sendEvent(new DurationUpdateEvent(this, this.eomDuration));
                    }
                }
                this.oldLoc = this.loc;
                this.getDuration();
                break;
            }
            case 10: {
                if (this.listeners.size() <= 0) break;
                JmpxAckNotifyEvent jmpxAckNotifyEvent = new JmpxAckNotifyEvent();
                jmpxAckNotifyEvent.sequence = n27;
                this.updateListeners(jmpxAckNotifyEvent);
                break;
            }
        }
        return n28;
    }

    public void run() {
        while (!this.killCommandThread) {
            this.listenCommand();
        }
    }

    public synchronized void resizeWindow(int n, int n2) {
        if (this.monitor == null) {
            return;
        }
        this.width = n;
        this.height = n2;
        if (this.videoformat instanceof RGBFormat) {
            this.rgbBuffer = new int[this.width * this.height];
            this.videoformat = new RGBFormat(new Dimension(this.width, this.height), this.width * this.height, Format.intArray, 30.0f, 32, this.rMask, this.gMask, this.bMask, 1, this.width, 0, 0);
            this.outWidth = this.width;
            this.outHeight = this.height;
        } else {
            this.videoformat = new YUVFormat(new Dimension(this.width, this.height), this.width * this.height * 2, Format.byteArray, -1.0f, 4, this.width, this.width / 2, 0, this.width * this.height, this.width * this.height + this.width * this.height / 4);
            this.rgbBuffer = new byte[this.width * this.height * 2];
        }
    }

    public Component getImage(int n, int n2) {
        if (this.width != n || this.height != n2 || this.rgbBuffer == null) {
            this.resizeWindow(n, n2);
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayImage() {
        if (this.monitor == null) {
            return;
        }
        Component component = this.monitor;
        synchronized (component) {
            if (this.videoformat instanceof RGBFormat) {
                this.outBuffer.setData((int[])this.rgbBuffer);
                this.outBuffer.setLength(this.width * this.height);
            } else {
                this.outBuffer.setData((byte[])this.rgbBuffer);
                this.outBuffer.setLength(this.width * this.height + this.width * this.height / 2);
            }
            this.outBuffer.setFormat(this.videoformat);
            this.outBuffer.setTimeStamp(-1L);
            this.outBuffer.setFlags(0);
            this.outBuffer.setHeader(null);
            this.renderer.process(this.outBuffer);
        }
    }

    private void updateSize(int n, int n2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class FramePositioningCtrl
    implements FramePositioningControl {
        private long frameStep = -1L;
        private float rate;
        private int lastFrame;

        FramePositioningCtrl() {
            this.rate = CustomJmpx.this.frameRateControl.getFrameRate();
            if (this.rate <= 0.0f) {
                CustomJmpx.this.frameRateControl.setFrameRate(24.0f);
                this.rate = 24.0f;
            }
            if (this.rate != -1.0f && this.rate != 0.0f) {
                this.frameStep = (long)(1.0E9f / this.rate);
            }
            this.lastFrame = this.mapTimeToFrame(CustomJmpx.this.getDuration());
        }

        public Component getControlComponent() {
            return null;
        }

        public int seek(int n) {
            if (n < 0) {
                CustomJmpx.this.player.setMediaTime(new Time(0L));
                n = 0;
                return 0;
            }
            if (n >= this.lastFrame) {
                n = this.lastFrame;
                CustomJmpx.this.player.setMediaTime(CustomJmpx.this.getDuration());
                return this.lastFrame;
            }
            Time time = this.mapFrameToTime(n);
            if (time.getNanoseconds() >= CustomJmpx.this.getDuration().getNanoseconds()) {
                time = CustomJmpx.this.getDuration();
            }
            if (time != null && time != FramePositioningControl.TIME_UNKNOWN) {
                CustomJmpx.this.player.setMediaTime(time);
                return this.mapTimeToFrame(time);
            }
            return Integer.MAX_VALUE;
        }

        public int skip(int n) {
            if (this.frameStep != -1L) {
                long l;
                long l2 = CustomJmpx.this.getMediaNanoseconds();
                long l3 = l2 + (l = (long)n * this.frameStep);
                if (l3 <= 0L) {
                    l3 = 0L;
                } else if (l3 >= CustomJmpx.this.getDuration().getNanoseconds()) {
                    l3 = CustomJmpx.this.getDuration().getNanoseconds();
                }
                CustomJmpx.this.player.setMediaTime(new Time(l3));
                n = (int)((l3 - l2) / this.frameStep);
                return n;
            }
            int n2 = this.mapTimeToFrame(CustomJmpx.this.getMediaTime());
            if (n2 != 0 && n2 != Integer.MAX_VALUE) {
                int n3 = this.seek(n2 + n);
                return n3 - n2;
            }
            return Integer.MAX_VALUE;
        }

        public Time mapFrameToTime(int n) {
            if (n < 0) {
                return FramePositioningControl.TIME_UNKNOWN;
            }
            if (n == 0) {
                return new Time(0L);
            }
            if (this.frameStep != -1L) {
                long l = (long)((float)n / this.rate * 1.0E9f);
                return new Time(l);
            }
            return FramePositioningControl.TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            long l = time.getNanoseconds();
            if (l < 0L) {
                return Integer.MAX_VALUE;
            }
            if (l == 0L) {
                return 0;
            }
            if (this.frameStep != -1L) {
                int n = (int)(l / this.frameStep);
                return n;
            }
            return Integer.MAX_VALUE;
        }
    }

    class GCA
    extends GainControlAdapter {
        CustomJmpx jmpx;

        protected GCA(CustomJmpx customJmpx2) {
            super(false);
            this.jmpx = customJmpx2;
        }

        public void setMute(boolean bl) {
            if (CustomJmpx.this.audio != null) {
                CustomJmpx.this.audio.setMute(bl);
            }
            super.setMute(bl);
        }

        public float setLevel(float f) {
            if (this.jmpx == null) {
                return f;
            }
            float f2 = super.setLevel(f);
            if (CustomJmpx.this.audio != null) {
                CustomJmpx.this.audio.setGain(this.getDB());
            }
            return f2;
        }
    }

    class PushStreamHandler
    implements SourceTransferHandler {
        PushStreamHandler() {
        }

        public void transferData(PushSourceStream pushSourceStream) {
            CustomJmpx.this.notifyPushDataArrival();
        }
    }

    class Monitor
    extends Canvas {
        public Monitor(int n, int n2) {
            super.setSize(n, n2);
        }

        public void updateSize(int n, int n2) {
            if (CustomJmpx.this.outputSizeSet) {
                return;
            }
            Component component = this;
            while (component.getParent() != null) {
                component = component.getParent();
            }
            super.setSize(n, n2);
            if (component != null) {
                component.validate();
            }
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }

        public Dimension getPreferredSize() {
            return new Dimension(CustomJmpx.this.getWidth(), CustomJmpx.this.getHeight());
        }

        public synchronized void removeNotify() {
            CustomJmpx.this.windowAvailable = false;
            super.removeNotify();
        }

        public synchronized void addNotify() {
            super.addNotify();
            CustomJmpx.this.windowAvailable = true;
        }

        public synchronized void paint(Graphics graphics) {
            if (CustomJmpx.this.getTargetState() == 600) {
                return;
            }
        }

        public void update(Graphics graphics) {
            if (CustomJmpx.this.getTargetState() == 600) {
                return;
            }
        }
    }

    class MPXTimeBase
    extends MediaTimeBase {
        MPXTimeBase() {
        }

        public long getMediaTime() {
            return CustomJmpx.this.audio != null ? CustomJmpx.this.audio.getMediaNanoseconds() : 0L;
        }

        protected void reset() {
            if (CustomJmpx.this.audio == null || CustomJmpx.this.getState() != 600) {
                this.mediaStopped();
            } else {
                this.mediaStarted();
            }
        }
    }
}

