/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class RGBScaler
extends BasicCodec {
    protected float quality = 0.5f;
    private int nativeData = 0;
    private static boolean nativeAvailable = true;

    public RGBScaler() {
        this(null);
    }

    public RGBScaler(Dimension dimension) {
        this.inputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1)};
        if (dimension != null) {
            this.setOutputSize(dimension);
        }
    }

    public void setOutputSize(Dimension dimension) {
        this.outputFormats = new Format[]{new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, dimension.width * 3, 0, -1)};
    }

    public String getName() {
        return "RGB Scaler";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (RGBScaler.matches(format, this.inputFormats) != null) {
            float f = ((VideoFormat)format).getFrameRate();
            VideoFormat videoFormat = new VideoFormat(null, null, -1, null, f);
            return new Format[]{this.outputFormats[0].intersects(videoFormat)};
        }
        return new Format[0];
    }

    public Format setInputFormat(Format format) {
        if (RGBScaler.matches(format, this.inputFormats) == null) {
            return null;
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (format == null || RGBScaler.matches(format, this.outputFormats) == null) {
            return null;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        int n = rGBFormat.getMaxDataLength();
        int n2 = rGBFormat.getLineStride();
        float f = rGBFormat.getFrameRate();
        int n3 = rGBFormat.getFlipped();
        int n4 = rGBFormat.getEndian();
        if (dimension == null) {
            return null;
        }
        if (n < dimension.width * dimension.height * 3) {
            n = dimension.width * dimension.height * 3;
        }
        if (n2 < dimension.width * 3) {
            n2 = dimension.width * 3;
        }
        if (n3 != 0) {
            n3 = 0;
        }
        this.outputFormat = this.outputFormats[0].intersects(new RGBFormat(dimension, n, null, f, -1, -1, -1, -1, -1, n2, -1, -1));
        return this.outputFormat;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n = ((VideoFormat)this.outputFormat).getMaxDataLength();
        buffer2.setLength(n);
        buffer2.setFormat(this.outputFormat);
        if (this.quality <= 0.5f) {
            this.nearestNeighbour(buffer, buffer2);
        }
        return 0;
    }

    public void close() {
        super.close();
        if (nativeAvailable && this.nativeData != 0) {
            try {
                this.nativeClose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void nearestNeighbour(Buffer buffer, Buffer buffer2) {
        Object object;
        Object object2;
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        Dimension dimension = rGBFormat.getSize();
        RGBFormat rGBFormat2 = (RGBFormat)buffer2.getFormat();
        Dimension dimension2 = rGBFormat2.getSize();
        int n = rGBFormat.getPixelStride();
        int n2 = rGBFormat2.getPixelStride();
        int n3 = rGBFormat.getLineStride();
        int n4 = rGBFormat2.getLineStride();
        float f = (float)dimension.width / (float)dimension2.width;
        float f2 = (float)dimension.height / (float)dimension2.height;
        long l = 0L;
        long l2 = 0L;
        if (nativeAvailable) {
            object2 = this.getInputData(buffer);
            object = this.validateData(buffer2, 0, true);
            l = this.getNativeData(object2);
            l2 = this.getNativeData(object);
        } else {
            object2 = buffer.getData();
            object = buffer2.getData();
        }
        if (nativeAvailable) {
            try {
                this.nativeScale(object2, l, object, l2, n, n3, dimension.width, dimension.height, n2, n4, dimension2.width, dimension2.height);
            }
            catch (Throwable throwable) {
                nativeAvailable = false;
            }
        }
        if (!nativeAvailable) {
            byte[] byArray = (byte[])object2;
            byte[] byArray2 = (byte[])object;
            for (int i = 0; i < dimension2.height; ++i) {
                int n5 = i * n4;
                int n6 = (int)((float)i * f2) * n3;
                for (int j = 0; j < dimension2.width; ++j) {
                    int n7 = n6 + (int)((float)j * f) * n;
                    byArray2[n5] = byArray[n7];
                    byArray2[n5 + 1] = byArray[n7 + 1];
                    byArray2[n5 + 2] = byArray[n7 + 2];
                    n5 += n2;
                }
            }
        }
    }

    private native void nativeScale(Object var1, long var2, Object var4, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    private native void nativeClose();

    static {
        try {
            JMFSecurityManager.loadLibrary("jmcustommpx");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

