/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public abstract class RGBConverter
extends BasicCodec {
    private static final String PLUGIN_NAME = "RGB To RGB Converter";
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame;

    public RGBConverter() {
        this.inputFormats = new Format[]{new RGBFormat()};
        this.outputFormats = new Format[]{new RGBFormat()};
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                FPC() {
                }

                public void setFramesBehind(float f) {
                    if (f > 0.0f) {
                        RGBConverter.this.dropFrame = true;
                    } else {
                        RGBConverter.this.dropFrame = false;
                    }
                }

                public boolean setMinimalProcessing(boolean bl) {
                    RGBConverter.this.dropFrame = bl;
                    return RGBConverter.this.dropFrame;
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }
            }
            this.frameControl = new FPC();
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (format instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)format;
            Dimension dimension = rGBFormat.getSize();
            float f = rGBFormat.getFrameRate();
            int n = rGBFormat.getBitsPerPixel();
            RGBFormat rGBFormat2 = new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, f, 16, -1, -1, -1, 1, dimension.width, -1, -1);
            RGBFormat rGBFormat3 = new RGBFormat(dimension, dimension.width * dimension.height * 2, Format.byteArray, f, 16, -1, -1, -1, 2, dimension.width * 2, -1, -1);
            RGBFormat rGBFormat4 = new RGBFormat(null, -1, null, -1.0f, -1, 63488, 2016, 31, -1, -1, -1, -1);
            RGBFormat rGBFormat5 = new RGBFormat(null, -1, null, -1.0f, -1, 31744, 992, 31, -1, -1, -1, -1);
            RGBFormat rGBFormat6 = new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, f, 24, -1, -1, -1, 3, dimension.width * 3, -1, -1);
            RGBFormat rGBFormat7 = new RGBFormat(null, -1, null, -1.0f, -1, 1, 2, 3, -1, -1, -1, -1);
            RGBFormat rGBFormat8 = new RGBFormat(null, -1, null, -1.0f, -1, 3, 2, 1, -1, -1, -1, -1);
            RGBFormat rGBFormat9 = new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, f, 32, -1, -1, -1, 1, dimension.width, -1, -1);
            RGBFormat rGBFormat10 = new RGBFormat(dimension, dimension.width * dimension.height * 4, Format.byteArray, f, 32, -1, -1, -1, 4, dimension.width * 4, -1, -1);
            RGBFormat rGBFormat11 = new RGBFormat(null, -1, null, -1.0f, -1, 2, 3, 4, -1, -1, -1, -1);
            RGBFormat rGBFormat12 = new RGBFormat(null, -1, null, -1.0f, -1, 4, 3, 2, -1, -1, -1, -1);
            RGBFormat rGBFormat13 = new RGBFormat(null, -1, null, -1.0f, -1, 1, 2, 3, -1, -1, -1, -1);
            RGBFormat rGBFormat14 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, 1, -1);
            RGBFormat rGBFormat15 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, 0, -1);
            RGBFormat rGBFormat16 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, 0);
            RGBFormat rGBFormat17 = new RGBFormat(null, -1, null, -1.0f, -1, -1, -1, -1, -1, -1, -1, 1);
            RGBFormat rGBFormat18 = new RGBFormat(null, -1, null, -1.0f, -1, 3, 2, 1, -1, -1, -1, -1);
            RGBFormat rGBFormat19 = new RGBFormat(null, -1, null, -1.0f, -1, 0xFF0000, 65280, 255, -1, -1, -1, -1);
            RGBFormat rGBFormat20 = new RGBFormat(null, -1, null, -1.0f, -1, 255, 65280, 0xFF0000, -1, -1, -1, -1);
            Format[] formatArray = new Format[]{rGBFormat2.intersects(rGBFormat4).intersects(rGBFormat14), rGBFormat2.intersects(rGBFormat4).intersects(rGBFormat15), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat14).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat14).intersects(rGBFormat16), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat15).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat4).intersects(rGBFormat15).intersects(rGBFormat16), rGBFormat2.intersects(rGBFormat5).intersects(rGBFormat14), rGBFormat2.intersects(rGBFormat5).intersects(rGBFormat15), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat14).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat14).intersects(rGBFormat16), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat15).intersects(rGBFormat17), rGBFormat3.intersects(rGBFormat5).intersects(rGBFormat15).intersects(rGBFormat16), rGBFormat6.intersects(rGBFormat7).intersects(rGBFormat14), rGBFormat6.intersects(rGBFormat7).intersects(rGBFormat15), rGBFormat6.intersects(rGBFormat8).intersects(rGBFormat14), rGBFormat6.intersects(rGBFormat8).intersects(rGBFormat15), rGBFormat9.intersects(rGBFormat19).intersects(rGBFormat14), rGBFormat9.intersects(rGBFormat19).intersects(rGBFormat15), rGBFormat9.intersects(rGBFormat20).intersects(rGBFormat14), rGBFormat9.intersects(rGBFormat20).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat13).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat13).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat18).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat18).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat11).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat11).intersects(rGBFormat15), rGBFormat10.intersects(rGBFormat12).intersects(rGBFormat14), rGBFormat10.intersects(rGBFormat12).intersects(rGBFormat15)};
            return formatArray;
        }
        return null;
    }

    protected abstract void sixteenToSixteen(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void sixteenToComponent(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void componentToSixteen(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    protected abstract void componentToComponent(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9, Object var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17, int var18, int var19, int var20, boolean var21);

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (format2 == null) {
            return null;
        }
        if (((RGBFormat)format2).getBitsPerPixel() < 15) {
            return null;
        }
        Dimension dimension = ((VideoFormat)format).getSize();
        if (this.opened) {
            this.outputFormat = this.updateRGBFormat((VideoFormat)format, (RGBFormat)this.outputFormat);
        }
        return format2;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.dropFrame) {
            buffer2.setFlags(buffer2.getFlags() | 2);
            return 0;
        }
        RGBFormat rGBFormat = (RGBFormat)this.inputFormat;
        RGBFormat rGBFormat2 = (RGBFormat)this.outputFormat;
        Object object = buffer.getData();
        Object object2 = buffer2.getData();
        if (object.getClass() != this.inputFormat.getDataType()) {
            return 1;
        }
        int n = rGBFormat2.getMaxDataLength();
        int n2 = 0;
        if (object2 != null) {
            if (object2.getClass() == Format.byteArray) {
                n2 = ((byte[])object2).length;
            } else if (object2.getClass() == Format.shortArray) {
                n2 = ((short[])object2).length;
            } else if (object2.getClass() == Format.intArray) {
                n2 = ((int[])object2).length;
            }
        }
        if (object2 == null || n2 < n || this.outputFormat != buffer2.getFormat() || !this.outputFormat.equals(buffer2.getFormat())) {
            Class clazz = this.outputFormat.getDataType();
            if (clazz == Format.byteArray) {
                object2 = new byte[rGBFormat2.getMaxDataLength()];
            } else if (clazz == Format.shortArray) {
                object2 = new short[rGBFormat2.getMaxDataLength()];
            } else if (clazz == Format.intArray) {
                object2 = new int[rGBFormat2.getMaxDataLength()];
            } else {
                return 1;
            }
            buffer2.setData(object2);
        }
        if (object2.getClass() != this.outputFormat.getDataType()) {
            return 1;
        }
        int n3 = rGBFormat.getBitsPerPixel();
        int n4 = rGBFormat2.getBitsPerPixel();
        boolean bl = rGBFormat.getDataType() != Format.byteArray;
        boolean bl2 = rGBFormat2.getDataType() != Format.byteArray;
        int n5 = rGBFormat.getPixelStride();
        int n6 = rGBFormat2.getPixelStride();
        int n7 = rGBFormat.getEndian();
        int n8 = rGBFormat2.getEndian();
        int n9 = rGBFormat.getRedMask();
        int n10 = rGBFormat.getGreenMask();
        int n11 = rGBFormat.getBlueMask();
        int n12 = rGBFormat2.getRedMask();
        int n13 = rGBFormat2.getGreenMask();
        int n14 = rGBFormat2.getBlueMask();
        int n15 = rGBFormat.getLineStride();
        int n16 = rGBFormat2.getLineStride();
        boolean bl3 = rGBFormat.getFlipped() != rGBFormat2.getFlipped();
        Dimension dimension = rGBFormat.getSize();
        int n17 = dimension.width;
        int n18 = dimension.height;
        if (n3 == 16 && n4 == 16) {
            this.sixteenToSixteen(object, n5, n15, n3, n9, n10, n11, bl, n7, object2, n6, n16, n4, n12, n13, n14, bl2, n8, n17, n18, bl3);
        } else if (n3 == 16 && n4 >= 24) {
            this.sixteenToComponent(object, n5, n15, n3, n9, n10, n11, bl, n7, object2, n6, n16, n4, n12, n13, n14, bl2, n8, n17, n18, bl3);
        } else if (n3 >= 24 && n4 == 16) {
            this.componentToSixteen(object, n5, n15, n3, n9, n10, n11, bl, n7, object2, n6, n16, n4, n12, n13, n14, bl2, n8, n17, n18, bl3);
        } else if (n3 >= 24 && n4 >= 24) {
            this.componentToComponent(object, n5, n15, n3, n9, n10, n11, bl, n7, object2, n6, n16, n4, n12, n13, n14, bl2, n8, n17, n18, bl3);
        }
        buffer2.setFormat(this.outputFormat);
        buffer2.setLength(rGBFormat2.getMaxDataLength());
        return 0;
    }

    public void open() throws ResourceUnavailableException {
        super.open();
    }

    public void close() {
        super.close();
    }

    public void reset() {
    }

    protected int getShift(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }
}

