/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class JavaRGBToYUV
extends BasicCodec {
    private static final String PLUGIN_NAME = "RGB To YUV";
    private FrameProcessingControl frameControl = null;
    private boolean dropFrame = false;

    public JavaRGBToYUV() {
        int n = -1;
        this.inputFormats = new Format[]{new RGBFormat(null, n, Format.byteArray, n, 24, n, n, n, n, n, n, n), new RGBFormat(null, n, Format.intArray, n, 32, 0xFF0000, 65280, 255, 1, n, n, n), new RGBFormat(null, n, Format.intArray, n, 32, 255, 65280, 0xFF0000, 1, n, n, n)};
        this.outputFormats = new Format[]{new YUVFormat(2)};
        if (this.frameControl == null) {
            class FPC
            implements FrameProcessingControl {
                FPC() {
                }

                public void setFramesBehind(float f) {
                    if (f > 0.0f) {
                        JavaRGBToYUV.this.dropFrame = true;
                    } else {
                        JavaRGBToYUV.this.dropFrame = false;
                    }
                }

                public boolean setMinimalProcessing(boolean bl) {
                    JavaRGBToYUV.this.dropFrame = bl;
                    return JavaRGBToYUV.this.dropFrame;
                }

                public Component getControlComponent() {
                    return null;
                }

                public int getFramesDropped() {
                    return 0;
                }
            }
            this.frameControl = new FPC();
            this.controls = new Control[1];
            this.controls[0] = this.frameControl;
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (format instanceof RGBFormat && JavaRGBToYUV.matches(format, this.inputFormats) != null) {
            RGBFormat rGBFormat = (RGBFormat)format;
            Dimension dimension = rGBFormat.getSize();
            float f = rGBFormat.getFrameRate();
            int n = rGBFormat.getBitsPerPixel();
            int n2 = dimension.width + 1 & 0xFFFFFFFE;
            YUVFormat yUVFormat = new YUVFormat(dimension, n2 * dimension.height * 3 / 2, Format.byteArray, f, 2, n2, n2 / 2, 0, n2 * dimension.height, n2 * dimension.height * 5 / 4);
            Format[] formatArray = new Format[]{yUVFormat};
            return formatArray;
        }
        return new Format[0];
    }

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (this.opened) {
            this.outputFormat = this.getSupportedOutputFormats(format2)[0];
        }
        return format2;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.dropFrame) {
            buffer2.setFlags(buffer2.getFlags() | 2);
            return 0;
        }
        Format format = buffer.getFormat();
        if (!(format instanceof RGBFormat) || buffer.getData() == null) {
            return 1;
        }
        Object object = buffer.getData();
        this.validateByteArraySize(buffer2, ((VideoFormat)this.outputFormat).getMaxDataLength());
        buffer2.setFormat(this.outputFormat);
        buffer2.setLength(((VideoFormat)this.outputFormat).getMaxDataLength());
        if (((RGBFormat)format).getBitsPerPixel() == 24) {
            return this.convert24(buffer, buffer2);
        }
        return this.convertInt(buffer, buffer2);
    }

    protected int convert24(Buffer buffer, Buffer buffer2) {
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        YUVFormat yUVFormat = (YUVFormat)buffer2.getFormat();
        Dimension dimension = rGBFormat.getSize();
        byte[] byArray = (byte[])buffer2.getData();
        byte[] byArray2 = (byte[])buffer.getData();
        boolean bl = rGBFormat.getFlipped() == 1;
        int n = bl ? -1 : 1;
        int n2 = yUVFormat.getStrideY();
        int n3 = yUVFormat.getStrideUV();
        int n4 = yUVFormat.getOffsetY() + n2 * (bl ? dimension.height - 1 : 0);
        int n5 = yUVFormat.getOffsetU() + n3 * (bl ? dimension.height / 2 - 1 : 0);
        int n6 = yUVFormat.getOffsetV() + n3 * (bl ? dimension.height / 2 - 1 : 0);
        int n7 = 0;
        int n8 = rGBFormat.getLineStride();
        int n9 = rGBFormat.getPixelStride();
        int n10 = rGBFormat.getRedMask() - 1;
        int n11 = rGBFormat.getGreenMask() - 1;
        int n12 = rGBFormat.getBlueMask() - 1;
        for (int i = 0; i < dimension.height; i += 2) {
            for (int j = 0; j < dimension.width; j += 2) {
                int n13 = byArray2[n7 + n10] & 0xFF;
                int n14 = byArray2[n7 + n11] & 0xFF;
                int n15 = byArray2[n7 + n12] & 0xFF;
                int n16 = (n13 * 257 + n14 * 504 + n15 * 98) / 1000 + 16;
                int n17 = (-n13 * 148 - n14 * 291 + n15 * 439) / 1000 + 128;
                int n18 = (n13 * 439 - n14 * 368 - n15 * 71) / 1000 + 128;
                byArray[n4] = (byte)(n16 & 0xFF);
                n13 = byArray2[n7 + n10 + n9] & 0xFF;
                n14 = byArray2[n7 + n11 + n9] & 0xFF;
                n15 = byArray2[n7 + n12 + n9] & 0xFF;
                n16 = (n13 * 257 + n14 * 504 + n15 * 98) / 1000 + 16;
                n17 += (-n13 * 148 - n14 * 291 + n15 * 439) / 1000 + 128;
                n18 += (n13 * 439 - n14 * 368 - n15 * 71) / 1000 + 128;
                byArray[n4 + 1] = (byte)(n16 & 0xFF);
                n13 = byArray2[n7 + n10 + n8] & 0xFF;
                n14 = byArray2[n7 + n11 + n8] & 0xFF;
                n15 = byArray2[n7 + n12 + n8] & 0xFF;
                n16 = (n13 * 257 + n14 * 504 + n15 * 98) / 1000 + 16;
                n17 += (-n13 * 148 - n14 * 291 + n15 * 439) / 1000 + 128;
                n18 += (n13 * 439 - n14 * 368 - n15 * 71) / 1000 + 128;
                byArray[n4 + n * n2] = (byte)(n16 & 0xFF);
                n13 = byArray2[n7 + n10 + n8 + n9] & 0xFF;
                n14 = byArray2[n7 + n11 + n8 + n9] & 0xFF;
                n15 = byArray2[n7 + n12 + n8 + n9] & 0xFF;
                n16 = (n13 * 257 + n14 * 504 + n15 * 98) / 1000 + 16;
                byArray[n4 + n * n2 + 1] = (byte)(n16 & 0xFF);
                byArray[n5] = (byte)((n17 += (-n13 * 148 - n14 * 291 + n15 * 439) / 1000 + 128) >> 2 & 0xFF);
                byArray[n6] = (byte)((n18 += (n13 * 439 - n14 * 368 - n15 * 71) / 1000 + 128) >> 2 & 0xFF);
                n4 += 2;
                ++n5;
                ++n6;
                n7 += n9 * 2;
            }
            n7 += n8 * 2 - dimension.width * n9;
            n4 += n * n2 * 2 - dimension.width;
            n5 += n * n3 - dimension.width / 2;
            n6 += n * n3 - dimension.width / 2;
        }
        return 0;
    }

    protected int convertInt(Buffer buffer, Buffer buffer2) {
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        YUVFormat yUVFormat = (YUVFormat)buffer2.getFormat();
        Dimension dimension = rGBFormat.getSize();
        byte[] byArray = (byte[])buffer2.getData();
        int[] nArray = (int[])buffer.getData();
        boolean bl = rGBFormat.getFlipped() == 1;
        int n = bl ? -1 : 1;
        int n2 = yUVFormat.getStrideY();
        int n3 = yUVFormat.getStrideUV();
        int n4 = yUVFormat.getOffsetY() + n2 * (bl ? dimension.height - 1 : 0);
        int n5 = yUVFormat.getOffsetU() + n3 * (bl ? dimension.height / 2 - 1 : 0);
        int n6 = yUVFormat.getOffsetV() + n3 * (bl ? dimension.height / 2 - 1 : 0);
        int n7 = 0;
        int n8 = rGBFormat.getLineStride();
        int n9 = 16;
        int n10 = 8;
        int n11 = 0;
        if (rGBFormat.getRedMask() == 255) {
            n9 = 0;
            n11 = 16;
        }
        for (int i = 0; i < dimension.height; i += 2) {
            for (int j = 0; j < dimension.width; j += 2) {
                int n12 = nArray[n7] >> n9 & 0xFF;
                int n13 = nArray[n7] >> n10 & 0xFF;
                int n14 = nArray[n7] >> n11 & 0xFF;
                int n15 = (n12 * 257 + n13 * 504 + n14 * 98) / 1000 + 16;
                int n16 = (-n12 * 148 - n13 * 291 + n14 * 439) / 1000 + 128;
                int n17 = (n12 * 439 - n13 * 368 - n14 * 71) / 1000 + 128;
                byArray[n4] = (byte)(n15 & 0xFF);
                n12 = nArray[n7 + 1] >> n9 & 0xFF;
                n13 = nArray[n7 + 1] >> n10 & 0xFF;
                n14 = nArray[n7 + 1] >> n11 & 0xFF;
                n15 = (n12 * 257 + n13 * 504 + n14 * 98) / 1000 + 16;
                n16 += (-n12 * 148 - n13 * 291 + n14 * 439) / 1000 + 128;
                n17 += (n12 * 439 - n13 * 368 - n14 * 71) / 1000 + 128;
                byArray[n4 + 1] = (byte)(n15 & 0xFF);
                n12 = nArray[n7 + n8] >> n9 & 0xFF;
                n13 = nArray[n7 + n8] >> n10 & 0xFF;
                n14 = nArray[n7 + n8] >> n11 & 0xFF;
                n15 = (n12 * 257 + n13 * 504 + n14 * 98) / 1000 + 16;
                n16 += (-n12 * 148 - n13 * 291 + n14 * 439) / 1000 + 128;
                n17 += (n12 * 439 - n13 * 368 - n14 * 71) / 1000 + 128;
                byArray[n4 + n * n2] = (byte)(n15 & 0xFF);
                n12 = nArray[n7 + n8 + 1] >> n9 & 0xFF;
                n13 = nArray[n7 + n8 + 1] >> n10 & 0xFF;
                n14 = nArray[n7 + n8 + 1] >> n11 & 0xFF;
                n15 = (n12 * 257 + n13 * 504 + n14 * 98) / 1000 + 16;
                byArray[n4 + n * n2 + 1] = (byte)(n15 & 0xFF);
                byArray[n5] = (byte)((n16 += (-n12 * 148 - n13 * 291 + n14 * 439) / 1000 + 128) >> 2 & 0xFF);
                byArray[n6] = (byte)((n17 += (n12 * 439 - n13 * 368 - n14 * 71) / 1000 + 128) >> 2 & 0xFF);
                n4 += 2;
                ++n5;
                ++n6;
                n7 += 2;
            }
            n7 += n8 * 2 - dimension.width;
            n4 += n * n2 * 2 - dimension.width;
            n5 += n * n3 - dimension.width / 2;
            n6 += n * n3 - dimension.width / 2;
        }
        return 0;
    }

    public void reset() {
    }
}

