/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicController;
import com.sun.media.util.MediaThread;

abstract class TimedActionThread
extends MediaThread {
    protected BasicController controller;
    protected long wakeupTime;
    protected boolean aborted = false;

    TimedActionThread(BasicController basicController, long l) {
        this.controller = basicController;
        this.useControlPriority();
        this.wakeupTime = l;
    }

    protected abstract long getTime();

    protected abstract void action();

    public synchronized void abort() {
        this.aborted = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        while ((l = this.getTime()) < this.wakeupTime && !this.aborted) {
            long l2 = this.wakeupTime - l;
            if (l2 > 1000000000L) {
                l2 = 1000000000L;
            }
            TimedActionThread timedActionThread = this;
            synchronized (timedActionThread) {
                try {
                    this.wait(l2 / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        if (!this.aborted) {
            this.action();
        }
    }
}

