/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicPlayer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.Registry;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;

public class Log {
    public static boolean isEnabled = true;
    private static DataOutputStream log = null;
    private static String fileName = "jmf.log";
    private static int indent = 0;
    private static JMFSecurity jmfSecurity = null;
    private static Method[] m = new Method[1];
    private static Class[] cl = new Class[1];
    private static Object[][] args = new Object[1][0];
    private static boolean ieSec = false;
    private static String permission = null;
    private static int permissionid = 0;
    static boolean errorWarned;

    private static synchronized boolean requestPerm() {
        try {
            if (!ieSec) {
                permission = "write file";
                permissionid = 4;
                jmfSecurity.requestPermission(m, cl, args, 4);
                m[0].invoke((Object)cl[0], args[0]);
            } else {
                PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static synchronized void writeHeader() {
        if (jmfSecurity != null && !Log.requestPerm()) {
            return;
        }
        Log.write("#\n# JMF " + BasicPlayer.VERSION + "\n#\n");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            string = System.getProperty("os.name");
            string3 = System.getProperty("os.arch");
            string2 = System.getProperty("os.version");
            string4 = System.getProperty("java.vendor");
            string5 = System.getProperty("java.version");
        }
        catch (Throwable throwable) {
            return;
        }
        if (string != null) {
            Log.comment("Platform: " + string + ", " + string3 + ", " + string2);
        }
        if (string4 != null) {
            Log.comment("Java VM: " + string4 + ", " + string5);
        }
        Log.write("");
    }

    public static synchronized void comment(Object object) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                log.writeBytes("## " + object + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void warning(Object object) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                log.writeBytes("!! " + object + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void profile(Object object) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                log.writeBytes("$$ " + object + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void error(Object object) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            if (!errorWarned) {
                System.err.println("An error has occurred.  Check jmf.log for details.");
                errorWarned = true;
            }
            try {
                log.writeBytes("XX " + object + "\n");
            }
            catch (IOException iOException) {}
        } else {
            System.err.println(object);
        }
    }

    public static synchronized void dumpStack(Throwable throwable) {
    }

    public static synchronized void write(Object object) {
        if (isEnabled) {
            if (jmfSecurity != null && !Log.requestPerm()) {
                return;
            }
            try {
                for (int i = indent; i > 0; --i) {
                    log.writeBytes("    ");
                }
                log.writeBytes(object + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void setIndent(int n) {
        indent = n;
    }

    public static synchronized void incrIndent() {
        ++indent;
    }

    public static synchronized void decrIndent() {
        --indent;
    }

    public static int getIndent() {
        return indent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string = fileName;
        synchronized (string) {
            if (isEnabled && log == null) {
                Object object = Registry.get("allowLogging");
                if (object != null && object instanceof Boolean && !((Boolean)object).booleanValue()) {
                    isEnabled = false;
                }
                if (isEnabled) {
                    try {
                        jmfSecurity = JMFSecurityManager.getJMFSecurity();
                        if (jmfSecurity != null) {
                            if (jmfSecurity.getName().startsWith("jmf-security")) {
                                permission = "write file";
                                permissionid = 4;
                                jmfSecurity.requestPermission(m, cl, args, 4);
                                m[0].invoke((Object)cl[0], args[0]);
                                permission = "delete file";
                                permissionid = 8;
                                jmfSecurity.requestPermission(m, cl, args, 8);
                                m[0].invoke((Object)cl[0], args[0]);
                                permission = "read system property";
                                permissionid = 1;
                                jmfSecurity.requestPermission(m, cl, args, 1);
                                m[0].invoke((Object)cl[0], args[0]);
                            } else if (jmfSecurity.getName().startsWith("internet")) {
                                PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                                PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                                ieSec = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        isEnabled = false;
                    }
                }
                if (isEnabled) {
                    isEnabled = false;
                    try {
                        Object object2 = Registry.get("secure.logDir");
                        String string2 = object2 != null && object2 instanceof String && !"".equals(object2) ? (String)object2 : System.getProperty("user.dir");
                        String string3 = string2 + File.separator + fileName;
                        log = new DataOutputStream(new FileOutputStream(string3));
                        if (log != null) {
                            System.err.println("Open log file: " + string3);
                            isEnabled = true;
                            Log.writeHeader();
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Failed to open log file.");
                    }
                }
            }
        }
        errorWarned = false;
    }
}

