/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicPlugIn;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public abstract class BasicCodec
extends BasicPlugIn
implements Codec {
    private static final boolean DEBUG = true;
    protected Format inputFormat;
    protected Format outputFormat;
    protected boolean opened = false;
    protected Format[] inputFormats = new Format[0];
    protected Format[] outputFormats = new Format[0];
    protected boolean pendingEOM = false;

    public Format setInputFormat(Format format) {
        this.inputFormat = format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        this.outputFormat = format;
        return format;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public void reset() {
    }

    public void open() throws ResourceUnavailableException {
        this.opened = true;
    }

    public void close() {
        this.opened = false;
    }

    public Format[] getSupportedInputFormats() {
        return this.inputFormats;
    }

    protected RGBFormat updateRGBFormat(VideoFormat videoFormat, RGBFormat rGBFormat) {
        Dimension dimension = videoFormat.getSize();
        RGBFormat rGBFormat2 = rGBFormat;
        int n = dimension.width * rGBFormat2.getPixelStride();
        RGBFormat rGBFormat3 = new RGBFormat(dimension, n * dimension.height, rGBFormat2.getDataType(), videoFormat.getFrameRate(), rGBFormat2.getBitsPerPixel(), rGBFormat2.getRedMask(), rGBFormat2.getGreenMask(), rGBFormat2.getBlueMask(), rGBFormat2.getPixelStride(), n, rGBFormat2.getFlipped(), rGBFormat2.getEndian());
        return rGBFormat3;
    }

    protected boolean isEOM(Buffer buffer) {
        return buffer.isEOM();
    }

    protected void propagateEOM(Buffer buffer) {
        this.updateOutput(buffer, this.getOutputFormat(), 0, 0);
        buffer.setEOM(true);
    }

    protected void updateOutput(Buffer buffer, Format format, int n, int n2) {
        buffer.setFormat(format);
        buffer.setLength(n);
        buffer.setOffset(n2);
    }

    protected boolean checkInputBuffer(Buffer buffer) {
        boolean bl;
        boolean bl2 = bl = !this.isEOM(buffer) && (buffer == null || buffer.getFormat() == null || !this.checkFormat(buffer.getFormat()));
        if (bl) {
            System.out.println(this.getClass().getName() + " : [error] checkInputBuffer");
        }
        return !bl;
    }

    protected boolean checkFormat(Format format) {
        return true;
    }

    protected int checkEOM(Buffer buffer, Buffer buffer2) {
        this.processAtEOM(buffer, buffer2);
        if (buffer2.getLength() > 0) {
            this.pendingEOM = true;
            return 2;
        }
        this.propagateEOM(buffer2);
        return 0;
    }

    protected int processAtEOM(Buffer buffer, Buffer buffer2) {
        return 0;
    }

    protected int getArrayElementSize(Class clazz) {
        if (clazz == Format.intArray) {
            return 4;
        }
        if (clazz == Format.shortArray) {
            return 2;
        }
        if (clazz == Format.byteArray) {
            return 1;
        }
        return 0;
    }
}

