/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.Log;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.StopTimeSetError;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;

public class BasicClock
implements Clock {
    private TimeBase master;
    private long startTime = Long.MAX_VALUE;
    private long stopTime = Long.MAX_VALUE;
    private long mediaTime = 0L;
    private long mediaStart = 0L;
    private long mediaLength = -1L;
    private float rate = 1.0f;
    public static final int STOPPED = 0;
    public static final int STARTED = 1;

    public BasicClock() {
        this.master = new SystemTimeBase();
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("setTimeBase cannot be used on a started clock."));
        }
        if (timeBase == null) {
            if (!(this.master instanceof SystemTimeBase)) {
                this.master = new SystemTimeBase();
            }
        } else {
            this.master = timeBase;
        }
    }

    public void syncStart(Time time) {
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("syncStart() cannot be used on an already started clock."));
        }
        this.startTime = this.master.getNanoseconds() > time.getNanoseconds() ? this.master.getNanoseconds() : time.getNanoseconds();
    }

    public void stop() {
        if (this.getState() == 0) {
            return;
        }
        this.mediaTime = this.getMediaNanoseconds();
        this.startTime = Long.MAX_VALUE;
    }

    public void setStopTime(Time time) {
        if (this.getState() == 1 && this.stopTime != Long.MAX_VALUE) {
            this.throwError(new StopTimeSetError("setStopTime() may be set only once on a Started Clock"));
        }
        this.stopTime = time.getNanoseconds();
    }

    public Time getStopTime() {
        return new Time(this.stopTime);
    }

    public void setMediaTime(Time time) {
        long l;
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("setMediaTime() cannot be used on a started clock."));
        }
        this.mediaTime = (l = time.getNanoseconds()) < this.mediaStart ? this.mediaStart : (this.mediaLength != -1L && l > this.mediaStart + this.mediaLength ? this.mediaStart + this.mediaLength : l);
    }

    public Time getMediaTime() {
        return new Time(this.getMediaNanoseconds());
    }

    public long getMediaNanoseconds() {
        if (this.getState() == 0) {
            return this.mediaTime;
        }
        long l = this.master.getNanoseconds();
        if (l > this.startTime) {
            long l2 = (long)((double)(l - this.startTime) * (double)this.rate) + this.mediaTime;
            if (this.mediaLength != -1L && l2 > this.mediaStart + this.mediaLength) {
                return this.mediaStart + this.mediaLength;
            }
            return l2;
        }
        return this.mediaTime;
    }

    protected void setMediaStart(long l) {
        this.mediaStart = l;
    }

    protected void setMediaLength(long l) {
        this.mediaLength = l;
    }

    public int getState() {
        if (this.startTime == Long.MAX_VALUE) {
            return 0;
        }
        if (this.stopTime == Long.MAX_VALUE) {
            return 1;
        }
        return 1;
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public TimeBase getTimeBase() {
        return this.master;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        if (this.getState() == 0) {
            ClockStoppedException clockStoppedException = new ClockStoppedException();
            Log.dumpStack(clockStoppedException);
            throw clockStoppedException;
        }
        return new Time((long)((float)(time.getNanoseconds() - this.mediaTime) / this.rate) + this.startTime);
    }

    public float setRate(float f) {
        if (this.getState() == 1) {
            this.throwError(new ClockStartedError("setRate() cannot be used on a started clock."));
        }
        this.rate = f;
        return this.rate;
    }

    public float getRate() {
        return this.rate;
    }

    protected void throwError(Error error) {
        Log.dumpStack(error);
        throw error;
    }
}

