/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public class SMTPMessage
extends MimeMessage {
    public static final int NOTIFY_NEVER = -1;
    public static final int NOTIFY_SUCCESS = 1;
    public static final int NOTIFY_FAILURE = 2;
    public static final int NOTIFY_DELAY = 4;
    public static final int RETURN_FULL = 1;
    public static final int RETURN_HDRS = 2;
    private static final String[] returnOptionString = new String[]{null, "FULL", "HDRS"};
    private String envelopeFrom;
    private int notifyOptions;
    private int returnOption;
    private boolean sendPartial = false;
    private boolean allow8bitMIME = false;

    public int getNotifyOptions() {
        return this.notifyOptions;
    }

    public int getReturnOption() {
        return this.returnOption;
    }

    public boolean getAllow8bitMIME() {
        return this.allow8bitMIME;
    }

    public boolean getSendPartial() {
        return this.sendPartial;
    }

    public void setNotifyOptions(int n) {
        if (n < -1 || n >= 8) {
            throw new IllegalArgumentException("Bad return option");
        }
        this.notifyOptions = n;
    }

    public void setReturnOption(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Bad return option");
        }
        this.returnOption = n;
    }

    public void setAllow8bitMIME(boolean bl) {
        this.allow8bitMIME = bl;
    }

    public void setSendPartial(boolean bl) {
        this.sendPartial = bl;
    }

    String getDSNNotify() {
        if (this.notifyOptions == 0) {
            return null;
        }
        if (this.notifyOptions == -1) {
            return "NEVER";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.notifyOptions & 1) != 0) {
            stringBuffer.append("SUCCESS");
        }
        if ((this.notifyOptions & 2) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("FAILURE");
        }
        if ((this.notifyOptions & 4) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("DELAY");
        }
        return stringBuffer.toString();
    }

    String getDSNRet() {
        return returnOptionString[this.returnOption];
    }

    public String getEnvelopeFrom() {
        return this.envelopeFrom;
    }

    public void setEnvelopeFrom(String string) {
        this.envelopeFrom = string;
    }

    public SMTPMessage(Session session) {
        super(session);
    }

    public SMTPMessage(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage);
    }

    public SMTPMessage(Session session, InputStream inputStream) throws MessagingException {
        super(session, inputStream);
    }
}

