/*
 * Decompiled with CFR 0.152.
 */
package example.bluetooth.demo;

import example.bluetooth.demo.BTImageServer;
import example.bluetooth.demo.DemoMIDlet;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

final class GUIImageServer
implements CommandListener {
    private final String helpText;
    private final Command backCommand = new Command("Back", 2, 2);
    private final Command addCommand = new Command("Publish image", 1, 1);
    private final Command removeCommand = new Command("Remove image", 1, 1);
    private final Command helpCommand = new Command("Help", 5, 1);
    private final List imagesList = new List("Configure Server", 3);
    private final Alert helpScreen = new Alert("Help");
    private DemoMIDlet parent;
    private Vector imagesNames;
    private Image onImage;
    private Image offImage;
    private boolean[] published;
    private BTImageServer bt_server;

    GUIImageServer(DemoMIDlet demoMIDlet) {
        this.helpText = "The server is started by default.\n\nNo images are published initially. Change this by corresponding commands - the changes have an effect immediately.\n\nIf image is removed from the published list, it can't be download.";
        this.parent = demoMIDlet;
        this.bt_server = new BTImageServer(this);
        this.setupIdicatorImage();
        this.setupImageList();
        this.published = new boolean[this.imagesList.size()];
        this.imagesList.addCommand(this.backCommand);
        this.imagesList.addCommand(this.addCommand);
        this.imagesList.addCommand(this.removeCommand);
        this.imagesList.addCommand(this.helpCommand);
        this.imagesList.setCommandListener((CommandListener)this);
        this.helpScreen.addCommand(this.backCommand);
        this.helpScreen.setTimeout(-2);
        this.helpScreen.setString("The server is started by default.\n\nNo images are published initially. Change this by corresponding commands - the changes have an effect immediately.\n\nIf image is removed from the published list, it can't be download.");
        this.helpScreen.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        if (command == this.backCommand && displayable == this.imagesList) {
            this.destroy();
            this.parent.show();
            return;
        }
        if (command == this.backCommand && displayable == this.helpScreen) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.imagesList);
            return;
        }
        if (command == this.helpCommand) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.helpScreen);
            return;
        }
        if (command == this.addCommand == this.published[n = this.imagesList.getSelectedIndex()]) {
            return;
        }
        this.published[n] = command == this.addCommand;
        Image image = command == this.addCommand ? this.onImage : this.offImage;
        this.imagesList.set(n, this.imagesList.getString(n), image);
        if (!this.bt_server.changeImageInfo(this.imagesList.getString(n), this.published[n])) {
            Alert alert = new Alert("Error", "Can't update base", null, AlertType.ERROR);
            alert.setTimeout(2000);
            Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.imagesList);
            this.published[n] = !this.published[n];
            image = this.published[n] ? this.onImage : this.offImage;
            this.imagesList.set(n, this.imagesList.getString(n), image);
        }
    }

    void completeInitialization(boolean bl) {
        if (bl) {
            Ticker ticker = new Ticker("Choose images you want to publish...");
            this.imagesList.setTicker(ticker);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.imagesList);
            return;
        }
        Alert alert = new Alert("Error", "Can't inititialize bluetooth", null, AlertType.ERROR);
        alert.setTimeout(2000);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, this.parent.getDisplayable());
    }

    void destroy() {
        this.bt_server.destroy();
    }

    String getImageFileName(String string) {
        if (string == null) {
            return null;
        }
        int n = -1;
        for (int i = 0; i < this.imagesList.size(); ++i) {
            if (!this.imagesList.getString(i).equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1 || !this.published[n]) {
            return null;
        }
        return (String)this.imagesNames.elementAt(n);
    }

    private void setupIdicatorImage() {
        try {
            this.onImage = Image.createImage((String)"/images/st-on.png");
        }
        catch (IOException iOException) {
            this.onImage = this.createIndicatorImage(12, 12, 0, 255, 0);
        }
        try {
            this.offImage = Image.createImage((String)"/images/st-off.png");
        }
        catch (IOException iOException) {
            this.offImage = this.createIndicatorImage(12, 12, 255, 0, 0);
        }
    }

    private void setupImageList() {
        String string;
        this.imagesNames = new Vector();
        this.imagesList.setCommandListener((CommandListener)this);
        for (int i = 1; i < 100 && (string = this.parent.getAppProperty("ImageName-" + i)) != null && string.length() != 0; ++i) {
            String string2 = this.parent.getAppProperty("ImageTitle-" + i);
            if (string2 == null || string2.length() == 0) {
                string2 = string;
            }
            this.imagesNames.addElement(string);
            this.imagesList.append(string2, this.offImage);
        }
    }

    private Image createIndicatorImage(int n, int n2, int n3, int n4, int n5) {
        Image image = Image.createImage((int)n, (int)n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(n3, n4, n5);
        graphics.fillRect(0, 0, n, n2);
        return image;
    }
}

