/*
 * Decompiled with CFR 0.152.
 */
package example.bluetooth.demo;

import example.bluetooth.demo.GUIImageClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Image;

final class BTImageClient
implements Runnable,
DiscoveryListener {
    private static final UUID PICTURES_SERVER_UUID = new UUID("F0E0D0C0B0A000908070605040302010", false);
    private static final int IMAGES_NAMES_ATTRIBUTE_ID = 17185;
    private static final int READY = 0;
    private static final int DEVICE_SEARCH = 1;
    private static final int SERVICE_SEARCH = 2;
    private int state = 0;
    private DiscoveryAgent discoveryAgent;
    private GUIImageClient parent;
    private boolean isClosed;
    private Thread processorThread;
    private Vector devices = new Vector();
    private Vector records = new Vector();
    private int discType;
    private int[] searchIDs;
    private String imageNameToLoad;
    private Hashtable base = new Hashtable();
    private boolean isDownloadCanceled;
    private UUID[] uuidSet;
    private int[] attrSet;

    BTImageClient(GUIImageClient gUIImageClient) {
        this.parent = gUIImageClient;
        this.processorThread = new Thread(this);
        this.processorThread.start();
    }

    public void run() {
        boolean bl = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            bl = true;
        }
        catch (Exception exception) {
            System.err.println("Can't initialize bluetooth: " + exception);
        }
        this.parent.completeInitialization(bl);
        if (!bl) {
            return;
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = PICTURES_SERVER_UUID;
        this.attrSet = new int[1];
        this.attrSet[0] = 17185;
        this.processImagesSearchDownload();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (this.devices.indexOf(remoteDevice) == -1) {
            this.devices.addElement(remoteDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int n) {
        this.discType = n;
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.notify();
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        for (int i = 0; i < serviceRecordArray.length; ++i) {
            this.records.addElement(serviceRecordArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int n, int n2) {
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < this.searchIDs.length; ++n3) {
            if (this.searchIDs[n3] != n) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1) {
            System.err.println("Unexpected transaction index: " + n);
        } else {
            this.searchIDs[n4] = -1;
        }
        for (n3 = 0; n3 < this.searchIDs.length; ++n3) {
            if (this.searchIDs[n3] == -1) continue;
            return;
        }
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestSearch() {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelSearch() {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            if (this.state == 1) {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            } else if (this.state == 2) {
                for (int i = 0; i < this.searchIDs.length; ++i) {
                    this.discoveryAgent.cancelServiceSearch(this.searchIDs[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestLoad(String string) {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.imageNameToLoad = string;
            this.notify();
        }
    }

    void cancelLoad() {
        this.isDownloadCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.isClosed = true;
            this.isDownloadCanceled = true;
            this.notify();
        }
        try {
            this.processorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void processImagesSearchDownload() {
        block4: while (!this.isClosed) {
            this.state = 0;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Unexpected interuption: " + interruptedException);
                return;
            }
            if (this.isClosed) {
                return;
            }
            if (!this.searchDevices()) {
                return;
            }
            if (this.devices.size() == 0) continue;
            if (!this.searchServices()) {
                return;
            }
            if (this.records.size() == 0 || !this.presentUserSearchResults()) continue;
            while (true) {
                this.isDownloadCanceled = false;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Unexpected interuption: " + interruptedException);
                    return;
                }
                if (this.isClosed) {
                    return;
                }
                if (this.imageNameToLoad == null) continue block4;
                Image image = this.loadImage();
                if (this.isClosed) {
                    return;
                }
                if (this.isDownloadCanceled) continue;
                if (image == null) {
                    this.parent.informLoadError("Can't load image: " + this.imageNameToLoad);
                    continue;
                }
                this.parent.showImage(image, this.imageNameToLoad);
            }
        }
    }

    private boolean searchDevices() {
        this.state = 1;
        this.devices.removeAllElements();
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bluetoothStateException) {
            System.err.println("Can't start inquiry now: " + (Object)((Object)bluetoothStateException));
            this.parent.informSearchError("Can't start device search");
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Unexpected interuption: " + interruptedException);
            return false;
        }
        if (this.isClosed) {
            return false;
        }
        switch (this.discType) {
            case 7: {
                this.parent.informSearchError("Device discovering error...");
            }
            case 5: {
                this.devices.removeAllElements();
                break;
            }
            case 0: {
                if (this.devices.size() != 0) break;
                this.parent.informSearchError("No devices in range");
                break;
            }
            default: {
                System.err.println("system error: unexpected device discovery code: " + this.discType);
                this.destroy();
                return false;
            }
        }
        return true;
    }

    private boolean searchServices() {
        this.state = 2;
        this.records.removeAllElements();
        this.searchIDs = new int[this.devices.size()];
        boolean bl = false;
        for (int i = 0; i < this.devices.size(); ++i) {
            RemoteDevice remoteDevice = (RemoteDevice)this.devices.elementAt(i);
            try {
                this.searchIDs[i] = this.discoveryAgent.searchServices(this.attrSet, this.uuidSet, remoteDevice, (DiscoveryListener)this);
            }
            catch (BluetoothStateException bluetoothStateException) {
                System.err.println("Can't search services for: " + remoteDevice.getBluetoothAddress() + " due to " + (Object)((Object)bluetoothStateException));
                this.searchIDs[i] = -1;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            this.parent.informSearchError("Can't search services.");
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Unexpected interuption: " + interruptedException);
            return false;
        }
        if (this.isClosed) {
            return false;
        }
        if (this.records.size() == 0) {
            this.parent.informSearchError("No proper services were found");
        }
        return true;
    }

    private boolean presentUserSearchResults() {
        this.base.clear();
        for (int i = 0; i < this.records.size(); ++i) {
            ServiceRecord serviceRecord = (ServiceRecord)this.records.elementAt(i);
            DataElement dataElement = serviceRecord.getAttributeValue(17185);
            if (dataElement == null) {
                System.err.println("Unexpected service - missed attribute");
                continue;
            }
            Enumeration enumeration = (Enumeration)dataElement.getValue();
            while (enumeration.hasMoreElements()) {
                dataElement = (DataElement)enumeration.nextElement();
                String string = (String)dataElement.getValue();
                Object object = this.base.get(string);
                if (object != null) {
                    Vector<Object> vector;
                    if (object instanceof ServiceRecord) {
                        vector = new Vector<Object>();
                        vector.addElement(object);
                    } else {
                        vector = (Vector<Object>)object;
                    }
                    vector.addElement(serviceRecord);
                    object = vector;
                } else {
                    object = serviceRecord;
                }
                this.base.put(string, object);
            }
        }
        return this.parent.showImagesNames(this.base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadImage() {
        if (this.imageNameToLoad == null) {
            System.err.println("Error: imageNameToLoad=null");
            return null;
        }
        ServiceRecord[] serviceRecordArray = null;
        Object v = this.base.get(this.imageNameToLoad);
        if (v == null) {
            System.err.println("Error: no record for: " + this.imageNameToLoad);
            return null;
        }
        if (v instanceof ServiceRecord) {
            serviceRecordArray = new ServiceRecord[]{(ServiceRecord)v};
        } else {
            Vector vector = (Vector)v;
            serviceRecordArray = new ServiceRecord[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                serviceRecordArray[i] = (ServiceRecord)vector.elementAt(i);
            }
        }
        for (int i = 0; i < serviceRecordArray.length; ++i) {
            InputStream inputStream;
            Object object;
            StreamConnection streamConnection = null;
            String string = null;
            if (this.isDownloadCanceled) {
                return null;
            }
            try {
                string = serviceRecordArray[i].getConnectionURL(0, false);
                streamConnection = (StreamConnection)Connector.open((String)string);
            }
            catch (IOException iOException) {
                System.err.println("Note: can't connect to: " + string);
                continue;
            }
            try {
                object = streamConnection.openOutputStream();
                ((OutputStream)object).write(this.imageNameToLoad.length());
                ((OutputStream)object).write(this.imageNameToLoad.getBytes());
                ((OutputStream)object).flush();
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                System.err.println("Can't write to server for: " + string);
                try {
                    streamConnection.close();
                }
                catch (IOException iOException2) {}
                continue;
            }
            object = null;
            try {
                int n;
                inputStream = streamConnection.openInputStream();
                int n2 = inputStream.read() << 8;
                if ((n2 |= inputStream.read()) <= 0) {
                    throw new IOException("Can't read a length");
                }
                object = new byte[n2];
                for (n2 = 0; n2 != ((Object)object).length; n2 += n) {
                    n = inputStream.read((byte[])object, n2, ((Object)object).length - n2);
                    if (n != -1) continue;
                    throw new IOException("Can't read a image data");
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Can't read from server for: " + string);
                continue;
            }
            finally {
                try {
                    streamConnection.close();
                }
                catch (IOException iOException) {}
            }
            inputStream = null;
            try {
                inputStream = Image.createImage((byte[])object, (int)0, (int)((Object)object).length);
            }
            catch (Exception exception) {
                System.err.println("Error: wrong image data from: " + string);
                continue;
            }
            return inputStream;
        }
        return null;
    }
}

