/*
 * Decompiled with CFR 0.152.
 */
package example.stock;

import example.About;
import example.stock.AlertDatabase;
import example.stock.Stock;
import example.stock.StockDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class StockMIDlet
extends MIDlet {
    private static int OFFSET = 10000;
    Display display = null;
    private Ticker stockTicker = null;
    private List choose = null;
    private List view = null;
    private List menu = null;
    private List alertList = null;
    private List settingsList = null;
    private Form whatif = null;
    private Form updatesForm = null;
    private TextBox stockSymbolBox = null;
    private TextBox alertPriceBox = null;
    private TextField origPurchPriceField = null;
    private TextField numSharesField = null;
    private static final Command BACK_COMMAND = new Command("Back", 2, 0);
    private static final Command MAIN_MENU_COMMAND = new Command("Main", 1, 1);
    private static final Command DONE_COMMAND = new Command("Done", 4, 2);
    private static final Command SET_COMMAND = new Command("Set", 4, 4);
    private static final Command EXIT_COMMAND = new Command("Exit", 6, 5);
    private static final Command CALC_COMMAND = new Command("Calc", 4, 6);
    private static final Command ABOUT_COMMAND = new Command("About", 5, 1);
    private ChoiceGroup updatesChoices = null;
    private String currentMenu = null;
    private String stockSymbol = null;
    private StockDatabase stocks = null;
    private AlertDatabase alerts = null;
    private String quoteServerURL = "http://quote.yahoo.com/d/quotes.csv?s=";
    private String quoteFormat = "&f=slc1wop";
    private String proxyURL = null;
    private Timer stockRefresh = null;
    private StockRefreshTask stockRefreshTask = null;
    private int refresh_interval = 900000;
    private boolean firstTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StockMIDlet() throws MIDletStateChangeException {
        StockMIDlet stockMIDlet = this;
        synchronized (stockMIDlet) {
            this.stocks = new StockDatabase();
            try {
                this.stocks.open("Stocks");
            }
            catch (Exception exception) {
                try {
                    this.stocks.cleanUp("Stocks");
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            this.alerts = new AlertDatabase();
            try {
                this.alerts.open("Alerts");
            }
            catch (Exception exception) {
                try {
                    this.alerts.cleanUp("Alerts");
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            this.origPurchPriceField = new TextField("Original Purchase Price:", "", 5, 2);
            this.numSharesField = new TextField("Number Of Shares:", "", 9, 2);
            this.menu = new List("Stock Menu", 3);
            this.menu.append("Stock Tracker", null);
            this.menu.append("What If?", null);
            this.menu.append("Alerts", null);
            this.menu.append("Settings", null);
            this.menu.addCommand(EXIT_COMMAND);
            this.menu.addCommand(ABOUT_COMMAND);
            this.menu.setCommandListener((CommandListener)new StockCommandListener());
            this.whatif = new Form("What If?");
            this.whatif.append((Item)this.origPurchPriceField);
            this.whatif.append((Item)this.numSharesField);
            this.whatif.addCommand(BACK_COMMAND);
            this.whatif.addCommand(CALC_COMMAND);
            this.whatif.setCommandListener((CommandListener)new StockCommandListener());
            this.alertList = new List("Alert Menu", 3);
            this.alertList.append("Add", null);
            this.alertList.append("Remove", null);
            this.alertList.addCommand(BACK_COMMAND);
            this.alertList.setCommandListener((CommandListener)new StockCommandListener());
            this.settingsList = new List("Settings", 3);
            this.settingsList.append("Updates", null);
            this.settingsList.append("Add Stock", null);
            this.settingsList.append("Remove Stock", null);
            this.settingsList.addCommand(BACK_COMMAND);
            this.settingsList.setCommandListener((CommandListener)new StockCommandListener());
            this.alertPriceBox = new TextBox("Alert me when stock reaches:", "", 9, 2);
            this.alertPriceBox.addCommand(DONE_COMMAND);
            this.alertPriceBox.addCommand(BACK_COMMAND);
            this.alertPriceBox.setCommandListener((CommandListener)new StockCommandListener());
            this.updatesForm = new Form("Updates");
            this.updatesChoices = new ChoiceGroup("Update Interval:", 1);
            this.updatesChoices.append("Continuous", null);
            this.updatesChoices.append("15 minutes", null);
            this.updatesChoices.append("30 minutes", null);
            this.updatesChoices.append("1 hour", null);
            this.updatesChoices.append("3 hours", null);
            switch (this.refresh_interval) {
                case 30000: {
                    this.updatesChoices.setSelectedIndex(0, true);
                    break;
                }
                case 1800000: {
                    this.updatesChoices.setSelectedIndex(2, true);
                    break;
                }
                case 3600000: {
                    this.updatesChoices.setSelectedIndex(3, true);
                    break;
                }
                case 10800000: {
                    this.updatesChoices.setSelectedIndex(4, true);
                    break;
                }
                default: {
                    this.updatesChoices.setSelectedIndex(1, true);
                }
            }
            this.updatesForm.append((Item)this.updatesChoices);
            this.updatesForm.addCommand(BACK_COMMAND);
            this.updatesForm.addCommand(DONE_COMMAND);
            this.updatesForm.setCommandListener((CommandListener)new StockCommandListener());
            this.stockSymbolBox = new TextBox("Enter a Stock Symbol:", "", 5, 0);
            this.stockSymbolBox.addCommand(DONE_COMMAND);
            this.stockSymbolBox.addCommand(BACK_COMMAND);
            this.stockSymbolBox.setCommandListener((CommandListener)new StockCommandListener());
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
                this.refresh_interval = Integer.valueOf(new String(recordStore.getRecord(1)));
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                this.refresh_interval = 900000;
            }
        }
        this.firstTime = true;
    }

    public void startApp() {
        this.stockTicker = new Ticker(this.makeTickerString());
        this.menu.setTicker(this.stockTicker);
        this.whatif.setTicker(this.stockTicker);
        this.alertList.setTicker(this.stockTicker);
        this.settingsList.setTicker(this.stockTicker);
        this.alertPriceBox.setTicker(this.stockTicker);
        this.updatesForm.setTicker(this.stockTicker);
        this.stockSymbolBox.setTicker(this.stockTicker);
        this.display = Display.getDisplay((MIDlet)this);
        if (this.firstTime) {
            this.mainMenu();
            this.firstTime = false;
        }
        this.stockRefreshTask = new StockRefreshTask();
        this.stockRefresh = new Timer();
        this.stockRefresh.schedule((TimerTask)this.stockRefreshTask, 0L, (long)this.refresh_interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseApp() {
        StockMIDlet stockMIDlet = this;
        synchronized (stockMIDlet) {
            this.display = null;
            this.stockTicker = null;
            this.stockRefresh.cancel();
            this.stockRefresh = null;
            this.stockRefreshTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (bl) {
            StockMIDlet stockMIDlet = this;
            synchronized (stockMIDlet) {
                if (this.display == null) {
                    return;
                }
                this.stockRefresh.cancel();
                try {
                    this.stocks.close();
                    this.alerts.close();
                    RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
                    try {
                        recordStore.setRecord(1, String.valueOf(this.refresh_interval).getBytes(), 0, String.valueOf(this.refresh_interval).length());
                    }
                    catch (RecordStoreException recordStoreException) {
                        recordStore.addRecord(String.valueOf(this.refresh_interval).getBytes(), 0, String.valueOf(this.refresh_interval).length());
                    }
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.notifyDestroyed();
            }
        }
    }

    private void calc() {
        try {
            String string = this.stocks.search(this.stockSymbol);
            int n = Stock.getPrice(string);
            int n2 = Stock.makeInt(this.origPurchPriceField.getString());
            int n3 = Integer.valueOf(this.numSharesField.getString());
            int n4 = (n - n2) * n3;
            Form form = new Form(Stock.getName(string) + " " + Stock.getStringPrice(string));
            StringBuffer stringBuffer = new StringBuffer().append("Net profit (loss) is ").append(n4 >= 0 ? "$" : "($").append(n4 >= 0 ? Stock.convert(n4) : "-" + Stock.convert(n4)).append(n4 >= 0 ? "" : ")").append(" when selling ").append(String.valueOf(n3)).append(" shares at $").append(Stock.convert(n)).append(" per share.");
            form.append(stringBuffer.toString());
            form.addCommand(BACK_COMMAND);
            form.addCommand(MAIN_MENU_COMMAND);
            form.setCommandListener((CommandListener)new StockCommandListener());
            this.display.setCurrent((Displayable)form);
            this.currentMenu = "AnswerForm";
        }
        catch (Exception exception) {
            this.error("Calculation Failed", 2000);
        }
    }

    private void setAlert(String string) {
        try {
            this.alerts.add(Stock.getName(this.stocks.search(this.stockSymbol)) + ';' + Stock.makeInt(string));
        }
        catch (Exception exception) {
            this.error("Failed to add alert", 2000);
        }
    }

    private String makeTickerString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            RecordEnumeration recordEnumeration = this.stocks.enumerateRecords();
            while (recordEnumeration.hasNextElement()) {
                String string = new String(recordEnumeration.nextRecord());
                stringBuffer.append(Stock.getName(string)).append(" @ ").append(Stock.getStringPrice(string)).append("   ");
            }
        }
        catch (Exception exception) {
            return "Error Accessing Database";
        }
        return stringBuffer.toString();
    }

    private void error(String string, int n) {
        if (!(this.display.getCurrent() instanceof Alert)) {
            Alert alert = new Alert("Error", string, null, AlertType.ERROR);
            alert.setTimeout(n);
            this.display.setCurrent(alert, this.display.getCurrent());
        }
    }

    private void checkAlerts(String string) {
        try {
            int n = Stock.getPrice(this.stocks.search(string));
            RecordEnumeration recordEnumeration = this.alerts.enumerateRecords(string, n);
            while (recordEnumeration.hasNextElement()) {
                String string2 = new String(recordEnumeration.nextRecord());
                int n2 = Integer.valueOf(string2.substring(string2.indexOf(59) + 1, string2.length()));
                Alert alert = new Alert(string, "", null, AlertType.ALARM);
                StringBuffer stringBuffer = new StringBuffer().append(string).append(" has reached your price point of $").append(Stock.convert(n2)).append(" and currently is trading at $").append(Stock.getStringPrice(this.stocks.search(string)));
                alert.setString(stringBuffer.toString());
                alert.setTimeout(-2);
                this.display.setCurrent((Displayable)alert);
                this.alerts.delete(string2);
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void mainMenu() {
        this.display.setCurrent((Displayable)this.menu);
        this.currentMenu = "Main";
    }

    private void chooseStock(boolean bl, String string, int n, boolean bl2) {
        if (bl) {
            this.choose = new List("Choose Stocks", n);
            this.choose.setTicker(this.stockTicker);
            this.choose.addCommand(BACK_COMMAND);
            if (string.equals("RemoveStock")) {
                this.choose.addCommand(DONE_COMMAND);
            } else if (string.equals("WhatChoose") || string.equals("AddAlert")) {
                this.choose.addCommand(MAIN_MENU_COMMAND);
            }
            this.choose.setCommandListener((CommandListener)new StockCommandListener());
            try {
                RecordEnumeration recordEnumeration = this.stocks.enumerateRecords();
                while (recordEnumeration.hasNextElement()) {
                    String string2 = new String(recordEnumeration.nextRecord());
                    if (bl2) {
                        this.choose.append(Stock.getName(string2) + " @ " + Stock.getStringPrice(string2), null);
                        continue;
                    }
                    this.choose.append(Stock.getName(string2), null);
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
        this.display.setCurrent((Displayable)this.choose);
        this.currentMenu = string;
    }

    private void displayStock(String string) {
        try {
            String string2 = this.stocks.search(string);
            Form form = new Form(Stock.getName(string2));
            form.setTicker(this.stockTicker);
            StringBuffer stringBuffer = new StringBuffer().append("Last Trade:\n         ").append(Stock.getTime(string2)).append("\n         ").append(Stock.getStringPrice(string2)).append("\nChange:  ").append(Stock.getStringChange(string2)).append("\nHigh:  ").append(Stock.getStringHigh(string2)).append("\nLow:  ").append(Stock.getStringLow(string2)).append("\nOpen:  ").append(Stock.getStringOpen(string2)).append("\nPrev:  ").append(Stock.getStringPrevious(string2));
            form.append(stringBuffer.toString());
            form.addCommand(BACK_COMMAND);
            form.addCommand(MAIN_MENU_COMMAND);
            form.setCommandListener((CommandListener)new StockCommandListener());
            this.display.setCurrent((Displayable)form);
            this.currentMenu = "stockInfo";
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            this.error("Could not display stock.  ", 2000);
        }
        catch (RecordStoreException recordStoreException) {
            this.error("Could not display stock.  ", 2000);
        }
        catch (NullPointerException nullPointerException) {
            this.error("Could not display stock.  ", 2000);
        }
    }

    private void whatIfForm(String string) {
        this.display.setCurrent((Displayable)this.whatif);
        this.currentMenu = "WhatIfForm";
        this.stockSymbol = string;
    }

    private void alertMenu(boolean bl) {
        this.display.setCurrent((Displayable)this.alertList);
        this.currentMenu = "AlertMenu";
        if (bl) {
            Alert alert = new Alert("", "\n\n\n   Saved!", null, null);
            alert.setTimeout(2000);
            this.display.setCurrent(alert, (Displayable)this.alertList);
        }
    }

    private void viewAlerts() {
        this.choose = new List("Current Alerts", 2);
        this.choose.setTicker(this.stockTicker);
        try {
            RecordEnumeration recordEnumeration = this.alerts.enumerateRecords("", 0);
            while (recordEnumeration.hasNextElement()) {
                String string = new String(recordEnumeration.nextRecord());
                String string2 = Stock.convert(Integer.valueOf(string.substring(string.indexOf(59) + 1, string.length())));
                this.choose.append(string.substring(0, string.indexOf(59)) + " @ $" + string2, null);
            }
        }
        catch (Exception exception) {
            this.error("Error reading alerts", 2500);
        }
        this.choose.addCommand(BACK_COMMAND);
        this.choose.addCommand(DONE_COMMAND);
        this.choose.setCommandListener((CommandListener)new StockCommandListener());
        this.display.setCurrent((Displayable)this.choose);
        this.currentMenu = "RemoveAlert";
    }

    private void alertForm(String string) {
        this.display.setCurrent((Displayable)this.alertPriceBox);
        this.currentMenu = "AlertForm";
        this.stockSymbol = string;
    }

    private void removeAlert(String string) {
        try {
            String string2 = string.substring(0, string.indexOf(64) - 1);
            int n = Stock.makeInt(string.substring(string.indexOf(64) + 3, string.length()));
            System.out.println("Remove Alert: " + string2 + ";" + n);
            this.alerts.delete(string2 + ";" + n);
        }
        catch (Exception exception) {
            this.error("Failed to remove alert", 2000);
        }
    }

    private void settings(boolean bl) {
        this.display.setCurrent((Displayable)this.settingsList);
        this.currentMenu = "Settings";
        if (bl) {
            Alert alert = new Alert("", "\n\n\n   Saved!", null, null);
            alert.setTimeout(1500);
            this.display.setCurrent(alert, (Displayable)this.settingsList);
        }
    }

    private void updates() {
        this.display.setCurrent((Displayable)this.updatesForm);
        this.currentMenu = "Updates";
    }

    private void addStock() {
        this.stockSymbolBox.setString("");
        this.display.setCurrent((Displayable)this.stockSymbolBox);
        this.currentMenu = "AddStock";
    }

    private boolean addNewStock(String string) {
        block12: {
            try {
                if (this.stocks.search(string) == null) {
                    try {
                        this.stocks.add(this.getStockQuote(string));
                        this.stockTicker.setString(this.makeTickerString());
                        break block12;
                    }
                    catch (RecordStoreFullException recordStoreFullException) {
                        this.error("Database is full.", 2000);
                        return false;
                    }
                    catch (RecordStoreException recordStoreException) {
                        this.error("Failed to add " + string, 2000);
                        return false;
                    }
                    catch (IOException iOException) {
                        this.error("Failed to download stock quote for \"" + string + "\"", 2000);
                        return false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.error("\"" + string + "\" not found on server, or invalid data " + "received from server", 2000);
                        return false;
                    }
                }
                try {
                    this.stocks.update(string, this.getStockQuote(string).getBytes());
                    this.stockTicker.setString(this.makeTickerString());
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    this.error("Database is full.", 2000);
                    return false;
                }
                catch (RecordStoreException recordStoreException) {
                    this.error("Failed to update " + string, 2000);
                    return false;
                }
                catch (IOException iOException) {
                    this.error("Failed to download stock quote for " + string, 2000);
                    return false;
                }
            }
            catch (RecordStoreException recordStoreException) {
                this.error("Error accessing database.", 2000);
                return false;
            }
        }
        return true;
    }

    private String getStockQuote(String string) throws IOException, NumberFormatException {
        int n;
        String string2 = this.quoteServerURL + string + this.quoteFormat;
        StreamConnection streamConnection = (StreamConnection)Connector.open((String)string2, (int)3);
        InputStream inputStream = streamConnection.openInputStream();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        Stock.parse(stringBuffer.toString());
        inputStream.close();
        streamConnection.close();
        return stringBuffer.toString();
    }

    private void deleteStock(String string) {
        try {
            this.stocks.delete(string);
            this.alerts.removeUselessAlerts(string);
            this.stockTicker.setString(this.makeTickerString());
        }
        catch (RecordStoreException recordStoreException) {
            this.error("Failed to delete " + string, 2000);
        }
    }

    private void about() {
        Runtime runtime = Runtime.getRuntime();
        About.showAbout(this.display);
    }

    private class StockRefreshTask
    extends TimerTask {
        private StockRefreshTask() {
        }

        public void run() {
            try {
                if (StockMIDlet.this.stocks.getNumRecords() == 0) {
                    return;
                }
                RecordEnumeration recordEnumeration = StockMIDlet.this.stocks.enumerateRecords();
                while (recordEnumeration.hasNextElement()) {
                    String string = Stock.getName(new String(recordEnumeration.nextRecord()));
                    try {
                        byte[] byArray = StockMIDlet.this.getStockQuote(string).getBytes();
                        StockMIDlet.this.stocks.update(string, byArray);
                        StockMIDlet.this.checkAlerts(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        StockMIDlet.this.error("\"" + string + "\" not found on server, or invalid data " + "received from server", 2000);
                    }
                }
            }
            catch (Exception exception) {
                StockMIDlet.this.error("Update Failed\n\nStocks were not updated", 2000);
            }
        }
    }

    private class StockCommandListener
    implements CommandListener,
    Runnable {
        private Command currentCommand;
        private Displayable currentDisplayable;
        private Thread commandThread;

        private StockCommandListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command command, Displayable displayable) {
            StockCommandListener stockCommandListener = this;
            synchronized (stockCommandListener) {
                if (this.commandThread != null) {
                    return;
                }
                this.currentCommand = command;
                this.currentDisplayable = displayable;
                this.commandThread = new Thread(this);
                this.commandThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            block63: {
                block69: {
                    block68: {
                        String string;
                        block67: {
                            block66: {
                                block65: {
                                    block64: {
                                        block62: {
                                            string = this.currentCommand.getLabel();
                                            if (!string.equals("Main")) break block62;
                                            StockMIDlet.this.mainMenu();
                                            break block63;
                                        }
                                        if (!string.equals("Back")) break block64;
                                        if (StockMIDlet.this.currentMenu.equals("View") || StockMIDlet.this.currentMenu.equals("WhatChoose") || StockMIDlet.this.currentMenu.equals("AlertMenu") || StockMIDlet.this.currentMenu.equals("Settings")) {
                                            StockMIDlet.this.mainMenu();
                                        } else if (StockMIDlet.this.currentMenu.equals("Add") || StockMIDlet.this.currentMenu.equals("Updates") || StockMIDlet.this.currentMenu.equals("RemoveStock")) {
                                            StockMIDlet.this.settings(false);
                                        } else if (StockMIDlet.this.currentMenu.equals("stockInfo")) {
                                            StockMIDlet.this.chooseStock(false, "View", 3, true);
                                        } else if (StockMIDlet.this.currentMenu.equals("WhatIfForm")) {
                                            StockMIDlet.this.chooseStock(false, "WhatChoose", 3, false);
                                        } else if (StockMIDlet.this.currentMenu.equals("AlertForm")) {
                                            StockMIDlet.this.chooseStock(false, "AddAlert", 3, false);
                                        } else if (StockMIDlet.this.currentMenu.equals("AnswerForm")) {
                                            StockMIDlet.this.whatIfForm(StockMIDlet.this.stockSymbol);
                                        } else if (StockMIDlet.this.currentMenu.equals("RemoveAlert") || StockMIDlet.this.currentMenu.equals("AddAlert")) {
                                            StockMIDlet.this.alertMenu(false);
                                        } else if (StockMIDlet.this.currentMenu.equals("AddStock")) {
                                            StockMIDlet.this.settings(false);
                                        }
                                        break block63;
                                    }
                                    if (!string.equals("Done")) break block65;
                                    if (StockMIDlet.this.currentMenu.equals("AddStock")) {
                                        if (!StockMIDlet.this.stockSymbolBox.getString().trim().equals("") && StockMIDlet.this.addNewStock(StockMIDlet.this.stockSymbolBox.getString().trim())) {
                                            StockMIDlet.this.settings(true);
                                        }
                                    } else if (StockMIDlet.this.currentMenu.equals("AlertForm")) {
                                        StockMIDlet.this.setAlert(((TextBox)this.currentDisplayable).getString());
                                        StockMIDlet.this.alertMenu(true);
                                    } else if (StockMIDlet.this.currentMenu.equals("RemoveAlert")) {
                                        object = new boolean[StockMIDlet.this.choose.size()];
                                        StockMIDlet.this.choose.getSelectedFlags((boolean[])object);
                                        for (int i = 0; i < ((Object)object).length; ++i) {
                                            if (object[i] == false) continue;
                                            StockMIDlet.this.removeAlert(StockMIDlet.this.choose.getString(i));
                                        }
                                        StockMIDlet.this.alertMenu(true);
                                    } else if (StockMIDlet.this.currentMenu.equals("RemoveStock")) {
                                        object = new boolean[StockMIDlet.this.choose.size()];
                                        StockMIDlet.this.choose.getSelectedFlags((boolean[])object);
                                        for (int i = 0; i < ((Object)object).length; ++i) {
                                            if (object[i] == false) continue;
                                            StockMIDlet.this.deleteStock(StockMIDlet.this.choose.getString(i));
                                        }
                                        object = null;
                                        StockMIDlet.this.settings(true);
                                    } else if (StockMIDlet.this.currentMenu.equals("Updates")) {
                                        switch (StockMIDlet.this.updatesChoices.getSelectedIndex()) {
                                            case 0: {
                                                StockMIDlet.this.refresh_interval = 30000;
                                                break;
                                            }
                                            case 1: {
                                                StockMIDlet.this.refresh_interval = 900000;
                                                break;
                                            }
                                            case 2: {
                                                StockMIDlet.this.refresh_interval = 1800000;
                                                break;
                                            }
                                            case 3: {
                                                StockMIDlet.this.refresh_interval = 3600000;
                                                break;
                                            }
                                            case 4: {
                                                StockMIDlet.this.refresh_interval = 10800000;
                                                break;
                                            }
                                        }
                                        StockMIDlet.this.stockRefreshTask.cancel();
                                        StockMIDlet.this.stockRefreshTask = new StockRefreshTask();
                                        StockMIDlet.this.stockRefresh.schedule((TimerTask)StockMIDlet.this.stockRefreshTask, 0L, (long)StockMIDlet.this.refresh_interval);
                                        StockMIDlet.this.settings(true);
                                    }
                                    break block63;
                                }
                                if (!string.equals("Exit")) break block66;
                                try {
                                    StockMIDlet.this.destroyApp(true);
                                }
                                catch (MIDletStateChangeException mIDletStateChangeException) {
                                    StockMIDlet.this.mainMenu();
                                }
                                break block63;
                            }
                            if (!string.equals("Calc")) break block67;
                            if (StockMIDlet.this.origPurchPriceField.size() == 0) {
                                StockMIDlet.this.error("You must enter the price you originally purchased the stock at.", 2000);
                            } else if (StockMIDlet.this.numSharesField.size() == 0) {
                                StockMIDlet.this.error("You must specify the number of shares to calculate with.", 2000);
                            } else {
                                StockMIDlet.this.calc();
                            }
                            break block63;
                        }
                        if (!string.equals("About")) break block68;
                        StockMIDlet.this.about();
                        break block63;
                    }
                    object = (List)StockMIDlet.this.display.getCurrent();
                    if (!StockMIDlet.this.currentMenu.equals("Main") && !StockMIDlet.this.currentMenu.equals("Settings") && !StockMIDlet.this.currentMenu.equals("AlertMenu")) break block69;
                    switch (object.getSelectedIndex()) {
                        case 0: {
                            if (StockMIDlet.this.currentMenu.equals("Main")) {
                                StockMIDlet.this.chooseStock(true, "View", 3, true);
                                break;
                            }
                            if (StockMIDlet.this.currentMenu.equals("Settings")) {
                                StockMIDlet.this.updates();
                                break;
                            }
                            StockMIDlet.this.chooseStock(true, "AddAlert", 3, false);
                            break;
                        }
                        case 1: {
                            if (StockMIDlet.this.currentMenu.equals("Main")) {
                                StockMIDlet.this.chooseStock(true, "WhatChoose", 3, false);
                                break;
                            }
                            if (StockMIDlet.this.currentMenu.equals("Settings")) {
                                StockMIDlet.this.addStock();
                                break;
                            }
                            StockMIDlet.this.viewAlerts();
                            break;
                        }
                        case 2: {
                            if (StockMIDlet.this.currentMenu.equals("Main")) {
                                StockMIDlet.this.alertMenu(false);
                                break;
                            }
                            if (StockMIDlet.this.currentMenu.equals("Settings")) {
                                StockMIDlet.this.chooseStock(true, "RemoveStock", 2, false);
                                break;
                            }
                            break block63;
                        }
                        case 3: {
                            if (StockMIDlet.this.currentMenu.equals("Main")) {
                                StockMIDlet.this.settings(false);
                                break;
                            }
                            break block63;
                        }
                    }
                    break block63;
                }
                if (StockMIDlet.this.currentMenu.equals("View")) {
                    StockMIDlet.this.displayStock(StockMIDlet.this.choose.getString(StockMIDlet.this.choose.getSelectedIndex()).substring(0, StockMIDlet.this.choose.getString(StockMIDlet.this.choose.getSelectedIndex()).indexOf(64) - 1));
                } else if (StockMIDlet.this.currentMenu.equals("WhatChoose")) {
                    if (StockMIDlet.this.choose.getSelectedIndex() >= 0) {
                        StockMIDlet.this.whatIfForm(StockMIDlet.this.choose.getString(StockMIDlet.this.choose.getSelectedIndex()));
                    }
                } else if (StockMIDlet.this.currentMenu.equals("AddAlert") && StockMIDlet.this.choose.getSelectedIndex() >= 0) {
                    StockMIDlet.this.alertForm(StockMIDlet.this.choose.getString(StockMIDlet.this.choose.getSelectedIndex()));
                }
            }
            object = this;
            synchronized (object) {
                this.commandThread = null;
            }
        }
    }
}

