/*
 * Decompiled with CFR 0.152.
 */
package example.stock;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public abstract class Database {
    protected volatile RecordStore database = null;
    protected volatile Vector recordIDs = null;
    protected int lastID = 1;
    protected RecordComparator rc = null;

    public void open(String string) throws RecordStoreNotFoundException, RecordStoreException, RecordStoreFullException {
        block7: {
            this.database = RecordStore.openRecordStore((String)string, (boolean)true);
            this.recordIDs = new Vector();
            try {
                if (this.database.getNumRecords() == 0) break block7;
                try {
                    this.lastID = Integer.valueOf(new String(this.database.getRecord(1)));
                    for (int i = 1; i <= this.lastID; ++i) {
                        try {
                            this.database.getRecord(i);
                            this.recordIDs.addElement(new Integer(i));
                            continue;
                        }
                        catch (RecordStoreException recordStoreException) {
                            // empty catch block
                        }
                    }
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    throw new RecordStoreException(invalidRecordIDException.getMessage());
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                throw new RecordStoreException(recordStoreNotOpenException.getMessage());
            }
        }
    }

    public void close() throws RecordStoreNotOpenException, RecordStoreException {
        if (this.database.getNumRecords() == 0) {
            String string = this.database.getName();
            this.database.closeRecordStore();
            RecordStore.deleteRecordStore((String)string);
        } else {
            this.database.closeRecordStore();
        }
    }

    public void cleanUp(String string) throws RecordStoreNotFoundException, RecordStoreException {
        RecordStore.deleteRecordStore((String)string);
        this.open(string);
    }

    public synchronized void add(String string) throws RecordStoreNotOpenException, RecordStoreFullException, RecordStoreException {
        if (this.database.getNumRecords() != 0) {
            this.database.addRecord(string.getBytes(), 0, string.getBytes().length);
            this.recordIDs.addElement(new Integer(++this.lastID));
            this.database.setRecord(1, String.valueOf(this.lastID).getBytes(), 0, String.valueOf(this.lastID).length());
        } else {
            this.recordIDs.addElement(new Integer(++this.lastID));
            this.database.addRecord(String.valueOf(this.lastID).getBytes(), 0, String.valueOf(this.lastID).length());
            try {
                this.database.addRecord(string.getBytes(), 0, string.getBytes().length);
            }
            catch (RecordStoreException recordStoreException) {
                this.recordIDs.removeElement(new Integer(this.lastID--));
                this.database.setRecord(1, String.valueOf(this.lastID).getBytes(), 0, String.valueOf(this.lastID).length());
                throw recordStoreException;
            }
        }
    }

    public synchronized void delete(String string) throws RecordStoreNotOpenException, RecordStoreException {
        this.action(string, null, 0);
    }

    public synchronized String search(String string) throws RecordStoreNotOpenException, RecordStoreException {
        return (String)this.action(string, null, 1);
    }

    public synchronized void update(String string, byte[] byArray) throws RecordStoreNotOpenException, RecordStoreFullException, RecordStoreException {
        this.action(string, byArray, 2);
    }

    private synchronized Object action(String string, byte[] byArray, int n) throws RecordStoreNotOpenException, RecordStoreFullException, RecordStoreException {
        if (n != 1 && this.recordIDs.size() == 0) {
            throw new RecordStoreException();
        }
        Enumeration enumeration = this.recordIDs.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            try {
                if (this.rc.compare(this.database.getRecord(n2), string.getBytes()) != 0) continue;
                switch (n) {
                    case 0: {
                        this.database.deleteRecord(n2);
                        this.recordIDs.removeElement(new Integer(n2));
                        return null;
                    }
                    case 1: {
                        return new String(this.database.getRecord(n2));
                    }
                    case 2: {
                        this.database.setRecord(n2, byArray, 0, byArray.length);
                        return null;
                    }
                }
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                throw new RecordStoreException(invalidRecordIDException.getMessage());
            }
        }
        return null;
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        return this.database.getNumRecords();
    }
}

