/*
 * Decompiled with CFR 0.152.
 */
package example.manyballs;

import example.manyballs.SmallBall;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class ManyCanvas
extends Canvas {
    Display display;
    SmallBall[] balls;
    int numBalls;
    int width;
    int height;
    boolean paused;
    static int NUM_HISTORY = 8;
    long[] times = new long[NUM_HISTORY];
    int times_idx;
    String msg = null;

    public ManyCanvas(Display display, int n) {
        this.display = display;
        this.balls = new SmallBall[n];
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.balls[0] = new SmallBall(this, 0, 0, this.width, this.height - 12 - 20);
        this.numBalls = 1;
        this.paused = true;
    }

    protected void paint(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n, n2, n3, n4);
        for (int i = 0; i < this.numBalls; ++i) {
            if (!this.balls[i].inside(n, n2, n + n3, n2 + n4)) continue;
            this.balls[i].paint(graphics);
        }
        graphics.setColor(0);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        long l = System.currentTimeMillis();
        String string = null;
        if (this.times_idx >= NUM_HISTORY) {
            long l2 = this.times[this.times_idx % NUM_HISTORY];
            if (l2 == l) {
                l2 = l - 1L;
            }
            long l3 = 1000L * (long)NUM_HISTORY / (l - l2);
            if (this.times_idx % 20 == 0) {
                string = this.numBalls + " Ball(s) " + l3 + " fps";
            }
        } else if (this.times_idx % 20 == 0) {
            string = this.numBalls + " Ball(s)";
        }
        if (this.msg != null) {
            graphics.setColor(0xFFFFFF);
            graphics.setClip(0, this.height - 14, this.width, this.height);
            graphics.fillRect(0, this.height - 20, this.width - 2, 18);
            graphics.setColor(0);
            graphics.drawString(this.msg, 5, this.height - 14, 0);
            graphics.drawRect(0, 0, this.width - 1, this.height - 1);
            this.msg = null;
        }
        if (string != null) {
            this.repaint();
            this.msg = string;
        }
        this.times[this.times_idx % ManyCanvas.NUM_HISTORY] = l;
        ++this.times_idx;
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                if (this.numBalls <= 0) break;
                --this.numBalls;
                this.balls[this.numBalls].stop = true;
                this.balls[this.numBalls] = null;
                break;
            }
            case 5: {
                if (this.numBalls >= this.balls.length) break;
                this.balls[this.numBalls] = new SmallBall(this, 0, 0, this.width, this.height - 12 - 20);
                new Thread(this.balls[this.numBalls]).start();
                ++this.numBalls;
                break;
            }
            case 1: {
                SmallBall.faster();
                break;
            }
            case 6: {
                SmallBall.slower();
            }
        }
        this.repaint();
    }

    void destroy() {
        for (int i = 0; i < this.balls.length && this.balls[i] != null; ++i) {
            this.balls[i].stop = true;
            this.balls[i] = null;
        }
        this.numBalls = 0;
    }

    boolean isPaused() {
        return this.paused;
    }

    void pause() {
        if (!this.paused) {
            this.paused = true;
            for (int i = 0; i < this.balls.length && this.balls[i] != null; ++i) {
                this.balls[i].stop = true;
            }
        }
        this.repaint();
    }

    void start() {
        if (this.paused) {
            this.paused = false;
            this.display.setCurrent((Displayable)this);
            for (int i = 0; i < this.balls.length && this.balls[i] != null; ++i) {
                Thread thread = new Thread(this.balls[i]);
                thread.start();
            }
        }
        this.repaint();
    }
}

