/*
 * Decompiled with CFR 0.152.
 */
package example.http;

import example.About;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.PushRegistry;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.UDPDatagramConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class HttpView
extends MIDlet
implements CommandListener,
Runnable {
    Command exitCommand = new Command("Exit", 7, 2);
    Command reloadCommand = new Command("Reload", 1, 1);
    Command headCommand = new Command("Head", 1, 1);
    Command postCommand = new Command("Post", 1, 1);
    Command getCommand = new Command("Get", 1, 1);
    Command aboutCommand = new Command("About", 5, 1);
    Command cancelCommand = new Command("Cancel", 1, 1);
    Command backCommand = new Command("Back", 2, 1);
    Command headersCommand = new Command("Headers", 1, 1);
    Command requestsCommand = new Command("Requests", 1, 1);
    Command errorsCommand = new Command("Errors", 1, 1);
    Command newURLCommand = new Command("New URL", 1, 10);
    Command removeURLCommand = new Command("Remove", 1, 11);
    Command okCommand = new Command("Ok", 1, 1);
    Command helpCommand = new Command("Help", 5, 1);
    List urlList;
    Vector urls;
    Alert alert;
    TextBox content;
    Display display = Display.getDisplay((MIDlet)this);
    Thread thread;
    String url;
    Command requestCommand;
    Form progressForm;
    Gauge progressGauge;
    Form headerForm;
    Form requestForm;
    Form errorsForm;
    TextBox urlbox;

    public HttpView() {
        this.setupList();
        this.alert = new Alert("Warning");
        this.alert.setTimeout(2000);
        this.headerForm = new Form("Headers");
        this.headerForm.addCommand(this.backCommand);
        this.headerForm.addCommand(this.requestsCommand);
        this.headerForm.setCommandListener((CommandListener)this);
        this.requestForm = new Form("Request headers");
        this.requestForm.addCommand(this.backCommand);
        this.requestForm.addCommand(this.errorsCommand);
        this.requestForm.setCommandListener((CommandListener)this);
        this.progressForm = new Form("Progress");
        this.progressForm.addCommand(this.cancelCommand);
        this.progressForm.setCommandListener((CommandListener)this);
        this.progressGauge = new Gauge(this.url, false, 9, 0);
        this.progressForm.append((Item)this.progressGauge);
        this.errorsForm = new Form("Errors");
        this.errorsForm.addCommand(this.backCommand);
        this.errorsForm.addCommand(this.headersCommand);
        this.errorsForm.setCommandListener((CommandListener)this);
        this.urlbox = new TextBox("Enter Url", "http://", 400, 4);
        this.urlbox.addCommand(this.okCommand);
        this.urlbox.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        String[] stringArray = PushRegistry.listConnections((boolean)true);
        String string = this.getAppProperty("MIDlet-Push-1");
        if (stringArray != null && stringArray.length > 0) {
            String string2;
            String string3;
            String string4 = "Pushed URL Placeholder";
            try {
                string3 = PushRegistry.getMIDlet((String)stringArray[0]);
                string2 = PushRegistry.getFilter((String)stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (stringArray[0].startsWith("socket://")) {
                try {
                    string3 = (ServerSocketConnection)Connector.open((String)stringArray[0]);
                    string2 = (SocketConnection)string3.acceptAndOpen();
                    DataInputStream dataInputStream = string2.openDataInputStream();
                    byte[] byArray = new byte[256];
                    int n = 0;
                    int n2 = dataInputStream.read(byArray);
                    for (int i = 0; i < n2; ++i) {
                        if (byArray[i] != 10) continue;
                        n = i;
                        break;
                    }
                    string4 = new String(byArray, 0, n);
                    dataInputStream.close();
                    string2.close();
                    string3.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    PushRegistry.registerConnection((String)"datagram://:40080", (String)"example.http.HttpView", (String)"129.148.*.*");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (ConnectionNotFoundException connectionNotFoundException) {
                    connectionNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (stringArray[0].startsWith("datagram://")) {
                try {
                    string3 = (UDPDatagramConnection)Connector.open((String)stringArray[0]);
                    string2 = string3.newDatagram(256);
                    string3.receive((Datagram)string2);
                    string3.close();
                    byte[] byArray = string2.getData();
                    int n = 0;
                    int n3 = byArray.length;
                    for (int i = 0; i < n3; ++i) {
                        if (byArray[i] != 10) continue;
                        n = i;
                        break;
                    }
                    string4 = new String(byArray, 0, n);
                    PushRegistry.unregisterConnection((String)"datagram://:40080");
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.urlList.append(string4, null);
            this.urls.addElement(string4);
        } else {
            stringArray = PushRegistry.listConnections((boolean)false);
            try {
                Date date = new Date();
                PushRegistry.registerAlarm((String)"example.http.HttpView", (long)(date.getTime() + 60000L));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (ConnectionNotFoundException connectionNotFoundException) {
                connectionNotFoundException.printStackTrace();
            }
        }
        if (this.urlList.size() > 0) {
            this.display.setCurrent((Displayable)this.urlList);
        } else {
            this.alert.setString("No url's configured.");
            this.display.setCurrent(this.alert, (Displayable)this.urlList);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.thread = null;
    }

    void setupList() {
        String string;
        String string2;
        this.urls = new Vector();
        this.urlList = new List("URLs", 3);
        this.urlList.addCommand(this.headCommand);
        this.urlList.addCommand(this.getCommand);
        this.urlList.addCommand(this.postCommand);
        this.urlList.addCommand(this.exitCommand);
        this.urlList.addCommand(this.newURLCommand);
        this.urlList.addCommand(this.removeURLCommand);
        this.urlList.addCommand(this.helpCommand);
        this.urlList.setCommandListener((CommandListener)this);
        for (int i = 1; i < 100 && (string2 = this.getAppProperty(string = "ViewURL-" + i)) != null && string2.length() != 0; ++i) {
            String string3 = "ViewTitle-" + i;
            String string4 = this.getAppProperty(string3);
            if (string4 == null || string4.length() == 0) {
                string4 = string2;
            }
            this.urls.addElement(string2);
            this.urlList.append(string4, null);
        }
        this.urls.addElement("http://jse.east/Telco/HttpTest.txt");
        this.urlList.append("Test URL", null);
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.exitCommand) {
                this.destroyApp(false);
                this.notifyDestroyed();
            } else if (command == this.headCommand || command == this.getCommand || command == this.postCommand || command == List.SELECT_COMMAND) {
                if (command == List.SELECT_COMMAND) {
                    command = this.getCommand;
                }
                this.requestCommand = command;
                int n = this.urlList.getSelectedIndex();
                this.url = (String)this.urls.elementAt(n);
                this.genProgressForm("Progress", this.url);
                this.display.setCurrent((Displayable)this.progressForm);
                this.thread = new Thread(this);
                this.thread.start();
            } else if (command == this.headersCommand) {
                this.display.setCurrent((Displayable)this.headerForm);
            } else if (command == this.requestsCommand) {
                this.display.setCurrent((Displayable)this.requestForm);
            } else if (command == this.errorsCommand) {
                this.display.setCurrent((Displayable)this.errorsForm);
            } else if (command == this.backCommand) {
                if (displayable == this.headerForm || displayable == this.requestForm || displayable == this.errorsForm) {
                    this.display.setCurrent((Displayable)this.content);
                } else {
                    this.display.setCurrent((Displayable)this.urlList);
                }
            } else if (command == this.cancelCommand) {
                this.thread = null;
                this.alert.setString("Loading cancelled.");
                this.display.setCurrent(this.alert, (Displayable)this.urlList);
            } else if (command == this.aboutCommand) {
                About.showAbout(this.display);
            } else if (command == this.newURLCommand) {
                this.display.setCurrent((Displayable)this.urlbox);
            } else if (command == this.removeURLCommand) {
                int n = this.urlList.getSelectedIndex();
                this.urlList.delete(n);
                this.urls.removeElementAt(n);
            } else if (command == this.okCommand && displayable == this.urlbox) {
                String string = this.urlbox.getString();
                this.urlList.append(string, null);
                this.urls.addElement(string);
                this.display.setCurrent((Displayable)this.urlList);
            } else if (command == this.helpCommand) {
                String string = "Use Head, Get or Post to download a URL.\n\nUse 'New URL' to enter a new URL.";
                Alert alert = new Alert(null, string, null, null);
                alert.setTimeout(-2);
                this.display.setCurrent((Displayable)alert);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        OutputStream outputStream;
        InputStream inputStream;
        HttpConnection httpConnection;
        Thread thread;
        block39: {
            block38: {
                block36: {
                    block35: {
                        block34: {
                            StringBuffer stringBuffer;
                            long l = 0L;
                            long l2 = 0L;
                            boolean bl = false;
                            boolean bl2 = false;
                            thread = Thread.currentThread();
                            String string = "GET";
                            if (this.requestCommand == this.headCommand) {
                                string = "HEAD";
                            } else if (this.requestCommand == this.postCommand) {
                                string = "POST";
                            }
                            if (this.content == null) {
                                this.content = new TextBox("Content", "", 4096, 0);
                                this.content.addCommand(this.backCommand);
                                this.content.addCommand(this.headersCommand);
                                this.content.setCommandListener((CommandListener)this);
                            }
                            this.content.setTitle("Body len = 0");
                            this.content.setString("");
                            this.genErrorsForm("Errors", null);
                            this.clearForm(this.requestForm);
                            this.clearForm(this.headerForm);
                            this.progressGauge.setValue(1);
                            httpConnection = null;
                            inputStream = null;
                            outputStream = null;
                            String string2 = null;
                            try {
                                int n;
                                long l3 = 0L;
                                httpConnection = (HttpConnection)Connector.open((String)this.url);
                                httpConnection.setRequestMethod(string);
                                this.setConfig(httpConnection);
                                if (thread != this.thread) {
                                    return;
                                }
                                this.progressGauge.setValue(2);
                                for (n = 0; n < 2; ++n) {
                                    HttpConnection httpConnection2;
                                    if (string == "POST") {
                                        outputStream = httpConnection.openOutputStream();
                                        if (thread != this.thread) {
                                            this.cleanUp(httpConnection, inputStream, outputStream);
                                            if (thread != this.thread) return;
                                            break block34;
                                        }
                                        outputStream.write("hello midlet world".getBytes());
                                        outputStream.close();
                                        outputStream = null;
                                    }
                                    if (httpConnection == (httpConnection2 = this.handleRedirects(httpConnection))) break;
                                    httpConnection = httpConnection2;
                                }
                                this.genRequestForm(httpConnection);
                                inputStream = httpConnection.openInputStream();
                                if (thread != this.thread) {
                                    this.cleanUp(httpConnection, inputStream, outputStream);
                                    break block35;
                                }
                                this.content.setTitle(httpConnection.getResponseMessage() + " (" + httpConnection.getResponseCode() + ")");
                                this.genHeaderForm(httpConnection);
                                this.progressGauge.setValue(5);
                                if (thread != this.thread) {
                                    this.cleanUp(httpConnection, inputStream, outputStream);
                                    break block36;
                                }
                                l3 = httpConnection.getLength();
                                stringBuffer = new StringBuffer(l3 >= 0L ? (int)l3 : 1000);
                                n = this.content.getMaxSize();
                                if (l3 != -1L) {
                                    int n2 = 0;
                                    int n3 = 0;
                                    while ((long)n3 < l3) {
                                        n2 = inputStream.read();
                                        if (n2 != -1) {
                                            if (n2 <= 32) {
                                                n2 = 32;
                                            }
                                            stringBuffer.append((char)n2);
                                            if (stringBuffer.length() >= n) break;
                                        }
                                        ++n3;
                                    }
                                } else {
                                    int n4 = 0;
                                    l3 = 0L;
                                    while ((n4 = inputStream.read()) != -1) {
                                        if (n4 <= 32) {
                                            n4 = 32;
                                        }
                                        stringBuffer.append((char)n4);
                                        if (stringBuffer.length() < n) continue;
                                    }
                                }
                                string2 = stringBuffer.toString();
                                if (thread != this.thread) {
                                    this.cleanUp(httpConnection, inputStream, outputStream);
                                    break block38;
                                }
                                this.progressGauge.setValue(8);
                                this.content.setTitle("Body len = " + stringBuffer.length());
                                if (stringBuffer.length() > 0) {
                                    this.content.setString(string2);
                                } else {
                                    this.content.setString("no data");
                                }
                                this.display.setCurrent((Displayable)this.content);
                                this.progressGauge.setValue(9);
                                this.cleanUp(httpConnection, inputStream, outputStream);
                                break block39;
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                stringBuffer = null;
                                this.content = null;
                                outOfMemoryError.printStackTrace();
                                if (thread == this.thread) return;
                                this.genErrorsForm("Memory", outOfMemoryError);
                                this.display.setCurrent((Displayable)this.errorsForm);
                                return;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                this.genErrorsForm("Errors", exception);
                                this.display.setCurrent((Displayable)this.errorsForm);
                                return;
                            }
                        }
                        this.progressGauge.setValue(10);
                        return;
                    }
                    if (thread != this.thread) return;
                    this.progressGauge.setValue(10);
                    return;
                }
                if (thread != this.thread) return;
                this.progressGauge.setValue(10);
                return;
            }
            if (thread != this.thread) return;
            this.progressGauge.setValue(10);
            return;
        }
        if (thread != this.thread) return;
        this.progressGauge.setValue(10);
        return;
        finally {
            this.cleanUp(httpConnection, inputStream, outputStream);
            if (thread == this.thread) {
                this.progressGauge.setValue(10);
            }
        }
    }

    void cleanUp(HttpConnection httpConnection, InputStream inputStream, OutputStream outputStream) {
        block11: {
            Thread thread;
            block10: {
                block9: {
                    thread = Thread.currentThread();
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (thread != this.thread) break block9;
                        this.genErrorsForm("InputStream close error", iOException);
                    }
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (thread != this.thread) break block10;
                    this.genErrorsForm("OutStream close error", iOException);
                }
            }
            try {
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (IOException iOException) {
                if (thread != this.thread) break block11;
                this.genErrorsForm("HttpConnection close error", iOException);
            }
        }
    }

    HttpConnection handleRedirects(HttpConnection httpConnection) throws IOException {
        block3: while (true) {
            int n = httpConnection.getResponseCode();
            switch (n) {
                case 301: 
                case 302: 
                case 307: {
                    String string = httpConnection.getHeaderField("location");
                    httpConnection.close();
                    this.showAlert("Redirecting to " + string, null);
                    this.progressGauge.setLabel(string);
                    httpConnection = (HttpConnection)Connector.open((String)string);
                    continue block3;
                }
            }
            break;
        }
        return httpConnection;
    }

    void setConfig(HttpConnection httpConnection) throws IOException {
        String string = System.getProperty("microedition.configuration");
        String string2 = System.getProperty("microedition.profiles");
        int n = string2.indexOf(32);
        if (n != -1) {
            string2 = string2.substring(0, n - 1);
        }
        String string3 = System.getProperty("microedition.platform");
        String string4 = System.getProperty("microedition.locale");
        String string5 = "Profile/" + string2 + " Configuration/" + string + " Platform/" + string3;
        httpConnection.setRequestProperty("User-Agent", string5);
        if (string4 != null) {
            httpConnection.setRequestProperty("Content-Language", string4);
        }
    }

    void genHeaderForm(HttpConnection httpConnection) throws IOException {
        String string;
        this.clearForm(this.headerForm);
        this.headerForm.append((Item)new StringItem("response message: ", httpConnection.getResponseMessage()));
        this.headerForm.append((Item)new StringItem("response code: ", httpConnection.getResponseCode() + ""));
        int n = 0;
        while ((string = httpConnection.getHeaderFieldKey(n)) != null) {
            String string2 = httpConnection.getHeaderField(n);
            StringItem stringItem = new StringItem(string + ": ", string2);
            this.headerForm.append((Item)stringItem);
            ++n;
        }
    }

    void genRequestForm(HttpConnection httpConnection) throws IOException {
        this.clearForm(this.requestForm);
        this.requestForm.append((Item)new StringItem("URL: ", httpConnection.getURL()));
        this.requestForm.append((Item)new StringItem("Method: ", httpConnection.getRequestMethod()));
        this.requestForm.append((Item)new StringItem("Protocol: ", httpConnection.getProtocol()));
        this.requestForm.append((Item)new StringItem("Host: ", httpConnection.getHost()));
        this.requestForm.append((Item)new StringItem("File: ", httpConnection.getFile()));
        this.requestForm.append((Item)new StringItem("Ref: ", httpConnection.getRef()));
        this.requestForm.append((Item)new StringItem("Query: ", httpConnection.getQuery()));
        this.requestForm.append((Item)new StringItem("Port: ", Integer.toString(httpConnection.getPort())));
        this.requestForm.append((Item)new StringItem("User-Agent: ", httpConnection.getRequestProperty("User-Agent")));
        this.requestForm.append((Item)new StringItem("Content-Language: ", httpConnection.getRequestProperty("Content-Language")));
    }

    void genProgressForm(String string, String string2) {
        this.progressGauge.setValue(0);
        this.progressGauge.setLabel(string2);
        this.progressForm.setTitle(string);
    }

    void genErrorsForm(String string, Throwable throwable) {
        this.clearForm(this.errorsForm);
        if (string != null) {
            this.errorsForm.setTitle(string);
        } else {
            this.errorsForm.setTitle("Exception");
        }
        if (throwable != null) {
            throwable.printStackTrace();
            this.errorsForm.append(throwable.getClass().getName());
            this.errorsForm.append("\n");
            String string2 = throwable.getMessage();
            if (string2 != null) {
                this.errorsForm.append(string2);
            }
        } else {
            this.errorsForm.append("None");
        }
    }

    void showAlert(String string, Screen screen) {
        this.alert.setString(string);
        if (screen == null) {
            this.display.setCurrent((Displayable)this.alert);
        } else {
            this.display.setCurrent(this.alert, (Displayable)screen);
        }
    }

    void clearForm(Form form) {
        int n = form.size();
        for (int i = n - 1; i >= 0; --i) {
            form.delete(i);
        }
    }
}

