/*
 * Decompiled with CFR 0.152.
 */
package example.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;

public class HttpTest
extends MIDlet
implements CommandListener,
Runnable {
    private Command exitCommand = new Command("Exit", 7, 2);
    private Command getCommand = new Command("Get", 1, 1);
    private Command postCommand = new Command("Post", 1, 1);
    private Command headCommand = new Command("Head", 1, 1);
    private Command chooseCommand = new Command("Choose", 1, 2);
    private Command addCommand = new Command("Add", 1, 1);
    private Command addSaveCommand = new Command("OK", 1, 1);
    private Command okCommand = new Command("OK", 4, 1);
    private Command cancelCommand = new Command("Cancel", 3, 1);
    private Display display;
    private String url;
    private Vector urls = new Vector();
    private List list;
    private TextBox addTextBox;
    private Command currentCommand;
    private Thread commandThread;
    private int attempt;
    private TextBox t;
    private boolean firstTime;

    public HttpTest() {
        this.urls.addElement("http://www.yahoo.com/");
        this.urls.addElement("http://www.sun.com/");
        this.urls.addElement("https://central.sun.net/");
        this.urls.addElement("https://www.wellsfargo.com");
        this.urls.addElement("-----------------------");
        this.urls.addElement("http://jse.east/Telco/HttpTest.txt");
        this.urls.addElement("http://spiro.eng/");
        this.urls.addElement("http://spiro.eng:80/");
        this.urls.addElement("http://localhost:8080/");
        this.urls.addElement("-----------------------");
        this.urls.addElement("shttp://host/notsupportedprotocol");
        this.urls.addElement("http://:8080/missinghost");
        this.urls.addElement("http://mal\\formed:axyt/url???");
        this.urls.addElement("http://www.yahoo.com/no/such/page/");
        this.urls.addElement("http://www.yahoo.com:29999/no/such/port/");
        this.urls.addElement("http://no.such.site/");
        this.urls.addElement("http://www.yahoo.com/bad_proxy/");
        this.url = (String)this.urls.elementAt(0);
        this.display = Display.getDisplay((MIDlet)this);
        this.firstTime = true;
    }

    static final void DEBUG(String string) {
        System.out.println(string);
    }

    private String time2str(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date(l));
        return ((Object)calendar).toString();
    }

    public void startApp() {
        if (this.firstTime) {
            String string = this.getAppProperty("HttpTest-Url");
            if (string != null) {
                this.url = string;
            }
            this.mainScreen();
            this.firstTime = false;
        } else {
            this.display.setCurrent((Displayable)this.t);
        }
    }

    void mainScreen() {
        String string = "URL = " + this.url + ". Press Get or Post to fetch it, or Choose to " + "use another URL";
        this.t = new TextBox("Http Test", string, string.length(), 0);
        this.setCommands((Displayable)this.t, false);
        this.display.setCurrent((Displayable)this.t);
    }

    void chooseScreen() {
        this.list = new List("Choose URL", 1);
        for (int i = 0; i < this.urls.size(); ++i) {
            this.list.append((String)this.urls.elementAt(i), null);
        }
        this.setCommands((Displayable)this.list, true);
        this.display.setCurrent((Displayable)this.list);
    }

    void addScreen() {
        this.addTextBox = new TextBox("New URL", "http://", 200, 0);
        this.addTextBox.addCommand(this.addSaveCommand);
        this.addTextBox.addCommand(this.cancelCommand);
        this.addTextBox.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.addTextBox);
    }

    private void readContents(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.attempt;
        stringBuffer.append("attempt " + this.attempt + " content of " + string + " " + this.url + "\n");
        HttpConnection httpConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        TextBox textBox = null;
        try {
            int n;
            Object object;
            long l = -1L;
            int n2 = 0;
            long l2 = 0L;
            HttpTest.DEBUG(string + " Page: " + this.url);
            httpConnection = (HttpConnection)Connector.open((String)this.url);
            HttpTest.DEBUG("c= " + httpConnection);
            httpConnection.setRequestMethod(string);
            httpConnection.setRequestProperty("foldedField", "first line\r\n second line\r\n third line");
            if (string == "POST") {
                object = "Test POST text.";
                HttpTest.DEBUG("Posting: " + (String)object);
                outputStream = httpConnection.openOutputStream();
                outputStream.write(((String)object).getBytes());
                outputStream.close();
            }
            if ((n = httpConnection.getResponseCode()) != 200) {
                stringBuffer.append("Response Code: " + httpConnection.getResponseCode() + "\n");
                stringBuffer.append("Response Message: " + httpConnection.getResponseMessage() + "\n\n");
            }
            inputStream = httpConnection.openInputStream();
            HttpTest.DEBUG("is = " + inputStream);
            if (httpConnection instanceof HttpConnection) {
                l = httpConnection.getLength();
            }
            HttpTest.DEBUG("len = " + l);
            if (l != -1L) {
                HttpTest.DEBUG("Content-Length: " + l);
                int n3 = 0;
                while ((long)n3 < l) {
                    n2 = inputStream.read();
                    if (n2 != -1) {
                        if (n2 <= 32) {
                            n2 = 32;
                        }
                        stringBuffer.append((char)n2);
                        if (++l2 > 200L) break;
                    }
                    ++n3;
                }
            } else {
                object = new byte[100];
                int n4 = inputStream.read((byte[])object, 0, ((Object)object).length);
                for (int i = 0; i < n4; ++i) {
                    n2 = object[i] & 0xFF;
                    stringBuffer.append((char)n2);
                }
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (Exception exception) {
                HttpTest.DEBUG("Error closing connection");
            }
            try {
                l = inputStream.available();
                HttpTest.DEBUG("Inputstream failed to throw IOException after close");
            }
            catch (IOException iOException) {
                HttpTest.DEBUG("expected IOException (available())");
                iOException.printStackTrace();
            }
            textBox = new TextBox("Http Test", stringBuffer.toString(), stringBuffer.length(), 0);
            inputStream = null;
            httpConnection = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            HttpTest.DEBUG(iOException.getClass().toString());
            HttpTest.DEBUG(iOException.toString());
            HttpTest.DEBUG("Exception reading from http");
            if (httpConnection != null) {
                try {
                    String string2 = null;
                    if (httpConnection instanceof HttpConnection) {
                        string2 = httpConnection.getResponseMessage();
                    }
                    HttpTest.DEBUG(string2);
                    if (string2 == null) {
                        string2 = "No Response message";
                    }
                    textBox = new TextBox("Http Error", string2, string2.length(), 0);
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                    String string3 = iOException2.toString();
                    HttpTest.DEBUG(string3);
                    if (string3 == null) {
                        string3 = iOException.getClass().getName();
                    }
                    textBox = new TextBox("Http Error", string3, string3.length(), 0);
                }
                try {
                    httpConnection.close();
                }
                catch (IOException iOException3) {}
            }
            textBox = new TextBox("Http Error", "Could not open URL", 128, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            textBox = new TextBox("Illegal Argument", illegalArgumentException.getMessage(), 128, 0);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (httpConnection != null) {
            try {
                httpConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setCommands((Displayable)textBox, false);
        this.display.setCurrent((Displayable)textBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(String string) {
        try {
            HttpConnection httpConnection;
            try {
                httpConnection = (HttpConnection)Connector.open((String)this.url);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = illegalArgumentException.getMessage();
                TextBox textBox = new TextBox("Illegal argument", illegalArgumentException.getMessage(), 128, 0);
                this.setCommands((Displayable)textBox, false);
                this.display.setCurrent((Displayable)textBox);
                return;
            }
            catch (ConnectionNotFoundException connectionNotFoundException) {
                TextBox textBox = new TextBox("Error", "Protocol not supported", 128, 0);
                this.setCommands((Displayable)textBox, false);
                this.display.setCurrent((Displayable)textBox);
                return;
            }
            try {
                Object object;
                httpConnection.setRequestMethod(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("URL: ");
                stringBuffer.append(httpConnection.getURL());
                stringBuffer.append("\nProtocol: ");
                stringBuffer.append(httpConnection.getProtocol());
                stringBuffer.append("\nHost: " + httpConnection.getHost());
                stringBuffer.append("\nFile: " + httpConnection.getFile());
                stringBuffer.append("\nRef: " + httpConnection.getRef());
                stringBuffer.append("\nQuery: ");
                stringBuffer.append(httpConnection.getQuery());
                stringBuffer.append("\nPort: ");
                stringBuffer.append(httpConnection.getPort());
                stringBuffer.append("\nMethod: ");
                stringBuffer.append(httpConnection.getRequestMethod());
                if (httpConnection instanceof HttpsConnection) {
                    SecurityInfo securityInfo = ((HttpsConnection)httpConnection).getSecurityInfo();
                    object = securityInfo.getServerCertificate();
                    stringBuffer.append("\nSecure protocol: ");
                    stringBuffer.append(securityInfo.getProtocolName());
                    stringBuffer.append("\nSecure protocol version: ");
                    stringBuffer.append(securityInfo.getProtocolVersion());
                    stringBuffer.append("\nCipher suite: ");
                    stringBuffer.append(securityInfo.getCipherSuite());
                    if (object == null) {
                        stringBuffer.append("\nNo server Certficate.");
                    } else {
                        stringBuffer.append("\nServer certificate \n\t Type: ");
                        stringBuffer.append(object.getType());
                        stringBuffer.append("\n\t Version: ");
                        stringBuffer.append(object.getVersion());
                        stringBuffer.append("\n\t Serial number: ");
                        stringBuffer.append(object.getSerialNumber());
                        stringBuffer.append("\n\t Issuer: ");
                        stringBuffer.append(object.getIssuer());
                        stringBuffer.append("\n\t Subject: ");
                        stringBuffer.append(object.getSubject());
                        stringBuffer.append("\n\t Signature algorithm: ");
                        stringBuffer.append(object.getSigAlgName());
                        stringBuffer.append("\n\t Not valid before: ");
                        stringBuffer.append(this.time2str(object.getNotBefore()));
                        stringBuffer.append("\n\t Not valid after:  ");
                        stringBuffer.append(this.time2str(object.getNotAfter()));
                    }
                }
                stringBuffer.append("\nResponseCode: ");
                stringBuffer.append(httpConnection.getResponseCode());
                stringBuffer.append("\nResponseMessage:");
                stringBuffer.append(httpConnection.getResponseMessage());
                stringBuffer.append("\nContentLength: ");
                stringBuffer.append(httpConnection.getLength());
                stringBuffer.append("\nContentType: ");
                stringBuffer.append(httpConnection.getType());
                stringBuffer.append("\nContentEncoding: ");
                stringBuffer.append(httpConnection.getEncoding());
                stringBuffer.append("\nContentExpiration: ");
                stringBuffer.append(httpConnection.getExpiration());
                stringBuffer.append("\nDate: ");
                stringBuffer.append(httpConnection.getDate());
                stringBuffer.append("\nLast-Modified: ");
                stringBuffer.append(httpConnection.getLastModified());
                stringBuffer.append("\n\n");
                int n = 0;
                try {
                    while ((object = httpConnection.getHeaderFieldKey(n)) != null) {
                        String string3 = httpConnection.getHeaderField(n);
                        stringBuffer.append((String)object);
                        stringBuffer.append(": ");
                        stringBuffer.append(string3);
                        stringBuffer.append("\n");
                        ++n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TextBox textBox = new TextBox("Http Test", stringBuffer.toString(), stringBuffer.length(), 0);
                this.setCommands((Displayable)textBox, false);
                this.display.setCurrent((Displayable)textBox);
            }
            finally {
                httpConnection.close();
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            TextBox textBox = new TextBox("Error", "Could not Connect.", 128, 0);
            this.setCommands((Displayable)textBox, false);
            this.display.setCurrent((Displayable)textBox);
            return;
        }
        catch (CertificateException certificateException) {
            StringBuffer stringBuffer = new StringBuffer(256);
            Certificate certificate = certificateException.getCertificate();
            stringBuffer.append(certificateException.getMessage());
            if (certificate != null) {
                stringBuffer.append("\nServer certificate \n\t Type: ");
                stringBuffer.append(certificate.getType());
                stringBuffer.append("\n\t Version: ");
                stringBuffer.append(certificate.getVersion());
                stringBuffer.append("\n\t Serial number: ");
                stringBuffer.append(certificate.getSerialNumber());
                stringBuffer.append("\n\t Issuer: ");
                stringBuffer.append(certificate.getIssuer());
                stringBuffer.append("\n\t Subject: ");
                stringBuffer.append(certificate.getSubject());
                stringBuffer.append("\n\t Signature algorithm: ");
                stringBuffer.append(certificate.getSigAlgName());
                stringBuffer.append("\n\t Not valid before: ");
                stringBuffer.append(this.time2str(certificate.getNotBefore()));
                stringBuffer.append("\n\t Not valid after:  ");
                stringBuffer.append(this.time2str(certificate.getNotAfter()));
            }
            String string4 = stringBuffer.toString();
            TextBox textBox = new TextBox("Certificate Error", string4, string4.length(), 0);
            this.setCommands((Displayable)textBox, false);
            this.display.setCurrent((Displayable)textBox);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void setCommands(Displayable displayable, boolean bl) {
        if (bl) {
            displayable.addCommand(this.addCommand);
            displayable.addCommand(this.okCommand);
        } else {
            displayable.addCommand(this.exitCommand);
            displayable.addCommand(this.chooseCommand);
            displayable.addCommand(this.getCommand);
            displayable.addCommand(this.postCommand);
            displayable.addCommand(this.headCommand);
        }
        displayable.setCommandListener((CommandListener)this);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        HttpTest httpTest = this;
        synchronized (httpTest) {
            if (this.commandThread != null) {
                return;
            }
            this.currentCommand = command;
            this.commandThread = new Thread(this);
            this.commandThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.currentCommand == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (this.currentCommand == this.getCommand) {
            this.readContents("GET");
        } else if (this.currentCommand == this.postCommand) {
            this.readContents("POST");
        } else if (this.currentCommand == this.headCommand) {
            this.readHeaders("HEAD");
        } else if (this.currentCommand == this.chooseCommand) {
            this.chooseScreen();
        } else if (this.currentCommand == this.okCommand) {
            int n = this.list.getSelectedIndex();
            if (n >= 0) {
                this.url = this.list.getString(n);
            }
            this.mainScreen();
        } else if (this.currentCommand == this.addSaveCommand) {
            this.urls.addElement(this.addTextBox.getString().trim());
            this.chooseScreen();
        } else if (this.currentCommand == this.addCommand) {
            this.addScreen();
        } else if (this.currentCommand == this.cancelCommand) {
            this.chooseScreen();
        }
        HttpTest httpTest = this;
        synchronized (httpTest) {
            this.commandThread = null;
        }
    }
}

