/*
 * Decompiled with CFR 0.152.
 */
package example.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class HttpExample
extends MIDlet
implements Runnable {
    String url = "http://www.yahoo.com/";
    StringBuffer buffer = new StringBuffer();
    Gauge gauge = new Gauge("Progress", false, 10, 0);
    Form form = new Form("Progress");

    public HttpExample() {
        this.form.append((Item)this.gauge);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.form);
    }

    public void startApp() {
        new Thread(this).start();
    }

    public void run() {
        try {
            this.gauge.setLabel("Get using ContentConnection");
            this.gauge.setValue(2);
            this.getViaContentConnection(this.url);
            this.gauge.setLabel("Get using StreamConnection");
            this.gauge.setValue(4);
            this.getViaStreamConnection(this.url);
            this.gauge.setLabel("Get using HttpConnection");
            this.gauge.setValue(6);
            this.getViaHttpConnection(this.url);
            this.gauge.setLabel("Post using HttpConnection");
            this.gauge.setValue(8);
            this.postViaHttpConnection(this.url);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        this.gauge.setValue(10);
        this.notifyDestroyed();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getViaStreamConnection(String string) throws IOException {
        StreamConnection streamConnection = null;
        InputStream inputStream = null;
        try {
            int n;
            streamConnection = (StreamConnection)Connector.open((String)string);
            inputStream = streamConnection.openInputStream();
            this.buffer.setLength(0);
            while ((n = inputStream.read()) != -1) {
                this.process((byte)n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (streamConnection != null) {
                streamConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getViaContentConnection(String string) throws IOException {
        ContentConnection contentConnection = null;
        InputStream inputStream = null;
        try {
            contentConnection = (ContentConnection)Connector.open((String)string);
            inputStream = contentConnection.openInputStream();
            this.buffer.setLength(0);
            int n = (int)contentConnection.getLength();
            if (n > 0) {
                byte[] byArray = new byte[n];
                int n2 = inputStream.read(byArray);
                this.process(byArray);
            } else {
                int n3;
                while ((n3 = inputStream.read()) != -1) {
                    this.process((byte)n3);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (contentConnection != null) {
                contentConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getViaHttpConnection(String string) throws IOException {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n = -1;
            while (true) {
                httpConnection = (HttpConnection)Connector.open((String)string);
                this.setRequestHeaders(httpConnection);
                n = httpConnection.getResponseCode();
                if (n != 307 && n != 302 && n != 301) break;
                string = httpConnection.getHeaderField("location");
                httpConnection.close();
                System.out.println("Redirecting to " + string);
            }
            if (n == 501 || n == 505 || n == 500 || n == 504 || n == 502) {
                System.err.print("WARNING: Server error status [" + n + "] ");
                System.err.println("returned for url [" + string + "]");
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
                return;
            }
            if (n != 200) {
                throw new IOException("Response status not OK [" + n + "]");
            }
            String string2 = httpConnection.getType();
            this.processType(string2);
            inputStream = httpConnection.openInputStream();
            this.buffer.setLength(0);
            int n2 = (int)httpConnection.getLength();
            if (n2 > 0) {
                byte[] byArray = new byte[n2];
                int n3 = inputStream.read(byArray);
                this.process(byArray);
            } else {
                int n4;
                while ((n4 = inputStream.read()) != -1) {
                    this.process((byte)n4);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
    }

    void setRequestHeaders(HttpConnection httpConnection) throws IOException {
        String string = System.getProperty("microedition.configuration");
        String string2 = System.getProperty("microedition.profiles");
        int n = string2.indexOf(32);
        if (n != -1) {
            string2 = string2.substring(0, n - 1);
        }
        String string3 = System.getProperty("microedition.locale");
        String string4 = "Profile/" + string2 + " Configuration/" + string;
        httpConnection.setRequestProperty("User-Agent", string4);
        if (string3 != null) {
            httpConnection.setRequestProperty("Content-Language", string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postViaHttpConnection(String string) throws IOException {
        int n = 0;
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            httpConnection = (HttpConnection)Connector.open((String)string);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("If-Modified-Since", "29 Oct 1999 19:43:31 GMT");
            httpConnection.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
            httpConnection.setRequestProperty("Content-Language", "en-US");
            outputStream = httpConnection.openOutputStream();
            outputStream.write("LIST games\n".getBytes());
            outputStream.flush();
            n = httpConnection.getResponseCode();
            if (n == 501 || n == 505 || n == 500 || n == 504 || n == 502) {
                System.err.print("WARNING: Server error status [" + n + "] ");
                System.err.println("returned for url [" + string + "]");
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
                return;
            }
            if (n != 200) {
                throw new IOException("Response status not OK [" + n + "]");
            }
            inputStream = httpConnection.openInputStream();
            String string2 = httpConnection.getType();
            this.processType(string2);
            int n2 = (int)httpConnection.getLength();
            if (n2 > 0) {
                byte[] byArray = new byte[n2];
                int n3 = inputStream.read(byArray);
                this.process(byArray);
            } else {
                int n4;
                while ((n4 = inputStream.read()) != -1) {
                    this.process((byte)n4);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
    }

    void processType(String string) {
    }

    void process(byte by) {
        this.buffer.append((char)by);
    }

    void process(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.process(byArray[i]);
        }
    }
}

