/*
 * Decompiled with CFR 0.152.
 */
package example.fonts;

import example.fonts.FontCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class FontTestlet
extends MIDlet
implements CommandListener {
    private Display myDisplay;
    private FontCanvas myCanvas;
    private int currentFace = 0;
    private Command monospaceCommand = new Command("monospace", 8, 1);
    private Command proportionalCommand = new Command("proportional", 8, 1);
    private Command systemCommand = new Command("system", 8, 1);

    public FontTestlet() {
        this.myDisplay = Display.getDisplay((MIDlet)this);
        this.myCanvas = new FontCanvas(this);
        this.myCanvas.setCommandListener(this);
        this.myCanvas.addCommand(this.monospaceCommand);
        this.myCanvas.addCommand(this.proportionalCommand);
    }

    public void init() throws MIDletStateChangeException {
    }

    public void startApp() throws MIDletStateChangeException {
        this.myDisplay.setCurrent((Displayable)this.myCanvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.myDisplay.setCurrent((Displayable)null);
        this.myCanvas.destroy();
    }

    public void paint(Graphics graphics) {
        String string;
        int n = 0;
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.myCanvas.getWidth(), this.myCanvas.getHeight());
        graphics.setColor(0xFFFFFF);
        switch (this.currentFace) {
            case 0: {
                string = "System";
                break;
            }
            case 64: {
                string = "Proportional";
                break;
            }
            case 32: {
                string = "Monospaced";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        graphics.drawString(string, 0, 0, 20);
        graphics.setFont(Font.getFont((int)this.currentFace, (int)0, (int)16));
        graphics.drawString("Regular plain", 0, n += graphics.getFont().getHeight(), 20);
        graphics.setFont(Font.getFont((int)this.currentFace, (int)2, (int)16));
        graphics.drawString("Regular ital", 0, n += graphics.getFont().getHeight(), 20);
        graphics.setFont(Font.getFont((int)this.currentFace, (int)1, (int)16));
        graphics.drawString("Bold plain", 0, n += graphics.getFont().getHeight(), 20);
        graphics.setFont(Font.getFont((int)this.currentFace, (int)3, (int)16));
        graphics.drawString("Bold ital", 0, n += graphics.getFont().getHeight(), 20);
    }

    Command getCurrentCommand() {
        switch (this.currentFace) {
            case 32: {
                return this.monospaceCommand;
            }
            case 64: {
                return this.proportionalCommand;
            }
        }
        return this.systemCommand;
    }

    public void commandAction(Command command, Displayable displayable) {
        this.myCanvas.addCommand(this.getCurrentCommand());
        if (command == this.monospaceCommand) {
            this.myCanvas.removeCommand(this.monospaceCommand);
            this.currentFace = 32;
        } else if (command == this.proportionalCommand) {
            this.myCanvas.removeCommand(this.proportionalCommand);
            this.currentFace = 64;
        } else if (command == this.systemCommand) {
            this.myCanvas.removeCommand(this.systemCommand);
            this.currentFace = 0;
        }
        this.myCanvas.repaint();
    }
}

