/*
 * Decompiled with CFR 0.152.
 */
package example.chooser;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ColorChooser
extends Canvas {
    private int width;
    private int height;
    private Font font;
    private int label_w;
    private int label_h;
    private int gray;
    private int rgbColor;
    private int radix = 10;
    private int delta = 32;
    private int ndx = 0;
    private boolean isColor;
    private int numColors;
    private int pndx;
    private int[] palette = new int[]{0xFFFF00, 65535, 0xFF00FF, 0xFFFF00, 0xC00000, 49152, 192, 0x80FFFF, 0xFF80FF, 0xFFFF80};
    static final int BORDER = 2;

    public ColorChooser(boolean bl, int n) {
        this.isColor = bl;
        this.numColors = n;
        this.ndx = 0;
        this.pndx = 0;
        this.setColor(this.palette[this.pndx]);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.font = Font.getDefaultFont();
        this.label_h = this.font.getHeight();
        if (this.label_h > this.height / 6) {
            this.font = Font.getFont((int)0, (int)0, (int)8);
            this.label_h = this.font.getHeight();
        }
        this.label_w = this.font.stringWidth("999");
    }

    public boolean setPaletteIndex(int n) {
        if (n >= this.palette.length) {
            return false;
        }
        this.pndx = n;
        this.setColor(this.palette[n]);
        return true;
    }

    public int getPaletteIndex() {
        return this.ndx;
    }

    public void setColor(int n, int n2, int n3) {
        n = n < 0 ? 0 : n & 0xFF;
        n2 = n2 < 0 ? 0 : n2 & 0xFF;
        n3 = n3 < 0 ? 0 : n3 & 0xFF;
        this.setColor(n << 16 | n2 << 8 | n3);
    }

    public void setColor(int n) {
        this.palette[this.pndx] = this.rgbColor = n & 0xFFFFFF;
        this.updateGray();
    }

    private void updateGray() {
        this.gray = Math.max(this.rgbColor >> 16 & 0xFF, Math.max(this.rgbColor >> 8 & 0xFF, this.rgbColor & 0xFF));
    }

    public int getColor() {
        return this.rgbColor;
    }

    public int getRedComponent() {
        return this.rgbColor >> 16 & 0xFF;
    }

    public int getGreenComponent() {
        return this.rgbColor >> 8 & 0xFF;
    }

    public int getBlueComponent() {
        return this.rgbColor & 0xFF;
    }

    public int getGrayScale() {
        return this.gray;
    }

    public void setGrayScale(int n) {
        this.setColor(n, n, n);
    }

    protected void showNotify() {
    }

    protected void paint(Graphics graphics) {
        if (this.isColor) {
            this.colorPaint(graphics);
        } else {
            this.grayPaint(graphics);
        }
    }

    public void setRadix(int n) {
        if (n != 10 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.radix = n;
        this.repaint();
    }

    public int getRadix() {
        return this.radix;
    }

    public void setDelta(int n) {
        if (n > 0 && n <= 128) {
            this.delta = n;
        }
    }

    public int getDelta() {
        return this.delta;
    }

    private String format(int n) {
        String string = Integer.toString(n, this.radix);
        if (this.radix == 10 || string.length() >= 2) {
            return string;
        }
        return "0" + string;
    }

    private void colorPaint(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.width / this.palette.length;
        int n4 = (this.height - 6) / 4;
        int n5 = n3 * this.palette.length;
        int n6 = n3 * this.palette.length - 1;
        int n7 = n4;
        int n8 = (this.width - n5) / 2;
        int n9 = 0;
        int n10 = n8;
        int n11 = n9 + n7 + 4;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(this.rgbColor);
        this.gray = graphics.getGrayScale();
        graphics.fillRect(n8, n9, n6, n7);
        graphics.setColor(this.ndx < 0 ? 0 : 0x808080);
        graphics.drawRect(n8, n9, n6 - 1, n7 - 1);
        for (n2 = 0; n2 < this.palette.length; ++n2) {
            graphics.setColor(this.palette[n2]);
            n = n2 == this.pndx ? 4 : 0;
            graphics.fillRect(n10 + n2 * n3, n11 - n, n3 - 1, n4);
            if (n2 != this.pndx) continue;
            graphics.setColor(this.ndx < 0 ? 0 : 0x808080);
            graphics.drawRect(n10 + n2 * n3, n11 - n - 1, n3 - 2, n4 + 1);
        }
        n2 = n8;
        n = n11 + n4 + 2;
        int n12 = this.label_h + 2;
        int n13 = n5 - this.label_w - 2;
        int n14 = this.label_w + 2;
        int n15 = n + 2;
        int n16 = n15 + n12;
        int n17 = n16 + n12;
        graphics.setColor(0, 0, 255);
        int n18 = n13 * this.getBlueComponent() / 255;
        graphics.fillRect(n14, n15, n18, n12 - 2);
        graphics.setColor(this.ndx == 0 ? 0 : 0xA0FFA0);
        graphics.drawRect(n14, n15, n13 - 1, n12 - 2 - 1);
        int n19 = n13 * this.getGreenComponent() / 255;
        graphics.setColor(0, 255, 0);
        graphics.fillRect(n14, n16, n19, n12 - 2);
        graphics.setColor(this.ndx == 1 ? 0 : 0xA0FFA0);
        graphics.drawRect(n14, n16, n13 - 1, n12 - 2 - 1);
        int n20 = n13 * this.getRedComponent() / 255;
        graphics.setColor(255, 0, 0);
        graphics.fillRect(n14, n17, n20, n12 - 2);
        graphics.setColor(this.ndx == 2 ? 0 : 0xFFA0A0);
        graphics.drawRect(n14, n17, n13 - 1, n12 - 2 - 1);
        graphics.setFont(this.font);
        graphics.setColor(0, 0, 0);
        graphics.drawString(this.format(this.getBlueComponent()), this.label_w, n15 + n12, 40);
        graphics.drawString(this.format(this.getGreenComponent()), this.label_w, n16 + n12, 40);
        graphics.drawString(this.format(this.getRedComponent()), this.label_w, n17 + n12, 40);
    }

    private void grayPaint(Graphics graphics) {
        int n = this.width;
        int n2 = this.height / 2;
        int n3 = this.height / 2;
        int n4 = this.width - (this.label_w + 2);
        int n5 = this.label_h + 2;
        graphics.setGrayScale(255);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setGrayScale(this.gray);
        graphics.fillRect(0, 0, n, n2);
        graphics.setGrayScale(0);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setGrayScale(0);
        graphics.fillRect(this.label_w + 2, n3 + 2, n4 * this.gray / 255, n5);
        graphics.drawRect(this.label_w + 2, n3 + 2, n4 - 1, n5 - 1);
        graphics.drawString(this.format(this.gray), this.label_w, n3 + 2 + n5, 40);
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        int n3 = 0;
        switch (n2) {
            case 5: {
                ++n3;
                break;
            }
            case 2: {
                --n3;
                break;
            }
            case 1: {
                --this.ndx;
                break;
            }
            case 6: {
                ++this.ndx;
                break;
            }
            default: {
                return;
            }
        }
        if (this.isColor) {
            if (this.ndx < -1) {
                this.ndx = -1;
            }
            if (this.ndx > 2) {
                this.ndx = 2;
            }
            if (this.ndx >= 0) {
                int n4 = this.rgbColor >> this.ndx * 8 & 0xFF;
                if ((n4 += n3 * this.delta) < 0) {
                    n4 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                int n5 = 255 << this.ndx * 8;
                this.palette[this.pndx] = this.rgbColor = this.rgbColor & ~n5 | n4 << this.ndx * 8;
            } else {
                this.pndx += n3;
                if (this.pndx < 0) {
                    this.pndx = 0;
                }
                if (this.pndx >= this.palette.length) {
                    this.pndx = this.palette.length - 1;
                }
                this.rgbColor = this.palette[this.pndx];
            }
        } else {
            this.gray += n3 * this.delta;
            if (this.gray < 0) {
                this.gray = 0;
            }
            if (this.gray > 255) {
                this.gray = 255;
            }
        }
        this.repaint();
    }
}

