/*
 * Decompiled with CFR 0.152.
 */
package example.chooser;

import example.About;
import example.chooser.ColorChooser;
import example.chooser.FontChooser;
import example.chooser.TextSample;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Chooser
extends MIDlet
implements CommandListener {
    private Display display;
    private FontChooser fonts;
    private TextSample sample;
    private ColorChooser colors;
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command textColorCommand = new Command("Text Color", 1, 3);
    private Command backgroundColorCommand = new Command("Background Color", 1, 4);
    private Command fontsCommand = new Command("Fonts", 1, 11);
    private Command aboutCommand = new Command("About", 1, 99);
    private Command okCommand = new Command("Ok", 1, 2);
    private Command okFgCommand = new Command("Ok", 1, 2);
    private Command okBgCommand = new Command("Ok", 1, 2);

    public Chooser() {
        this.display = Display.getDisplay((MIDlet)this);
        this.sample = new TextSample();
        this.sample.addCommand(this.exitCommand);
        this.sample.addCommand(this.aboutCommand);
        this.sample.addCommand(this.textColorCommand);
        this.sample.addCommand(this.backgroundColorCommand);
        this.sample.addCommand(this.fontsCommand);
        this.sample.setCommandListener(this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.sample);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (command == this.aboutCommand) {
            About.showAbout(this.display);
        } else if (command == this.fontsCommand) {
            if (this.fonts == null) {
                this.fonts = new FontChooser();
                this.fonts.setFace(this.sample.getFace());
                this.fonts.setStyle(this.sample.getStyle());
                this.fonts.setSize(this.sample.getSize());
                this.fonts.addCommand(this.okCommand);
                this.fonts.setCommandListener(this);
            }
            this.display.setCurrent((Displayable)this.fonts);
        } else if (command == this.backgroundColorCommand) {
            if (this.colors == null) {
                this.colors = new ColorChooser(this.display.isColor(), this.display.numColors());
                this.colors.setCommandListener(this);
            }
            this.colors.addCommand(this.okBgCommand);
            this.colors.removeCommand(this.okFgCommand);
            this.colors.setColor(this.sample.getBackgroundColor());
            this.display.setCurrent((Displayable)this.colors);
        } else if (command == this.textColorCommand) {
            if (this.colors == null) {
                this.colors = new ColorChooser(this.display.isColor(), this.display.numColors());
                this.colors.setCommandListener(this);
            }
            this.colors.addCommand(this.okFgCommand);
            this.colors.removeCommand(this.okBgCommand);
            this.colors.setColor(this.sample.getForegroundColor());
            this.display.setCurrent((Displayable)this.colors);
        } else if (command == this.okCommand) {
            if (displayable == this.fonts) {
                this.sample.setStyle(this.fonts.getStyle());
                this.sample.setFace(this.fonts.getFace());
                this.sample.setSize(this.fonts.getSize());
            }
            this.display.setCurrent((Displayable)this.sample);
        } else if (command == this.okFgCommand) {
            this.sample.setForegroundColor(this.colors.getColor());
            this.display.setCurrent((Displayable)this.sample);
        } else if (command == this.okBgCommand) {
            this.sample.setBackgroundColor(this.colors.getColor());
            this.display.setCurrent((Displayable)this.sample);
        }
    }
}

