/*
 * Decompiled with CFR 0.152.
 */
package example.auction;

import example.About;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class NewTicketAuction
extends MIDlet
implements CommandListener {
    Display display;
    Alert splashScreenAlert;
    static final int DefaultTimeout = 2000;
    Image splashScreen;
    boolean imageLoaded;
    Band band = new Band();
    Login login = new Login();
    TextBox addBand;
    RmBand rmBand = new RmBand();
    static final Command BACK_CMD = new Command("Back", 2, 1);
    static final Command SAVE_CMD = new Command("Save", 1, 2);
    static final Command NEXT_CMD = new Command("Next", 1, 2);
    static final Command SUBMIT_CMD = new Command("Submit", 8, 2);
    static final Command AUCTION_CMD = new Command("Auction", 8, 2);
    static final Command CANCEL_CMD = new Command("Cancel", 3, 1);
    static final Command STOP_CMD = new Command("Stop", 6, 1);
    List mainMenu;
    List cateMenu;
    List ticketList;
    Ticker ticker;
    Alert notImpl;
    Alert savedMsg;
    Alert alertMsg;
    Form band_ticket_Form;
    Form ticketForm;
    Form enterForm;
    Form bidForm;
    Form submitMsg;
    TextField enterText;
    ChoiceGroup bandCg;
    ChoiceGroup auctionCg;
    StringItem auctionName;
    UpdateAlert updateAlert = new UpdateAlert();
    Gauge submitGauge;
    Timer TimerService;
    SetMenuForm setMenu2 = new SetMenuForm();
    String _bandName;
    int _bandIndex = 0;
    static final Command EXIT_CMD = new Command("Exit", 7, 1);
    static final Command ABOUT_CMD = new Command("About Tickets", 5, 1);
    static final Command SHOW_CMD = new Command("Show Auctions", 1, 1);
    static final Command ADD_CMD = new Command("Add Bands", 1, 1);
    static final Command RMV_CMD = new Command("Remove Bands", 1, 2);
    static final Command SETTING_CMD = new Command("Settings", 1, 3);
    static final Command SHOW_INFO_CMD = new Command("Show More Info", 8, 1);
    static final Command MAKE_BID_CMD = new Command("Make a Bid", 8, 2);
    static final Command SET_ALERT_CMD = new Command("Set an Alert", 8, 3);
    static final Command BAND_CMD = new Command("Bands", 1, 1);
    private boolean firstTime;

    public NewTicketAuction() {
        this.display = Display.getDisplay((MIDlet)this);
        this.notImpl = new Alert("Sorry!!!", "Not Implemented", null, null);
        this.savedMsg = new Alert(null, "Your new settings have been saved!", null, null);
        this.alertMsg = new Alert(null, "Your alerts have been saved!", null, null);
        this.submitGauge = new Gauge("", false, 100, 0);
        this.submitMsg = new Form("Submitting bid...");
        this.submitMsg.append((Item)this.submitGauge);
        this.submitMsg.addCommand(STOP_CMD);
        this.submitMsg.setCommandListener((CommandListener)this);
        this.ticker = new Ticker("");
        this.ticker.setString(this.band.toTickerString(null));
        this.band_ticket_Form = new Form("Welcome To Tickets");
        this.band_ticket_Form.addCommand(SHOW_INFO_CMD);
        this.band_ticket_Form.addCommand(MAKE_BID_CMD);
        this.band_ticket_Form.addCommand(SET_ALERT_CMD);
        this.band_ticket_Form.addCommand(ADD_CMD);
        this.band_ticket_Form.addCommand(RMV_CMD);
        this.band_ticket_Form.addCommand(SETTING_CMD);
        this.band_ticket_Form.addCommand(ABOUT_CMD);
        this.band_ticket_Form.addCommand(EXIT_CMD);
        this.band_ticket_Form.setCommandListener((CommandListener)this);
        this.band_ticket_Form.setTicker(this.ticker);
        this.bandCg = new ChoiceGroup("Choose a Band", 4);
        this.band_ticket_Form.append((Item)this.bandCg);
        String[] stringArray = this.band.getList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.bandCg.append(stringArray[i], null);
        }
        String string = this.band.getName(this.bandCg.getSelectedIndex());
        this.auctionCg = new ChoiceGroup(string + " Auctions:", 1);
        this.auctionCg.setLayout(2048);
        this.band_ticket_Form.append((Item)this.auctionCg);
        this.reconstructList((Choice)this.auctionCg, this.band.getTicketList(string));
        this.band_ticket_Form.setItemStateListener(new ItemStateListener(){

            public void itemStateChanged(Item item) {
                ChoiceGroup choiceGroup;
                if (item instanceof ChoiceGroup && (choiceGroup = (ChoiceGroup)item) == NewTicketAuction.this.bandCg) {
                    int n = choiceGroup.getSelectedIndex();
                    String string = NewTicketAuction.this.band.getName(n);
                    NewTicketAuction.this.auctionCg.setLabel(string + " Auctions:");
                    NewTicketAuction.this.reconstructList((Choice)NewTicketAuction.this.auctionCg, NewTicketAuction.this.band.getTicketList(string));
                }
            }
        });
        try {
            this.splashScreen = Image.createImage((String)"/example/auction/images/splashScreen.png");
            this.imageLoaded = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.splashScreenAlert = new Alert("Welcome to Ticket Auction", "", this.splashScreen, AlertType.INFO);
        this.splashScreenAlert.setTimeout(2000);
        this.ticketForm = new Form("dummy");
        this.ticketForm.append("dummy");
        this.ticketForm.addCommand(BACK_CMD);
        this.ticketForm.addCommand(BAND_CMD);
        this.ticketForm.addCommand(MAKE_BID_CMD);
        this.ticketForm.addCommand(SET_ALERT_CMD);
        this.ticketForm.setCommandListener((CommandListener)this);
        this.enterText = new TextField("Tell me when bid reaches:", "", 10, 5);
        this.enterForm = new Form("Set an Alert");
        this.enterForm.append((Item)this.enterText);
        this.enterForm.addCommand(BACK_CMD);
        this.enterForm.addCommand(SAVE_CMD);
        this.enterForm.setCommandListener((CommandListener)this);
        this.addBand = new TextBox("Add Bands, Bands:", "", 100, 0);
        this.addBand.addCommand(BACK_CMD);
        this.addBand.addCommand(SAVE_CMD);
        this.addBand.setCommandListener((CommandListener)this);
        this.firstTime = true;
    }

    public void startApp() {
        if (this.firstTime) {
            this.display.setCurrent(this.splashScreenAlert, (Displayable)this.band_ticket_Form);
            this.firstTime = false;
        }
    }

    public void destroyApp(boolean bl) {
    }

    public void pauseApp() {
    }

    public void commandAction(Command command, Displayable displayable) {
        TextBox textBox;
        if (displayable instanceof Form) {
            Form form = (Form)displayable;
            if (form == this.band_ticket_Form) {
                int n;
                this._bandIndex = n = this.auctionCg.getSelectedIndex();
                int n2 = this.bandCg.getSelectedIndex();
                String string = "";
                if (n2 >= 0) {
                    string = this.band.getName(n2);
                }
                this._bandName = string;
                if (command == SHOW_INFO_CMD) {
                    this.deleteFormItem(this.ticketForm);
                    this.ticketForm.setTitle(this.band.getTicketDataTitle(string, n));
                    this.band.getTicketData(this.ticketForm, string, n);
                    this.display.setCurrent((Displayable)this.ticketForm);
                } else if (command == MAKE_BID_CMD) {
                    this.login.setBandAttributes(string, this._bandIndex);
                    this.deleteFormItem(this.login);
                    this.login.append((Item)this.login.id);
                    this.login.id.setLabel("Enter Your ID:");
                    this.login.append((Item)this.login.pd);
                    this.login.pd.setLabel("Enter PIN:");
                    this.login.append((Item)this.login.curBid);
                    this.login.append((Item)this.login.incBid);
                    this.login.append((Item)this.login.minBid);
                    this.login.append((Item)this.login.bidText);
                    this.login.id.setString(null);
                    this.login.pd.setString(null);
                    this.login.bidText.setString(null);
                    this.band.getTicketBidTitle(this.login, this._bandName, this._bandIndex);
                    this.display.setCurrent((Displayable)this.login);
                } else if (command == SET_ALERT_CMD) {
                    this.display.setCurrent((Displayable)this.enterForm);
                } else if (command == ADD_CMD) {
                    this.display.setCurrent((Displayable)this.addBand);
                } else if (command == RMV_CMD) {
                    this.display.setCurrent((Displayable)this.rmBand);
                } else if (command == SETTING_CMD) {
                    this.display.setCurrent((Displayable)this.setMenu2);
                } else if (command == ABOUT_CMD) {
                    About.showAbout(this.display);
                } else if (command == EXIT_CMD) {
                    this.notifyDestroyed();
                }
            } else if (form == this.ticketForm) {
                if (command == BACK_CMD) {
                    this.display.setCurrent((Displayable)this.band_ticket_Form);
                } else if (command == BAND_CMD) {
                    this.display.setCurrent((Displayable)this.band_ticket_Form);
                } else if (command == MAKE_BID_CMD) {
                    this.login.setBandAttributes(this.band.getName(this.bandCg.getSelectedIndex()), this._bandIndex);
                    this.deleteFormItem(this.login);
                    this.login.append((Item)this.login.id);
                    this.login.id.setLabel("Enter Auction ID:");
                    this.login.append((Item)this.login.pd);
                    this.login.pd.setLabel("Enter PIN:");
                    this.login.append((Item)this.login.curBid);
                    this.login.append((Item)this.login.incBid);
                    this.login.append((Item)this.login.minBid);
                    this.login.append((Item)this.login.bidText);
                    this.login.id.setString(null);
                    this.login.pd.setString(null);
                    this.login.bidText.setString(null);
                    this.band.getTicketBidTitle(this.login, this._bandName, this._bandIndex);
                    this.display.setCurrent((Displayable)this.login);
                } else if (command == SET_ALERT_CMD) {
                    this.deleteFormItem(this.enterForm);
                    int n = this.bandCg.getSelectedIndex();
                    String string = this.band.getTicketID(this.band.getName(n), this.login._bandIndex);
                    this.enterForm.append((Item)new StringItem("Auction:", this.band.getName(n) + " " + string));
                    String string2 = this.band.getCurrentBid(this.band.getName(n), this.login._bandIndex);
                    this.enterForm.append((Item)new StringItem("Current Bid:", "$" + string2));
                    this.enterForm.append((Item)this.enterText);
                    this.display.setCurrent((Displayable)this.enterForm);
                }
            } else if (form == this.enterForm) {
                if (command == BACK_CMD) {
                    this.enterText.setString(null);
                    this.display.setCurrent((Displayable)this.band_ticket_Form);
                } else if (command == SAVE_CMD) {
                    this.updateAlert.set(this.band.getName(this.bandCg.getSelectedIndex()), this.enterText.getString());
                    this.display.setCurrent(this.alertMsg, (Displayable)this.band_ticket_Form);
                }
            } else if (form == this.submitMsg && command == STOP_CMD) {
                this.TimerService.cancel();
                this.display.setCurrent((Displayable)this.login.confirm);
            }
        } else if (displayable instanceof TextBox && (textBox = (TextBox)displayable) == this.addBand) {
            if (command == BACK_CMD) {
                this.display.setCurrent((Displayable)this.band_ticket_Form);
            } else if (command == SAVE_CMD) {
                this.updateBandList(this.addBand.getString());
                this.display.setCurrent(this.savedMsg, (Displayable)this.band_ticket_Form);
            }
        }
    }

    void updateBandList(String string) {
        int n;
        if (string.length() == 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (true) {
            if ((n = string.indexOf(44, n2)) == -1) break;
            vector.addElement(string.substring(n2, n));
            n2 = n + 1;
        }
        vector.addElement(string.substring(n2));
        for (n = 0; n < vector.size(); ++n) {
            int n3;
            String string2 = (String)vector.elementAt(n);
            int n4 = string2.length();
            for (n3 = 0; n3 < n4 && string2.charAt(n3) == ' '; ++n3) {
            }
            if (n3 == n4) continue;
            if (n3 == 0) {
                this.band.add(string2);
                continue;
            }
            this.band.add(string2.substring(n3));
        }
        this.reconstructBandTicketForm(this.band.getList());
        this.rmBand.reset();
    }

    void reconstructBandTicketForm(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.bandCg.deleteAll();
            this.auctionCg.setLabel(null);
            this.auctionCg.deleteAll();
            return;
        }
        this.reconstructList((Choice)this.bandCg, stringArray);
        this.bandCg.setSelectedIndex(0, true);
        String string = this.band.getName(this.bandCg.getSelectedIndex());
        this.auctionCg.setLabel(string + " Auctions:");
        this.reconstructList((Choice)this.auctionCg, this.band.getTicketList(string));
    }

    void reconstructList(Choice choice, String[] stringArray) {
        choice.deleteAll();
        for (int i = 0; i < stringArray.length; ++i) {
            choice.append(stringArray[i], null);
        }
    }

    void deleteFormItem(Form form) {
        int n = form.size();
        while (--n >= 0) {
            form.delete(n);
        }
    }

    class SetMenuForm
    extends Form
    implements CommandListener,
    ItemStateListener {
        Timer timerService = new Timer();
        ChoiceGroup tickerCg = new ChoiceGroup("Ticker Display", 2);
        ChoiceGroup updatesCg;
        Gauge gauge;
        DateField dateTimeItem;
        int updateChoice;
        int volumeValue;
        boolean[] musicChoice;
        boolean systemCurrentDate = true;
        long setTimeMillisDelta;
        long curTimeMillisDelta;

        SetMenuForm() {
            super("Settings");
            this.tickerCg.append("Rock", null);
            this.tickerCg.append("Pop", null);
            this.tickerCg.append("Country", null);
            this.tickerCg.append("Alternative", null);
            this.tickerCg.append("Jazz", null);
            this.tickerCg.append("Classical", null);
            this.musicChoice = new boolean[]{false, false, false, true, false, false};
            this.append((Item)this.tickerCg);
            this.updatesCg = new ChoiceGroup("Updates", 1);
            this.updatesCg.append("Continuous", null);
            this.updatesCg.append("15 minutes", null);
            this.updatesCg.append("30 minutes", null);
            this.updatesCg.append("1 hour", null);
            this.updatesCg.append("3 hours", null);
            this.updateChoice = 0;
            this.append((Item)this.updatesCg);
            this.gauge = new Gauge(null, true, 40, 0);
            this.volumeValue = 0;
            this.append((Item)this.gauge);
            this.setItemStateListener(this);
            this.curTimeMillisDelta = 0L;
            this.setTimeMillisDelta = 0L;
            this.dateTimeItem = new DateField(this, "Set Date:", 3){
                private final /* synthetic */ SetMenuForm this$1;
                {
                    this.this$1 = setMenuForm;
                }

                public void showNotify() {
                    long l = System.currentTimeMillis();
                    if (this.this$1.curTimeMillisDelta != 0L) {
                        l -= this.this$1.curTimeMillisDelta;
                    }
                    this.setDate(new Date(l));
                }
            };
            this.append((Item)this.dateTimeItem);
            this.settings(this.musicChoice, this.updateChoice, this.volumeValue, this.setTimeMillisDelta);
            this.addCommand(BACK_CMD);
            this.addCommand(SAVE_CMD);
            this.setCommandListener(this);
        }

        public void settings(boolean[] blArray, int n, int n2, long l) {
            this.tickerCg.setSelectedFlags(blArray);
            this.updatesCg.setSelectedIndex(n, true);
            this.gauge.setValue(n2);
            this.gauge.setLabel("Set Alert Volume: " + n2);
            long l2 = System.currentTimeMillis();
            if (l != 0L) {
                l2 -= l;
            }
            this.dateTimeItem.setDate(new Date(l2));
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == SAVE_CMD) {
                this.tickerCg.getSelectedFlags(this.musicChoice);
                String string = NewTicketAuction.this.band.toTickerString(this.musicChoice);
                if (string != null) {
                    NewTicketAuction.this.ticker.setString(string);
                }
                this.updateChoice = this.updatesCg.getSelectedIndex();
                this.volumeValue = this.gauge.getValue();
                this.setTimeMillisDelta = this.curTimeMillisDelta;
                if (NewTicketAuction.this.updateAlert.hasDataToUpdate()) {
                    int n = this.updatesCg.getSelectedIndex();
                    TimerTask timerTask = new TimerTask(this){
                        private final /* synthetic */ SetMenuForm this$1;
                        {
                            this.this$1 = setMenuForm;
                        }

                        public final void run() {
                            SetMenuForm.access$200((SetMenuForm)this.this$1).updateAlert.show();
                        }
                    };
                    switch (n) {
                        case 0: {
                            this.timerService.schedule(timerTask, 3000L);
                            break;
                        }
                        case 1: {
                            this.timerService.schedule(timerTask, 3000L);
                            break;
                        }
                        case 2: {
                            this.timerService.schedule(timerTask, 3000L);
                            break;
                        }
                        case 3: {
                            this.timerService.schedule(timerTask, 3000L);
                            break;
                        }
                        case 4: {
                            this.timerService.schedule(timerTask, 3000L);
                        }
                    }
                }
                NewTicketAuction.this.display.setCurrent(NewTicketAuction.this.savedMsg, (Displayable)NewTicketAuction.this.band_ticket_Form);
            } else if (command == BACK_CMD) {
                NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
                this.settings(this.musicChoice, this.updateChoice, this.volumeValue, this.setTimeMillisDelta);
            }
        }

        public void itemStateChanged(Item item) {
            if (item == this.gauge) {
                int n = this.gauge.getValue();
                this.gauge.setLabel("Set Alert Volume: " + String.valueOf(n));
            } else if (item == this.dateTimeItem) {
                this.curTimeMillisDelta = System.currentTimeMillis() - this.dateTimeItem.getDate().getTime();
            }
        }

        static /* synthetic */ NewTicketAuction access$200(SetMenuForm setMenuForm) {
            return setMenuForm.NewTicketAuction.this;
        }
    }

    class UpdateAlert {
        String band = "";
        String bid = "";
        Alert soundAlert = new Alert("Alert", "", null, AlertType.ALARM);

        UpdateAlert() {
            this.soundAlert.setTimeout(-2);
        }

        void set(String string, String string2) {
            this.band = string;
            this.bid = string2;
        }

        boolean hasDataToUpdate() {
            return this.band != null && this.band != "" && this.bid != null && this.bid != "";
        }

        void show() {
            if (this.hasDataToUpdate()) {
                String string = new String(this.band + "\n" + "ticket bids\n" + "have reached\n" + "$" + this.bid);
                this.soundAlert.setString(string);
                NewTicketAuction.this.display.setCurrent((Displayable)this.soundAlert);
            }
        }
    }

    class RmBand
    extends List
    implements CommandListener {
        RmBand() {
            super("Remove Bands", 2);
            String[] stringArray = NewTicketAuction.this.band.getList();
            for (int i = 0; i < stringArray.length; ++i) {
                this.append(stringArray[i], null);
            }
            this.addCommand(BACK_CMD);
            this.addCommand(SAVE_CMD);
            this.setCommandListener(this);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == SAVE_CMD) {
                boolean[] blArray = new boolean[this.size()];
                this.getSelectedFlags(blArray);
                this.removeBandList(blArray);
                NewTicketAuction.this.display.setCurrent(NewTicketAuction.this.savedMsg, (Displayable)NewTicketAuction.this.band_ticket_Form);
            } else if (command == BACK_CMD) {
                NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
            }
        }

        void reset() {
            NewTicketAuction.this.reconstructList((Choice)this, NewTicketAuction.this.band.getList());
        }

        void removeBandList(boolean[] blArray) {
            int n = blArray.length;
            while (--n >= 0) {
                if (!blArray[n]) continue;
                NewTicketAuction.this.band.remove(n);
            }
            NewTicketAuction.this.reconstructBandTicketForm(NewTicketAuction.this.band.getList());
            NewTicketAuction.this.reconstructList((Choice)this, NewTicketAuction.this.band.getList());
        }
    }

    class Band {
        private BandListTable table = new BandListTable();
        String def_ticker = "Ricky Martin 2 tix $90.00 2 tix $110.00 2 tix $200.00 Tina Turner 2 tix $65.00";
        String alt_ticker = "Alanis Morisette 2 tix $58.00 4 tix $115.00 Fiona Apple 2 tix $37.00";

        Band() {
            TicketItem ticketItem = new TicketItem("Alanis Morrisette", "18 & 19", "XF, Row 17", "Aug 23, 2002", "PacBell Stadium", "San Francisco, CA", "#7720", "2", "45.00", "69.00", "2.00", "3", "12:00 am on Aug 16, 2002");
            this.add(0, "Alanis Morrisette", ticketItem);
            ticketItem = new TicketItem("Envy", "10, 11, 12, 13", "F9, Row A", "Sep 7, 2002", "Civic Center", "Santa Cruz, CA", "4509", "4", "100.00", "101.00", "1.00", "1", "9:45 pm on Sep 1, 2002");
            this.add(1, "Envy", ticketItem);
            ticketItem = new TicketItem("Envy", "69 & 70", "PIT Row 1", "Aug 9, 2002", "Monterey Civic Ampitheatre", "Monterey, CA", "3058", "2", "9.00", "175.00", "2.50", "40", "9:00 pm on Aug 2, 2002");
            this.add(1, "Envy", ticketItem);
            ticketItem = new TicketItem("Envy", "5 & 6 & 7", "PIT Rw 11", "Aug 10, 2002", "Monterey Civic Ampitheatre", "Monterey, CA", "3541", "3", "28.00", "97.00", "1.00", "11", "11:15 pm on Aug 2, 2002");
            this.add(1, "Envy", ticketItem);
            ticketItem = new TicketItem("JawBreakers", "General Admission", "- NA -", "Aug 3, 2002", "Bottom of the Hill", "San Francisco, CA", "3489", "2", "30.00", "44.00", "2.00", "5", "11:30 pm on Jul 7, 2002");
            this.add(2, "JawBreakers", ticketItem);
            ticketItem = new TicketItem("Jets to Brazil", "General Admission", "- NA -", "Jul 19, 2001", "The Fillmore", "San Francisco, CA", "3861", "2", "55.00", "62.50", "2.50", "3", "6:30 pm on Jul 12, 2002");
            this.add(3, "Jets to Brazil", ticketItem);
            ticketItem = new TicketItem("Jets to Brazil", "4 & 6", "N2 Row 5", "Jul 18, 2002", "Mountain View Center for the Performing Arts", "Mountain View, CA", "9916", "2", "65.00", "200.00", "10.00", "12", "9:30 pm on Jul 10, 2002");
            this.add(3, "Jets to Brazil", ticketItem);
            ticketItem = new TicketItem("moby", "General Admission", "- NA -", "Aug 3, 2002", "Bottom of the Hill", "San Francisco", "1313", "2", "30.00", "37.00", "1.00", "7", "5:35 pm on Jul 27, 2002");
            this.add(4, "moby", ticketItem);
            ticketItem = new TicketItem("Nerf Herders", "N & O", "S, Row 14", "Aug 3, 2002", "3COM Park", "San Francisco, CA", "8120", "2", "80.00", "125.00", "2.00", "5", "11:30 am on Jul 7, 2002");
            this.add(5, "Nerf Herders", ticketItem);
            ticketItem = new TicketItem("The Mr. T Experience", "15 & 16", "B, Row 14", "Aug 30, 2002", "3COM Park", "San Francisco, CA", "1770", "2", "100.00", "175.00", "2.00", "5", "11:30 pm on Aug 23, 2002");
            this.add(6, "The Mr. T Experience", ticketItem);
            ticketItem = new TicketItem("Thirty Odd Foot of Grunts", "11 & 12", "F Row J", "Jul 19, 2001", "Stugg's Ampitheatre", "Austin, TX", "3766", "2", "60.00", "90.00", "5.00", "3", "6:30 pm on Jul 12, 2002");
            this.add(7, "Thirty Odd Foot of Grunts", ticketItem);
            ticketItem = new TicketItem("Thirty Odd Foot of Grunts", "4 & 6", "N2 Row 5", "Jul 18, 2002", "Seattle Thunderdome", "Seattle, WA", "9135", "2", "70.00", "200.00", "10.00", "12", "9:30 pm on Jul 10, 2002");
            this.add(7, "Thirty Odd Foot of Grunts", ticketItem);
            ticketItem = new TicketItem("Thirty Odd Foot of Grunts", "General Admission", "- NA -", "Jul 20, 2002", "The Fillmore", "San Francisco, CA", "2722", "2", "75.00", "110.00", "2.00", "12", "4:00 pm on Jul 13, 2002");
            this.add(7, "Thirty Odd Foot of Grunts", ticketItem);
        }

        void add(String string) {
            this.add(this.table.size(), string, new TicketItem(string));
        }

        void add(int n, String string) {
            this.add(n, string, new TicketItem(string));
        }

        void add(int n, String string, TicketItem ticketItem) {
            Object object = this.table.get(string);
            Vector<TicketItem> vector = object == null ? new Vector<TicketItem>() : (Vector)object;
            vector.addElement(ticketItem);
            this.table.put(n, vector);
        }

        void remove(int n) {
            this.table.remove(n);
        }

        String[] getList() {
            int n = this.table.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                Vector vector = (Vector)this.table.elementAt(i);
                TicketItem ticketItem = (TicketItem)vector.elementAt(0);
                stringArray[i] = ticketItem.name;
            }
            return stringArray;
        }

        String getName(int n) {
            TicketItem ticketItem;
            Vector vector = (Vector)this.table.elementAt(n);
            if (vector != null && (ticketItem = (TicketItem)vector.elementAt(0)) != null) {
                return ticketItem.name;
            }
            return null;
        }

        String[] getTicketList(String string) {
            Object object = this.table.get(string);
            if (object == null) {
                return null;
            }
            Vector vector = (Vector)object;
            int n = vector.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                TicketItem ticketItem = (TicketItem)vector.elementAt(i);
                stringArray[i] = new String("#" + ticketItem.id + " $" + ticketItem.curBid + "\n" + ticketItem.place + ", " + ticketItem.state + "\n" + ticketItem.sect + "," + ticketItem.seat + " ...");
            }
            return stringArray;
        }

        TicketItem getTicketItem(String string, int n) {
            Object object = this.table.get(string);
            if (object == null) {
                return null;
            }
            Vector vector = (Vector)object;
            return (TicketItem)vector.elementAt(n);
        }

        String getTicketID(String string, int n) {
            TicketItem ticketItem = this.getTicketItem(string, n);
            if (ticketItem == null) {
                return null;
            }
            return ticketItem.id;
        }

        String getTicketDataTitle(String string, int n) {
            TicketItem ticketItem = this.getTicketItem(string, n);
            if (ticketItem == null) {
                return null;
            }
            return ticketItem.name + " " + ticketItem.id + ":";
        }

        void getTicketData(Form form, String string, int n) {
            TicketItem ticketItem = this.getTicketItem(string, n);
            if (ticketItem == null) {
                return;
            }
            form.append((Item)new StringItem("Quantity:", ticketItem.numItem + " tickets"));
            form.append((Item)new StringItem("Bid starts at:", "$" + ticketItem.begBid));
            form.append((Item)new StringItem("Current bid:", "$" + ticketItem.curBid));
            form.append((Item)new StringItem("Number of Bids:", ticketItem.numBids));
            form.append((Item)new StringItem("Bidding ends at:", ticketItem.endsAt));
            form.append((Item)new StringItem("Seat(s):", ticketItem.seat));
            form.append((Item)new StringItem("Concert Date:", ticketItem.date));
            form.append((Item)new StringItem("Concert Venue:", ticketItem.place + "," + ticketItem.state));
        }

        void getAuctionData(Form form, String string, int n) {
            TicketItem ticketItem = this.getTicketItem(string, n);
            if (ticketItem == null) {
                return;
            }
            form.append((Item)new StringItem("Band Name:", ticketItem.name + " tickets"));
            form.append((Item)new StringItem("Concert Date:", ticketItem.date));
            form.append((Item)new StringItem("Quantity:", ticketItem.numItem));
            form.append((Item)new StringItem("Concert Venue:", ticketItem.place + "," + ticketItem.state));
        }

        String getCurrentBid(String string, int n) {
            TicketItem ticketItem = this.getTicketItem(string, n);
            if (ticketItem == null) {
                return "";
            }
            return ticketItem.curBid;
        }

        boolean isTicketData(String string, String string2) {
            return this.getTicketItem(string, string2) != null;
        }

        TicketItem getTicketItem(String string, String string2) {
            Object object = this.table.get(string);
            if (object == null) {
                return null;
            }
            Vector vector = (Vector)object;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                TicketItem ticketItem = (TicketItem)vector.elementAt(i);
                if (!ticketItem.id.equals(string2)) continue;
                return ticketItem;
            }
            return null;
        }

        void getTicketBidTitle(Form form, String string, int n) {
            TicketItem ticketItem = this.getTicketItem(string, n);
            long l = this.stringToLong1000(ticketItem.curBid) + this.stringToLong1000(ticketItem.incBid);
            String string2 = this.long1000ToString(l);
            NewTicketAuction.this.login.curBid.setText("$" + ticketItem.curBid);
            NewTicketAuction.this.login.incBid.setText("$" + ticketItem.incBid);
            NewTicketAuction.this.login.minBid.setText("$" + string2);
        }

        String toTickerString(boolean[] blArray) {
            String string = "";
            if (blArray == null) {
                return this.alt_ticker;
            }
            if (blArray[0]) {
                string = string + this.def_ticker;
            }
            if (blArray[1]) {
                // empty if block
            }
            if (blArray[2]) {
                // empty if block
            }
            if (blArray[3]) {
                if (string.length() > 0) {
                    string = string + " ";
                }
                string = string + this.alt_ticker;
            }
            if (blArray[4]) {
                // empty if block
            }
            if (blArray[5]) {
                // empty if block
            }
            return string;
        }

        long stringToLong1000(String string) {
            if (string == null || string.equals("")) {
                return 0L;
            }
            try {
                int n = string.indexOf(46);
                if (n == -1) {
                    return 1000L * (long)Integer.parseInt(string);
                }
                long l = 1000 * Integer.parseInt(string.substring(0, n));
                String string2 = string.substring(n + 1);
                int n2 = 0;
                switch (string2.length()) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 100;
                        break;
                    }
                    case 2: {
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        n2 = 1;
                    }
                }
                long l2 = n2 * Integer.parseInt(string2);
                return l + l2;
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }

        String long1000ToString(long l) {
            if (l == 0L) {
                return "0";
            }
            String string = String.valueOf(l);
            if (string.length() < 4) {
                return "0";
            }
            String string2 = string.substring(0, string.length() - 3) + "." + string.substring(string.length() - 2);
            return string2;
        }

        class BandListTable {
            private Vector vec = new Vector();

            BandListTable() {
            }

            void put(int n, Object object) {
                Object var3_3 = null;
                try {
                    var3_3 = this.vec.elementAt(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    var3_3 = null;
                }
                if (var3_3 == null) {
                    this.vec.addElement(object);
                } else {
                    this.vec.setElementAt(object, n);
                }
            }

            Object get(String string) {
                int n = this.vec.size();
                for (int i = 0; i < n; ++i) {
                    Object e = this.vec.elementAt(i);
                    if (!(e instanceof Vector)) continue;
                    Vector vector = (Vector)e;
                    TicketItem ticketItem = (TicketItem)vector.elementAt(0);
                    if (!ticketItem.name.equals(string)) continue;
                    return e;
                }
                return null;
            }

            Object elementAt(int n) {
                return this.vec.elementAt(n);
            }

            void remove(int n) {
                Object var2_2 = null;
                try {
                    var2_2 = this.vec.elementAt(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    var2_2 = null;
                }
                if (var2_2 != null) {
                    this.vec.removeElementAt(n);
                }
            }

            int size() {
                return this.vec.size();
            }
        }

        class TicketItem {
            String name;
            String seat;
            String sect;
            String date;
            String place;
            String state;
            String id;
            String numItem;
            String begBid;
            String curBid;
            String incBid;
            String numBids;
            String endsAt;

            TicketItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
                this.name = string;
                this.seat = string2;
                this.sect = string3;
                this.date = string4;
                this.place = string5;
                this.state = string6;
                this.id = string7;
                this.numItem = string8;
                this.begBid = string9;
                this.curBid = string10;
                this.incBid = string11;
                this.numBids = string12;
                this.endsAt = string13;
            }

            TicketItem(String string) {
                this(string, "n/a", "n/a", "n/a", "n/a", "n/a", "0", "0", "0", "0", "0", "0", "0");
            }
        }
    }

    class Login
    extends Form
    implements CommandListener {
        TextField id = new TextField("", "", 10, 0);
        TextField pd = new TextField("", "", 10, 65538);
        TextField bidText = new TextField("Enter Bid:", "", 10, 5);
        StringItem submitButton = new StringItem("", "Submit", 2);
        StringItem auctionHyperlink = new StringItem("Auction:", "", 1);
        StringItem curBid = new StringItem("Current Bid:", "");
        StringItem incBid = new StringItem("Increment:", "");
        StringItem minBid = new StringItem("Minimum Bid:", "");
        Form confirm = new Form("Confirm Bid");
        Form notice = new Form("Bid Received");
        Form auctionForm = new Form("dummy");
        Alert loginAlert = new Alert("Alert", "Your must enter your ID and password before you can proceed.", null, null);
        String bandName;
        String bid;
        String ticketID;
        String _bandName;
        int _bandIndex;

        Login() {
            super("Make A Bid");
            this.id.setLabel("Enter Auction ID:");
            this.append((Item)this.id);
            this.pd.setLabel("Enter PIN:");
            this.append((Item)this.pd);
            this.append((Item)this.curBid);
            this.append((Item)this.incBid);
            this.append((Item)this.minBid);
            this.append((Item)this.bidText);
            this.addCommand(BACK_CMD);
            this.addCommand(NEXT_CMD);
            this.setCommandListener(this);
            MyItemCommandListener myItemCommandListener = new MyItemCommandListener();
            this.confirm.append("dummy");
            this.confirm.addCommand(CANCEL_CMD);
            this.confirm.setCommandListener((CommandListener)this);
            this.auctionHyperlink.setDefaultCommand(AUCTION_CMD);
            this.auctionHyperlink.setItemCommandListener((ItemCommandListener)myItemCommandListener);
            this.submitButton.setDefaultCommand(SUBMIT_CMD);
            this.submitButton.setItemCommandListener((ItemCommandListener)myItemCommandListener);
            NewTicketAuction.this.deleteFormItem(this.notice);
            this.notice.append((Item)new StringItem("Your bid has been received:", ""));
            this.notice.append((Item)new StringItem("Confirm #:", "12-B455-31"));
            this.notice.addCommand(BAND_CMD);
            this.notice.setCommandListener((CommandListener)this);
            this.loginAlert.setTimeout(-2);
            this.auctionForm.append("dummy");
            this.auctionForm.addCommand(BACK_CMD);
            this.auctionForm.setCommandListener((CommandListener)this);
        }

        void setBid(String string, String string2) {
            this.bandName = string;
            this.bid = string2;
        }

        void setID(String string, String string2) {
            this.bandName = string;
            this.ticketID = string2;
        }

        void setBandAttributes(String string, int n) {
            this._bandName = string;
            this._bandIndex = n;
        }

        void doSubmit() {
            NewTicketAuction.this.TimerService = new Timer();
            TimerClient timerClient = new TimerClient();
            NewTicketAuction.this.TimerService.schedule((TimerTask)timerClient, 0L, 1000L);
            NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.submitMsg);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (displayable instanceof Form) {
                Form form = (Form)displayable;
                if (form == this) {
                    if (command == BACK_CMD) {
                        NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
                    } else if (command == NEXT_CMD) {
                        if (this.id.getString().length() == 0 || this.pd.getString().length() == 0) {
                            NewTicketAuction.this.display.setCurrent((Displayable)this.loginAlert);
                        } else {
                            NewTicketAuction.this.login.setID(this._bandName, NewTicketAuction.this.band.getTicketID(this._bandName, this._bandIndex));
                            String string = this.bidText.getString();
                            System.err.println("\n\n #### bidAmt : " + string);
                            if (string.equals("")) {
                                Alert alert = new Alert("Alert", "The bid amount you have entered is invalid.", null, AlertType.ERROR);
                                alert.setTimeout(-2);
                                NewTicketAuction.this.display.setCurrent((Displayable)alert);
                            } else {
                                NewTicketAuction.this.deleteFormItem(NewTicketAuction.this.login.confirm);
                                NewTicketAuction.this.login.confirm.append((Item)new StringItem("Please confirm this information is correct before submitting your bid", ""));
                                this.auctionHyperlink.setText(NewTicketAuction.this.login.ticketID);
                                NewTicketAuction.this.login.confirm.append((Item)this.auctionHyperlink);
                                NewTicketAuction.this.login.confirm.append((Item)new StringItem("Band: " + NewTicketAuction.this.login.bandName, ""));
                                NewTicketAuction.this.login.confirm.append((Item)new StringItem("Bid Amount:", "$" + string));
                                NewTicketAuction.this.login.confirm.append((Item)this.submitButton);
                                NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.login.confirm);
                            }
                        }
                    }
                } else if (form == this.confirm) {
                    if (command == CANCEL_CMD) {
                        NewTicketAuction.this.display.setCurrent((Displayable)this);
                    }
                } else if (form == this.notice) {
                    if (command == BAND_CMD) {
                        NewTicketAuction.this.display.setCurrent((Displayable)NewTicketAuction.this.band_ticket_Form);
                    }
                } else if (form == this.auctionForm && command == BACK_CMD) {
                    NewTicketAuction.this.display.setCurrent((Displayable)this.confirm);
                }
            }
        }

        private class TimerClient
        extends TimerTask {
            private TimerClient() {
            }

            public final void run() {
                if (((Login)Login.this).NewTicketAuction.this.submitGauge.getValue() == ((Login)Login.this).NewTicketAuction.this.submitGauge.getMaxValue()) {
                    ((Login)Login.this).NewTicketAuction.this.TimerService.cancel();
                    ((Login)Login.this).NewTicketAuction.this.submitGauge.setValue(0);
                    ((Login)Login.this).NewTicketAuction.this.display.setCurrent((Displayable)Login.this.notice);
                } else {
                    ((Login)Login.this).NewTicketAuction.this.submitGauge.setValue(((Login)Login.this).NewTicketAuction.this.submitGauge.getValue() + 10);
                }
            }
        }

        class MyItemCommandListener
        implements ItemCommandListener {
            MyItemCommandListener() {
            }

            public void commandAction(Command command, Item item) {
                if (command == SUBMIT_CMD) {
                    Login.this.doSubmit();
                } else if (command == AUCTION_CMD) {
                    NewTicketAuction.this.deleteFormItem(Login.this.auctionForm);
                    Login.this.auctionForm.setTitle("Auction:" + ((Login)Login.this).NewTicketAuction.this.login.ticketID);
                    ((Login)Login.this).NewTicketAuction.this.band.getAuctionData(Login.this.auctionForm, ((Login)Login.this).NewTicketAuction.this.login.bandName, ((Login)Login.this).NewTicketAuction.this.login._bandIndex);
                    ((Login)Login.this).NewTicketAuction.this.display.setCurrent((Displayable)Login.this.auctionForm);
                }
            }
        }
    }
}

