/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;

class SmallBall
implements Runnable {
    static Random random = new Random();
    public static boolean paused = false;
    private static final int DEFAULT_DELAY = 8;
    private static final int MIN_DELAY = 1;
    private static final int MAX_DELAY = 128;
    static int delay = 8;
    static int[][] matrix = new int[][]{{1, -1, -1, 1, 1, 1}, {-1, -1, 1, 1, -1, 1}, null, {1, 1, -1, -1, 1, -1}, {-1, 1, 1, -1, -1, -1}};
    int top;
    int left;
    int width;
    int height;
    int posX;
    int posY;
    int radius = 5;
    int ballSize = this.radius * 2;
    int deltaX;
    int deltaY;
    Graphics g;
    Canvas canvas;
    int note = 60;
    int clr = 0;
    public boolean stop;
    public boolean doRepaint;

    static void slower() {
        if ((delay *= 2) > 128) {
            delay = 128;
        }
    }

    static void faster() {
        if ((delay /= 2) < 1) {
            delay = 1;
        }
    }

    static int getSpeedPercent() {
        int n = 100;
        int n2 = delay;
        while (n2 > 8) {
            n2 /= 2;
            n -= 10;
        }
        while (n2 < 8) {
            n2 *= 2;
            n += 10;
        }
        return n;
    }

    SmallBall(Canvas canvas, int n, int n2, int n3, int n4) {
        this.canvas = canvas;
        this.left = n + 1;
        this.top = n2 + 1;
        this.width = n3 - (2 * this.radius + 2);
        this.height = n4 - (2 * this.radius + 2);
        this.posX = (random.nextInt() >>> 1) % (this.width - 20) + 10;
        this.posY = (random.nextInt() >>> 1) % (this.height - 20) + 10;
        this.deltaX = random.nextInt() & 1;
        this.deltaY = random.nextInt() & 1;
        if (this.deltaX == 0) {
            this.deltaX = -1;
        }
        if (this.deltaY == 0) {
            this.deltaY = -1;
        }
        this.stop = true;
    }

    public void setNote(int n) {
        this.note = n;
    }

    public void run() {
        int n = this.left + this.width;
        int n2 = this.top + this.height;
        while (!this.stop) {
            this.ballSize = this.radius * 2;
            int n3 = this.deltaX + this.deltaY;
            if (n3 == 0) {
                n3 = this.deltaX + 2 * this.deltaY;
            }
            int n4 = 0;
            if (this.posX <= this.left || this.posX >= n) {
                ++n4;
            }
            if (this.posY <= this.top || this.posY >= n2) {
                n4 += 2;
            }
            if (n4 != 0) {
                try {
                    Manager.playTone((int)this.note, (int)100, (int)100);
                }
                catch (Exception exception) {
                    System.out.println("failed to play tone");
                }
                n4 = (n4 - 1) * 2;
                this.deltaX = matrix[n3 + 2][n4];
                this.deltaY = matrix[n3 + 2][n4 + 1];
            }
            this.posX += this.deltaX;
            this.posY += this.deltaY;
            if (this.doRepaint) {
                this.canvas.repaint();
            }
            do {
                try {
                    Thread.sleep(paused ? 100L : (long)delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (paused && !this.stop);
        }
    }

    void paint(Graphics graphics) {
        graphics.setColor(this.clr);
        graphics.fillArc(this.posX, this.posY, this.ballSize, this.ballSize, 0, 360);
    }

    public void setColor(int n) {
        this.clr = n;
    }

    public String toString() {
        return super.toString() + " x = " + this.posX + ", y = " + this.posY;
    }
}

