/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.AudioPlayer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;

public class PlayerCanvas
extends Canvas
implements Runnable,
CommandListener {
    private static final String RECORD_STORE_NAME = "adrms";
    private Player player;
    private Thread dThread;
    private Object dThreadLock = new Object();
    private Object pauseLock = new Object();
    private boolean interrupted;
    private boolean paused;
    private Image logo = null;
    private Display parentDisplay;
    private Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command pauseCommand = new Command("Pause", 8, 10);
    private String title;
    private String url;
    private String mtime;

    public PlayerCanvas(Display display) {
        this.parentDisplay = display;
        this.initialize();
    }

    private void initialize() {
        this.addCommand(this.backCommand);
        this.addCommand(this.pauseCommand);
        this.setCommandListener(this);
        try {
            this.logo = Image.createImage((String)"/icons/logo.png");
        }
        catch (Exception exception) {
            this.logo = null;
        }
        if (this.logo == null) {
            System.out.println("can not load logo.png");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this) {
            if (command == this.backCommand) {
                this.stopSound();
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
                this.parentDisplay.setCurrent((Displayable)AudioPlayer.getList());
            } else if (command == this.playCommand) {
                this.playSound();
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
            } else if (command == this.pauseCommand) {
                this.pauseSound();
                this.removeCommand(this.pauseCommand);
                this.addCommand(this.playCommand);
            }
        }
    }

    public void setParam(String string) {
        this.url = string;
        int n = string.lastIndexOf(47);
        this.title = string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound() {
        if (this.title == null || this.url == null) {
            return;
        }
        if (this.player != null) {
            Object object = this.pauseLock;
            synchronized (object) {
                this.paused = false;
                this.pauseLock.notify();
            }
            try {
                this.player.start();
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
            return;
        }
        Object object = this.dThreadLock;
        synchronized (object) {
            this.stopSound();
            this.interrupted = false;
            this.paused = false;
            this.mtime = "";
            this.dThread = new Thread(this);
            this.dThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSound() {
        Object object = this.dThreadLock;
        synchronized (object) {
            try {
                this.interrupted = true;
                Object object2 = this.pauseLock;
                synchronized (object2) {
                    this.pauseLock.notify();
                }
                if (this.dThread != null) {
                    this.dThreadLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void pauseSound() {
        try {
            if (this.player != null) {
                this.player.stop();
                this.paused = true;
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public boolean isPlaying() {
        return this.player != null && this.player.getState() >= 400;
    }

    private static String guessContentType(String string) throws Exception {
        String string2;
        if (string.endsWith("wav")) {
            string2 = "audio/x-wav";
        } else if (string.endsWith("jts")) {
            string2 = "audio/x-tone-seq";
        } else if (string.endsWith("mid")) {
            string2 = "audio/midi";
        } else {
            throw new Exception("Cannot guess content type from URL: " + string);
        }
        return string2;
    }

    void createPlayer() {
        try {
            if (this.url.startsWith("http:")) {
                this.player = Manager.createPlayer((String)this.url);
            } else if (this.url.startsWith("resource")) {
                int n = this.url.indexOf(58);
                String string = this.url.substring(n + 1);
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                String string2 = PlayerCanvas.guessContentType(this.url);
                this.player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            } else if (this.url.startsWith("rms:")) {
                String string;
                boolean bl = false;
                ByteArrayInputStream byteArrayInputStream = null;
                while (byteArrayInputStream == null) {
                    try {
                        string = RecordStore.openRecordStore((String)RECORD_STORE_NAME, (boolean)false);
                        byte[] byArray = string.getRecord(1);
                        string.closeRecordStore();
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        break;
                    }
                    catch (Exception exception) {
                        if (bl) {
                            throw new Exception("Could not create and open record store!");
                        }
                        bl = true;
                        this.createMyRecordStore(this.url, RECORD_STORE_NAME);
                    }
                }
                string = PlayerCanvas.guessContentType(this.url);
                this.player = Manager.createPlayer(byteArrayInputStream, (String)string);
            }
            this.player.setLoopCount(-1);
        }
        catch (Exception exception) {
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
            Alert alert = new Alert("Warning", "Cannot create player", null, null);
            alert.setTimeout(1000);
            this.parentDisplay.setCurrent((Displayable)alert);
        }
    }

    private void createMyRecordStore(String string, String string2) {
        try {
            int n;
            int n2 = string.indexOf(58);
            String string3 = string.substring(n2 + 1);
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, 1024)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            inputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)string2, (boolean)true);
            recordStore.addRecord(byArray2, 0, byArray2.length);
            recordStore.closeRecordStore();
            System.out.println("created record store '" + string2 + "' with contents of " + string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(0xFF7F00);
        graphics.drawString("Audio Player", n / 2, 8, 17);
        if (this.logo != null) {
            graphics.drawImage(this.logo, n / 2, 30, 17);
        }
        graphics.setColor(0xFF7F00);
        graphics.drawString("Audio Player", n / 2, 8, 17);
        graphics.drawString(this.title, n / 2, 84, 17);
        graphics.drawString(this.mtime, 0, 150, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.createPlayer();
        if (this.player == null) {
            Object object = this.dThreadLock;
            synchronized (object) {
                this.dThread = null;
                this.dThreadLock.notify();
                return;
            }
        }
        try {
            this.player.realize();
            long l = this.player.getDuration();
            if (l != -1L) {
                this.title = this.title + " [" + this.timeFM(l) + "]";
            }
            this.player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!this.interrupted) {
            try {
                this.mtime = this.timeFM(this.player.getMediaTime());
                this.repaint(0, 110, 100, 170);
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = this.pauseLock;
            synchronized (object) {
                if (this.paused) {
                    try {
                        this.pauseLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.player.close();
        this.player = null;
        Object object = this.dThreadLock;
        synchronized (object) {
            this.dThread = null;
            this.dThreadLock.notify();
        }
    }

    protected void keyPressed(int n) {
        switch (n) {
            case 42: {
                this.changeVolume(-10);
                break;
            }
            case 35: {
                this.changeVolume(10);
            }
        }
    }

    private void changeVolume(int n) {
        VolumeControl volumeControl;
        if (this.player != null && (volumeControl = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            int n2 = volumeControl.getLevel();
            n2 += n;
            n2 = volumeControl.setLevel(n2);
        }
    }

    private String timeFM(long l) {
        String string = "";
        int n = (int)(l / 1000L);
        int n2 = n / 1000;
        int n3 = n2 / 60;
        string = n3 >= 10 ? string + n3 + ":" : (n3 > 0 ? "0" + n3 + ":" : "00:");
        string = n2 >= 10 ? string + n2 + "." : (n2 > 0 ? string + "0" + n2 + "." : string + "00.");
        n = n % 1000 / 100;
        string = string + n;
        return string;
    }
}

