/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.MixCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class MixTest
extends MIDlet
implements CommandListener,
Runnable {
    private static final String[] mcases = new String[]{"Tone+Wav", "Tone+ToneSeq", "ToneSeq+Wav"};
    static String wavUrl;
    private static MixCanvas soundObj;
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Display display;
    private static List theList;
    private static MixTest instance;
    private boolean firstTime = true;
    private boolean restartOnResume = false;

    public static MixTest getInstance() {
        return instance;
    }

    public static List getList() {
        return theList;
    }

    public MixTest() {
        instance = this;
        this.display = Display.getDisplay((MIDlet)this);
        theList = new List("Lists", 3);
        for (int i = 0; i < mcases.length; ++i) {
            theList.append(mcases[i], null);
        }
        wavUrl = this.getAppProperty("MixTestURL");
        theList.addCommand(this.playCommand);
        theList.addCommand(this.exitCommand);
        theList.setCommandListener((CommandListener)this);
        soundObj = new MixCanvas(this.display);
    }

    public void startApp() {
        if (this.firstTime) {
            this.display.setCurrent((Displayable)theList);
            this.firstTime = false;
        } else {
            if (soundObj != null && this.restartOnResume) {
                soundObj.playSound();
            }
            this.restartOnResume = false;
        }
    }

    public void pauseApp() {
        boolean bl = this.restartOnResume = soundObj != null && soundObj.isPlaying();
        if (this.restartOnResume) {
            soundObj.pauseSound();
        }
    }

    public void destroyApp(boolean bl) {
        if (soundObj != null) {
            soundObj.stopSound();
        }
        soundObj = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (displayable == theList && command == List.SELECT_COMMAND || command == this.playCommand) {
            int n = theList.getSelectedIndex();
            soundObj.setIndex(n);
            this.display.setCurrent((Displayable)soundObj);
            soundObj.serviceRepaints();
            new Thread(this).start();
        }
    }

    public void run() {
        if (soundObj != null) {
            soundObj.playSound();
        }
    }

    static {
        soundObj = null;
        instance = null;
    }
}

