/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.MixTest;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class MixCanvas
extends Canvas
implements CommandListener {
    private static final String TITLE_TEXT = "Mix Demo";
    private static final int[] notes = new int[]{69, 70, 71, 72, 73, 74, 75, 76};
    static Player wavPlayer = null;
    static Player tonePlayer = null;
    static Image logo = null;
    private int idx = 0;
    private int ip = 0;
    Display parentDisplay;
    private Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command pauseCommand = new Command("Pause", 8, 1);
    private Command toneCommand = new Command("Tone", 8, 1);
    private Alert alert;
    private boolean stopSound = false;

    public MixCanvas(Display display) {
        this.parentDisplay = display;
        this.initialize();
    }

    void initialize() {
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        try {
            logo = Image.createImage((String)"/icons/logo.png");
        }
        catch (Exception exception) {
            logo = null;
        }
        if (logo == null) {
            System.out.println("can not load logo.png");
        }
        this.alert = new Alert("Warning", "Can not create player", null, null);
        this.alert.setTimeout(1000);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this) {
            if (command == this.backCommand) {
                this.stopSound();
                this.parentDisplay.setCurrent((Displayable)MixTest.getList());
            } else if (command == this.toneCommand) {
                try {
                    Manager.playTone((int)notes[this.ip], (int)1000, (int)100);
                    ++this.ip;
                    if (this.ip >= 8) {
                        this.ip = 0;
                    }
                }
                catch (Exception exception) {
                    System.out.println("get an exception for tone");
                }
            } else if (command == this.playCommand) {
                this.playSound();
            } else if (command == this.pauseCommand) {
                this.pauseSound();
            }
        }
    }

    public void setIndex(int n) {
        this.idx = n;
    }

    private void createWavPlayer() {
        try {
            if (wavPlayer == null) {
                if (MixTest.wavUrl.startsWith("resource")) {
                    int n = MixTest.wavUrl.indexOf(58);
                    String string = MixTest.wavUrl.substring(n + 1);
                    InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
                    String string2 = MixCanvas.guessContentType(MixTest.wavUrl);
                    wavPlayer = Manager.createPlayer((InputStream)inputStream, (String)string2);
                } else {
                    wavPlayer = Manager.createPlayer((String)MixTest.wavUrl);
                }
                wavPlayer.setLoopCount(-1);
            }
            if (this.stopSound) {
                return;
            }
            wavPlayer.start();
        }
        catch (Exception exception) {
            if (wavPlayer != null) {
                wavPlayer.close();
                wavPlayer = null;
            }
            this.parentDisplay.setCurrent((Displayable)this.alert);
        }
    }

    private static String guessContentType(String string) throws Exception {
        String string2;
        if (string.endsWith("wav")) {
            string2 = "audio/x-wav";
        } else if (string.endsWith("jts")) {
            string2 = "audio/x-tone-seq";
        } else if (string.endsWith("mid")) {
            string2 = "audio/midi";
        } else {
            throw new Exception("Cannot guess content type from URL: " + string);
        }
        return string2;
    }

    private void createTonePlayer() {
        byte by = 8;
        byte by2 = 60;
        byte by3 = 62;
        byte by4 = 64;
        byte by5 = 67;
        byte by6 = -1;
        byte[] byArray = new byte[]{-2, 1, -3, 30, -5, 0, by4, by, by3, by, by2, by, by3, by, by4, by, by4, by, by4, by, by6, by, -6, 0, -7, 0, by3, by, by3, by, by3, by, by6, by, by4, by, by5, by, by5, by, by6, by, -7, 0, by3, by, by3, by, by4, by, by3, by, by2, by, by6, by};
        try {
            if (tonePlayer == null) {
                tonePlayer = Manager.createPlayer((String)"device://tone");
                tonePlayer.setLoopCount(-1);
                tonePlayer.realize();
                ToneControl toneControl = (ToneControl)tonePlayer.getControl("javax.microedition.media.control.ToneControl");
                toneControl.setSequence(byArray);
            }
            if (tonePlayer != null && !this.stopSound) {
                tonePlayer.start();
            }
        }
        catch (Exception exception) {
            if (tonePlayer != null) {
                tonePlayer.close();
                tonePlayer = null;
            }
            this.parentDisplay.setCurrent((Displayable)this.alert);
        }
    }

    public void playSound() {
        this.stopSound = false;
        switch (this.idx) {
            case 0: {
                this.addCommand(this.toneCommand);
                this.removeCommand(this.pauseCommand);
                this.removeCommand(this.playCommand);
                this.createWavPlayer();
                break;
            }
            case 1: {
                this.addCommand(this.toneCommand);
                this.removeCommand(this.pauseCommand);
                this.removeCommand(this.playCommand);
                this.createTonePlayer();
                break;
            }
            case 2: {
                this.removeCommand(this.playCommand);
                this.removeCommand(this.toneCommand);
                this.addCommand(this.pauseCommand);
                this.createWavPlayer();
                this.createTonePlayer();
            }
        }
    }

    public void stopSound() {
        this.stopSound = true;
        if (tonePlayer != null) {
            tonePlayer.close();
            tonePlayer = null;
        }
        if (wavPlayer != null) {
            wavPlayer.close();
            wavPlayer = null;
        }
        this.removeCommand(this.toneCommand);
        this.removeCommand(this.pauseCommand);
        this.removeCommand(this.playCommand);
    }

    public void pauseSound() {
        this.removeCommand(this.pauseCommand);
        this.addCommand(this.playCommand);
        try {
            if (wavPlayer != null) {
                wavPlayer.stop();
            }
        }
        catch (MediaException mediaException) {
            System.err.println((Object)mediaException);
        }
        try {
            if (tonePlayer != null) {
                tonePlayer.stop();
            }
        }
        catch (MediaException mediaException) {
            System.err.println((Object)mediaException);
        }
    }

    public boolean isPlaying() {
        return tonePlayer != null && tonePlayer.getState() >= 400 || wavPlayer != null && wavPlayer.getState() >= 400;
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        String string = "";
        switch (this.idx) {
            case 0: {
                string = "test-wav.wav";
                break;
            }
            case 1: {
                string = "tone seq";
                break;
            }
            case 2: {
                string = "wave+toneseq";
            }
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n2);
        if (logo != null) {
            graphics.drawImage(logo, n / 2, 30, 17);
        }
        graphics.setColor(0xFF7F00);
        graphics.drawString(TITLE_TEXT, n / 2, 8, 17);
        graphics.drawString(string, 0, 84, 20);
    }

    protected void keyPressed(int n) {
        switch (n) {
            case 42: {
                this.changeVolume(-10);
                break;
            }
            case 35: {
                this.changeVolume(10);
            }
        }
    }

    private void changeVolume(int n) {
        int n2;
        VolumeControl volumeControl;
        if (wavPlayer != null && (volumeControl = (VolumeControl)wavPlayer.getControl("VolumeControl")) != null) {
            n2 = volumeControl.getLevel();
            n2 += n;
            n2 = volumeControl.setLevel(n2);
        }
        if (tonePlayer != null && (volumeControl = (VolumeControl)tonePlayer.getControl("VolumeControl")) != null) {
            n2 = volumeControl.getLevel();
            n2 += n;
            n2 = volumeControl.setLevel(n2);
        }
    }
}

