/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.BBall;
import example.audiodemo.SmallBall;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;

public class BallCanvas
extends Canvas
implements CommandListener {
    private BBall midlet;
    private Player player;
    private int[] notes = new int[]{68, 72, 70, 74, 76, 80, 56, 58};
    private int[] colors = new int[]{255, 65280, 0xFF0000, 65535, 0xFF00FF, 0xFF8080, 0x80FF80, 0x8080FF};
    private SmallBall[] balls;
    private int numBalls;
    private int width;
    private int height;
    private boolean paused;
    private Command backCommand = new Command("Back", 2, 1);
    private Command pauseCommand = new Command("Pause", 2, 1);
    private Command playCommand = new Command("Play", 2, 1);
    private boolean playerCreated;
    private int currBackground = -1;

    public BallCanvas(BBall bBall) {
        this.midlet = bBall;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.balls = null;
        this.numBalls = 0;
        this.paused = true;
        this.addCommand(this.backCommand);
        this.addCommand(this.pauseCommand);
        this.setCommandListener(this);
    }

    public synchronized void init(int n, int n2) {
        if (n < 1) {
            n = 1;
        } else if (n > this.notes.length) {
            n = this.notes.length;
        }
        if (this.balls == null || this.player == null || this.balls.length != n || this.currBackground != n2) {
            this.destroy();
            this.balls = new SmallBall[n];
            this.currBackground = n2;
            this.playerCreated = this.initPlayer(n2);
        }
        this.numBalls = 0;
        this.pause();
        this.makeNumberOfBalls(2);
    }

    boolean needAlert() {
        return !this.playerCreated;
    }

    private static String guessContentType(String string) throws Exception {
        String string2;
        if (string.endsWith("wav")) {
            string2 = "audio/x-wav";
        } else if (string.endsWith("jts")) {
            string2 = "audio/x-tone-seq";
        } else if (string.endsWith("mid")) {
            string2 = "audio/midi";
        } else {
            throw new Exception("Cannot guess content type from URL: " + string);
        }
        return string2;
    }

    private void createPlayer(String string) throws Exception {
        if (string.startsWith("resource")) {
            int n = string.indexOf(58);
            String string2 = string.substring(n + 1);
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string2);
            String string3 = BallCanvas.guessContentType(string);
            this.player = Manager.createPlayer((InputStream)inputStream, (String)string3);
        } else {
            this.player = Manager.createPlayer((String)string);
        }
    }

    private boolean initPlayer(int n) {
        try {
            switch (n) {
                case 1: {
                    this.createPlayer(BBall.wavbgUrl);
                    break;
                }
                case 2: {
                    byte by = 8;
                    byte by2 = 60;
                    byte by3 = 62;
                    byte by4 = 64;
                    byte by5 = 67;
                    byte by6 = -1;
                    byte[] byArray = new byte[]{-2, 1, -3, 30, -5, 0, by4, by, by3, by, by2, by, by3, by, by4, by, by4, by, by4, by, by6, by, -6, 0, -7, 0, by3, by, by3, by, by3, by, by6, by, by4, by, by5, by, by5, by, by6, by, -7, 0, by3, by, by3, by, by4, by, by3, by, by2, by, by6, by};
                    this.player = Manager.createPlayer((String)"device://tone");
                    this.player.realize();
                    ToneControl toneControl = (ToneControl)this.player.getControl("ToneControl");
                    toneControl.setSequence(byArray);
                    break;
                }
                case 3: {
                    this.createPlayer(BBall.midbgUrl);
                    break;
                }
                default: {
                    this.player = null;
                }
            }
            if (this.player != null) {
                this.player.setLoopCount(-1);
                this.player.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.player != null) {
                this.player.close();
            }
            this.player = null;
            return false;
        }
        return true;
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.width - 1, this.height - 1);
        graphics.setColor(0);
        graphics.drawRect(1, 1, this.width - 2, this.height - 2);
        for (int i = 0; i < this.numBalls; ++i) {
            if (this.balls[i] == null) continue;
            this.balls[i].paint(graphics);
        }
    }

    private void makeNumberOfBalls(int n) {
        if (this.balls != null) {
            if (n > this.balls.length) {
                n = this.balls.length;
            } else if (n < 1) {
                n = 1;
            }
            if (n != this.numBalls) {
                int n2;
                this.numBalls = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    if (this.balls[n2] == null) {
                        this.balls[n2] = new SmallBall(this, 0, 0, this.width, this.height - 12);
                        this.balls[n2].setNote(this.notes[n2]);
                        this.balls[n2].setColor(this.colors[n2]);
                    }
                    if (this.paused || !this.balls[n2].stop) continue;
                    this.balls[n2].stop = false;
                    new Thread(this.balls[n2]).start();
                }
                for (n2 = n; n2 < this.balls.length; ++n2) {
                    if (this.balls[n2] == null) continue;
                    this.balls[n2].stop = true;
                    this.balls[n2] = null;
                }
                this.numBalls = n;
                if (n > 0) {
                    this.balls[0].doRepaint = true;
                }
            }
        }
    }

    synchronized void destroy() {
        this.numBalls = 0;
        this.pause();
        this.balls = null;
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        if (!this.paused) {
            BallCanvas ballCanvas = this;
            synchronized (ballCanvas) {
                this.paused = true;
                for (int i = 0; i < this.balls.length; ++i) {
                    if (this.balls[i] == null) continue;
                    this.balls[i].stop = true;
                }
                try {
                    if (this.player != null) {
                        this.player.stop();
                    }
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (this.paused) {
            BallCanvas ballCanvas = this;
            synchronized (ballCanvas) {
                this.paused = false;
                if (this.balls != null) {
                    for (int i = 0; i < this.balls.length; ++i) {
                        if (this.balls[i] == null) continue;
                        this.balls[i].stop = false;
                        new Thread(this.balls[i]).start();
                    }
                }
                if (this.player != null) {
                    try {
                        this.player.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.repaint();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.destroy();
            this.midlet.displayList();
        } else if (command == this.pauseCommand) {
            this.pause();
            this.removeCommand(this.pauseCommand);
            this.addCommand(this.playCommand);
        } else if (command == this.playCommand) {
            this.removeCommand(this.playCommand);
            this.addCommand(this.pauseCommand);
            this.start();
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.makeNumberOfBalls(this.numBalls - 1);
                break;
            }
            case 5: {
                this.makeNumberOfBalls(this.numBalls + 1);
                break;
            }
            case 1: {
                SmallBall.faster();
                break;
            }
            case 6: {
                SmallBall.slower();
            }
        }
        this.repaint();
    }
}

