/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.BallCanvas;
import example.audiodemo.SmallBall;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class BBall
extends MIDlet
implements CommandListener,
Runnable {
    private static final String[] bgs = new String[]{"no background", "wave background", "tone seq background", "MIDI background"};
    static String wavbgUrl;
    static String midbgUrl;
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Display display = Display.getDisplay((MIDlet)this);
    private int idx = 0;
    private List theList = new List("Bouncing Ball", 3);
    private static final Object gameLock;
    private BallCanvas game;
    private boolean firstTime = true;
    private boolean restartOnResume = false;

    public BBall() {
        for (int i = 0; i < bgs.length; ++i) {
            this.theList.append(bgs[i], null);
        }
        wavbgUrl = this.getAppProperty("BBall-wav-URL");
        midbgUrl = this.getAppProperty("BBall-MIDI-URL");
        this.theList.addCommand(this.playCommand);
        this.theList.addCommand(this.exitCommand);
        this.theList.setCommandListener((CommandListener)this);
    }

    public void displayList() {
        this.display.setCurrent((Displayable)this.theList);
    }

    public void startApp() {
        if (this.firstTime) {
            this.displayList();
            this.firstTime = false;
        } else {
            SmallBall.paused = false;
            if (this.game != null && this.restartOnResume) {
                this.game.start();
            }
            this.restartOnResume = false;
        }
    }

    public void pauseApp() {
        SmallBall.paused = true;
        boolean bl = this.restartOnResume = this.game != null && !this.game.isPaused();
        if (this.restartOnResume) {
            this.game.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApp(boolean bl) {
        Object object = gameLock;
        synchronized (object) {
            if (this.game != null) {
                this.game.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            Object object = gameLock;
            synchronized (object) {
                if (this.game != null) {
                    this.game.destroy();
                    this.game = null;
                }
            }
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (displayable == this.theList && command == List.SELECT_COMMAND || command == this.playCommand) {
            this.idx = this.theList.getSelectedIndex();
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = gameLock;
        synchronized (object) {
            if (this.game == null) {
                this.game = new BallCanvas(this);
            }
            this.display.setCurrent((Displayable)this.game);
            this.game.init(8, this.idx);
            if (this.game.needAlert()) {
                Alert alert = new Alert("Warning", "Cannot create player", null, null);
                alert.setTimeout(1000);
                this.display.setCurrent(alert, (Displayable)this.game);
            }
            this.game.start();
        }
    }

    static {
        gameLock = new Object();
    }
}

