/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.PlayerCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;

public class AudioPlayer
extends MIDlet
implements CommandListener {
    private static PlayerCanvas playerGUI = null;
    private static List theList;
    private static Vector urls;
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Display display = Display.getDisplay((MIDlet)this);
    private boolean restartOnResume = false;

    public AudioPlayer() {
        this.initPlayList();
        this.display.setCurrent((Displayable)theList);
    }

    public static List getList() {
        return theList;
    }

    public void startApp() {
        if (playerGUI != null && this.restartOnResume) {
            playerGUI.playSound();
        }
        this.restartOnResume = false;
    }

    public void pauseApp() {
        boolean bl = this.restartOnResume = playerGUI != null && playerGUI.isPlaying();
        if (this.restartOnResume) {
            playerGUI.pauseSound();
        }
    }

    public void destroyApp(boolean bl) {
        if (playerGUI != null) {
            playerGUI.stopSound();
            playerGUI = null;
        }
        this.display.setCurrent(null);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (displayable == theList && command == List.SELECT_COMMAND || command == this.playCommand) {
            int n = theList.getSelectedIndex();
            if (n == 0) {
                try {
                    Manager.playTone((int)60, (int)200, (int)90);
                }
                catch (MediaException mediaException) {
                    System.out.println("can't play tone");
                }
            } else if (n > 0) {
                if (playerGUI == null) {
                    playerGUI = new PlayerCanvas(this.display);
                } else {
                    playerGUI.stopSound();
                }
                playerGUI.setParam((String)urls.elementAt(n));
                playerGUI.playSound();
                this.display.setCurrent((Displayable)playerGUI);
            }
        }
    }

    private void initPlayList() {
        String string;
        String string2;
        urls = new Vector();
        theList = new List("MIDP Audio Player", 3);
        for (int i = 1; i < 32 && (string2 = this.getAppProperty(string = "PlayerURL-" + i)) != null && string2.length() != 0; ++i) {
            String string3 = "PlayerTitle-" + i;
            String string4 = this.getAppProperty(string3);
            if (string4 == null || string4.length() == 0) {
                string4 = string2;
            }
            urls.addElement(string2);
            theList.append(string4, null);
        }
        theList.addCommand(this.exitCommand);
        theList.addCommand(this.playCommand);
        theList.setCommandListener((CommandListener)this);
    }
}

