/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.wma.sms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.Message;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import com.sun.kvem.wma.WMAConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SendSMSDialog
extends JDialog {
    private static Debug debug = Debug.create((Class)SendSMSDialog.class);
    private static final int CLIENT_LIST_REFRESH_DELAY_MS = 2000;
    private static final int MESSAGE_AREA_WIDTH_IN_CHARS = 45;
    private WMAConsole console;
    private PrintStream textOut;
    private boolean isSMS;
    private JTabbedPane tabs;
    private JPanel textTab;
    private JPanel binaryTab;
    private String titleBase;
    private JList binaryList;
    private JList textList;
    private DefaultListModel registeredClients;
    private List additionalClients;
    private JButton binaryAddClients;
    private JButton textAddClients;
    private WMAConsole.PositiveIntField binarySMSPortField;
    private WMAConsole.PositiveIntField textSMSPortField;
    private WMAConsole.PositiveIntField binaryCBSPortField;
    private WMAConsole.PositiveIntField textCBSPortField;
    private JTextField fileName;
    private JButton browseButton;
    private JFileChooser browser;
    private JPanel textSMSAddressPane;
    private JPanel binarySMSAddressPane;
    private JPanel textCBSAddressPane;
    private JPanel binaryCBSAddressPane;
    private JTextArea messageArea;
    private JPanel textPane;
    private JPanel binaryPane;
    private JPanel buttonPane;
    private JButton clearMsgButton;
    private JButton clearFileNameButton;
    private JButton sendButton;
    private JButton cancelButton;
    private Thread pollerThread = null;
    private static final String I18N_TITLE = ToolkitResources.getString((String)"WMA_CONSOLE.TITLE");
    private static final String I18N_TEXT = ToolkitResources.getString((String)"WMA_CONSOLE.TEXT");
    private static final String I18N_BINARY = ToolkitResources.getString((String)"WMA_CONSOLE.BINARY");
    private JComponent content;

    public SendSMSDialog(WMAConsole wMAConsole, PrintStream printStream) {
        super((Frame)wMAConsole, "");
        this.console = wMAConsole;
        this.textOut = printStream;
        this.titleBase = ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.TITLE");
        this.registeredClients = new DefaultListModel();
        this.additionalClients = new Vector();
        this.initUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExtraClient(String string) {
        if (string != null) {
            DefaultListModel defaultListModel = this.registeredClients;
            synchronized (defaultListModel) {
                this.registeredClients.insertElementAt(string, this.additionalClients.size());
                this.additionalClients.add(string);
            }
            if (this.textTab.isVisible()) {
                this.textList.setSelectedValue(string, true);
            } else {
                this.binaryList.setSelectedValue(string, true);
            }
        }
    }

    private void initUI() {
        this.binaryList = new JList(this.registeredClients);
        this.textList = new JList(this.registeredClients);
        this.tabs = new JTabbedPane();
        this.textTab = new JPanel();
        this.binaryTab = new JPanel();
        this.binaryAddClients = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.ADD_CLIENTS"));
        this.binaryAddClients.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.ADD_CLIENTS_SHORTCUT").charAt(0));
        this.textAddClients = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.ADD_CLIENTS"));
        this.textAddClients.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.ADD_CLIENTS_SHORTCUT").charAt(0));
        this.fileName = new JTextField();
        this.browseButton = new JButton(ToolkitResources.getString((String)"BROWSE"));
        this.browseButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.BROWSE_SHORTCUT").charAt(0));
        this.browser = new JFileChooser();
        JLabel jLabel = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SMS_PORT_LABEL"));
        JLabel jLabel2 = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SMS_PORT_LABEL"));
        JLabel jLabel3 = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CBS_PORT_LABEL"));
        JLabel jLabel4 = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CBS_PORT_LABEL"));
        this.binarySMSPortField = new WMAConsole.PositiveIntField(5);
        this.textSMSPortField = new WMAConsole.PositiveIntField(5);
        this.binaryCBSPortField = new WMAConsole.PositiveIntField(5);
        this.textCBSPortField = new WMAConsole.PositiveIntField(5);
        this.sendButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SEND"));
        this.sendButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SEND_SHORTCUT").charAt(0));
        this.cancelButton = new JButton(ToolkitResources.getString((String)"CANCEL"));
        this.cancelButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CANCEL_SHORTCUT").charAt(0));
        this.clearMsgButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CLEAR"));
        this.clearMsgButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CLEAR_SHORTCUT").charAt(0));
        this.clearMsgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendSMSDialog.this.messageArea.setText("");
            }
        });
        this.clearFileNameButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CLEAR"));
        this.clearFileNameButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CLEAR_SHORTCUT").charAt(0));
        this.clearFileNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendSMSDialog.this.fileName.setText("");
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendSMSDialog.this.setVisible(false);
            }
        });
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SendSMSDialog.access$300(4.access$200(this.this$1));
                    }
                }).start();
            }

            static /* synthetic */ SendSMSDialog access$200(4 var0) {
                return var0.SendSMSDialog.this;
            }
        });
        final AddClientsDialog addClientsDialog = new AddClientsDialog();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                addClientsDialog.setVisible(true);
                addClientsDialog.toFront();
                addClientsDialog.pack();
                WindowUtils.center((Window)addClientsDialog, null);
            }
        };
        this.textAddClients.addActionListener(actionListener);
        this.binaryAddClients.addActionListener(actionListener);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.textTab.setLayout(gridBagLayout);
        this.binaryTab.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.textSMSAddressPane = this.makeAddressPane(this.textList, this.textAddClients, jLabel2, this.textSMSPortField);
        gridBagLayout.setConstraints(this.textSMSAddressPane, gridBagConstraints);
        this.textTab.add(this.textSMSAddressPane);
        this.textCBSAddressPane = new JPanel();
        this.textCBSAddressPane.setLayout(new BoxLayout(this.textCBSAddressPane, 1));
        this.textCBSAddressPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 0));
        jLabel4.setAlignmentX(0.0f);
        this.textCBSAddressPane.add(jLabel4);
        this.textCBSPortField.setAlignmentX(0.0f);
        Dimension dimension = this.textCBSPortField.getPreferredSize();
        this.textCBSPortField.setMaximumSize(dimension);
        this.textCBSPortField.setMinimumSize(dimension);
        this.textCBSAddressPane.add(this.textCBSPortField);
        gridBagLayout.setConstraints(this.textCBSAddressPane, gridBagConstraints);
        this.textTab.add(this.textCBSAddressPane);
        this.binarySMSAddressPane = this.makeAddressPane(this.binaryList, this.binaryAddClients, jLabel, this.binarySMSPortField);
        gridBagLayout2.setConstraints(this.binarySMSAddressPane, gridBagConstraints);
        this.binaryTab.add(this.binarySMSAddressPane);
        this.binaryCBSAddressPane = new JPanel();
        this.binaryCBSAddressPane.setLayout(new BoxLayout(this.binaryCBSAddressPane, 1));
        this.binaryCBSAddressPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 0));
        jLabel3.setAlignmentX(0.0f);
        this.binaryCBSAddressPane.add(jLabel3);
        Dimension dimension2 = this.binaryCBSPortField.getPreferredSize();
        this.binaryCBSPortField.setMaximumSize(dimension2);
        this.binaryCBSPortField.setMinimumSize(dimension2);
        this.binaryCBSPortField.setAlignmentX(0.0f);
        this.binaryCBSAddressPane.add(this.binaryCBSPortField);
        gridBagLayout2.setConstraints(this.binaryCBSAddressPane, gridBagConstraints);
        this.binaryTab.add(this.binaryCBSAddressPane);
        this.messageArea = new JTextArea(5, 45);
        JScrollPane jScrollPane = new JScrollPane(this.messageArea);
        jScrollPane.setAlignmentX(0.5f);
        this.textPane = new JPanel();
        this.textPane.setLayout(new BorderLayout());
        this.textPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.MESSAGE")));
        this.textPane.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.clearMsgButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setAlignmentX(0.5f);
        this.textPane.add((Component)jPanel, "South");
        this.textPane.setAlignmentX(0.5f);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.textPane, gridBagConstraints);
        this.textTab.add(this.textPane);
        this.binaryPane = new JPanel();
        this.binaryPane.setLayout(new BoxLayout(this.binaryPane, 1));
        this.binaryPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel5 = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.BROWSE_LABEL"));
        jLabel5.setAlignmentX(0.0f);
        this.binaryPane.add(jLabel5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        Dimension dimension3 = this.fileName.getPreferredSize();
        this.fileName.setMaximumSize(new Dimension(Short.MAX_VALUE, dimension3.height));
        this.fileName.setPreferredSize(new Dimension(300, dimension3.height));
        this.fileName.setMinimumSize(new Dimension(300, dimension3.height));
        jPanel2.add(this.fileName);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.clearFileNameButton);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.browseButton);
        jPanel2.setAlignmentX(0.0f);
        this.binaryPane.add(jPanel2);
        this.binaryPane.setAlignmentX(0.5f);
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.binaryPane, gridBagConstraints);
        this.binaryTab.add(this.binaryPane);
        final SendSMSDialog sendSMSDialog = this;
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SendSMSDialog.this.browser.showOpenDialog(sendSMSDialog);
                if (n == 0) {
                    try {
                        SendSMSDialog.this.fileName.setText(SendSMSDialog.this.browser.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.buttonPane.add(Box.createHorizontalGlue());
        this.buttonPane.add(this.sendButton);
        this.buttonPane.add(Box.createRigidArea(new Dimension(15, 0)));
        this.buttonPane.add(this.cancelButton);
        this.buttonPane.add(Box.createHorizontalGlue());
        this.buttonPane.setAlignmentX(0.5f);
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
        this.content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.content);
        this.content.add(this.tabs);
        this.tabs.addTab(I18N_TEXT, this.textTab);
        this.tabs.addTab(I18N_BINARY, this.binaryTab);
        this.content.add((Component)this.buttonPane, "South");
    }

    private JPanel makeAddressPane(JList jList, JButton jButton, JLabel jLabel, JTextField jTextField) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 5, 0));
        JLabel jLabel2 = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SEND_TO_SELECTED"));
        jLabel2.setAlignmentX(0.0f);
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jList.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        jScrollPane.setAlignmentX(0.0f);
        Dimension dimension = new Dimension(200, 106);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setMaximumSize(dimension);
        jPanel3.add(jScrollPane);
        jPanel3.add(Box.createHorizontalStrut(10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        jButton.setAlignmentX(0.0f);
        jPanel4.add(jButton);
        jPanel4.add(Box.createVerticalGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jLabel);
        Dimension dimension2 = jTextField.getPreferredSize();
        jTextField.setMaximumSize(dimension2);
        jTextField.setMinimumSize(dimension2);
        jTextField.setAlignmentX(0.0f);
        jPanel5.add(jTextField);
        jPanel4.add(jPanel5);
        jPanel4.setAlignmentX(0.0f);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        jPanel.setAlignmentX(0.5f);
        return jPanel;
    }

    private synchronized void setupPoller() {
        if (this.pollerThread == null) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (SendSMSDialog.this.pollerThread != null) {
                        try {
                            DefaultListModel defaultListModel = SendSMSDialog.this.registeredClients;
                            synchronized (defaultListModel) {
                                Object[] objectArray = SendSMSDialog.this.registeredClients.toArray();
                                Object[] objectArray2 = SendSMSDialog.this.console.getWMAClient().getKnownReceivers();
                                if (!Arrays.equals(objectArray, objectArray2)) {
                                    int[] nArray;
                                    int n;
                                    int n2;
                                    int n3;
                                    Object[] objectArray3 = SendSMSDialog.this.textList.getSelectedValues();
                                    Object[] objectArray4 = SendSMSDialog.this.binaryList.getSelectedValues();
                                    SendSMSDialog.this.registeredClients.removeAllElements();
                                    for (n3 = 0; n3 < SendSMSDialog.this.additionalClients.size(); ++n3) {
                                        SendSMSDialog.this.registeredClients.addElement(SendSMSDialog.this.additionalClients.get(n3));
                                    }
                                    for (n3 = objectArray2.length; n3 > 0; --n3) {
                                        SendSMSDialog.this.registeredClients.addElement(objectArray2[n3 - 1]);
                                    }
                                    if (objectArray3.length != 0) {
                                        Vector<Integer> vector = new Vector<Integer>();
                                        n2 = objectArray3.length;
                                        for (int i = 0; i < n2; ++i) {
                                            n = SendSMSDialog.this.registeredClients.indexOf(objectArray3[i]);
                                            if (n == -1) continue;
                                            vector.add(new Integer(n));
                                        }
                                        nArray = new int[vector.size()];
                                        for (n = 0; n < nArray.length; ++n) {
                                            nArray[n] = (Integer)vector.get(n);
                                        }
                                        SendSMSDialog.this.textList.setSelectedIndices(nArray);
                                    }
                                    if (objectArray4.length != 0) {
                                        Vector<Integer> vector = new Vector<Integer>();
                                        n2 = objectArray4.length;
                                        for (int i = 0; i < n2; ++i) {
                                            n = SendSMSDialog.this.registeredClients.indexOf(objectArray4[i]);
                                            if (n == -1) continue;
                                            vector.add(new Integer(n));
                                        }
                                        nArray = new int[vector.size()];
                                        for (n = 0; n < nArray.length; ++n) {
                                            nArray[n] = (Integer)vector.get(n);
                                        }
                                        SendSMSDialog.this.binaryList.setSelectedIndices(nArray);
                                    }
                                    SendSMSDialog.this.textList.repaint();
                                    SendSMSDialog.this.binaryList.repaint();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            SendSMSDialog.this.textOut.println("Failed to refresh client list.");
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                        }
                        catch (Throwable throwable) {}
                    }
                    debug.println(3, "Returning from Poller's run().");
                }
            };
            this.pollerThread = new Thread(runnable);
        }
        this.pollerThread.start();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setupPoller();
        } else {
            this.pollerThread = null;
        }
        super.setVisible(bl);
    }

    public void setSMS(boolean bl) {
        this.isSMS = bl;
        if (this.isSMS) {
            String string = ToolkitResources.getString((String)"WMA_CONSOLE.SMS");
            this.setTitle(this.console.getPhoneNumber() + " - " + this.titleBase + " - " + string);
            this.tabs.setTitleAt(0, I18N_TEXT + " " + string);
            this.tabs.setTitleAt(1, I18N_BINARY + " " + string);
            this.textSMSAddressPane.setVisible(true);
            this.binarySMSAddressPane.setVisible(true);
            this.textCBSAddressPane.setVisible(false);
            this.binaryCBSAddressPane.setVisible(false);
        } else {
            String string = ToolkitResources.getString((String)"WMA_CONSOLE.CBS");
            this.setTitle(this.console.getPhoneNumber() + " - " + this.titleBase + " - " + string);
            this.tabs.setTitleAt(0, I18N_TEXT + " " + string);
            this.tabs.setTitleAt(1, I18N_BINARY + " " + string);
            this.textSMSAddressPane.setVisible(false);
            this.binarySMSAddressPane.setVisible(false);
            this.textCBSAddressPane.setVisible(true);
            this.binaryCBSAddressPane.setVisible(true);
        }
        this.content.setMinimumSize(new Dimension(this.console.getTextAreaPreferredSize().width + 10, 130));
        this.pack();
        WindowUtils.center((Window)this, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getFileContents() throws IOException {
        byte[] byArray;
        block9: {
            byArray = null;
            File file = new File(this.fileName.getText());
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(this, "Unable to read the file " + this.fileName.getText(), I18N_TITLE, 0);
                throw new IOException("Can't read file");
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    int n = 0;
                    while ((n = bufferedInputStream.read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Throwable throwable) {
                    debug.exception(1, throwable);
                    JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.FILE_ERROR"), I18N_TITLE, 0);
                    throw new IOException("Can't read file.");
                }
                Object var7_7 = null;
                if (bufferedInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (bufferedInputStream == null) throw throwable;
                try {
                    bufferedInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedInputStream.close();
        }
        if (byArray != null) return byArray;
        return new byte[0];
    }

    JTextField getAproposPortField() {
        if (this.isSMS) {
            if (this.binaryTab.isVisible()) {
                return this.binarySMSPortField;
            }
            return this.textSMSPortField;
        }
        if (this.binaryTab.isVisible()) {
            return this.binaryCBSPortField;
        }
        return this.textCBSPortField;
    }

    private void send() {
        String string;
        Object object;
        Object object2;
        JTextField jTextField = this.getAproposPortField();
        Message message = null;
        if (!(this.isSMS || (object2 = jTextField.getText()) != null && object2.length() >= 1)) {
            JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CBS_PORT_REQUIRED"), I18N_TITLE, 0);
            return;
        }
        if (this.binaryTab.isVisible()) {
            object2 = null;
            try {
                object2 = this.getFileContents();
            }
            catch (IOException iOException) {
                return;
            }
            message = new Message((byte[])object2);
        } else {
            object2 = this.messageArea.getText();
            if (object2 == null) {
                object2 = "";
            }
            message = new Message((String)object2);
        }
        debug.println(3, "Message constructed: " + message);
        object2 = null;
        if (this.isSMS) {
            object = this.textTab.isVisible() ? this.textList : this.binaryList;
            object2 = ((JList)object).getSelectedValues();
            if (((Object[])object2).length < 1) {
                JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.NO_ADDRESSES"), I18N_TITLE, 0);
                return;
            }
        } else {
            object2 = new String[]{""};
        }
        object = jTextField.getText();
        int n = -1;
        if (object != null && ((String)object).length() > 0) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = this.isSMS ? ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.PORT") : ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.MESSAGE_ID");
                String string3 = ToolkitResources.format((String)"WMA_CONSOLE.DIALOG.BAD_PORT", (Object[])new Object[]{string2});
                JOptionPane.showMessageDialog(this, string3, I18N_TITLE, 0);
                return;
            }
        }
        String string4 = string = this.isSMS ? "sms" : "cbs";
        if (this.isSMS) {
            message.setFromAddress("sms://" + this.console.getPhoneNumber());
        }
        for (int i = 0; i < ((Object[])object2).length; ++i) {
            String string5 = string + "://" + object2[i];
            message.setToAddress(string5);
            if (n > -1) {
                message.setToPort(n);
            }
            try {
                debug.println(3, "sending message to " + message.getToAddress() + " to WMAClient.");
                this.console.getWMAClient().send(message);
                this.textOut.println("Sent " + string + " to " + message.getToAddress() + ".");
                continue;
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.RESERVED_PORT"), I18N_TITLE, 0);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string6 = illegalArgumentException.getMessage();
                if (string6.indexOf("255") >= 0) {
                    JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.MESSAGE_TOO_BIG"), I18N_TITLE, 0);
                } else if (string6.startsWith("Host format:")) {
                    String string7 = ToolkitResources.format((String)"WMA_CONSOLE.DIALOG.INVALID_ADDRESS", (Object[])new Object[]{object2[i]});
                    JOptionPane.showMessageDialog(this, string7, I18N_TITLE, 0);
                } else if (string6.indexOf("65535") >= 0) {
                    String string8 = this.isSMS ? ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.PORT") : ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.MESSAGE_ID");
                    String string9 = ToolkitResources.format((String)"WMA_CONSOLE.DIALOG.BAD_PORT", (Object[])new Object[]{string8});
                    JOptionPane.showMessageDialog(this, string9, I18N_TITLE, 0);
                }
                return;
            }
            catch (Exception exception) {
                this.textOut.println("Error sending message to " + message.getToAddress() + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.setVisible(false);
    }

    static /* synthetic */ void access$300(SendSMSDialog sendSMSDialog) {
        sendSMSDialog.send();
    }

    private class AddClientsDialog
    extends JDialog {
        private JTextField field;
        private JButton cancel;
        private JButton ok;

        AddClientsDialog() {
            super((Dialog)SendSMSDialog.this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.ADD_CLIENTS_TITLE"));
            this.field = new JTextField();
            this.cancel = new JButton(ToolkitResources.getString((String)"CANCEL"));
            this.cancel.setMnemonic(ToolkitResources.getString((String)"CANCEL_SHORTCUT").charAt(0));
            this.ok = new JButton(ToolkitResources.getString((String)"OK"));
            this.ok.setMnemonic(ToolkitResources.getString((String)"OK_SHORTCUT").charAt(0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel jLabel = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.ENTER_EXTRA_CLIENTS"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 3, 0));
            jPanel.add((Component)jLabel, "North");
            this.field.setPreferredSize(new Dimension(150, this.field.getPreferredSize().height));
            jPanel.add(this.field);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1, 50, 5));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            jPanel2.add(this.ok);
            jPanel2.add(this.cancel);
            jPanel.add((Component)jPanel2, "South");
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddClientsDialog this$1;
                {
                    this.this$1 = addClientsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setVisible(false);
                    AddClientsDialog.access$1300(this.this$1).addExtraClient(this.this$1.getEntry());
                }
            });
            this.cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddClientsDialog this$1;
                {
                    this.this$1 = addClientsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setVisible(false);
                }
            });
            this.getContentPane().add(jPanel);
        }

        String getEntry() {
            String string = this.field.getText();
            if (string.length() > 0) {
                return string;
            }
            return null;
        }

        static /* synthetic */ SendSMSDialog access$1300(AddClientsDialog addClientsDialog) {
            return addClientsDialog.SendSMSDialog.this;
        }
    }
}

