/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.wma.mms;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.MessagePart;
import com.sun.kvem.midp.io.j2se.wma.MultipartMessage;
import com.sun.kvem.midp.io.j2se.wma.SizeExceededException;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.wma.WMAConsole;
import com.sun.kvem.wma.mms.HeaderPanel;
import com.sun.kvem.wma.mms.PartsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SendMMSDialog
extends JDialog
implements TableModelListener {
    private static Debug debug = Debug.create((Class)SendMMSDialog.class);
    private WMAConsole console;
    private PrintStream textOut;
    private String titleBase;
    private HeaderPanel header;
    private PartsPanel parts;
    private Action sendAction;
    private JLabel errorMessage;

    public SendMMSDialog(WMAConsole wMAConsole, PrintStream printStream) {
        super((Frame)wMAConsole, "");
        this.console = wMAConsole;
        this.textOut = printStream;
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.header = new HeaderPanel();
        jTabbedPane.add(ToolkitResources.getString((String)"WMA_CONSOLE.HEADER"), this.header);
        this.parts = new PartsPanel();
        jTabbedPane.add(ToolkitResources.getString((String)"WMA_CONSOLE.PARTS"), this.parts);
        this.errorMessage = new JLabel(" ");
        this.errorMessage.setForeground(Color.RED);
        this.sendAction = new AbstractAction(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SEND")){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SendMMSDialog.access$100(1.access$000(this.this$1));
                    }
                }).start();
            }

            static /* synthetic */ SendMMSDialog access$000(1 var0) {
                return var0.SendMMSDialog.this;
            }
        };
        JButton jButton = new JButton(this.sendAction);
        jButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.SEND_SHORTCUT").charAt(0));
        JButton jButton2 = new JButton(ToolkitResources.getString((String)"CANCEL"));
        jButton2.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CANCEL_SHORTCUT").charAt(0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendMMSDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        Box box = new Box(1);
        box.add(this.errorMessage);
        box.add(jPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jTabbedPane, "Center");
        container.add((Component)box, "South");
        this.titleBase = ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.TITLE");
        this.setTitle(wMAConsole.getPhoneNumber() + " - " + this.titleBase + " - MMS");
        this.header.addTableModelListener(this);
        this.parts.addTableModelListener(this);
    }

    private void send() {
        MultipartMessage multipartMessage = new MultipartMessage("mms://" + this.console.getPhoneNumber());
        try {
            int n;
            ChangeEvent changeEvent = new ChangeEvent(this);
            this.header.stopEditting(changeEvent);
            this.parts.stopEditting(changeEvent);
            multipartMessage.setSubject(this.header.getSubject());
            multipartMessage.setApplicationID(this.header.getApplicationID());
            String[][] stringArray = this.header.getAddresses();
            boolean bl = false;
            for (n = 0; n < stringArray[0].length; ++n) {
                bl = true;
                multipartMessage.addAddress("to", stringArray[0][n]);
            }
            for (n = 0; n < stringArray[1].length; ++n) {
                bl = true;
                multipartMessage.addAddress("cc", stringArray[1][n]);
            }
            for (n = 0; n < stringArray[2].length; ++n) {
                bl = true;
                multipartMessage.addAddress("bcc", stringArray[2][n]);
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.NO_MMS_ADDRESSES"), "", 0);
                return;
            }
            MessagePart[] messagePartArray = this.parts.getParts();
            for (int i = 0; i < messagePartArray.length; ++i) {
                multipartMessage.addMessagePart(messagePartArray[i]);
            }
            debug.println(3, "sending message " + multipartMessage.getSubject() + " to WMAClient.");
            this.console.getWMAClient().send(multipartMessage);
            this.textOut.println("Sent MMS with subject '" + multipartMessage.getSubject() + "'.");
            this.dispose();
        }
        catch (SizeExceededException sizeExceededException) {
            JOptionPane.showMessageDialog(this, sizeExceededException.getMessage(), ToolkitResources.getString((String)"WMA_CONSOLE.SIZE_EXCEEDED"), 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "", 0);
        }
        catch (IOException iOException) {
            this.textOut.println("Error sending message " + multipartMessage.getSubject() + ": " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        try {
            this.header.verifyValid();
            this.parts.verifyValid();
            this.errorMessage.setText(" ");
            this.sendAction.setEnabled(true);
        }
        catch (Exception exception) {
            this.errorMessage.setText(ToolkitResources.getString((String)"ERROR") + ": " + exception.getMessage());
            this.sendAction.setEnabled(false);
        }
    }

    static /* synthetic */ void access$100(SendMMSDialog sendMMSDialog) {
        sendMMSDialog.send();
    }
}

