/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.wma.mms;

import com.sun.kvem.midp.io.j2se.wma.MessagePart;
import com.sun.kvem.midp.io.j2se.wma.SizeExceededException;
import com.sun.kvem.util.MIMETypeHelper;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class PartsPanel
extends JPanel {
    private final PartsTableModel tableModel;
    private final JTable table;
    private int idCount = 0;
    private JLabel totalSizeLabel;
    private long totalSize = 0L;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public PartsPanel() {
        this.setLayout(new BorderLayout());
        this.tableModel = new PartsTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new FileCellRenderer());
        tableColumnModel.getColumn(5).setCellRenderer(new SizeCellRenderer());
        Box box = new Box(1);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        box.add(jScrollPane);
        Box box2 = new Box(0);
        JLabel jLabel = new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.TOTAL_SIZE") + ": ");
        this.totalSizeLabel = new JLabel(Long.toString(0L));
        this.totalSizeLabel.setPreferredSize(new Dimension(80, 0));
        this.totalSizeLabel.setLabelFor(jLabel);
        box2.add(Box.createHorizontalGlue());
        box2.add(jLabel);
        box2.add(this.totalSizeLabel);
        box.add(box2);
        this.add((Component)box, "Center");
        JButton jButton = new JButton(ToolkitResources.getString((String)"ADD"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SmartFileChooser smartFileChooser = new SmartFileChooser();
                int n = smartFileChooser.showOpenDialog((Component)PartsPanel.this);
                if (n == 0) {
                    File file = smartFileChooser.getSelectedFile();
                    PartsPanel.this.tableModel.addPart(file);
                }
            }
        });
        JButton jButton2 = new JButton(ToolkitResources.getString((String)"REMOVE"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PartsPanel.this.table.getSelectedRow();
                if (n != -1) {
                    PartsPanel.this.tableModel.removePart(n);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "South");
    }

    MessagePart[] getParts() throws SizeExceededException {
        return this.tableModel.getParts();
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModel.addTableModelListener(tableModelListener);
    }

    void verifyValid() throws Exception {
        if (this.totalSize > 30720L) {
            throw new SizeExceededException(ToolkitResources.getString((String)"WMA_CONSOLE.SIZE_EXCEEDED_MSG") + " (" + 30720 + ")");
        }
    }

    private long getTotalSize() {
        return this.totalSize;
    }

    private void setTotalSize(long l) {
        this.totalSize = l;
        this.totalSizeLabel.setText(Long.toString(this.totalSize));
        if (this.totalSize > 30720L) {
            this.totalSizeLabel.setForeground(Color.RED);
        } else {
            this.totalSizeLabel.setForeground(Color.BLACK);
        }
    }

    void stopEditting(ChangeEvent changeEvent) {
        this.table.editingStopped(changeEvent);
    }

    private static class SizeCellRenderer
    extends DefaultTableCellRenderer {
        private SizeCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Long l = (Long)object;
            if (l > 30720L) {
                component.setForeground(Color.RED);
            } else if (bl) {
                component.setForeground(jTable.getSelectionForeground());
            } else {
                component.setForeground(jTable.getForeground());
            }
            return component;
        }
    }

    private static class FileCellRenderer
    extends DefaultTableCellRenderer {
        private FileCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            File file = (File)object;
            if (!file.isFile()) {
                component.setForeground(Color.RED);
            } else if (bl) {
                component.setForeground(jTable.getSelectionForeground());
            } else {
                component.setForeground(jTable.getForeground());
            }
            return component;
        }
    }

    private static class RawPart {
        File file;
        String location;
        String id;
        String MIMEType;
        String enc;

        private RawPart() {
        }
    }

    private class PartsTableModel
    extends AbstractTableModel {
        List parts = new Vector();
        String[] columnNames = new String[]{ToolkitResources.getString((String)"WMA_CONSOLE.FILE"), ToolkitResources.getString((String)"WMA_CONSOLE.CONTENT_LOC"), ToolkitResources.getString((String)"WMA_CONSOLE.CONTENT_ID"), ToolkitResources.getString((String)"WMA_CONSOLE.MIME_TYPE"), ToolkitResources.getString((String)"WMA_CONSOLE.ENCODING"), ToolkitResources.getString((String)"WMA_CONSOLE.SIZE")};

        private PartsTableModel() {
        }

        public void addPart(File file) {
            String string;
            RawPart rawPart = new RawPart();
            rawPart.file = file;
            rawPart.location = string = file.getName();
            rawPart.id = Integer.toString(PartsPanel.this.idCount++);
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string2 = string.substring(n + 1);
                rawPart.MIMEType = MIMETypeHelper.getMIMEType((String)string2);
            } else {
                rawPart.MIMEType = "";
            }
            rawPart.enc = System.getProperty("file.encoding", "");
            this.parts.add(rawPart);
            PartsPanel.this.setTotalSize(PartsPanel.this.totalSize + file.length());
            int n2 = this.parts.size() - 1;
            this.fireTableRowsInserted(n2, n2);
        }

        public void removePart(int n) {
            RawPart rawPart = (RawPart)this.parts.remove(n);
            PartsPanel.this.setTotalSize(PartsPanel.this.totalSize - rawPart.file.length());
            this.fireTableRowsDeleted(n, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public MessagePart[] getParts() throws SizeExceededException {
            MessagePart[] messagePartArray = new MessagePart[this.parts.size()];
            int n = 0;
            Iterator iterator = this.parts.iterator();
            while (iterator.hasNext()) {
                RawPart rawPart = (RawPart)iterator.next();
                FileInputStream fileInputStream = null;
                byte[] byArray = new byte[(int)rawPart.file.length()];
                fileInputStream = new FileInputStream(rawPart.file);
                fileInputStream.read(byArray);
                MessagePart messagePart = new MessagePart(byArray, rawPart.MIMEType, rawPart.id, rawPart.location, rawPart.enc);
                messagePartArray[n++] = messagePart;
                Object var9_9 = null;
                if (fileInputStream == null) continue;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                continue;
                {
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        var9_9 = null;
                        if (fileInputStream == null) continue;
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            return messagePartArray;
        }

        private List getRawParts() {
            return this.parts;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.parts.size();
        }

        public Object getValueAt(int n, int n2) {
            RawPart rawPart = (RawPart)this.parts.get(n);
            switch (n2) {
                case 0: {
                    return rawPart.file;
                }
                case 1: {
                    return rawPart.location;
                }
                case 2: {
                    return rawPart.id;
                }
                case 3: {
                    return rawPart.MIMEType;
                }
                case 4: {
                    return rawPart.enc;
                }
                case 5: {
                    return new Long(rawPart.file.length());
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 && n2 != 5;
        }

        public void setValueAt(Object object, int n, int n2) {
            RawPart rawPart = (RawPart)this.parts.get(n);
            switch (n2) {
                case 1: {
                    rawPart.location = (String)object;
                    return;
                }
                case 2: {
                    rawPart.id = (String)object;
                    return;
                }
                case 3: {
                    rawPart.MIMEType = (String)object;
                    return;
                }
                case 4: {
                    rawPart.enc = (String)object;
                    return;
                }
            }
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$io$File == null ? (class$java$io$File = PartsPanel.class$("java.io.File")) : class$java$io$File;
            }
            if (n == 5) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = PartsPanel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            return class$java$lang$String == null ? (class$java$lang$String = PartsPanel.class$("java.lang.String")) : class$java$lang$String;
        }
    }
}

