/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.wma.mms;

import com.sun.kvem.util.AutoAcceptCellEditor;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class HeaderPanel
extends Box {
    private final String TO = ToolkitResources.getString((String)"WMA_CONSOLE.TO");
    private final String CC = ToolkitResources.getString((String)"WMA_CONSOLE.CC");
    private final String BCC = ToolkitResources.getString((String)"WMA_CONSOLE.BCC");
    private JTextField subject;
    private JTextField appId;
    private JTable table;

    public HeaderPanel() {
        super(1);
        this.add(this.createSubjectPanel());
        this.add(this.createAppIDPanel());
        this.add(this.createAddressPanel());
    }

    private Component createSubjectPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.SUBJECT") + ":"));
        this.subject = new JTextField(50);
        jPanel.add(this.subject);
        return jPanel;
    }

    private Component createAppIDPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(ToolkitResources.getString((String)"WMA_CONSOLE.APP_ID") + ":"));
        this.appId = new JTextField(50);
        jPanel.add(this.appId);
        return jPanel;
    }

    private Component createAddressPanel() {
        this.table = new JTable(0, 2);
        this.table.setTableHeader(null);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.setupAddressModeColumn(this.table.getColumnModel().getColumn(0));
        this.setupAddressColumn(this.table.getColumnModel().getColumn(1));
        this.addAddress();
        JButton jButton = new JButton(ToolkitResources.getString((String)"ADD"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeaderPanel.this.addAddress();
            }
        });
        final JButton jButton2 = new JButton(ToolkitResources.getString((String)"REMOVE"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = HeaderPanel.this.table.getSelectedRow();
                if (n != -1) {
                    HeaderPanel.this.removeAdress(n);
                }
            }
        });
        jButton2.setEnabled(false);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    jButton2.setEnabled(false);
                } else {
                    jButton2.setEnabled(true);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    public void setupAddressModeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.TO);
        jComboBox.addItem(this.CC);
        jComboBox.addItem(this.BCC);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    public void setupAddressColumn(TableColumn tableColumn) {
        tableColumn.setCellEditor((TableCellEditor)new AutoAcceptCellEditor(new JTextField()));
    }

    public void addAddress() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.addRow(new Object[]{this.TO, "mms://"});
    }

    public void removeAdress(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.removeRow(n);
    }

    public String getSubject() {
        return this.subject.getText();
    }

    public String getApplicationID() {
        return this.appId.getText();
    }

    public String[][] getAddresses() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = defaultTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            stringArray = defaultTableModel.getValueAt(i, 0);
            String string = (String)defaultTableModel.getValueAt(i, 1);
            if (string == null || string.equals("")) continue;
            if (stringArray.equals(this.TO)) {
                vector.add(string);
                continue;
            }
            if (stringArray.equals(this.CC)) {
                vector2.add(string);
                continue;
            }
            if (!stringArray.equals(this.BCC)) continue;
            vector3.add(string);
        }
        String[][] stringArray2 = new String[3][];
        stringArray = new String[]{};
        stringArray2[0] = vector.toArray(stringArray);
        stringArray2[1] = vector2.toArray(stringArray);
        stringArray2[2] = vector3.toArray(stringArray);
        return stringArray2;
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.table.getModel().addTableModelListener(tableModelListener);
    }

    void verifyValid() throws Exception {
    }

    void stopEditting(ChangeEvent changeEvent) {
        this.table.editingStopped(changeEvent);
    }
}

