/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.wma;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.midp.io.j2se.wma.Message;
import com.sun.kvem.midp.io.j2se.wma.MessagePart;
import com.sun.kvem.midp.io.j2se.wma.MultipartMessage;
import com.sun.kvem.midp.io.j2se.wma.WMAMessage;
import com.sun.kvem.midp.io.j2se.wma.client.WMAClient;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import com.sun.kvem.wma.mms.SendMMSDialog;
import com.sun.kvem.wma.sms.SendSMSDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WMAConsole
extends JFrame
implements Runnable {
    private static Debug debug = Debug.create((Class)WMAConsole.class);
    private static final int CONSOLE_WIDTH_IN_CHARS = 60;
    private JButton sendSMSButton;
    private JButton sendCBSButton;
    private JButton sendMMSButton;
    private JButton closeButton;
    private JScrollPane textScrollPane;
    private JTextArea textArea;
    private PrintStream textOut;
    private SendSMSDialog sendSMSDialog;
    private JButton clearButton;
    private JPanel consolePane;
    private WindowListener windowListener;
    private WMAClient wmaClient = null;
    private String phoneNumber;
    private boolean running = false;

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean bl) {
        this.running = bl;
    }

    public void notifyClosed() {
        this.removeWindowListener(this.windowListener);
        this.setRunning(false);
        if (this.wmaClient != null) {
            try {
                this.wmaClient.setMessageListener(null);
                this.wmaClient.unregisterFromServer();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dispose();
    }

    public void run() {
        this.createUI();
        this.setRunning(true);
        this.connectToSwitch();
        this.setTitle();
        this.setVisible(true);
        if (this.wmaClient == null) {
            JOptionPane.showMessageDialog(null, ToolkitResources.getString((String)"WMA_INIT_FAILED"), ToolkitResources.getString((String)"WMA_CONSOLE.TITLE"), 0);
            this.setVisible(false);
            this.notifyClosed();
        }
        this.textOut.println("WMA Console running, using phone number " + this.phoneNumber + ".");
    }

    private static String getMaxWidthString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('m');
        }
        return stringBuffer.toString();
    }

    private void createUI() {
        Object object;
        this.sendSMSButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.SENDSMS"));
        this.sendSMSButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.SENDSMS_SHORTCUT").charAt(0));
        this.sendCBSButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.SENDCBS"));
        this.sendCBSButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.SENDCBS_SHORTCUT").charAt(0));
        this.sendMMSButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.SENDMMS"));
        this.sendMMSButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.SENDMMS_SHORTCUT").charAt(0));
        this.closeButton = new JButton(ToolkitResources.getString((String)"EXIT"));
        this.closeButton.setMnemonic(ToolkitResources.getString((String)"EXIT_SHORTCUT").charAt(0));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textScrollPane = new JScrollPane(this.textArea);
        this.textOut = new PrintStream(new ConsoleStream(this.textArea, this.textScrollPane));
        this.sendSMSDialog = new SendSMSDialog(this, this.textOut);
        this.sendSMSDialog.pack();
        WindowUtils.center((Window)this.sendSMSDialog, null);
        this.clearButton = new JButton(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CLEAR"));
        this.clearButton.setMnemonic(ToolkitResources.getString((String)"WMA_CONSOLE.DIALOG.CLEAR_SHORTCUT").charAt(0));
        this.phoneNumber = null;
        this.setDefaultCloseOperation(2);
        this.windowListener = new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                WMAConsole.this.notifyClosed();
            }
        };
        this.addWindowListener(this.windowListener);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WMAConsole.this.notifyClosed();
            }
        });
        this.sendSMSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WMAConsole.this.sendSMSButtonPressed();
            }
        });
        this.sendCBSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WMAConsole.this.sendCBSButtonPressed();
            }
        });
        this.sendMMSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WMAConsole.this.sendMMSButtonPressed();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WMAConsole.this.textArea.setText("");
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(this.sendSMSButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(this.sendCBSButton);
        try {
            object = Class.forName("com.sun.kvem.netmon.mms.MMSMessage");
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add(this.sendMMSButton);
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.println(2, "No MMS protocol support.");
        }
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel2, "North");
        this.consolePane = new JPanel();
        this.consolePane.setLayout(new BoxLayout(this.consolePane, 1));
        this.consolePane.setAlignmentX(0.5f);
        this.consolePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolkitResources.getString((String)"WMA_CONSOLE.CONSOLE")));
        object = WMAConsole.getMaxWidthString(60);
        int n = this.textArea.getFontMetrics(this.textArea.getFont()).stringWidth((String)object);
        this.textScrollPane.setPreferredSize(new Dimension(n, 180));
        this.consolePane.add(this.textScrollPane);
        jPanel.add((Component)this.consolePane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(this.clearButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.closeButton);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel3, "South");
        this.pack();
        WindowUtils.center((Window)this, null);
        String string = ToolkitDirs.LIB + "images" + File.separator;
        WindowUtils.setFrameIcon((JFrame)this, (String)(string + "wma-console.gif"));
    }

    private void setTitle() {
        this.setTitle(this.phoneNumber + " - " + ToolkitResources.getString((String)"WMA_CONSOLE.TITLE"));
    }

    private void connectToSwitch() {
        try {
            this.wmaClient = new WMAClient(null, 4);
            this.wmaClient.connect();
            this.phoneNumber = this.wmaClient.getPhoneNumber();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.wmaClient = null;
            return;
        }
        this.wmaClient.setMessageListener(new WMAClient.MessageListenerAdapter(){

            public void notifyIncomingMessage(WMAClient wMAClient) {
                try {
                    WMAMessage wMAMessage = WMAConsole.this.wmaClient.receive();
                    debug.println(3, "Message received...");
                    if (wMAMessage instanceof Message) {
                        int n;
                        Message message = (Message)wMAMessage;
                        WMAConsole.this.textOut.print("Received ");
                        WMAConsole.this.textOut.print(message.getToAddress().substring(0, 3));
                        WMAConsole.this.textOut.print(" message");
                        String string = message.getFromAddress();
                        if (string != null) {
                            WMAConsole.this.textOut.print(" from ");
                            WMAConsole.this.textOut.print(string);
                        }
                        if ((n = message.getToPort()) != -1) {
                            if (message.isSMS()) {
                                WMAConsole.this.textOut.print(" on port ");
                            } else {
                                WMAConsole.this.textOut.print(" with message identifier ");
                            }
                            WMAConsole.this.textOut.print(n);
                        }
                        WMAConsole.this.textOut.println(':');
                        WMAConsole.this.textOut.println(message.toString());
                    } else {
                        MessagePart[] messagePartArray;
                        String string;
                        String[] stringArray;
                        String[] stringArray2;
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        MultipartMessage multipartMessage = (MultipartMessage)wMAMessage;
                        WMAConsole.this.textOut.print("Received mms message");
                        String string6 = multipartMessage.getFromAddress();
                        if (string6 != null) {
                            WMAConsole.this.textOut.print(" from ");
                            WMAConsole.this.textOut.print(string6);
                        }
                        if ((string5 = multipartMessage.getReplyToApplicationID()) != null) {
                            WMAConsole.this.textOut.print(" application-ID " + string5);
                        }
                        if ((string4 = multipartMessage.getApplicationID()) != null) {
                            WMAConsole.this.textOut.print(" to application-ID " + string4);
                        }
                        WMAConsole.this.textOut.println(':');
                        String string7 = multipartMessage.getSubject();
                        if (string7 != null) {
                            WMAConsole.this.textOut.println("Subject: " + string7);
                        }
                        if ((string3 = multipartMessage.getHeader("X-Mms-Delivery-Time")) != null) {
                            WMAConsole.this.textOut.println("Delivery-Time: " + string3);
                        }
                        if ((string2 = multipartMessage.getHeader("X-Mms-Priority")) != null) {
                            WMAConsole.this.textOut.println("Priority: " + string2);
                        }
                        if ((stringArray2 = multipartMessage.getAddresses("to")) != null) {
                            WMAConsole.this.textOut.print("To: ");
                            WMAConsole.this.textOut.print(stringArray2[0]);
                            for (int i = 1; i < stringArray2.length; ++i) {
                                WMAConsole.this.textOut.print("; ");
                                WMAConsole.this.textOut.print(stringArray2[i]);
                            }
                            WMAConsole.this.textOut.println();
                        }
                        if ((stringArray = multipartMessage.getAddresses("cc")) != null) {
                            WMAConsole.this.textOut.print("Cc: ");
                            WMAConsole.this.textOut.print(stringArray[0]);
                            for (int i = 1; i < stringArray.length; ++i) {
                                WMAConsole.this.textOut.print("; ");
                                WMAConsole.this.textOut.print(stringArray[i]);
                            }
                            WMAConsole.this.textOut.println();
                        }
                        if ((string = multipartMessage.getStartContentId()) != null) {
                            WMAConsole.this.textOut.println("Start Content-ID: " + string);
                        }
                        int n = (messagePartArray = multipartMessage.getMessageParts()) == null ? 0 : messagePartArray.length;
                        WMAConsole.this.textOut.println("No. of parts: " + n);
                        if (messagePartArray != null) {
                            for (int i = 0; i < n; ++i) {
                                MessagePart messagePart = messagePartArray[i];
                                WMAConsole.this.textOut.println("--- Part " + (i + 1));
                                WMAConsole.this.textOut.println(" Content-ID: " + messagePart.getContentID());
                                String string8 = messagePart.getContentLocation();
                                if (string8 != null) {
                                    WMAConsole.this.textOut.println(" Content Location: " + string8);
                                }
                                WMAConsole.this.textOut.println(" MIME Type: " + messagePart.getMIMEType());
                                String string9 = messagePart.getEncoding();
                                if (string9 != null) {
                                    WMAConsole.this.textOut.println(" Encoding: " + string9);
                                }
                                WMAConsole.this.textOut.println(" Length: " + messagePart.getLength());
                            }
                            WMAConsole.this.textOut.println("---");
                        }
                    }
                }
                catch (Exception exception) {
                    debug.exception(2, (Throwable)exception);
                }
            }
        });
    }

    public void sendSMSButtonPressed() {
        if (!this.sendSMSDialog.isVisible()) {
            this.sendSMSDialog.setSMS(true);
            this.sendSMSDialog.setVisible(true);
        }
        this.sendSMSDialog.toFront();
    }

    public void sendCBSButtonPressed() {
        if (!this.sendSMSDialog.isVisible()) {
            this.sendSMSDialog.setSMS(false);
            this.sendSMSDialog.setVisible(true);
        }
        this.sendSMSDialog.toFront();
    }

    public void sendMMSButtonPressed() {
        SendMMSDialog sendMMSDialog = new SendMMSDialog(this, this.textOut);
        sendMMSDialog.pack();
        WindowUtils.center((Window)sendMMSDialog, (Window)this);
        sendMMSDialog.setVisible(true);
    }

    public WMAClient getWMAClient() {
        return this.wmaClient;
    }

    public Dimension getTextAreaPreferredSize() {
        return this.textArea.getPreferredSize();
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public static void main(String[] stringArray) {
        try {
            WMAConsole wMAConsole = new WMAConsole();
            wMAConsole.run();
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
        }
    }

    public static class PositiveIntField
    extends JTextField {
        public PositiveIntField(int n) {
            super(n);
        }

        protected Document createDefaultModel() {
            return new PositiveIntDocument();
        }

        static class PositiveIntDocument
        extends PlainDocument {
            PositiveIntDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null || string.length() == 0) {
                    return;
                }
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (Character.isDigit(cArray[i])) continue;
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
        }
    }

    private static class ConsoleStream
    extends OutputStream {
        private JTextArea jTextArea;
        private JScrollPane jScrollPane;
        private int length = 0;
        private int unflushedBytes = 0;

        public ConsoleStream(JTextArea jTextArea, JScrollPane jScrollPane) {
            this.jTextArea = jTextArea;
            this.jScrollPane = jScrollPane;
        }

        public void write(int n) {
            this.jTextArea.append(String.valueOf((char)n));
            this.jScrollPane.getVerticalScrollBar().setValue(this.jTextArea.getHeight() - this.jTextArea.getVisibleRect().height);
            ++this.length;
            ++this.unflushedBytes;
        }

        public void write(byte[] byArray, int n, int n2) {
            String string = new String(byArray, n, n2);
            this.jTextArea.append(string);
            this.jScrollPane.getVerticalScrollBar().setValue(this.jTextArea.getHeight() - this.jTextArea.getVisibleRect().height);
            this.length += n2;
            ++this.unflushedBytes;
        }

        public void flush() {
            if (this.unflushedBytes != 0) {
                this.unflushedBytes = 0;
                this.jScrollPane.getVerticalScrollBar().setValue(this.jTextArea.getHeight() - this.jTextArea.getVisibleRect().height);
            }
        }
    }
}

