/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.wbmp;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class WBMPMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "javax_imageio_wbmp_1.0";
    public int wbmpType;
    public int width;
    public int height;

    public WBMPMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.imageio.WBMPMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("The provided metadata format isn't recognized.");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(iIOMetadataNode, "WBMPType", new Integer(this.wbmpType));
        this.addChildNode(iIOMetadataNode, "Width", new Integer(this.width));
        this.addChildNode(iIOMetadataNode, "Height", new Integer(this.height));
        return iIOMetadataNode;
    }

    public void setFromTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only.");
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only.");
    }

    public void reset() {
        throw new IllegalStateException("Metadata is read-only.");
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode iIOMetadataNode, String string, Object object) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        if (object != null) {
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode2.setNodeValue(this.convertObjectToString(object));
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }

    public String convertObjectToString(Object object) {
        if (object == null) {
            return "";
        }
        String string = "";
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                string = string + byArray[i] + " ";
            }
            return string;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                string = string + nArray[i] + " ";
            }
            return string;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                string = string + sArray[i] + " ";
            }
            return string;
        }
        return object.toString();
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

