/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.profiler;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.APIManager;
import com.sun.kvem.profiler.CallGraphNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

final class Profile {
    CallGraphNode root;
    private Vector rangeRecord = new Vector();
    private static final String MIDP_MIDLET_INIT = "javax.microedition.midlet.MIDlet.<init>";
    private static final String MIDP_MIDLET_SELECTOR = "com.sun.midp.midlet.Selector.<init>";
    private static final String MIDP_MIDLET_END = "javax.microedition.midlet.MIDlet.notifyDestroyed";
    private static final String UNITED_NODES_NAME_SUFFIX = "...";
    private Hashtable nodes;
    private MIDletRange currentMIDlet;
    private boolean collectMIDletOnly = false;
    private boolean uniteSystem = false;
    private String[] systemPackages;
    private long totalCycles = 0L;
    private Vector childrenToUnite = new Vector();
    private static final Debug debug = Debug.create((Class)Profile.class);

    Profile(String string, boolean bl) throws IOException {
        this.collectMIDletOnly = !bl;
        this.uniteSystem = !bl;
        ArrayList arrayList = APIManager.getSystemPackages();
        this.systemPackages = arrayList.toArray(new String[arrayList.size()]);
        this.nodes = new Hashtable();
        this.root = this.createRoot();
        try {
            this.readInputFile(string);
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            return;
        }
        this.createCallGraph();
        if (this.collectMIDletOnly || this.uniteSystem) {
            this.correctMIDletRanges();
            this.setNeedToCountFlag(this.root);
        }
        if (this.collectMIDletOnly) {
            this.addNeedToCountFlag(this.root, false);
            this.removeOutOfMIDletRunStatistics(this.root);
        }
        if (this.root.children != null) {
            if (this.uniteSystem) {
                this.uniteSystemStatistics();
            }
            this.root.computeSummary();
        }
    }

    private CallGraphNode createRoot() {
        CallGraphNode callGraphNode = new CallGraphNode();
        callGraphNode.parent = null;
        callGraphNode.parentIdx = null;
        callGraphNode.index = new Integer(-1);
        callGraphNode.name = "<root>";
        this.nodes.put(callGraphNode.index, callGraphNode);
        return callGraphNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInputFile(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                throw new IOException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() != 29) {
                throw new IOException();
            }
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null && !bl) {
                bl = this.readInputLine(string2);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
    }

    private boolean readInputLine(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != 15) {
            if (string.startsWith("\tjprof_threadSwitch_enter")) {
                return true;
            }
            throw new IOException();
        }
        CallGraphNode callGraphNode = new CallGraphNode();
        try {
            callGraphNode.index = new Integer(stringTokenizer.nextToken());
            callGraphNode.parentIdx = new Integer(stringTokenizer.nextToken());
            callGraphNode.depth = Integer.parseInt(stringTokenizer.nextToken());
            callGraphNode.name = stringTokenizer.nextToken();
            callGraphNode.count = Integer.parseInt(stringTokenizer.nextToken());
            callGraphNode.onlyCycles = Long.parseLong(stringTokenizer.nextToken());
            callGraphNode.onlyMsec = Double.parseDouble(stringTokenizer.nextToken());
            callGraphNode.onlyPerc = Double.parseDouble(stringTokenizer.nextToken());
            callGraphNode.kidsCycles = Long.parseLong(stringTokenizer.nextToken());
            callGraphNode.kidsMsec = Double.parseDouble(stringTokenizer.nextToken());
            callGraphNode.kidsPerc = Double.parseDouble(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            debug.exception(1, (Throwable)numberFormatException);
            throw new IOException();
        }
        if (this.collectMIDletOnly || this.uniteSystem) {
            for (int i = 0; i < this.systemPackages.length; ++i) {
                if (!callGraphNode.name.startsWith(this.systemPackages[i])) continue;
                callGraphNode.isSystem = true;
                break;
            }
            if (this.currentMIDlet == null && callGraphNode.name.startsWith(MIDP_MIDLET_INIT)) {
                CallGraphNode callGraphNode2 = (CallGraphNode)this.nodes.get(callGraphNode.parentIdx);
                if (!callGraphNode2.name.startsWith(MIDP_MIDLET_SELECTOR)) {
                    this.currentMIDlet = new MIDletRange();
                    this.currentMIDlet.midletName = callGraphNode2.name.substring(0, callGraphNode2.name.lastIndexOf(46));
                    this.currentMIDlet.midletEndMethodName = this.currentMIDlet.midletName + ".destroyApp";
                    this.currentMIDlet.startIndex = callGraphNode2.index;
                }
            }
            if (this.currentMIDlet != null && (callGraphNode.name.equals(MIDP_MIDLET_END) || callGraphNode.name.equals(this.currentMIDlet.midletEndMethodName))) {
                this.currentMIDlet.endIndex = callGraphNode.index;
                this.rangeRecord.addElement(this.currentMIDlet);
                this.currentMIDlet = null;
            }
        }
        this.nodes.put(callGraphNode.index, callGraphNode);
        return false;
    }

    private void createCallGraph() {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            CallGraphNode callGraphNode = (CallGraphNode)enumeration.nextElement();
            if (callGraphNode.parentIdx == null) continue;
            CallGraphNode callGraphNode2 = (CallGraphNode)this.nodes.get(callGraphNode.parentIdx);
            if (callGraphNode2 == null) {
                callGraphNode2 = this.root;
            }
            if (callGraphNode2.children == null) {
                callGraphNode2.children = new Vector();
            }
            callGraphNode2.children.addElement(callGraphNode);
            callGraphNode.parent = callGraphNode2;
        }
    }

    private void correctMIDletRanges() {
        MIDletRange mIDletRange = null;
        MIDletRange mIDletRange2 = null;
        block0: for (int i = 0; i < this.rangeRecord.size(); ++i) {
            int n;
            CallGraphNode callGraphNode;
            mIDletRange2 = (MIDletRange)this.rangeRecord.elementAt(i);
            if (i == 0) {
                callGraphNode = (CallGraphNode)this.nodes.get(new Integer(mIDletRange2.startIndex));
                callGraphNode = (CallGraphNode)this.nodes.get(callGraphNode.parentIdx);
                n = callGraphNode.index;
            } else {
                mIDletRange = (MIDletRange)this.rangeRecord.elementAt(i - 1);
                n = mIDletRange.endIndex + 1;
            }
            for (int j = n; j < mIDletRange2.startIndex; ++j) {
                callGraphNode = (CallGraphNode)this.nodes.get(new Integer(j));
                if (callGraphNode.isSystem) continue;
                mIDletRange2.startIndex = callGraphNode.index;
                continue block0;
            }
        }
    }

    private void setNeedToCountFlag(CallGraphNode callGraphNode) {
        int n;
        if (callGraphNode.children != null) {
            for (n = 0; n < callGraphNode.children.size(); ++n) {
                this.setNeedToCountFlag((CallGraphNode)callGraphNode.children.elementAt(n));
            }
        }
        n = callGraphNode.index;
        callGraphNode.needToCount = !callGraphNode.isSystem;
        for (int i = 0; i < this.rangeRecord.size(); ++i) {
            MIDletRange mIDletRange = (MIDletRange)this.rangeRecord.elementAt(i);
            if (n < mIDletRange.startIndex || n > mIDletRange.endIndex) continue;
            callGraphNode.needToCount = true;
            break;
        }
    }

    private void addNeedToCountFlag(CallGraphNode callGraphNode, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            callGraphNode.needToCount = true;
        }
        if (callGraphNode.children != null) {
            for (int i = 0; i < callGraphNode.children.size(); ++i) {
                CallGraphNode callGraphNode2 = (CallGraphNode)callGraphNode.children.elementAt(i);
                if (callGraphNode2.isSystem) {
                    this.addNeedToCountFlag(callGraphNode2, bl);
                } else {
                    this.addNeedToCountFlag(callGraphNode2, true);
                }
                bl2 = bl2 || callGraphNode2.needToCount;
            }
        }
        if (bl2) {
            callGraphNode.needToCount = true;
        }
        if (callGraphNode.needToCount) {
            this.totalCycles += callGraphNode.onlyCycles;
        }
    }

    private void removeOutOfMIDletRunStatistics(CallGraphNode callGraphNode) {
        if (callGraphNode != this.root) {
            callGraphNode.onlyPerc = (double)callGraphNode.onlyCycles * 100.0 / (double)this.totalCycles;
            callGraphNode.kidsCycles = callGraphNode.onlyCycles;
            callGraphNode.kidsMsec = callGraphNode.onlyMsec;
            callGraphNode.kidsPerc = 0.0;
        }
        if (callGraphNode.children != null) {
            for (int i = 0; i < callGraphNode.children.size(); ++i) {
                CallGraphNode callGraphNode2 = (CallGraphNode)callGraphNode.children.elementAt(i);
                if (callGraphNode2.needToCount) {
                    this.removeOutOfMIDletRunStatistics(callGraphNode2);
                    if (callGraphNode == this.root) continue;
                    callGraphNode.kidsCycles += callGraphNode2.kidsCycles;
                    callGraphNode.kidsMsec += callGraphNode2.kidsMsec;
                    continue;
                }
                callGraphNode.children.removeElementAt(i);
                --i;
            }
            if (callGraphNode.children.size() == 0) {
                callGraphNode.children = null;
            }
        }
    }

    private void uniteSystemStatistics() {
        for (int i = 0; i < this.root.children.size(); ++i) {
            this.processNode((CallGraphNode)this.root.children.elementAt(i));
        }
    }

    private void processNode(CallGraphNode callGraphNode) {
        while (this.canMerge(callGraphNode)) {
            this.mergeChildrenWithParent(callGraphNode);
        }
        if (callGraphNode.children == null) {
            return;
        }
        for (int i = 0; i < callGraphNode.children.size(); ++i) {
            this.processNode((CallGraphNode)callGraphNode.children.elementAt(i));
        }
        this.uniteListChildren(callGraphNode);
    }

    private boolean canMerge(CallGraphNode callGraphNode) {
        if (!callGraphNode.isSystem) {
            return false;
        }
        if (callGraphNode.children == null || callGraphNode.children.size() == 0) {
            return false;
        }
        for (int i = 0; i < callGraphNode.children.size(); ++i) {
            if (((CallGraphNode)callGraphNode.children.elementAt((int)i)).isSystem) continue;
            return false;
        }
        return true;
    }

    private void mergeChildrenWithParent(CallGraphNode callGraphNode) {
        Vector<CallGraphNode> vector = new Vector<CallGraphNode>();
        if (!callGraphNode.name.endsWith(UNITED_NODES_NAME_SUFFIX)) {
            callGraphNode.name = callGraphNode.name + UNITED_NODES_NAME_SUFFIX;
        }
        for (int i = 0; i < callGraphNode.children.size(); ++i) {
            CallGraphNode callGraphNode2 = (CallGraphNode)callGraphNode.children.elementAt(i);
            callGraphNode.onlyCycles += callGraphNode2.onlyCycles;
            callGraphNode.onlyMsec += callGraphNode2.onlyMsec;
            callGraphNode.onlyPerc += callGraphNode2.onlyPerc;
            if (callGraphNode2.children == null) continue;
            for (int j = 0; j < callGraphNode2.children.size(); ++j) {
                CallGraphNode callGraphNode3 = (CallGraphNode)callGraphNode2.children.elementAt(j);
                callGraphNode3.parentIdx = callGraphNode.index;
                if (callGraphNode2.isSystem && callGraphNode3.isSystem) {
                    callGraphNode3.name = callGraphNode2.name;
                }
                vector.addElement(callGraphNode3);
            }
        }
        callGraphNode.children = vector.size() != 0 ? vector : null;
    }

    private void uniteListChildren(CallGraphNode callGraphNode) {
        this.childrenToUnite.clear();
        for (int i = 0; i < callGraphNode.children.size(); ++i) {
            CallGraphNode callGraphNode2 = (CallGraphNode)callGraphNode.children.elementAt(i);
            if (callGraphNode2.children != null || !callGraphNode2.isSystem) continue;
            this.childrenToUnite.addElement(callGraphNode2);
        }
        if (this.childrenToUnite.size() < 2) {
            return;
        }
        CallGraphNode callGraphNode3 = (CallGraphNode)this.childrenToUnite.elementAt(0);
        if (!callGraphNode3.name.endsWith(UNITED_NODES_NAME_SUFFIX)) {
            callGraphNode3.name = callGraphNode3.name + UNITED_NODES_NAME_SUFFIX;
        }
        for (int i = 1; i < this.childrenToUnite.size(); ++i) {
            CallGraphNode callGraphNode4 = (CallGraphNode)this.childrenToUnite.elementAt(i);
            callGraphNode3.onlyCycles += callGraphNode4.onlyCycles;
            callGraphNode3.onlyMsec += callGraphNode4.onlyMsec;
            callGraphNode3.onlyPerc += callGraphNode4.onlyPerc;
            callGraphNode3.kidsCycles += callGraphNode4.kidsCycles;
            callGraphNode3.kidsMsec += callGraphNode4.kidsMsec;
            callGraphNode3.kidsPerc += callGraphNode4.kidsPerc;
            callGraphNode.children.removeElement(callGraphNode4);
        }
    }

    private static class MIDletRange {
        int startIndex = 0;
        int endIndex = 0;
        String midletName;
        String midletEndMethodName;

        private MIDletRange() {
        }

        public String toString() {
            return "MIDletRange: (" + this.startIndex + ", " + this.endIndex + "), " + this.midletName;
        }
    }
}

