/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.profiler;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ModulesRegistry;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.profiler.CallGraphNode;
import com.sun.kvem.profiler.MainTableModel;
import com.sun.kvem.profiler.MyTreeNode;
import com.sun.kvem.profiler.Profile;
import com.sun.kvem.util.FileUtils;
import com.sun.kvem.util.FindDialog;
import com.sun.kvem.util.FinderListener;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ProfView
implements TreeSelectionListener,
ActionListener {
    public static final String CMD_FIND = "find";
    public static final String CMD_SAVE = "save";
    public static final String CMD_SAVE_AS = "saveAs";
    public static final String CMD_SAVE_SELECTED = "saveSelected";
    public static final String CMD_OPEN = "open";
    public static final String CMD_CLOSE = "close";
    private static final String CMD_SORT_BY_NAME = "sort_by_name";
    private static final String CMD_SORT_BY_COUNT = "sort_by_count";
    private static final String CMD_SORT_BY_CYCLES = "sort_by_cycles";
    private static final String CMD_SORT_BY_PERC = "sort_by_perc";
    private static final String CMD_SORT_BY_KIDS_CYCLES = "sort_by_kids_cycles";
    private static final String CMD_SORT_BY_KIDS_PERC = "sort_by_kids_prec";
    private static final String TEXT_FILE_EXT = "txt";
    private static final String TEXT_FILTER_DESC = "Text file";
    private static final Debug debug = Debug.create((Class)ProfView.class);
    public static final MessageFormat fileExistsMsgFormat = new MessageFormat(ToolkitResources.getString((String)"FILE_EXISTS_MSG"));
    String deviceTitle = null;
    JTree tree;
    JTable table;
    MainTableModel tableModel;
    Profile profile;
    JLabel tableLabel;
    MyTreeNode topTreeNode;
    String filename;
    JFrame frame;
    JSplitPane splitPane;
    JButton saveButton;
    JMenuItem saveItem;
    JMenuItem saveAsItem;
    JMenuItem saveSelectedItem;
    JMenuItem popupSelectedItem;
    JPopupMenu tablePopup;
    private FindDialog findDialog;
    private boolean startFromExtension = false;
    private File currentFile = null;
    private File defaultDir = new File(ToolkitDirs.SESSION);
    public static final String PROFILER_SESSION_FILE_EXT = "prf";
    private boolean registered = false;
    private boolean showSystem;

    public ProfView(boolean bl, String string) {
        this.showSystem = bl;
        this.deviceTitle = string;
    }

    public ProfView(boolean bl) {
        this(bl, null);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void startFromExtension(String string) {
        this.currentFile = new File(string);
        this.startFromExtension = true;
        this.start(string);
    }

    public synchronized void register() {
        if (!this.registered) {
            this.registered = true;
            ModulesRegistry.registerModule((Object)this);
        }
    }

    public synchronized void deregister() {
        if (this.registered) {
            this.registered = false;
            ModulesRegistry.deregisterModule((Object)this);
        }
    }

    public void start(String string) {
        Object object;
        WindowUtils.setLookAndFeel();
        this.frame = new JFrame();
        this.updateTitle();
        AccessibleContext accessibleContext = this.frame.getAccessibleContext();
        accessibleContext.setAccessibleName("Methods' Profiler");
        accessibleContext.setAccessibleDescription("Wireless Toolkit's methods' profiler");
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ProfView.this.register();
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (ProfView.this.findDialog != null) {
                    ProfView.this.findDialog.dispose();
                }
                ProfView.this.deregister();
            }
        });
        this.splitPane = new JSplitPane(1);
        try {
            this.loadFile(string);
            this.frame.setJMenuBar(this.createMenuBar());
            object = this.frame.getContentPane();
            ((Container)object).add((Component)this.createToolBar(), "North");
            ((Container)object).add((Component)this.splitPane, "Center");
            String string2 = ToolkitDirs.LIB + "images" + File.separator + "Profiler.gif";
            WindowUtils.setFrameIcon((JFrame)this.frame, (String)string2);
            this.frame.pack();
            this.frame.setVisible(true);
        }
        catch (IOException iOException) {
            if (this.startFromExtension) {
                this.corruptedFile();
            }
            this.deregister();
            debug.exception(1, (Throwable)iOException);
            debug.println(1, "Can not open file: {0}.", (Object)string);
        }
        object = this.table.getSelectionModel();
        object.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    ProfView.this.saveSelectedItem.setEnabled(false);
                    ProfView.this.popupSelectedItem.setEnabled(false);
                } else {
                    ProfView.this.saveSelectedItem.setEnabled(true);
                    ProfView.this.popupSelectedItem.setEnabled(true);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ProfView.this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        if (this.startFromExtension) {
            this.saveButton.setEnabled(false);
            this.saveItem.setEnabled(false);
            this.saveAsItem.setEnabled(false);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ToolkitResources.getString((String)"FILE"));
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(ToolkitResources.getString((String)"MONITORS.OPEN"), 79);
        jMenuItem.setActionCommand(CMD_OPEN);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.saveItem = new JMenuItem(ToolkitResources.getString((String)"SAVE"), 83);
        this.saveItem.setActionCommand(CMD_SAVE);
        this.saveItem.addActionListener(this);
        jMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem(ToolkitResources.getString((String)"SAVE_AS"), 65);
        this.saveAsItem.setActionCommand(CMD_SAVE_AS);
        this.saveAsItem.addActionListener(this);
        jMenu.add(this.saveAsItem);
        this.saveSelectedItem = this.createSelectedMenuItem();
        jMenu.add(this.saveSelectedItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"CLOSE"), 67);
        jMenuItem.setActionCommand(CMD_CLOSE);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ToolkitResources.getString((String)"VIEW"));
        jMenu.setMnemonic(86);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(ToolkitResources.getString((String)"PROFILER_EXT.SORT_BY"));
        jMenu2.setMnemonic(83);
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.METHOD_NAME"), 78);
        jMenuItem.setActionCommand(CMD_SORT_BY_NAME);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.METHOD_COUNT"), 67);
        jMenuItem.setActionCommand(CMD_SORT_BY_COUNT);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.METHOD_CYCLES"), 89);
        jMenuItem.setActionCommand(CMD_SORT_BY_CYCLES);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.METHOD_PERCENTAGE"), 76);
        jMenuItem.setActionCommand(CMD_SORT_BY_PERC);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.KIDS_CYCLES"), 78);
        jMenuItem.setActionCommand(CMD_SORT_BY_KIDS_CYCLES);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.KIDS_PERCENTAGE"), 87);
        jMenuItem.setActionCommand(CMD_SORT_BY_KIDS_PERC);
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        this.tablePopup = new JPopupMenu();
        this.popupSelectedItem = this.createSelectedMenuItem();
        this.tablePopup.add(this.popupSelectedItem);
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.saveButton = new JButton(ToolkitResources.getString((String)"SAVE"));
        this.saveButton.setMnemonic(83);
        this.saveButton.setToolTipText(ToolkitResources.getString((String)"PROFILER_EXT.SAVE_HELP"));
        this.saveButton.setActionCommand(CMD_SAVE);
        this.saveButton.addActionListener(this);
        JButton jButton = new JButton(ToolkitResources.getString((String)"OPEN"));
        jButton.setMnemonic(79);
        jButton.setToolTipText(ToolkitResources.getString((String)"PROFILER_EXT.OPEN_HELP"));
        jButton.setActionCommand(CMD_OPEN);
        jButton.addActionListener(this);
        jToolBar.add(this.saveButton);
        jToolBar.add(jButton);
        return jToolBar;
    }

    JScrollPane createTableView(Profile profile) {
        this.tableModel = new MainTableModel(this);
        this.table = new JTable(this.tableModel);
        this.tableModel.setCurrentDataSet(profile.root);
        this.tableModel.setOwner(this.table);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setMinimumSize(new Dimension(180, 400));
        jScrollPane.setPreferredSize(new Dimension(680, 400));
        return jScrollPane;
    }

    JPanel createTablePanel(Profile profile) {
        JScrollPane jScrollPane = this.createTableView(profile);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tableLabel = new JLabel(ToolkitResources.getString((String)"PROFILER_EXT.ALL_CALLS") + " <root>");
        this.tableLabel.setLabelFor(jScrollPane);
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    JPanel createTreePanel(Profile profile) {
        this.topTreeNode = this.createNodes(profile.root, null);
        this.tree = new JTree(this.topTreeNode);
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setMinimumSize(new Dimension(180, 400));
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(ToolkitResources.getString((String)"FIND"));
        jButton.setMnemonic(73);
        jButton.setToolTipText(ToolkitResources.getString((String)"PROFILER_EXT.FIND_HELP"));
        jButton.setActionCommand(CMD_FIND);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(ToolkitResources.getString((String)"PROFILER_EXT.CALL_GRAPH"));
        jLabel.setLabelFor(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    private JMenuItem createSelectedMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.SAVE_SELECTED"), ToolkitResources.getString((String)"PROFILER_EXT.SAVE_SELECTED_SHORTCUT").charAt(0));
        jMenuItem.setToolTipText(ToolkitResources.getString((String)"PROFILER_EXT.SAVE_SELECTED_HELP"));
        jMenuItem.setActionCommand(CMD_SAVE_SELECTED);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    MyTreeNode createNodes(CallGraphNode callGraphNode, MyTreeNode myTreeNode) {
        MyTreeNode myTreeNode2 = new MyTreeNode(callGraphNode, myTreeNode);
        if (callGraphNode.children != null) {
            Vector vector = callGraphNode.children;
            for (int i = 0; i < vector.size(); ++i) {
                CallGraphNode callGraphNode2 = (CallGraphNode)vector.elementAt(i);
                myTreeNode2.add(this.createNodes(callGraphNode2, myTreeNode2));
            }
        }
        return myTreeNode2;
    }

    private void loadFile(String string) throws IOException {
        this.profile = new Profile(string, this.showSystem);
        if (this.currentFile != null) {
            File file = new File(string);
            String string2 = ToolkitResources.getString((String)"PROFILER_EXT.TITLE_PRE") + " [" + file.getName() + "] - " + ToolkitResources.getString((String)"MONITOR_TITLE_SUFF");
            file = null;
            this.frame.setTitle(string2);
        }
        this.splitPane.setLeftComponent(this.createTreePanel(this.profile));
        this.splitPane.setRightComponent(this.createTablePanel(this.profile));
        this.filename = string;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        MyTreeNode myTreeNode = (MyTreeNode)this.tree.getLastSelectedPathComponent();
        if (myTreeNode == null) {
            return;
        }
        this.tableLabel.setText(ToolkitResources.getString((String)"PROFILER_EXT.ALL_CALLS") + " " + myTreeNode.cgNode.name);
        this.tableModel.setCurrentDataSet(myTreeNode.cgNode);
        this.tableModel.updateTable();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
    }

    private MyTreeNode getNextMatchingNode(MyTreeNode myTreeNode, String string, boolean bl) {
        if (myTreeNode == null) {
            myTreeNode = this.topTreeNode;
        }
        while ((myTreeNode = (MyTreeNode)myTreeNode.getNextNode()) != null) {
            if (!(bl ? myTreeNode.cgNode.name.indexOf(string) != -1 : myTreeNode.cgNode.name.toLowerCase().indexOf(string.toLowerCase()) != -1)) continue;
            return myTreeNode;
        }
        return null;
    }

    private void findNextNode(String string, boolean bl, boolean bl2) {
        MyTreeNode myTreeNode = (MyTreeNode)this.tree.getLastSelectedPathComponent();
        if ((myTreeNode = this.getNextMatchingNode(myTreeNode, string, bl)) == null && bl2) {
            myTreeNode = this.getNextMatchingNode(this.topTreeNode, string, bl);
        }
        if (myTreeNode == null) {
            this.findDialog.showNotFoundMessageDialog();
        } else {
            TreePath treePath = new TreePath(myTreeNode.getPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    public void corruptedFile() {
        int n;
        JOptionPane jOptionPane = new JOptionPane(ToolkitResources.getString((String)"CORRUPTED_FILE"), 0);
        JDialog jDialog = jOptionPane.createDialog(this.frame, ToolkitResources.getString((String)"TITLE_ERROR"));
        FontMetrics fontMetrics = jDialog.getFontMetrics(jDialog.getFont());
        int n2 = fontMetrics.stringWidth(ToolkitResources.getString((String)"TITLE_ERROR"));
        int n3 = n2 > (n = fontMetrics.stringWidth(ToolkitResources.getString((String)"CORRUPTED_FILE"))) ? 2 * n2 : 2 * n;
        Dimension dimension = new Dimension(n3, 140);
        jDialog.setSize(dimension);
        jDialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SAVE)) {
            if (this.currentFile == null) {
                this.actionPerformed(new ActionEvent(CMD_SAVE_AS, 0, CMD_SAVE_AS));
                return;
            }
            try {
                FileUtils.copyFile((File)new File(this.filename), (File)this.currentFile);
                this.updateTitle();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.frame, ToolkitResources.getString((String)"SAVING_ERROR_MESSAGE") + this.currentFile, ToolkitResources.getString((String)"ERROR_TITLE"), 0);
            }
        } else if (string.equals(CMD_SAVE_AS)) {
            try {
                SmartFileChooser smartFileChooser = new SmartFileChooser(this.currentFile, this.defaultDir);
                smartFileChooser.setAcceptAllFileFilterUsed(false);
                smartFileChooser.addExtFilter(PROFILER_SESSION_FILE_EXT, ToolkitResources.getString((String)"PROFILER_FILE_FILTER_DESC"));
                int n = smartFileChooser.showSaveDialog((Component)this.frame);
                if (n == 0) {
                    this.currentFile = smartFileChooser.getSelectedFile();
                    FileUtils.copyFile((File)new File(this.filename), (File)this.currentFile);
                    this.updateTitle();
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.frame, ToolkitResources.getString((String)"SAVING_ERROR_MESSAGE") + this.currentFile, ToolkitResources.getString((String)"ERROR_TITLE"), 0);
            }
        } else if (string.equals(CMD_SAVE_SELECTED)) {
            SmartFileChooser smartFileChooser = new SmartFileChooser(this.defaultDir);
            smartFileChooser.setAcceptAllFileFilterUsed(false);
            smartFileChooser.addExtFilter(TEXT_FILE_EXT, TEXT_FILTER_DESC);
            int n = smartFileChooser.showSaveDialog((Component)this.frame);
            if (n == 0) {
                this.saveSelected(smartFileChooser.getSelectedFile());
            }
        } else if (string.equals(CMD_OPEN)) {
            SmartFileChooser smartFileChooser = new SmartFileChooser(this.currentFile, this.defaultDir);
            smartFileChooser.setAcceptAllFileFilterUsed(false);
            smartFileChooser.addExtFilter(PROFILER_SESSION_FILE_EXT, ToolkitResources.getString((String)"PROFILER_FILE_FILTER_DESC"));
            int n = smartFileChooser.showOpenDialog((Component)this.frame);
            if (n == 0) {
                this.currentFile = smartFileChooser.getSelectedFile();
                this.saveButton.setEnabled(false);
                this.saveItem.setEnabled(false);
                this.saveAsItem.setEnabled(false);
                try {
                    this.loadFile(this.currentFile.getAbsolutePath());
                }
                catch (IOException iOException) {
                    this.corruptedFile();
                }
            }
        } else if (string.equals(CMD_FIND)) {
            if (this.findDialog == null) {
                this.findDialog = new FindDialog(this.frame);
                this.findDialog.setFinderListener(new FinderListener(){

                    public void find(String string, boolean bl, boolean bl2) {
                        ProfView.this.findNextNode(string, bl, bl2);
                    }
                });
            }
            this.findDialog.showDialog();
        } else if (string.equals(CMD_SORT_BY_NAME)) {
            this.tableModel.setSortColumn(0);
            this.tableModel.sort();
            this.tableModel.updateTable();
        } else if (string.equals(CMD_SORT_BY_COUNT)) {
            this.tableModel.setSortColumn(1);
            this.tableModel.sort();
            this.tableModel.updateTable();
        } else if (string.equals(CMD_SORT_BY_CYCLES)) {
            this.tableModel.setSortColumn(2);
            this.tableModel.sort();
            this.tableModel.updateTable();
        } else if (string.equals(CMD_SORT_BY_PERC)) {
            this.tableModel.setSortColumn(3);
            this.tableModel.sort();
            this.tableModel.updateTable();
        } else if (string.equals(CMD_SORT_BY_KIDS_CYCLES)) {
            this.tableModel.setSortColumn(4);
            this.tableModel.sort();
            this.tableModel.updateTable();
        } else if (string.equals(CMD_SORT_BY_KIDS_PERC)) {
            this.tableModel.setSortColumn(5);
            this.tableModel.sort();
            this.tableModel.updateTable();
        } else if (string.equals(CMD_CLOSE)) {
            this.frame.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSelected(File file) {
        int n;
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        int[] nArray = this.table.getSelectedRows();
        for (n = 0; n < this.table.getColumnCount(); ++n) {
            String string = this.table.getColumnName(n);
            if (n < this.table.getColumnCount() - 1) {
                string = string.concat("\t");
            }
            fileOutputStream.write(string.getBytes());
        }
        fileOutputStream.write("\n".getBytes());
        for (n = nArray[0]; n <= nArray[nArray.length - 1]; ++n) {
            int n2 = this.table.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                String string = this.table.getValueAt(n, i).toString();
                if (i < this.table.getColumnCount() - 1) {
                    string = string.concat("\t");
                }
                fileOutputStream.write(string.getBytes());
            }
            fileOutputStream.write("\n".getBytes());
        }
        Object var9_11 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            Debug.warning((String)iOException.toString());
        }
        return;
        {
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
                Debug.warning((String)iOException.toString());
                Object var9_12 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    debug.exception(1, (Throwable)iOException2);
                    Debug.warning((String)iOException2.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
                Debug.warning((String)iOException.toString());
            }
            throw throwable;
        }
    }

    private void updateTitle() {
        StringBuffer stringBuffer = new StringBuffer(ToolkitResources.getString((String)"PROFILER_EXT.TITLE_PRE"));
        if (this.deviceTitle != null) {
            stringBuffer.append("-").append(this.deviceTitle);
        }
        if (this.currentFile != null) {
            stringBuffer.append(" [").append(this.currentFile.getName()).append("]");
        }
        stringBuffer.append(" - ").append(ToolkitResources.getString((String)"MONITOR_TITLE_SUFF"));
        this.frame.setTitle(stringBuffer.toString());
    }

    TreePath getTreePath(CallGraphNode callGraphNode) {
        if (callGraphNode.parent == null) {
            return new TreePath(this.topTreeNode);
        }
        TreePath treePath = this.getTreePath(callGraphNode.parent);
        MyTreeNode myTreeNode = (MyTreeNode)treePath.getLastPathComponent();
        Enumeration<TreeNode> enumeration = myTreeNode.children();
        while (enumeration.hasMoreElements()) {
            MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
            if (myTreeNode2.cgNode != callGraphNode) continue;
            return treePath.pathByAddingChild(myTreeNode2);
        }
        throw new RuntimeException("Shouldn't come to here!");
    }

    void gotoGraph(CallGraphNode callGraphNode) {
        TreePath treePath = this.getTreePath(callGraphNode);
        this.tree.makeVisible(treePath);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.clearSelection();
        treeSelectionModel.addSelectionPath(treePath);
    }
}

